package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetSubscriptionAttributes invokes the mns_open.SetSubscriptionAttributes API synchronously
func (client *Client) SetSubscriptionAttributes(request *SetSubscriptionAttributesRequest) (response *SetSubscriptionAttributesResponse, err error) {
	response = CreateSetSubscriptionAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// SetSubscriptionAttributesWithChan invokes the mns_open.SetSubscriptionAttributes API asynchronously
func (client *Client) SetSubscriptionAttributesWithChan(request *SetSubscriptionAttributesRequest) (<-chan *SetSubscriptionAttributesResponse, <-chan error) {
	responseChan := make(chan *SetSubscriptionAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetSubscriptionAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetSubscriptionAttributesWithCallback invokes the mns_open.SetSubscriptionAttributes API asynchronously
func (client *Client) SetSubscriptionAttributesWithCallback(request *SetSubscriptionAttributesRequest, callback func(response *SetSubscriptionAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetSubscriptionAttributesResponse
		var err error
		defer close(result)
		response, err = client.SetSubscriptionAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetSubscriptionAttributesRequest is the request struct for api SetSubscriptionAttributes
type SetSubscriptionAttributesRequest struct {
	*requests.RpcRequest
	SubscriptionName string `position:"Query" name:"SubscriptionName"`
	TopicName        string `position:"Query" name:"TopicName"`
	NotifyStrategy   string `position:"Query" name:"NotifyStrategy"`
}

// SetSubscriptionAttributesResponse is the response struct for api SetSubscriptionAttributes
type SetSubscriptionAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSetSubscriptionAttributesRequest creates a request to invoke SetSubscriptionAttributes API
func CreateSetSubscriptionAttributesRequest() (request *SetSubscriptionAttributesRequest) {
	request = &SetSubscriptionAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "SetSubscriptionAttributes", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetSubscriptionAttributesResponse creates a response to parse from SetSubscriptionAttributes response
func CreateSetSubscriptionAttributesResponse() (response *SetSubscriptionAttributesResponse) {
	response = &SetSubscriptionAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
