package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadMPCDPrivacyDocById invokes the mpaas.DownloadMPCDPrivacyDocById API synchronously
func (client *Client) DownloadMPCDPrivacyDocById(request *DownloadMPCDPrivacyDocByIdRequest) (response *DownloadMPCDPrivacyDocByIdResponse, err error) {
	response = CreateDownloadMPCDPrivacyDocByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadMPCDPrivacyDocByIdWithChan invokes the mpaas.DownloadMPCDPrivacyDocById API asynchronously
func (client *Client) DownloadMPCDPrivacyDocByIdWithChan(request *DownloadMPCDPrivacyDocByIdRequest) (<-chan *DownloadMPCDPrivacyDocByIdResponse, <-chan error) {
	responseChan := make(chan *DownloadMPCDPrivacyDocByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadMPCDPrivacyDocById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadMPCDPrivacyDocByIdWithCallback invokes the mpaas.DownloadMPCDPrivacyDocById API asynchronously
func (client *Client) DownloadMPCDPrivacyDocByIdWithCallback(request *DownloadMPCDPrivacyDocByIdRequest, callback func(response *DownloadMPCDPrivacyDocByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadMPCDPrivacyDocByIdResponse
		var err error
		defer close(result)
		response, err = client.DownloadMPCDPrivacyDocById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadMPCDPrivacyDocByIdRequest is the request struct for api DownloadMPCDPrivacyDocById
type DownloadMPCDPrivacyDocByIdRequest struct {
	*requests.RpcRequest
	AppId       string           `position:"Body" name:"AppId"`
	TenantId    string           `position:"Body" name:"TenantId"`
	ScanTaskId  requests.Integer `position:"Body" name:"ScanTaskId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// DownloadMPCDPrivacyDocByIdResponse is the response struct for api DownloadMPCDPrivacyDocById
type DownloadMPCDPrivacyDocByIdResponse struct {
	*responses.BaseResponse
}

// CreateDownloadMPCDPrivacyDocByIdRequest creates a request to invoke DownloadMPCDPrivacyDocById API
func CreateDownloadMPCDPrivacyDocByIdRequest() (request *DownloadMPCDPrivacyDocByIdRequest) {
	request = &DownloadMPCDPrivacyDocByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DownloadMPCDPrivacyDocById", "", "")
	request.Method = requests.POST
	return
}

// CreateDownloadMPCDPrivacyDocByIdResponse creates a response to parse from DownloadMPCDPrivacyDocById response
func CreateDownloadMPCDPrivacyDocByIdResponse() (response *DownloadMPCDPrivacyDocByIdResponse) {
	response = &DownloadMPCDPrivacyDocByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
