package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewayCircuitBreakerRule invokes the mse.DeleteGatewayCircuitBreakerRule API synchronously
func (client *Client) DeleteGatewayCircuitBreakerRule(request *DeleteGatewayCircuitBreakerRuleRequest) (response *DeleteGatewayCircuitBreakerRuleResponse, err error) {
	response = CreateDeleteGatewayCircuitBreakerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewayCircuitBreakerRuleWithChan invokes the mse.DeleteGatewayCircuitBreakerRule API asynchronously
func (client *Client) DeleteGatewayCircuitBreakerRuleWithChan(request *DeleteGatewayCircuitBreakerRuleRequest) (<-chan *DeleteGatewayCircuitBreakerRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewayCircuitBreakerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewayCircuitBreakerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewayCircuitBreakerRuleWithCallback invokes the mse.DeleteGatewayCircuitBreakerRule API asynchronously
func (client *Client) DeleteGatewayCircuitBreakerRuleWithCallback(request *DeleteGatewayCircuitBreakerRuleRequest, callback func(response *DeleteGatewayCircuitBreakerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewayCircuitBreakerRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewayCircuitBreakerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewayCircuitBreakerRuleRequest is the request struct for api DeleteGatewayCircuitBreakerRule
type DeleteGatewayCircuitBreakerRuleRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	RouteId         requests.Integer `position:"Query" name:"RouteId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	RuleId          requests.Integer `position:"Query" name:"RuleId"`
}

// DeleteGatewayCircuitBreakerRuleResponse is the response struct for api DeleteGatewayCircuitBreakerRule
type DeleteGatewayCircuitBreakerRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteGatewayCircuitBreakerRuleRequest creates a request to invoke DeleteGatewayCircuitBreakerRule API
func CreateDeleteGatewayCircuitBreakerRuleRequest() (request *DeleteGatewayCircuitBreakerRuleRequest) {
	request = &DeleteGatewayCircuitBreakerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteGatewayCircuitBreakerRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGatewayCircuitBreakerRuleResponse creates a response to parse from DeleteGatewayCircuitBreakerRule response
func CreateDeleteGatewayCircuitBreakerRuleResponse() (response *DeleteGatewayCircuitBreakerRuleResponse) {
	response = &DeleteGatewayCircuitBreakerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
