package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProtocolMountTarget invokes the nas.DescribeProtocolMountTarget API synchronously
func (client *Client) DescribeProtocolMountTarget(request *DescribeProtocolMountTargetRequest) (response *DescribeProtocolMountTargetResponse, err error) {
	response = CreateDescribeProtocolMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProtocolMountTargetWithChan invokes the nas.DescribeProtocolMountTarget API asynchronously
func (client *Client) DescribeProtocolMountTargetWithChan(request *DescribeProtocolMountTargetRequest) (<-chan *DescribeProtocolMountTargetResponse, <-chan error) {
	responseChan := make(chan *DescribeProtocolMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProtocolMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProtocolMountTargetWithCallback invokes the nas.DescribeProtocolMountTarget API asynchronously
func (client *Client) DescribeProtocolMountTargetWithCallback(request *DescribeProtocolMountTargetRequest, callback func(response *DescribeProtocolMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProtocolMountTargetResponse
		var err error
		defer close(result)
		response, err = client.DescribeProtocolMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProtocolMountTargetRequest is the request struct for api DescribeProtocolMountTarget
type DescribeProtocolMountTargetRequest struct {
	*requests.RpcRequest
	ClientToken  string                                `position:"Query" name:"ClientToken"`
	NextToken    string                                `position:"Query" name:"NextToken"`
	FileSystemId string                                `position:"Query" name:"FileSystemId"`
	Filters      *[]DescribeProtocolMountTargetFilters `position:"Query" name:"Filters"  type:"Repeated"`
	MaxResults   requests.Integer                      `position:"Query" name:"MaxResults"`
}

// DescribeProtocolMountTargetFilters is a repeated param struct in DescribeProtocolMountTargetRequest
type DescribeProtocolMountTargetFilters struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeProtocolMountTargetResponse is the response struct for api DescribeProtocolMountTarget
type DescribeProtocolMountTargetResponse struct {
	*responses.BaseResponse
	RequestId            string                `json:"RequestId" xml:"RequestId"`
	NextToken            string                `json:"NextToken" xml:"NextToken"`
	ProtocolMountTargets []ProtocolMountTarget `json:"ProtocolMountTargets" xml:"ProtocolMountTargets"`
}

// CreateDescribeProtocolMountTargetRequest creates a request to invoke DescribeProtocolMountTarget API
func CreateDescribeProtocolMountTargetRequest() (request *DescribeProtocolMountTargetRequest) {
	request = &DescribeProtocolMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeProtocolMountTarget", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProtocolMountTargetResponse creates a response to parse from DescribeProtocolMountTarget response
func CreateDescribeProtocolMountTargetResponse() (response *DescribeProtocolMountTargetResponse) {
	response = &DescribeProtocolMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
