package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDirectoryOrFileProperties invokes the nas.GetDirectoryOrFileProperties API synchronously
func (client *Client) GetDirectoryOrFileProperties(request *GetDirectoryOrFilePropertiesRequest) (response *GetDirectoryOrFilePropertiesResponse, err error) {
	response = CreateGetDirectoryOrFilePropertiesResponse()
	err = client.DoAction(request, response)
	return
}

// GetDirectoryOrFilePropertiesWithChan invokes the nas.GetDirectoryOrFileProperties API asynchronously
func (client *Client) GetDirectoryOrFilePropertiesWithChan(request *GetDirectoryOrFilePropertiesRequest) (<-chan *GetDirectoryOrFilePropertiesResponse, <-chan error) {
	responseChan := make(chan *GetDirectoryOrFilePropertiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDirectoryOrFileProperties(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDirectoryOrFilePropertiesWithCallback invokes the nas.GetDirectoryOrFileProperties API asynchronously
func (client *Client) GetDirectoryOrFilePropertiesWithCallback(request *GetDirectoryOrFilePropertiesRequest, callback func(response *GetDirectoryOrFilePropertiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDirectoryOrFilePropertiesResponse
		var err error
		defer close(result)
		response, err = client.GetDirectoryOrFileProperties(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDirectoryOrFilePropertiesRequest is the request struct for api GetDirectoryOrFileProperties
type GetDirectoryOrFilePropertiesRequest struct {
	*requests.RpcRequest
	Path         string `position:"Query" name:"Path"`
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// GetDirectoryOrFilePropertiesResponse is the response struct for api GetDirectoryOrFileProperties
type GetDirectoryOrFilePropertiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Entry     Entry  `json:"Entry" xml:"Entry"`
}

// CreateGetDirectoryOrFilePropertiesRequest creates a request to invoke GetDirectoryOrFileProperties API
func CreateGetDirectoryOrFilePropertiesRequest() (request *GetDirectoryOrFilePropertiesRequest) {
	request = &GetDirectoryOrFilePropertiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "GetDirectoryOrFileProperties", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDirectoryOrFilePropertiesResponse creates a response to parse from GetDirectoryOrFileProperties response
func CreateGetDirectoryOrFilePropertiesResponse() (response *GetDirectoryOrFilePropertiesResponse) {
	response = &GetDirectoryOrFilePropertiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
