package nlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLoadBalancerProtection invokes the nlb.UpdateLoadBalancerProtection API synchronously
func (client *Client) UpdateLoadBalancerProtection(request *UpdateLoadBalancerProtectionRequest) (response *UpdateLoadBalancerProtectionResponse, err error) {
	response = CreateUpdateLoadBalancerProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLoadBalancerProtectionWithChan invokes the nlb.UpdateLoadBalancerProtection API asynchronously
func (client *Client) UpdateLoadBalancerProtectionWithChan(request *UpdateLoadBalancerProtectionRequest) (<-chan *UpdateLoadBalancerProtectionResponse, <-chan error) {
	responseChan := make(chan *UpdateLoadBalancerProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLoadBalancerProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLoadBalancerProtectionWithCallback invokes the nlb.UpdateLoadBalancerProtection API asynchronously
func (client *Client) UpdateLoadBalancerProtectionWithCallback(request *UpdateLoadBalancerProtectionRequest, callback func(response *UpdateLoadBalancerProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLoadBalancerProtectionResponse
		var err error
		defer close(result)
		response, err = client.UpdateLoadBalancerProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLoadBalancerProtectionRequest is the request struct for api UpdateLoadBalancerProtection
type UpdateLoadBalancerProtectionRequest struct {
	*requests.RpcRequest
	DeletionProtectionReason     string           `position:"Body" name:"DeletionProtectionReason"`
	ModificationProtectionReason string           `position:"Body" name:"ModificationProtectionReason"`
	ClientToken                  string           `position:"Body" name:"ClientToken"`
	DeletionProtectionEnabled    requests.Boolean `position:"Body" name:"DeletionProtectionEnabled"`
	DryRun                       requests.Boolean `position:"Body" name:"DryRun"`
	ModificationProtectionStatus string           `position:"Body" name:"ModificationProtectionStatus"`
	LoadBalancerId               string           `position:"Body" name:"LoadBalancerId"`
}

// UpdateLoadBalancerProtectionResponse is the response struct for api UpdateLoadBalancerProtection
type UpdateLoadBalancerProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLoadBalancerProtectionRequest creates a request to invoke UpdateLoadBalancerProtection API
func CreateUpdateLoadBalancerProtectionRequest() (request *UpdateLoadBalancerProtectionRequest) {
	request = &UpdateLoadBalancerProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Nlb", "2022-04-30", "UpdateLoadBalancerProtection", "nlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLoadBalancerProtectionResponse creates a response to parse from UpdateLoadBalancerProtection response
func CreateUpdateLoadBalancerProtectionResponse() (response *UpdateLoadBalancerProtectionResponse) {
	response = &UpdateLoadBalancerProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
