package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectMainBody invokes the objectdet.DetectMainBody API synchronously
func (client *Client) DetectMainBody(request *DetectMainBodyRequest) (response *DetectMainBodyResponse, err error) {
	response = CreateDetectMainBodyResponse()
	err = client.DoAction(request, response)
	return
}

// DetectMainBodyWithChan invokes the objectdet.DetectMainBody API asynchronously
func (client *Client) DetectMainBodyWithChan(request *DetectMainBodyRequest) (<-chan *DetectMainBodyResponse, <-chan error) {
	responseChan := make(chan *DetectMainBodyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectMainBody(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectMainBodyWithCallback invokes the objectdet.DetectMainBody API asynchronously
func (client *Client) DetectMainBodyWithCallback(request *DetectMainBodyRequest, callback func(response *DetectMainBodyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectMainBodyResponse
		var err error
		defer close(result)
		response, err = client.DetectMainBody(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectMainBodyRequest is the request struct for api DetectMainBody
type DetectMainBodyRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Query" name:"ImageURL"`
}

// DetectMainBodyResponse is the response struct for api DetectMainBody
type DetectMainBodyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectMainBodyRequest creates a request to invoke DetectMainBody API
func CreateDetectMainBodyRequest() (request *DetectMainBodyRequest) {
	request = &DetectMainBodyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "DetectMainBody", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectMainBodyResponse creates a response to parse from DetectMainBody response
func CreateDetectMainBodyResponse() (response *DetectMainBodyResponse) {
	response = &DetectMainBodyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
