package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceCreatableZone invokes the oceanbasepro.DescribeInstanceCreatableZone API synchronously
func (client *Client) DescribeInstanceCreatableZone(request *DescribeInstanceCreatableZoneRequest) (response *DescribeInstanceCreatableZoneResponse, err error) {
	response = CreateDescribeInstanceCreatableZoneResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceCreatableZoneWithChan invokes the oceanbasepro.DescribeInstanceCreatableZone API asynchronously
func (client *Client) DescribeInstanceCreatableZoneWithChan(request *DescribeInstanceCreatableZoneRequest) (<-chan *DescribeInstanceCreatableZoneResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceCreatableZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceCreatableZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceCreatableZoneWithCallback invokes the oceanbasepro.DescribeInstanceCreatableZone API asynchronously
func (client *Client) DescribeInstanceCreatableZoneWithCallback(request *DescribeInstanceCreatableZoneRequest, callback func(response *DescribeInstanceCreatableZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceCreatableZoneResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceCreatableZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceCreatableZoneRequest is the request struct for api DescribeInstanceCreatableZone
type DescribeInstanceCreatableZoneRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
}

// DescribeInstanceCreatableZoneResponse is the response struct for api DescribeInstanceCreatableZone
type DescribeInstanceCreatableZoneResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	ZoneList  []ZoneListItem `json:"ZoneList" xml:"ZoneList"`
}

// CreateDescribeInstanceCreatableZoneRequest creates a request to invoke DescribeInstanceCreatableZone API
func CreateDescribeInstanceCreatableZoneRequest() (request *DescribeInstanceCreatableZoneRequest) {
	request = &DescribeInstanceCreatableZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeInstanceCreatableZone", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceCreatableZoneResponse creates a response to parse from DescribeInstanceCreatableZone response
func CreateDescribeInstanceCreatableZoneResponse() (response *DescribeInstanceCreatableZoneResponse) {
	response = &DescribeInstanceCreatableZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
