package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTimeZones invokes the oceanbasepro.DescribeTimeZones API synchronously
func (client *Client) DescribeTimeZones(request *DescribeTimeZonesRequest) (response *DescribeTimeZonesResponse, err error) {
	response = CreateDescribeTimeZonesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTimeZonesWithChan invokes the oceanbasepro.DescribeTimeZones API asynchronously
func (client *Client) DescribeTimeZonesWithChan(request *DescribeTimeZonesRequest) (<-chan *DescribeTimeZonesResponse, <-chan error) {
	responseChan := make(chan *DescribeTimeZonesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTimeZones(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTimeZonesWithCallback invokes the oceanbasepro.DescribeTimeZones API asynchronously
func (client *Client) DescribeTimeZonesWithCallback(request *DescribeTimeZonesRequest, callback func(response *DescribeTimeZonesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTimeZonesResponse
		var err error
		defer close(result)
		response, err = client.DescribeTimeZones(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTimeZonesRequest is the request struct for api DescribeTimeZones
type DescribeTimeZonesRequest struct {
	*requests.RpcRequest
}

// DescribeTimeZonesResponse is the response struct for api DescribeTimeZones
type DescribeTimeZonesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	TimeZones TimeZones `json:"TimeZones" xml:"TimeZones"`
}

// CreateDescribeTimeZonesRequest creates a request to invoke DescribeTimeZones API
func CreateDescribeTimeZonesRequest() (request *DescribeTimeZonesRequest) {
	request = &DescribeTimeZonesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTimeZones", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTimeZonesResponse creates a response to parse from DescribeTimeZones response
func CreateDescribeTimeZonesResponse() (response *DescribeTimeZonesResponse) {
	response = &DescribeTimeZonesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
