package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllLabels invokes the oceanbasepro.ListAllLabels API synchronously
func (client *Client) ListAllLabels(request *ListAllLabelsRequest) (response *ListAllLabelsResponse, err error) {
	response = CreateListAllLabelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllLabelsWithChan invokes the oceanbasepro.ListAllLabels API asynchronously
func (client *Client) ListAllLabelsWithChan(request *ListAllLabelsRequest) (<-chan *ListAllLabelsResponse, <-chan error) {
	responseChan := make(chan *ListAllLabelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllLabels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllLabelsWithCallback invokes the oceanbasepro.ListAllLabels API asynchronously
func (client *Client) ListAllLabelsWithCallback(request *ListAllLabelsRequest, callback func(response *ListAllLabelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllLabelsResponse
		var err error
		defer close(result)
		response, err = client.ListAllLabels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllLabelsRequest is the request struct for api ListAllLabels
type ListAllLabelsRequest struct {
	*requests.RpcRequest
}

// ListAllLabelsResponse is the response struct for api ListAllLabels
type ListAllLabelsResponse struct {
	*responses.BaseResponse
}

// CreateListAllLabelsRequest creates a request to invoke ListAllLabels API
func CreateListAllLabelsRequest() (request *ListAllLabelsRequest) {
	request = &ListAllLabelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ListAllLabels", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAllLabelsResponse creates a response to parse from ListAllLabels response
func CreateListAllLabelsResponse() (response *ListAllLabelsResponse) {
	response = &ListAllLabelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
