package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainPartByProxy invokes the oms.DeleteDomainPartByProxy API synchronously
func (client *Client) DeleteDomainPartByProxy(request *DeleteDomainPartByProxyRequest) (response *DeleteDomainPartByProxyResponse, err error) {
	response = CreateDeleteDomainPartByProxyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainPartByProxyWithChan invokes the oms.DeleteDomainPartByProxy API asynchronously
func (client *Client) DeleteDomainPartByProxyWithChan(request *DeleteDomainPartByProxyRequest) (<-chan *DeleteDomainPartByProxyResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainPartByProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainPartByProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainPartByProxyWithCallback invokes the oms.DeleteDomainPartByProxy API asynchronously
func (client *Client) DeleteDomainPartByProxyWithCallback(request *DeleteDomainPartByProxyRequest, callback func(response *DeleteDomainPartByProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainPartByProxyResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainPartByProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainPartByProxyRequest is the request struct for api DeleteDomainPartByProxy
type DeleteDomainPartByProxyRequest struct {
	*requests.RpcRequest
	DomainCode string `position:"Query" name:"DomainCode"`
	DataType   string `position:"Query" name:"DataType"`
	Part       string `position:"Query" name:"Part"`
}

// DeleteDomainPartByProxyResponse is the response struct for api DeleteDomainPartByProxy
type DeleteDomainPartByProxyResponse struct {
	*responses.BaseResponse
	DataType   string `json:"DataType" xml:"DataType"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
}

// CreateDeleteDomainPartByProxyRequest creates a request to invoke DeleteDomainPartByProxy API
func CreateDeleteDomainPartByProxyRequest() (request *DeleteDomainPartByProxyRequest) {
	request = &DeleteDomainPartByProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "DeleteDomainPartByProxy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDomainPartByProxyResponse creates a response to parse from DeleteDomainPartByProxy response
func CreateDeleteDomainPartByProxyResponse() (response *DeleteDomainPartByProxyResponse) {
	response = &DeleteDomainPartByProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
