package paielasticdatasetaccelerator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstance invokes the paielasticdatasetaccelerator.DescribeInstance API synchronously
func (client *Client) DescribeInstance(request *DescribeInstanceRequest) (response *DescribeInstanceResponse, err error) {
	response = CreateDescribeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceWithChan invokes the paielasticdatasetaccelerator.DescribeInstance API asynchronously
func (client *Client) DescribeInstanceWithChan(request *DescribeInstanceRequest) (<-chan *DescribeInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceWithCallback invokes the paielasticdatasetaccelerator.DescribeInstance API asynchronously
func (client *Client) DescribeInstanceWithCallback(request *DescribeInstanceRequest, callback func(response *DescribeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceRequest is the request struct for api DescribeInstance
type DescribeInstanceRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeInstanceResponse is the response struct for api DescribeInstance
type DescribeInstanceResponse struct {
	*responses.BaseResponse
	RequestId       string     `json:"RequestId" xml:"RequestId"`
	UserId          string     `json:"UserId" xml:"UserId"`
	OwnerId         string     `json:"OwnerId" xml:"OwnerId"`
	GmtCreateTime   string     `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string     `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	Uuid            string     `json:"Uuid" xml:"Uuid"`
	Name            string     `json:"Name" xml:"Name"`
	Description     string     `json:"Description" xml:"Description"`
	Type            string     `json:"Type" xml:"Type"`
	PaymentType     string     `json:"PaymentType" xml:"PaymentType"`
	Capacity        string     `json:"Capacity" xml:"Capacity"`
	MaxSlot         int        `json:"MaxSlot" xml:"MaxSlot"`
	MaxEndpoint     int        `json:"MaxEndpoint" xml:"MaxEndpoint"`
	StorageType     string     `json:"StorageType" xml:"StorageType"`
	ProviderType    string     `json:"ProviderType" xml:"ProviderType"`
	Status          Status     `json:"Status" xml:"Status"`
	Tags            []TagsItem `json:"Tags" xml:"Tags"`
}

// CreateDescribeInstanceRequest creates a request to invoke DescribeInstance API
func CreateDescribeInstanceRequest() (request *DescribeInstanceRequest) {
	request = &DescribeInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PAIElasticDatasetAccelerator", "2022-08-01", "DescribeInstance", "/api/v1/instances/[InstanceId]", "datasetacc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeInstanceResponse creates a response to parse from DescribeInstance response
func CreateDescribeInstanceResponse() (response *DescribeInstanceResponse) {
	response = &DescribeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
