package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLabelTable invokes the paifeaturestore.UpdateLabelTable API synchronously
func (client *Client) UpdateLabelTable(request *UpdateLabelTableRequest) (response *UpdateLabelTableResponse, err error) {
	response = CreateUpdateLabelTableResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLabelTableWithChan invokes the paifeaturestore.UpdateLabelTable API asynchronously
func (client *Client) UpdateLabelTableWithChan(request *UpdateLabelTableRequest) (<-chan *UpdateLabelTableResponse, <-chan error) {
	responseChan := make(chan *UpdateLabelTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLabelTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLabelTableWithCallback invokes the paifeaturestore.UpdateLabelTable API asynchronously
func (client *Client) UpdateLabelTableWithCallback(request *UpdateLabelTableRequest, callback func(response *UpdateLabelTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLabelTableResponse
		var err error
		defer close(result)
		response, err = client.UpdateLabelTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLabelTableRequest is the request struct for api UpdateLabelTable
type UpdateLabelTableRequest struct {
	*requests.RoaRequest
	Body         string `position:"Body" name:"body"`
	InstanceId   string `position:"Path" name:"InstanceId"`
	LabelTableId string `position:"Path" name:"LabelTableId"`
}

// UpdateLabelTableResponse is the response struct for api UpdateLabelTable
type UpdateLabelTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLabelTableRequest creates a request to invoke UpdateLabelTable API
func CreateUpdateLabelTableRequest() (request *UpdateLabelTableRequest) {
	request = &UpdateLabelTableRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "UpdateLabelTable", "/api/v1/instances/[InstanceId]/labeltables/[LabelTableId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateLabelTableResponse creates a response to parse from UpdateLabelTable response
func CreateUpdateLabelTableResponse() (response *UpdateLabelTableResponse) {
	response = &UpdateLabelTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
