package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTableMeta invokes the pairecservice.GetTableMeta API synchronously
func (client *Client) GetTableMeta(request *GetTableMetaRequest) (response *GetTableMetaResponse, err error) {
	response = CreateGetTableMetaResponse()
	err = client.DoAction(request, response)
	return
}

// GetTableMetaWithChan invokes the pairecservice.GetTableMeta API asynchronously
func (client *Client) GetTableMetaWithChan(request *GetTableMetaRequest) (<-chan *GetTableMetaResponse, <-chan error) {
	responseChan := make(chan *GetTableMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTableMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTableMetaWithCallback invokes the pairecservice.GetTableMeta API asynchronously
func (client *Client) GetTableMetaWithCallback(request *GetTableMetaRequest, callback func(response *GetTableMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTableMetaResponse
		var err error
		defer close(result)
		response, err = client.GetTableMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTableMetaRequest is the request struct for api GetTableMeta
type GetTableMetaRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Query" name:"InstanceId"`
	TableMetaId string `position:"Path" name:"TableMetaId"`
}

// GetTableMetaResponse is the response struct for api GetTableMeta
type GetTableMetaResponse struct {
	*responses.BaseResponse
	RequestId       string       `json:"RequestId" xml:"RequestId"`
	Name            string       `json:"Name" xml:"Name"`
	Description     string       `json:"Description" xml:"Description"`
	ResourceId      string       `json:"ResourceId" xml:"ResourceId"`
	TableName       string       `json:"TableName" xml:"TableName"`
	Type            string       `json:"Type" xml:"Type"`
	Module          string       `json:"Module" xml:"Module"`
	CanDelete       bool         `json:"CanDelete" xml:"CanDelete"`
	GmtCreateTime   string       `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string       `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	Url             string       `json:"Url" xml:"Url"`
	TableMetaId     string       `json:"TableMetaId" xml:"TableMetaId"`
	GmtImportedTime string       `json:"GmtImportedTime" xml:"GmtImportedTime"`
	Config          string       `json:"Config" xml:"Config"`
	Fields          []FieldsItem `json:"Fields" xml:"Fields"`
}

// CreateGetTableMetaRequest creates a request to invoke GetTableMeta API
func CreateGetTableMetaRequest() (request *GetTableMetaRequest) {
	request = &GetTableMetaRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetTableMeta", "/api/v1/tablemetas/[TableMetaId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTableMetaResponse creates a response to parse from GetTableMeta response
func CreateGetTableMetaResponse() (response *GetTableMetaResponse) {
	response = &GetTableMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
