package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTrafficControlTargetItemReportDetail invokes the pairecservice.QueryTrafficControlTargetItemReportDetail API synchronously
func (client *Client) QueryTrafficControlTargetItemReportDetail(request *QueryTrafficControlTargetItemReportDetailRequest) (response *QueryTrafficControlTargetItemReportDetailResponse, err error) {
	response = CreateQueryTrafficControlTargetItemReportDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTrafficControlTargetItemReportDetailWithChan invokes the pairecservice.QueryTrafficControlTargetItemReportDetail API asynchronously
func (client *Client) QueryTrafficControlTargetItemReportDetailWithChan(request *QueryTrafficControlTargetItemReportDetailRequest) (<-chan *QueryTrafficControlTargetItemReportDetailResponse, <-chan error) {
	responseChan := make(chan *QueryTrafficControlTargetItemReportDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTrafficControlTargetItemReportDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTrafficControlTargetItemReportDetailWithCallback invokes the pairecservice.QueryTrafficControlTargetItemReportDetail API asynchronously
func (client *Client) QueryTrafficControlTargetItemReportDetailWithCallback(request *QueryTrafficControlTargetItemReportDetailRequest, callback func(response *QueryTrafficControlTargetItemReportDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTrafficControlTargetItemReportDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryTrafficControlTargetItemReportDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTrafficControlTargetItemReportDetailRequest is the request struct for api QueryTrafficControlTargetItemReportDetail
type QueryTrafficControlTargetItemReportDetailRequest struct {
	*requests.RoaRequest
	Date                   string `position:"Query" name:"Date"`
	TrafficControlTargetId string `position:"Path" name:"TrafficControlTargetId"`
	Environment            string `position:"Query" name:"Environment"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// QueryTrafficControlTargetItemReportDetailResponse is the response struct for api QueryTrafficControlTargetItemReportDetail
type QueryTrafficControlTargetItemReportDetailResponse struct {
	*responses.BaseResponse
	RequestId                            string                               `json:"RequestId" xml:"RequestId"`
	TrafficControlTargetItemReportDetail TrafficControlTargetItemReportDetail `json:"TrafficControlTargetItemReportDetail" xml:"TrafficControlTargetItemReportDetail"`
}

// CreateQueryTrafficControlTargetItemReportDetailRequest creates a request to invoke QueryTrafficControlTargetItemReportDetail API
func CreateQueryTrafficControlTargetItemReportDetailRequest() (request *QueryTrafficControlTargetItemReportDetailRequest) {
	request = &QueryTrafficControlTargetItemReportDetailRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "QueryTrafficControlTargetItemReportDetail", "/api/v1/trafficcontroltargets/[TrafficControlTargetId]/itemcontrolreportdetail", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryTrafficControlTargetItemReportDetailResponse creates a response to parse from QueryTrafficControlTargetItemReportDetail response
func CreateQueryTrafficControlTargetItemReportDetailResponse() (response *QueryTrafficControlTargetItemReportDetailResponse) {
	response = &QueryTrafficControlTargetItemReportDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
