package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyActiveOperationTasks invokes the polardb.ModifyActiveOperationTasks API synchronously
func (client *Client) ModifyActiveOperationTasks(request *ModifyActiveOperationTasksRequest) (response *ModifyActiveOperationTasksResponse, err error) {
	response = CreateModifyActiveOperationTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyActiveOperationTasksWithChan invokes the polardb.ModifyActiveOperationTasks API asynchronously
func (client *Client) ModifyActiveOperationTasksWithChan(request *ModifyActiveOperationTasksRequest) (<-chan *ModifyActiveOperationTasksResponse, <-chan error) {
	responseChan := make(chan *ModifyActiveOperationTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyActiveOperationTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyActiveOperationTasksWithCallback invokes the polardb.ModifyActiveOperationTasks API asynchronously
func (client *Client) ModifyActiveOperationTasksWithCallback(request *ModifyActiveOperationTasksRequest, callback func(response *ModifyActiveOperationTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyActiveOperationTasksResponse
		var err error
		defer close(result)
		response, err = client.ModifyActiveOperationTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyActiveOperationTasksRequest is the request struct for api ModifyActiveOperationTasks
type ModifyActiveOperationTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskIds              string           `position:"Query" name:"TaskIds"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SwitchTime           string           `position:"Query" name:"SwitchTime"`
	EngineType           string           `position:"Query" name:"EngineType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ImmediateStart       requests.Integer `position:"Query" name:"ImmediateStart"`
}

// ModifyActiveOperationTasksResponse is the response struct for api ModifyActiveOperationTasks
type ModifyActiveOperationTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskIds   string `json:"TaskIds" xml:"TaskIds"`
}

// CreateModifyActiveOperationTasksRequest creates a request to invoke ModifyActiveOperationTasks API
func CreateModifyActiveOperationTasksRequest() (request *ModifyActiveOperationTasksRequest) {
	request = &ModifyActiveOperationTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyActiveOperationTasks", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyActiveOperationTasksResponse creates a response to parse from ModifyActiveOperationTasks response
func CreateModifyActiveOperationTasksResponse() (response *ModifyActiveOperationTasksResponse) {
	response = &ModifyActiveOperationTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
