package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWorkspaceRoleUsers invokes the quickbi_public.ListWorkspaceRoleUsers API synchronously
func (client *Client) ListWorkspaceRoleUsers(request *ListWorkspaceRoleUsersRequest) (response *ListWorkspaceRoleUsersResponse, err error) {
	response = CreateListWorkspaceRoleUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListWorkspaceRoleUsersWithChan invokes the quickbi_public.ListWorkspaceRoleUsers API asynchronously
func (client *Client) ListWorkspaceRoleUsersWithChan(request *ListWorkspaceRoleUsersRequest) (<-chan *ListWorkspaceRoleUsersResponse, <-chan error) {
	responseChan := make(chan *ListWorkspaceRoleUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWorkspaceRoleUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWorkspaceRoleUsersWithCallback invokes the quickbi_public.ListWorkspaceRoleUsers API asynchronously
func (client *Client) ListWorkspaceRoleUsersWithCallback(request *ListWorkspaceRoleUsersRequest, callback func(response *ListWorkspaceRoleUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWorkspaceRoleUsersResponse
		var err error
		defer close(result)
		response, err = client.ListWorkspaceRoleUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWorkspaceRoleUsersRequest is the request struct for api ListWorkspaceRoleUsers
type ListWorkspaceRoleUsersRequest struct {
	*requests.RpcRequest
	RoleId      requests.Integer `position:"Query" name:"RoleId"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	PageNum     requests.Integer `position:"Query" name:"PageNum"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Keyword     string           `position:"Query" name:"Keyword"`
	SignType    string           `position:"Query" name:"SignType"`
	WorkspaceId string           `position:"Query" name:"WorkspaceId"`
}

// ListWorkspaceRoleUsersResponse is the response struct for api ListWorkspaceRoleUsers
type ListWorkspaceRoleUsersResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Success   bool                           `json:"Success" xml:"Success"`
	Result    ResultInListWorkspaceRoleUsers `json:"Result" xml:"Result"`
}

// CreateListWorkspaceRoleUsersRequest creates a request to invoke ListWorkspaceRoleUsers API
func CreateListWorkspaceRoleUsersRequest() (request *ListWorkspaceRoleUsersRequest) {
	request = &ListWorkspaceRoleUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "ListWorkspaceRoleUsers", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListWorkspaceRoleUsersResponse creates a response to parse from ListWorkspaceRoleUsers response
func CreateListWorkspaceRoleUsersResponse() (response *ListWorkspaceRoleUsersResponse) {
	response = &ListWorkspaceRoleUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
