package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDataServiceList invokes the quickbi_public.QueryDataServiceList API synchronously
func (client *Client) QueryDataServiceList(request *QueryDataServiceListRequest) (response *QueryDataServiceListResponse, err error) {
	response = CreateQueryDataServiceListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDataServiceListWithChan invokes the quickbi_public.QueryDataServiceList API asynchronously
func (client *Client) QueryDataServiceListWithChan(request *QueryDataServiceListRequest) (<-chan *QueryDataServiceListResponse, <-chan error) {
	responseChan := make(chan *QueryDataServiceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDataServiceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDataServiceListWithCallback invokes the quickbi_public.QueryDataServiceList API asynchronously
func (client *Client) QueryDataServiceListWithCallback(request *QueryDataServiceListRequest, callback func(response *QueryDataServiceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDataServiceListResponse
		var err error
		defer close(result)
		response, err = client.QueryDataServiceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDataServiceListRequest is the request struct for api QueryDataServiceList
type QueryDataServiceListRequest struct {
	*requests.RpcRequest
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	UserId      string           `position:"Query" name:"UserId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	SignType    string           `position:"Query" name:"SignType"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
	Name        string           `position:"Query" name:"Name"`
}

// QueryDataServiceListResponse is the response struct for api QueryDataServiceList
type QueryDataServiceListResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Success   bool                         `json:"Success" xml:"Success"`
	Result    ResultInQueryDataServiceList `json:"Result" xml:"Result"`
}

// CreateQueryDataServiceListRequest creates a request to invoke QueryDataServiceList API
func CreateQueryDataServiceListRequest() (request *QueryDataServiceListRequest) {
	request = &QueryDataServiceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryDataServiceList", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDataServiceListResponse creates a response to parse from QueryDataServiceList response
func CreateQueryDataServiceListResponse() (response *QueryDataServiceListResponse) {
	response = &QueryDataServiceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
