package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDedicatedUserCluster invokes the r_kvstore.CreateDedicatedUserCluster API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/creatededicatedusercluster.html
func (client *Client) CreateDedicatedUserCluster(request *CreateDedicatedUserClusterRequest) (response *CreateDedicatedUserClusterResponse, err error) {
	response = CreateCreateDedicatedUserClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDedicatedUserClusterWithChan invokes the r_kvstore.CreateDedicatedUserCluster API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/creatededicatedusercluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedUserClusterWithChan(request *CreateDedicatedUserClusterRequest) (<-chan *CreateDedicatedUserClusterResponse, <-chan error) {
	responseChan := make(chan *CreateDedicatedUserClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDedicatedUserCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDedicatedUserClusterWithCallback invokes the r_kvstore.CreateDedicatedUserCluster API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/creatededicatedusercluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedUserClusterWithCallback(request *CreateDedicatedUserClusterRequest, callback func(response *CreateDedicatedUserClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDedicatedUserClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateDedicatedUserCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDedicatedUserClusterRequest is the request struct for api CreateDedicatedUserCluster
type CreateDedicatedUserClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterName               string           `position:"Query" name:"ClusterName"`
	SecurityToken             string           `position:"Query" name:"SecurityToken"`
	DiskOverAllocationRatio   requests.Integer `position:"Query" name:"DiskOverAllocationRatio"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	ClusterId                 string           `position:"Query" name:"ClusterId"`
	MemoryOverAllocationRatio requests.Integer `position:"Query" name:"MemoryOverAllocationRatio"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	HostReplacePolicy         string           `position:"Query" name:"HostReplacePolicy"`
	AllocationPolicy          string           `position:"Query" name:"AllocationPolicy"`
	ZoneId                    string           `position:"Query" name:"ZoneId"`
	CpuOverAllocationRatio    requests.Integer `position:"Query" name:"CpuOverAllocationRatio"`
}

// CreateDedicatedUserClusterResponse is the response struct for api CreateDedicatedUserCluster
type CreateDedicatedUserClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
}

// CreateCreateDedicatedUserClusterRequest creates a request to invoke CreateDedicatedUserCluster API
func CreateCreateDedicatedUserClusterRequest() (request *CreateDedicatedUserClusterRequest) {
	request = &CreateDedicatedUserClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "CreateDedicatedUserCluster", "redisa", "openAPI")
	return
}

// CreateCreateDedicatedUserClusterResponse creates a response to parse from CreateDedicatedUserCluster response
func CreateCreateDedicatedUserClusterResponse() (response *CreateDedicatedUserClusterResponse) {
	response = &CreateDedicatedUserClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
