package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSupportOnlineResizeDisk invokes the rds.DescribeSupportOnlineResizeDisk API synchronously
func (client *Client) DescribeSupportOnlineResizeDisk(request *DescribeSupportOnlineResizeDiskRequest) (response *DescribeSupportOnlineResizeDiskResponse, err error) {
	response = CreateDescribeSupportOnlineResizeDiskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSupportOnlineResizeDiskWithChan invokes the rds.DescribeSupportOnlineResizeDisk API asynchronously
func (client *Client) DescribeSupportOnlineResizeDiskWithChan(request *DescribeSupportOnlineResizeDiskRequest) (<-chan *DescribeSupportOnlineResizeDiskResponse, <-chan error) {
	responseChan := make(chan *DescribeSupportOnlineResizeDiskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSupportOnlineResizeDisk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSupportOnlineResizeDiskWithCallback invokes the rds.DescribeSupportOnlineResizeDisk API asynchronously
func (client *Client) DescribeSupportOnlineResizeDiskWithCallback(request *DescribeSupportOnlineResizeDiskRequest, callback func(response *DescribeSupportOnlineResizeDiskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSupportOnlineResizeDiskResponse
		var err error
		defer close(result)
		response, err = client.DescribeSupportOnlineResizeDisk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSupportOnlineResizeDiskRequest is the request struct for api DescribeSupportOnlineResizeDisk
type DescribeSupportOnlineResizeDiskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSupportOnlineResizeDiskResponse is the response struct for api DescribeSupportOnlineResizeDisk
type DescribeSupportOnlineResizeDiskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDescribeSupportOnlineResizeDiskRequest creates a request to invoke DescribeSupportOnlineResizeDisk API
func CreateDescribeSupportOnlineResizeDiskRequest() (request *DescribeSupportOnlineResizeDiskRequest) {
	request = &DescribeSupportOnlineResizeDiskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeSupportOnlineResizeDisk", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSupportOnlineResizeDiskResponse creates a response to parse from DescribeSupportOnlineResizeDisk response
func CreateDescribeSupportOnlineResizeDiskResponse() (response *DescribeSupportOnlineResizeDiskResponse) {
	response = &DescribeSupportOnlineResizeDiskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
