package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceGroup invokes the resourcemanager.DeleteResourceGroup API synchronously
func (client *Client) DeleteResourceGroup(request *DeleteResourceGroupRequest) (response *DeleteResourceGroupResponse, err error) {
	response = CreateDeleteResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceGroupWithChan invokes the resourcemanager.DeleteResourceGroup API asynchronously
func (client *Client) DeleteResourceGroupWithChan(request *DeleteResourceGroupRequest) (<-chan *DeleteResourceGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceGroupWithCallback invokes the resourcemanager.DeleteResourceGroup API asynchronously
func (client *Client) DeleteResourceGroupWithCallback(request *DeleteResourceGroupRequest, callback func(response *DeleteResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceGroupRequest is the request struct for api DeleteResourceGroup
type DeleteResourceGroupRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
}

// DeleteResourceGroupResponse is the response struct for api DeleteResourceGroup
type DeleteResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResourceGroup ResourceGroup `json:"ResourceGroup" xml:"ResourceGroup"`
}

// CreateDeleteResourceGroupRequest creates a request to invoke DeleteResourceGroup API
func CreateDeleteResourceGroupRequest() (request *DeleteResourceGroupRequest) {
	request = &DeleteResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "DeleteResourceGroup", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteResourceGroupResponse creates a response to parse from DeleteResourceGroup response
func CreateDeleteResourceGroupResponse() (response *DeleteResourceGroupResponse) {
	response = &DeleteResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
