package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AudienceExportResultCheck invokes the retailadvqa_public.AudienceExportResultCheck API synchronously
func (client *Client) AudienceExportResultCheck(request *AudienceExportResultCheckRequest) (response *AudienceExportResultCheckResponse, err error) {
	response = CreateAudienceExportResultCheckResponse()
	err = client.DoAction(request, response)
	return
}

// AudienceExportResultCheckWithChan invokes the retailadvqa_public.AudienceExportResultCheck API asynchronously
func (client *Client) AudienceExportResultCheckWithChan(request *AudienceExportResultCheckRequest) (<-chan *AudienceExportResultCheckResponse, <-chan error) {
	responseChan := make(chan *AudienceExportResultCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AudienceExportResultCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AudienceExportResultCheckWithCallback invokes the retailadvqa_public.AudienceExportResultCheck API asynchronously
func (client *Client) AudienceExportResultCheckWithCallback(request *AudienceExportResultCheckRequest, callback func(response *AudienceExportResultCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AudienceExportResultCheckResponse
		var err error
		defer close(result)
		response, err = client.AudienceExportResultCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AudienceExportResultCheckRequest is the request struct for api AudienceExportResultCheck
type AudienceExportResultCheckRequest struct {
	*requests.RpcRequest
	AccessId     string           `position:"Query" name:"AccessId"`
	ErrorMessage string           `position:"Query" name:"ErrorMessage"`
	TenantId     string           `position:"Query" name:"TenantId"`
	TaskId       string           `position:"Query" name:"TaskId"`
	ErrorCode    string           `position:"Query" name:"ErrorCode"`
	Status       requests.Boolean `position:"Query" name:"Status"`
	WorkspaceId  string           `position:"Query" name:"WorkspaceId"`
}

// AudienceExportResultCheckResponse is the response struct for api AudienceExportResultCheck
type AudienceExportResultCheckResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateAudienceExportResultCheckRequest creates a request to invoke AudienceExportResultCheck API
func CreateAudienceExportResultCheckRequest() (request *AudienceExportResultCheckRequest) {
	request = &AudienceExportResultCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "AudienceExportResultCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateAudienceExportResultCheckResponse creates a response to parse from AudienceExportResultCheck response
func CreateAudienceExportResultCheckResponse() (response *AudienceExportResultCheckResponse) {
	response = &AudienceExportResultCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
