package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJobStatus invokes the sae.DescribeJobStatus API synchronously
func (client *Client) DescribeJobStatus(request *DescribeJobStatusRequest) (response *DescribeJobStatusResponse, err error) {
	response = CreateDescribeJobStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobStatusWithChan invokes the sae.DescribeJobStatus API asynchronously
func (client *Client) DescribeJobStatusWithChan(request *DescribeJobStatusRequest) (<-chan *DescribeJobStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeJobStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJobStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobStatusWithCallback invokes the sae.DescribeJobStatus API asynchronously
func (client *Client) DescribeJobStatusWithCallback(request *DescribeJobStatusRequest, callback func(response *DescribeJobStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeJobStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobStatusRequest is the request struct for api DescribeJobStatus
type DescribeJobStatusRequest struct {
	*requests.RoaRequest
	JobId string `position:"Query" name:"JobId"`
	AppId string `position:"Query" name:"AppId"`
}

// DescribeJobStatusResponse is the response struct for api DescribeJobStatus
type DescribeJobStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeJobStatusRequest creates a request to invoke DescribeJobStatus API
func CreateDescribeJobStatusRequest() (request *DescribeJobStatusRequest) {
	request = &DescribeJobStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeJobStatus", "/pop/v1/sam/job/describeJobStatus", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeJobStatusResponse creates a response to parse from DescribeJobStatus response
func CreateDescribeJobStatusResponse() (response *DescribeJobStatusResponse) {
	response = &DescribeJobStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
