package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRiskCheckItemResult invokes the sas.DescribeRiskCheckItemResult API synchronously
func (client *Client) DescribeRiskCheckItemResult(request *DescribeRiskCheckItemResultRequest) (response *DescribeRiskCheckItemResultResponse, err error) {
	response = CreateDescribeRiskCheckItemResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRiskCheckItemResultWithChan invokes the sas.DescribeRiskCheckItemResult API asynchronously
func (client *Client) DescribeRiskCheckItemResultWithChan(request *DescribeRiskCheckItemResultRequest) (<-chan *DescribeRiskCheckItemResultResponse, <-chan error) {
	responseChan := make(chan *DescribeRiskCheckItemResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRiskCheckItemResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRiskCheckItemResultWithCallback invokes the sas.DescribeRiskCheckItemResult API asynchronously
func (client *Client) DescribeRiskCheckItemResultWithCallback(request *DescribeRiskCheckItemResultRequest, callback func(response *DescribeRiskCheckItemResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRiskCheckItemResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeRiskCheckItemResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRiskCheckItemResultRequest is the request struct for api DescribeRiskCheckItemResult
type DescribeRiskCheckItemResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ItemId          requests.Integer `position:"Query" name:"ItemId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// DescribeRiskCheckItemResultResponse is the response struct for api DescribeRiskCheckItemResult
type DescribeRiskCheckItemResultResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	PageContentResource PageContentResource `json:"PageContentResource" xml:"PageContentResource"`
}

// CreateDescribeRiskCheckItemResultRequest creates a request to invoke DescribeRiskCheckItemResult API
func CreateDescribeRiskCheckItemResultRequest() (request *DescribeRiskCheckItemResultRequest) {
	request = &DescribeRiskCheckItemResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeRiskCheckItemResult", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRiskCheckItemResultResponse creates a response to parse from DescribeRiskCheckItemResult response
func CreateDescribeRiskCheckItemResultResponse() (response *DescribeRiskCheckItemResultResponse) {
	response = &DescribeRiskCheckItemResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
