package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIncIOCs invokes the sas.GetIncIOCs API synchronously
func (client *Client) GetIncIOCs(request *GetIncIOCsRequest) (response *GetIncIOCsResponse, err error) {
	response = CreateGetIncIOCsResponse()
	err = client.DoAction(request, response)
	return
}

// GetIncIOCsWithChan invokes the sas.GetIncIOCs API asynchronously
func (client *Client) GetIncIOCsWithChan(request *GetIncIOCsRequest) (<-chan *GetIncIOCsResponse, <-chan error) {
	responseChan := make(chan *GetIncIOCsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIncIOCs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIncIOCsWithCallback invokes the sas.GetIncIOCs API asynchronously
func (client *Client) GetIncIOCsWithCallback(request *GetIncIOCsRequest, callback func(response *GetIncIOCsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIncIOCsResponse
		var err error
		defer close(result)
		response, err = client.GetIncIOCs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIncIOCsRequest is the request struct for api GetIncIOCs
type GetIncIOCsRequest struct {
	*requests.RpcRequest
	Date     string `position:"Query" name:"Date"`
	Type     string `position:"Query" name:"Type"`
	SourceIp string `position:"Query" name:"SourceIp"`
}

// GetIncIOCsResponse is the response struct for api GetIncIOCs
type GetIncIOCsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateGetIncIOCsRequest creates a request to invoke GetIncIOCs API
func CreateGetIncIOCsRequest() (request *GetIncIOCsRequest) {
	request = &GetIncIOCsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "GetIncIOCs", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetIncIOCsResponse creates a response to parse from GetIncIOCs response
func CreateGetIncIOCsResponse() (response *GetIncIOCsResponse) {
	response = &GetIncIOCsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
