package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateJob invokes the schedulerx3.CreateJob API synchronously
func (client *Client) CreateJob(request *CreateJobRequest) (response *CreateJobResponse, err error) {
	response = CreateCreateJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateJobWithChan invokes the schedulerx3.CreateJob API asynchronously
func (client *Client) CreateJobWithChan(request *CreateJobRequest) (<-chan *CreateJobResponse, <-chan error) {
	responseChan := make(chan *CreateJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateJobWithCallback invokes the schedulerx3.CreateJob API asynchronously
func (client *Client) CreateJobWithCallback(request *CreateJobRequest, callback func(response *CreateJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateJobResponse
		var err error
		defer close(result)
		response, err = client.CreateJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateJobRequest is the request struct for api CreateJob
type CreateJobRequest struct {
	*requests.RpcRequest
	MseSessionId          string                     `position:"Query" name:"MseSessionId"`
	ExecutorBlockStrategy requests.Integer           `position:"Body" name:"ExecutorBlockStrategy"`
	Timezone              string                     `position:"Body" name:"Timezone"`
	RouteStrategy         requests.Integer           `position:"Body" name:"RouteStrategy"`
	Description           string                     `position:"Body" name:"Description"`
	AttemptInterval       requests.Integer           `position:"Body" name:"AttemptInterval"`
	StartTime             requests.Integer           `position:"Body" name:"StartTime"`
	AppName               string                     `position:"Body" name:"AppName"`
	NoticeContacts        *[]CreateJobNoticeContacts `position:"Body" name:"NoticeContacts"  type:"Json"`
	NoticeConfig          CreateJobNoticeConfig      `position:"Body" name:"NoticeConfig"  type:"Struct"`
	Calendar              string                     `position:"Body" name:"Calendar"`
	DataOffset            requests.Integer           `position:"Body" name:"DataOffset"`
	MaxAttempt            requests.Integer           `position:"Body" name:"MaxAttempt"`
	ClusterId             string                     `position:"Body" name:"ClusterId"`
	Priority              requests.Integer           `position:"Body" name:"Priority"`
	JobType               string                     `position:"Body" name:"JobType"`
	TimeExpression        string                     `position:"Body" name:"TimeExpression"`
	Name                  string                     `position:"Body" name:"Name"`
	XAttrs                string                     `position:"Body" name:"XAttrs"`
	MaxConcurrency        requests.Integer           `position:"Body" name:"MaxConcurrency"`
	TimeType              requests.Integer           `position:"Body" name:"TimeType"`
	Parameters            string                     `position:"Body" name:"Parameters"`
	JobHandler            string                     `position:"Body" name:"JobHandler"`
	CleanMode             string                     `position:"Body" name:"CleanMode"`
	Status                requests.Integer           `position:"Body" name:"Status"`
}

// CreateJobNoticeContacts is a repeated param struct in CreateJobRequest
type CreateJobNoticeContacts struct {
	ContactType string `name:"ContactType"`
	Name        string `name:"Name"`
}

// CreateJobNoticeConfig is a repeated param struct in CreateJobRequest
type CreateJobNoticeConfig struct {
	TimeoutKillEnable string `name:"TimeoutKillEnable"`
	FailEnable        string `name:"FailEnable"`
	WebhookIsAtAll    string `name:"WebhookIsAtAll"`
	SuccessNotice     string `name:"SuccessNotice"`
	FailLimitTimes    string `name:"FailLimitTimes"`
	SendChannel       string `name:"SendChannel"`
	NoticeChannel     string `name:"NoticeChannel"`
	TimeoutEnable     string `name:"TimeoutEnable"`
	MissWorkerEnable  string `name:"MissWorkerEnable"`
	Timeout           string `name:"Timeout"`
}

// CreateJobResponse is the response struct for api CreateJob
type CreateJobResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateJobRequest creates a request to invoke CreateJob API
func CreateCreateJobRequest() (request *CreateJobRequest) {
	request = &CreateJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "CreateJob", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateJobResponse creates a response to parse from CreateJob response
func CreateCreateJobResponse() (response *CreateJobResponse) {
	response = &CreateJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
