package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportJobs invokes the schedulerx3.ExportJobs API synchronously
func (client *Client) ExportJobs(request *ExportJobsRequest) (response *ExportJobsResponse, err error) {
	response = CreateExportJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ExportJobsWithChan invokes the schedulerx3.ExportJobs API asynchronously
func (client *Client) ExportJobsWithChan(request *ExportJobsRequest) (<-chan *ExportJobsResponse, <-chan error) {
	responseChan := make(chan *ExportJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportJobsWithCallback invokes the schedulerx3.ExportJobs API asynchronously
func (client *Client) ExportJobsWithCallback(request *ExportJobsRequest, callback func(response *ExportJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportJobsResponse
		var err error
		defer close(result)
		response, err = client.ExportJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportJobsRequest is the request struct for api ExportJobs
type ExportJobsRequest struct {
	*requests.RpcRequest
	MseSessionId  string           `position:"Query" name:"MseSessionId"`
	AppName       string           `position:"Body" name:"AppName"`
	ClusterId     string           `position:"Body" name:"ClusterId"`
	JobIds        *[]string        `position:"Body" name:"JobIds"  type:"Json"`
	ExportJobType requests.Integer `position:"Body" name:"ExportJobType"`
}

// ExportJobsResponse is the response struct for api ExportJobs
type ExportJobsResponse struct {
	*responses.BaseResponse
}

// CreateExportJobsRequest creates a request to invoke ExportJobs API
func CreateExportJobsRequest() (request *ExportJobsRequest) {
	request = &ExportJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ExportJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateExportJobsResponse creates a response to parse from ExportJobs response
func CreateExportJobsResponse() (response *ExportJobsResponse) {
	response = &ExportJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
