package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDesigateInfo invokes the schedulerx3.GetDesigateInfo API synchronously
func (client *Client) GetDesigateInfo(request *GetDesigateInfoRequest) (response *GetDesigateInfoResponse, err error) {
	response = CreateGetDesigateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetDesigateInfoWithChan invokes the schedulerx3.GetDesigateInfo API asynchronously
func (client *Client) GetDesigateInfoWithChan(request *GetDesigateInfoRequest) (<-chan *GetDesigateInfoResponse, <-chan error) {
	responseChan := make(chan *GetDesigateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDesigateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDesigateInfoWithCallback invokes the schedulerx3.GetDesigateInfo API asynchronously
func (client *Client) GetDesigateInfoWithCallback(request *GetDesigateInfoRequest, callback func(response *GetDesigateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDesigateInfoResponse
		var err error
		defer close(result)
		response, err = client.GetDesigateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDesigateInfoRequest is the request struct for api GetDesigateInfo
type GetDesigateInfoRequest struct {
	*requests.RpcRequest
	MseSessionId string           `position:"Query" name:"MseSessionId"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	JobId        requests.Integer `position:"Query" name:"JobId"`
	AppName      string           `position:"Query" name:"AppName"`
}

// GetDesigateInfoResponse is the response struct for api GetDesigateInfo
type GetDesigateInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDesigateInfoRequest creates a request to invoke GetDesigateInfo API
func CreateGetDesigateInfoRequest() (request *GetDesigateInfoRequest) {
	request = &GetDesigateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "GetDesigateInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDesigateInfoResponse creates a response to parse from GetDesigateInfo response
func CreateGetDesigateInfoResponse() (response *GetDesigateInfoResponse) {
	response = &GetDesigateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
