package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGatewayFileShare invokes the sgw.ModifyGatewayFileShare API synchronously
func (client *Client) ModifyGatewayFileShare(request *ModifyGatewayFileShareRequest) (response *ModifyGatewayFileShareResponse, err error) {
	response = CreateModifyGatewayFileShareResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGatewayFileShareWithChan invokes the sgw.ModifyGatewayFileShare API asynchronously
func (client *Client) ModifyGatewayFileShareWithChan(request *ModifyGatewayFileShareRequest) (<-chan *ModifyGatewayFileShareResponse, <-chan error) {
	responseChan := make(chan *ModifyGatewayFileShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGatewayFileShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGatewayFileShareWithCallback invokes the sgw.ModifyGatewayFileShare API asynchronously
func (client *Client) ModifyGatewayFileShareWithCallback(request *ModifyGatewayFileShareRequest, callback func(response *ModifyGatewayFileShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGatewayFileShareResponse
		var err error
		defer close(result)
		response, err = client.ModifyGatewayFileShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGatewayFileShareRequest is the request struct for api ModifyGatewayFileShare
type ModifyGatewayFileShareRequest struct {
	*requests.RpcRequest
	CacheConfig   string `position:"Query" name:"CacheConfig"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	IndexId       string `position:"Query" name:"IndexId"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// ModifyGatewayFileShareResponse is the response struct for api ModifyGatewayFileShare
type ModifyGatewayFileShareResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateModifyGatewayFileShareRequest creates a request to invoke ModifyGatewayFileShare API
func CreateModifyGatewayFileShareRequest() (request *ModifyGatewayFileShareRequest) {
	request = &ModifyGatewayFileShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ModifyGatewayFileShare", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyGatewayFileShareResponse creates a response to parse from ModifyGatewayFileShare response
func CreateModifyGatewayFileShareResponse() (response *ModifyGatewayFileShareResponse) {
	response = &ModifyGatewayFileShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
