package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagGlobalRouteProtocol invokes the smartag.DescribeSagGlobalRouteProtocol API synchronously
func (client *Client) DescribeSagGlobalRouteProtocol(request *DescribeSagGlobalRouteProtocolRequest) (response *DescribeSagGlobalRouteProtocolResponse, err error) {
	response = CreateDescribeSagGlobalRouteProtocolResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagGlobalRouteProtocolWithChan invokes the smartag.DescribeSagGlobalRouteProtocol API asynchronously
func (client *Client) DescribeSagGlobalRouteProtocolWithChan(request *DescribeSagGlobalRouteProtocolRequest) (<-chan *DescribeSagGlobalRouteProtocolResponse, <-chan error) {
	responseChan := make(chan *DescribeSagGlobalRouteProtocolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagGlobalRouteProtocol(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagGlobalRouteProtocolWithCallback invokes the smartag.DescribeSagGlobalRouteProtocol API asynchronously
func (client *Client) DescribeSagGlobalRouteProtocolWithCallback(request *DescribeSagGlobalRouteProtocolRequest, callback func(response *DescribeSagGlobalRouteProtocolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagGlobalRouteProtocolResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagGlobalRouteProtocol(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagGlobalRouteProtocolRequest is the request struct for api DescribeSagGlobalRouteProtocol
type DescribeSagGlobalRouteProtocolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DescribeSagGlobalRouteProtocolResponse is the response struct for api DescribeSagGlobalRouteProtocol
type DescribeSagGlobalRouteProtocolResponse struct {
	*responses.BaseResponse
	RouteProtocol string      `json:"RouteProtocol" xml:"RouteProtocol"`
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	TaskStates    []TaskState `json:"TaskStates" xml:"TaskStates"`
}

// CreateDescribeSagGlobalRouteProtocolRequest creates a request to invoke DescribeSagGlobalRouteProtocol API
func CreateDescribeSagGlobalRouteProtocolRequest() (request *DescribeSagGlobalRouteProtocolRequest) {
	request = &DescribeSagGlobalRouteProtocolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagGlobalRouteProtocol", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagGlobalRouteProtocolResponse creates a response to parse from DescribeSagGlobalRouteProtocol response
func CreateDescribeSagGlobalRouteProtocolResponse() (response *DescribeSagGlobalRouteProtocolResponse) {
	response = &DescribeSagGlobalRouteProtocolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
