package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlaybookReleases invokes the sophonsoar.DescribePlaybookReleases API synchronously
func (client *Client) DescribePlaybookReleases(request *DescribePlaybookReleasesRequest) (response *DescribePlaybookReleasesResponse, err error) {
	response = CreateDescribePlaybookReleasesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlaybookReleasesWithChan invokes the sophonsoar.DescribePlaybookReleases API asynchronously
func (client *Client) DescribePlaybookReleasesWithChan(request *DescribePlaybookReleasesRequest) (<-chan *DescribePlaybookReleasesResponse, <-chan error) {
	responseChan := make(chan *DescribePlaybookReleasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlaybookReleases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlaybookReleasesWithCallback invokes the sophonsoar.DescribePlaybookReleases API asynchronously
func (client *Client) DescribePlaybookReleasesWithCallback(request *DescribePlaybookReleasesRequest, callback func(response *DescribePlaybookReleasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlaybookReleasesResponse
		var err error
		defer close(result)
		response, err = client.DescribePlaybookReleases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlaybookReleasesRequest is the request struct for api DescribePlaybookReleases
type DescribePlaybookReleasesRequest struct {
	*requests.RpcRequest
	RoleFor      string           `position:"Query" name:"RoleFor"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PlaybookUuid string           `position:"Query" name:"PlaybookUuid"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	RoleType     string           `position:"Query" name:"RoleType"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribePlaybookReleasesResponse is the response struct for api DescribePlaybookReleases
type DescribePlaybookReleasesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Page      Page   `json:"Page" xml:"Page"`
	Records   []Data `json:"Records" xml:"Records"`
}

// CreateDescribePlaybookReleasesRequest creates a request to invoke DescribePlaybookReleases API
func CreateDescribePlaybookReleasesRequest() (request *DescribePlaybookReleasesRequest) {
	request = &DescribePlaybookReleasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePlaybookReleases", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePlaybookReleasesResponse creates a response to parse from DescribePlaybookReleases response
func CreateDescribePlaybookReleasesResponse() (response *DescribePlaybookReleasesResponse) {
	response = &DescribePlaybookReleasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
