package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetContact invokes the subscription.GetContact API synchronously
// api document: https://help.aliyun.com/api/subscription/getcontact.html
func (client *Client) GetContact(request *GetContactRequest) (response *GetContactResponse, err error) {
	response = CreateGetContactResponse()
	err = client.DoAction(request, response)
	return
}

// GetContactWithChan invokes the subscription.GetContact API asynchronously
// api document: https://help.aliyun.com/api/subscription/getcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetContactWithChan(request *GetContactRequest) (<-chan *GetContactResponse, <-chan error) {
	responseChan := make(chan *GetContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetContactWithCallback invokes the subscription.GetContact API asynchronously
// api document: https://help.aliyun.com/api/subscription/getcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetContactWithCallback(request *GetContactRequest, callback func(response *GetContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetContactResponse
		var err error
		defer close(result)
		response, err = client.GetContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetContactRequest is the request struct for api GetContact
type GetContactRequest struct {
	*requests.RpcRequest
	ContactId requests.Integer `position:"Query" name:"ContactId"`
	Locale    string           `position:"Query" name:"Locale"`
}

// GetContactResponse is the response struct for api GetContact
type GetContactResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Message   string  `json:"Message" xml:"Message"`
	Code      string  `json:"Code" xml:"Code"`
	Success   bool    `json:"Success" xml:"Success"`
	Contact   Contact `json:"Contact" xml:"Contact"`
}

// CreateGetContactRequest creates a request to invoke GetContact API
func CreateGetContactRequest() (request *GetContactRequest) {
	request = &GetContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "GetContact", "", "")
	return
}

// CreateGetContactResponse creates a response to parse from GetContact response
func CreateGetContactResponse() (response *GetContactResponse) {
	response = &GetContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
