package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFirewallRules invokes the swas_open.DeleteFirewallRules API synchronously
func (client *Client) DeleteFirewallRules(request *DeleteFirewallRulesRequest) (response *DeleteFirewallRulesResponse, err error) {
	response = CreateDeleteFirewallRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFirewallRulesWithChan invokes the swas_open.DeleteFirewallRules API asynchronously
func (client *Client) DeleteFirewallRulesWithChan(request *DeleteFirewallRulesRequest) (<-chan *DeleteFirewallRulesResponse, <-chan error) {
	responseChan := make(chan *DeleteFirewallRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFirewallRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFirewallRulesWithCallback invokes the swas_open.DeleteFirewallRules API asynchronously
func (client *Client) DeleteFirewallRulesWithCallback(request *DeleteFirewallRulesRequest, callback func(response *DeleteFirewallRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFirewallRulesResponse
		var err error
		defer close(result)
		response, err = client.DeleteFirewallRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFirewallRulesRequest is the request struct for api DeleteFirewallRules
type DeleteFirewallRulesRequest struct {
	*requests.RpcRequest
	ClientToken string    `position:"Query" name:"ClientToken"`
	RuleIds     *[]string `position:"Query" name:"RuleIds"  type:"Repeated"`
	InstanceId  string    `position:"Query" name:"InstanceId"`
}

// DeleteFirewallRulesResponse is the response struct for api DeleteFirewallRules
type DeleteFirewallRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFirewallRulesRequest creates a request to invoke DeleteFirewallRules API
func CreateDeleteFirewallRulesRequest() (request *DeleteFirewallRulesRequest) {
	request = &DeleteFirewallRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DeleteFirewallRules", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFirewallRulesResponse creates a response to parse from DeleteFirewallRules response
func CreateDeleteFirewallRulesResponse() (response *DeleteFirewallRulesResponse) {
	response = &DeleteFirewallRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
