package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnablePolicyType invokes the tag.EnablePolicyType API synchronously
func (client *Client) EnablePolicyType(request *EnablePolicyTypeRequest) (response *EnablePolicyTypeResponse, err error) {
	response = CreateEnablePolicyTypeResponse()
	err = client.DoAction(request, response)
	return
}

// EnablePolicyTypeWithChan invokes the tag.EnablePolicyType API asynchronously
func (client *Client) EnablePolicyTypeWithChan(request *EnablePolicyTypeRequest) (<-chan *EnablePolicyTypeResponse, <-chan error) {
	responseChan := make(chan *EnablePolicyTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnablePolicyType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnablePolicyTypeWithCallback invokes the tag.EnablePolicyType API asynchronously
func (client *Client) EnablePolicyTypeWithCallback(request *EnablePolicyTypeRequest, callback func(response *EnablePolicyTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnablePolicyTypeResponse
		var err error
		defer close(result)
		response, err = client.EnablePolicyType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnablePolicyTypeRequest is the request struct for api EnablePolicyType
type EnablePolicyTypeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UserType             string           `position:"Query" name:"UserType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OpenType             string           `position:"Query" name:"OpenType"`
}

// EnablePolicyTypeResponse is the response struct for api EnablePolicyType
type EnablePolicyTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnablePolicyTypeRequest creates a request to invoke EnablePolicyType API
func CreateEnablePolicyTypeRequest() (request *EnablePolicyTypeRequest) {
	request = &EnablePolicyTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "EnablePolicyType", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnablePolicyTypeResponse creates a response to parse from EnablePolicyType response
func CreateEnablePolicyTypeResponse() (response *EnablePolicyTypeResponse) {
	response = &EnablePolicyTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
