package threedvision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EstimateMonocularImageDepth invokes the threedvision.EstimateMonocularImageDepth API synchronously
func (client *Client) EstimateMonocularImageDepth(request *EstimateMonocularImageDepthRequest) (response *EstimateMonocularImageDepthResponse, err error) {
	response = CreateEstimateMonocularImageDepthResponse()
	err = client.DoAction(request, response)
	return
}

// EstimateMonocularImageDepthWithChan invokes the threedvision.EstimateMonocularImageDepth API asynchronously
func (client *Client) EstimateMonocularImageDepthWithChan(request *EstimateMonocularImageDepthRequest) (<-chan *EstimateMonocularImageDepthResponse, <-chan error) {
	responseChan := make(chan *EstimateMonocularImageDepthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EstimateMonocularImageDepth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EstimateMonocularImageDepthWithCallback invokes the threedvision.EstimateMonocularImageDepth API asynchronously
func (client *Client) EstimateMonocularImageDepthWithCallback(request *EstimateMonocularImageDepthRequest, callback func(response *EstimateMonocularImageDepthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EstimateMonocularImageDepthResponse
		var err error
		defer close(result)
		response, err = client.EstimateMonocularImageDepth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EstimateMonocularImageDepthRequest is the request struct for api EstimateMonocularImageDepth
type EstimateMonocularImageDepthRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// EstimateMonocularImageDepthResponse is the response struct for api EstimateMonocularImageDepth
type EstimateMonocularImageDepthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEstimateMonocularImageDepthRequest creates a request to invoke EstimateMonocularImageDepth API
func CreateEstimateMonocularImageDepthRequest() (request *EstimateMonocularImageDepthRequest) {
	request = &EstimateMonocularImageDepthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("threedvision", "2021-01-31", "EstimateMonocularImageDepth", "threedvision", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEstimateMonocularImageDepthResponse creates a response to parse from EstimateMonocularImageDepth response
func CreateEstimateMonocularImageDepthResponse() (response *EstimateMonocularImageDepthResponse) {
	response = &EstimateMonocularImageDepthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
