package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMaterial invokes the trademark.UpdateMaterial API synchronously
// api document: https://help.aliyun.com/api/trademark/updatematerial.html
func (client *Client) UpdateMaterial(request *UpdateMaterialRequest) (response *UpdateMaterialResponse, err error) {
	response = CreateUpdateMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMaterialWithChan invokes the trademark.UpdateMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/updatematerial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateMaterialWithChan(request *UpdateMaterialRequest) (<-chan *UpdateMaterialResponse, <-chan error) {
	responseChan := make(chan *UpdateMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMaterialWithCallback invokes the trademark.UpdateMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/updatematerial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateMaterialWithCallback(request *UpdateMaterialRequest, callback func(response *UpdateMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMaterialResponse
		var err error
		defer close(result)
		response, err = client.UpdateMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMaterialRequest is the request struct for api UpdateMaterial
type UpdateMaterialRequest struct {
	*requests.RpcRequest
	ContactEmail          string           `position:"Query" name:"ContactEmail"`
	ContactAddress        string           `position:"Query" name:"ContactAddress"`
	EAddress              string           `position:"Query" name:"EAddress"`
	LegalNoticeOssKey     string           `position:"Query" name:"LegalNoticeOssKey"`
	Address               string           `position:"Query" name:"Address"`
	Town                  string           `position:"Query" name:"Town"`
	ContactNumber         string           `position:"Query" name:"ContactNumber"`
	City                  string           `position:"Query" name:"City"`
	IdCardOssKey          string           `position:"Query" name:"IdCardOssKey"`
	ContactName           string           `position:"Query" name:"ContactName"`
	PassportOssKey        string           `position:"Query" name:"PassportOssKey"`
	ContactZipcode        string           `position:"Query" name:"ContactZipcode"`
	EName                 string           `position:"Query" name:"EName"`
	Province              string           `position:"Query" name:"Province"`
	BusinessLicenceOssKey string           `position:"Query" name:"BusinessLicenceOssKey"`
	Name                  string           `position:"Query" name:"Name"`
	Id                    requests.Integer `position:"Query" name:"Id"`
	CardNumber            string           `position:"Query" name:"CardNumber"`
	LoaId                 requests.Integer `position:"Query" name:"LoaId"`
	LoaOssKey             string           `position:"Query" name:"LoaOssKey"`
}

// UpdateMaterialResponse is the response struct for api UpdateMaterial
type UpdateMaterialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateMaterialRequest creates a request to invoke UpdateMaterial API
func CreateUpdateMaterialRequest() (request *UpdateMaterialRequest) {
	request = &UpdateMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "UpdateMaterial", "trademark", "openAPI")
	return
}

// CreateUpdateMaterialResponse creates a response to parse from UpdateMaterial response
func CreateUpdateMaterialResponse() (response *UpdateMaterialResponse) {
	response = &UpdateMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
