package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnatEntries invokes the uis.DescribeDnatEntries API synchronously
// api document: https://help.aliyun.com/api/uis/describednatentries.html
func (client *Client) DescribeDnatEntries(request *DescribeDnatEntriesRequest) (response *DescribeDnatEntriesResponse, err error) {
	response = CreateDescribeDnatEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnatEntriesWithChan invokes the uis.DescribeDnatEntries API asynchronously
// api document: https://help.aliyun.com/api/uis/describednatentries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDnatEntriesWithChan(request *DescribeDnatEntriesRequest) (<-chan *DescribeDnatEntriesResponse, <-chan error) {
	responseChan := make(chan *DescribeDnatEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnatEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnatEntriesWithCallback invokes the uis.DescribeDnatEntries API asynchronously
// api document: https://help.aliyun.com/api/uis/describednatentries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDnatEntriesWithCallback(request *DescribeDnatEntriesRequest, callback func(response *DescribeDnatEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnatEntriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnatEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnatEntriesRequest is the request struct for api DescribeDnatEntries
type DescribeDnatEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UisDnatId            string           `position:"Query" name:"UisDnatId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDnatEntriesResponse is the response struct for api DescribeDnatEntries
type DescribeDnatEntriesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	UisDnatEntries UisDnatEntries `json:"UisDnatEntries" xml:"UisDnatEntries"`
}

// CreateDescribeDnatEntriesRequest creates a request to invoke DescribeDnatEntries API
func CreateDescribeDnatEntriesRequest() (request *DescribeDnatEntriesRequest) {
	request = &DescribeDnatEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeDnatEntries", "uis", "openAPI")
	return
}

// CreateDescribeDnatEntriesResponse creates a response to parse from DescribeDnatEntries response
func CreateDescribeDnatEntriesResponse() (response *DescribeDnatEntriesResponse) {
	response = &DescribeDnatEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
