package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIndustryLabelBag invokes the unimkt.QueryIndustryLabelBag API synchronously
func (client *Client) QueryIndustryLabelBag(request *QueryIndustryLabelBagRequest) (response *QueryIndustryLabelBagResponse, err error) {
	response = CreateQueryIndustryLabelBagResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIndustryLabelBagWithChan invokes the unimkt.QueryIndustryLabelBag API asynchronously
func (client *Client) QueryIndustryLabelBagWithChan(request *QueryIndustryLabelBagRequest) (<-chan *QueryIndustryLabelBagResponse, <-chan error) {
	responseChan := make(chan *QueryIndustryLabelBagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIndustryLabelBag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIndustryLabelBagWithCallback invokes the unimkt.QueryIndustryLabelBag API asynchronously
func (client *Client) QueryIndustryLabelBagWithCallback(request *QueryIndustryLabelBagRequest, callback func(response *QueryIndustryLabelBagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIndustryLabelBagResponse
		var err error
		defer close(result)
		response, err = client.QueryIndustryLabelBag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIndustryLabelBagRequest is the request struct for api QueryIndustryLabelBag
type QueryIndustryLabelBagRequest struct {
	*requests.RpcRequest
	ChannelId string `position:"Query" name:"ChannelId"`
}

// QueryIndustryLabelBagResponse is the response struct for api QueryIndustryLabelBag
type QueryIndustryLabelBagResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryIndustryLabelBagRequest creates a request to invoke QueryIndustryLabelBag API
func CreateQueryIndustryLabelBagRequest() (request *QueryIndustryLabelBagRequest) {
	request = &QueryIndustryLabelBagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryIndustryLabelBag", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryIndustryLabelBagResponse creates a response to parse from QueryIndustryLabelBag response
func CreateQueryIndustryLabelBagResponse() (response *QueryIndustryLabelBagResponse) {
	response = &QueryIndustryLabelBagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
