package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateDownloadSecretKey invokes the vod.GenerateDownloadSecretKey API synchronously
func (client *Client) GenerateDownloadSecretKey(request *GenerateDownloadSecretKeyRequest) (response *GenerateDownloadSecretKeyResponse, err error) {
	response = CreateGenerateDownloadSecretKeyResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateDownloadSecretKeyWithChan invokes the vod.GenerateDownloadSecretKey API asynchronously
func (client *Client) GenerateDownloadSecretKeyWithChan(request *GenerateDownloadSecretKeyRequest) (<-chan *GenerateDownloadSecretKeyResponse, <-chan error) {
	responseChan := make(chan *GenerateDownloadSecretKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateDownloadSecretKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateDownloadSecretKeyWithCallback invokes the vod.GenerateDownloadSecretKey API asynchronously
func (client *Client) GenerateDownloadSecretKeyWithCallback(request *GenerateDownloadSecretKeyRequest, callback func(response *GenerateDownloadSecretKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateDownloadSecretKeyResponse
		var err error
		defer close(result)
		response, err = client.GenerateDownloadSecretKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateDownloadSecretKeyRequest is the request struct for api GenerateDownloadSecretKey
type GenerateDownloadSecretKeyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AppDecryptKey        string           `position:"Query" name:"AppDecryptKey"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	AppIdentification    string           `position:"Query" name:"AppIdentification"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GenerateDownloadSecretKeyResponse is the response struct for api GenerateDownloadSecretKey
type GenerateDownloadSecretKeyResponse struct {
	*responses.BaseResponse
	AppEncryptKey string `json:"AppEncryptKey" xml:"AppEncryptKey"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateGenerateDownloadSecretKeyRequest creates a request to invoke GenerateDownloadSecretKey API
func CreateGenerateDownloadSecretKeyRequest() (request *GenerateDownloadSecretKeyRequest) {
	request = &GenerateDownloadSecretKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GenerateDownloadSecretKey", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateDownloadSecretKeyResponse creates a response to parse from GenerateDownloadSecretKey response
func CreateGenerateDownloadSecretKeyResponse() (response *GenerateDownloadSecretKeyResponse) {
	response = &GenerateDownloadSecretKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
