package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VpcDescribeVpcNatGatewayNetworkInterfaceQuota invokes the vpc.VpcDescribeVpcNatGatewayNetworkInterfaceQuota API synchronously
func (client *Client) VpcDescribeVpcNatGatewayNetworkInterfaceQuota(request *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest) (response *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse, err error) {
	response = CreateVpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// VpcDescribeVpcNatGatewayNetworkInterfaceQuotaWithChan invokes the vpc.VpcDescribeVpcNatGatewayNetworkInterfaceQuota API asynchronously
func (client *Client) VpcDescribeVpcNatGatewayNetworkInterfaceQuotaWithChan(request *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest) (<-chan *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse, <-chan error) {
	responseChan := make(chan *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VpcDescribeVpcNatGatewayNetworkInterfaceQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VpcDescribeVpcNatGatewayNetworkInterfaceQuotaWithCallback invokes the vpc.VpcDescribeVpcNatGatewayNetworkInterfaceQuota API asynchronously
func (client *Client) VpcDescribeVpcNatGatewayNetworkInterfaceQuotaWithCallback(request *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest, callback func(response *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse
		var err error
		defer close(result)
		response, err = client.VpcDescribeVpcNatGatewayNetworkInterfaceQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest is the request struct for api VpcDescribeVpcNatGatewayNetworkInterfaceQuota
type VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceUid          requests.Integer `position:"Query" name:"ResourceUid"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse is the response struct for api VpcDescribeVpcNatGatewayNetworkInterfaceQuota
type VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Quota     int64  `json:"Quota" xml:"Quota"`
}

// CreateVpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest creates a request to invoke VpcDescribeVpcNatGatewayNetworkInterfaceQuota API
func CreateVpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest() (request *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest) {
	request = &VpcDescribeVpcNatGatewayNetworkInterfaceQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "VpcDescribeVpcNatGatewayNetworkInterfaceQuota", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse creates a response to parse from VpcDescribeVpcNatGatewayNetworkInterfaceQuota response
func CreateVpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse() (response *VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse) {
	response = &VpcDescribeVpcNatGatewayNetworkInterfaceQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
