package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindTemplate invokes the vs.BindTemplate API synchronously
func (client *Client) BindTemplate(request *BindTemplateRequest) (response *BindTemplateResponse, err error) {
	response = CreateBindTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// BindTemplateWithChan invokes the vs.BindTemplate API asynchronously
func (client *Client) BindTemplateWithChan(request *BindTemplateRequest) (<-chan *BindTemplateResponse, <-chan error) {
	responseChan := make(chan *BindTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindTemplateWithCallback invokes the vs.BindTemplate API asynchronously
func (client *Client) BindTemplateWithCallback(request *BindTemplateRequest, callback func(response *BindTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindTemplateResponse
		var err error
		defer close(result)
		response, err = client.BindTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindTemplateRequest is the request struct for api BindTemplate
type BindTemplateRequest struct {
	*requests.RpcRequest
	Replace      requests.Boolean `position:"Query" name:"Replace"`
	TemplateType string           `position:"Query" name:"TemplateType"`
	InstanceType string           `position:"Query" name:"InstanceType"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	ApplyAll     requests.Boolean `position:"Query" name:"ApplyAll"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId   string           `position:"Query" name:"TemplateId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
}

// BindTemplateResponse is the response struct for api BindTemplate
type BindTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	TemplateId   string `json:"TemplateId" xml:"TemplateId"`
}

// CreateBindTemplateRequest creates a request to invoke BindTemplate API
func CreateBindTemplateRequest() (request *BindTemplateRequest) {
	request = &BindTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BindTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateBindTemplateResponse creates a response to parse from BindTemplate response
func CreateBindTemplateResponse() (response *BindTemplateResponse) {
	response = &BindTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
