package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDirectory invokes the vs.ModifyDirectory API synchronously
func (client *Client) ModifyDirectory(request *ModifyDirectoryRequest) (response *ModifyDirectoryResponse, err error) {
	response = CreateModifyDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDirectoryWithChan invokes the vs.ModifyDirectory API asynchronously
func (client *Client) ModifyDirectoryWithChan(request *ModifyDirectoryRequest) (<-chan *ModifyDirectoryResponse, <-chan error) {
	responseChan := make(chan *ModifyDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDirectoryWithCallback invokes the vs.ModifyDirectory API asynchronously
func (client *Client) ModifyDirectoryWithCallback(request *ModifyDirectoryRequest, callback func(response *ModifyDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDirectoryResponse
		var err error
		defer close(result)
		response, err = client.ModifyDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDirectoryRequest is the request struct for api ModifyDirectory
type ModifyDirectoryRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	Id          string           `position:"Query" name:"Id"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	Name        string           `position:"Query" name:"Name"`
}

// ModifyDirectoryResponse is the response struct for api ModifyDirectory
type ModifyDirectoryResponse struct {
	*responses.BaseResponse
	Id        string `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDirectoryRequest creates a request to invoke ModifyDirectory API
func CreateModifyDirectoryRequest() (request *ModifyDirectoryRequest) {
	request = &ModifyDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ModifyDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDirectoryResponse creates a response to parse from ModifyDirectory response
func CreateModifyDirectoryResponse() (response *ModifyDirectoryResponse) {
	response = &ModifyDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
