package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppEnvs invokes the webplus.DescribeAppEnvs API synchronously
// api document: https://help.aliyun.com/api/webplus/describeappenvs.html
func (client *Client) DescribeAppEnvs(request *DescribeAppEnvsRequest) (response *DescribeAppEnvsResponse, err error) {
	response = CreateDescribeAppEnvsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppEnvsWithChan invokes the webplus.DescribeAppEnvs API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeappenvs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppEnvsWithChan(request *DescribeAppEnvsRequest) (<-chan *DescribeAppEnvsResponse, <-chan error) {
	responseChan := make(chan *DescribeAppEnvsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppEnvs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppEnvsWithCallback invokes the webplus.DescribeAppEnvs API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeappenvs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppEnvsWithCallback(request *DescribeAppEnvsRequest, callback func(response *DescribeAppEnvsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppEnvsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppEnvs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppEnvsRequest is the request struct for api DescribeAppEnvs
type DescribeAppEnvsRequest struct {
	*requests.RoaRequest
	RecentUpdated     requests.Boolean `position:"Query" name:"RecentUpdated"`
	EnvName           string           `position:"Query" name:"EnvName"`
	AppId             string           `position:"Query" name:"AppId"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	IncludeTerminated requests.Boolean `position:"Query" name:"IncludeTerminated"`
	EnvId             string           `position:"Query" name:"EnvId"`
	StackSearch       string           `position:"Query" name:"StackSearch"`
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	EnvSearch         string           `position:"Query" name:"EnvSearch"`
}

// DescribeAppEnvsResponse is the response struct for api DescribeAppEnvs
type DescribeAppEnvsResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	AppEnvs    AppEnvs `json:"AppEnvs" xml:"AppEnvs"`
}

// CreateDescribeAppEnvsRequest creates a request to invoke DescribeAppEnvs API
func CreateDescribeAppEnvsRequest() (request *DescribeAppEnvsRequest) {
	request = &DescribeAppEnvsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeAppEnvs", "/pop/v1/wam/appEnv", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAppEnvsResponse creates a response to parse from DescribeAppEnvs response
func CreateDescribeAppEnvsResponse() (response *DescribeAppEnvsResponse) {
	response = &DescribeAppEnvsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
