package wfts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLjxAccountInfo invokes the wfts.GetLjxAccountInfo API synchronously
func (client *Client) GetLjxAccountInfo(request *GetLjxAccountInfoRequest) (response *GetLjxAccountInfoResponse, err error) {
	response = CreateGetLjxAccountInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetLjxAccountInfoWithChan invokes the wfts.GetLjxAccountInfo API asynchronously
func (client *Client) GetLjxAccountInfoWithChan(request *GetLjxAccountInfoRequest) (<-chan *GetLjxAccountInfoResponse, <-chan error) {
	responseChan := make(chan *GetLjxAccountInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLjxAccountInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLjxAccountInfoWithCallback invokes the wfts.GetLjxAccountInfo API asynchronously
func (client *Client) GetLjxAccountInfoWithCallback(request *GetLjxAccountInfoRequest, callback func(response *GetLjxAccountInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLjxAccountInfoResponse
		var err error
		defer close(result)
		response, err = client.GetLjxAccountInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLjxAccountInfoRequest is the request struct for api GetLjxAccountInfo
type GetLjxAccountInfoRequest struct {
	*requests.RoaRequest
	LjxAccountInfoId string `position:"Query" name:"LjxAccountInfoId"`
}

// GetLjxAccountInfoResponse is the response struct for api GetLjxAccountInfo
type GetLjxAccountInfoResponse struct {
	*responses.BaseResponse
	LjxAccountInfoId string `json:"LjxAccountInfoId" xml:"LjxAccountInfoId"`
	RequestId        string `json:"requestId" xml:"requestId"`
}

// CreateGetLjxAccountInfoRequest creates a request to invoke GetLjxAccountInfo API
func CreateGetLjxAccountInfoRequest() (request *GetLjxAccountInfoRequest) {
	request = &GetLjxAccountInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Wfts", "2022-02-12", "GetLjxAccountInfo", "/get/ljx/acc", "", "")
	request.Method = requests.GET
	return
}

// CreateGetLjxAccountInfoResponse creates a response to parse from GetLjxAccountInfo response
func CreateGetLjxAccountInfoResponse() (response *GetLjxAccountInfoResponse) {
	response = &GetLjxAccountInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
