// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package sagemakeriface provides an interface to enable mocking the Amazon SageMaker Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package sagemakeriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sagemaker"
)

// SageMakerAPI provides an interface to enable mocking the
// sagemaker.SageMaker service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon SageMaker Service.
//	func myFunc(svc sagemakeriface.SageMakerAPI) bool {
//	    // Make svc.AddAssociation request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := sagemaker.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSageMakerClient struct {
//	    sagemakeriface.SageMakerAPI
//	}
//	func (m *mockSageMakerClient) AddAssociation(input *sagemaker.AddAssociationInput) (*sagemaker.AddAssociationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSageMakerClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SageMakerAPI interface {
	AddAssociation(*sagemaker.AddAssociationInput) (*sagemaker.AddAssociationOutput, error)
	AddAssociationWithContext(aws.Context, *sagemaker.AddAssociationInput, ...request.Option) (*sagemaker.AddAssociationOutput, error)
	AddAssociationRequest(*sagemaker.AddAssociationInput) (*request.Request, *sagemaker.AddAssociationOutput)

	AddTags(*sagemaker.AddTagsInput) (*sagemaker.AddTagsOutput, error)
	AddTagsWithContext(aws.Context, *sagemaker.AddTagsInput, ...request.Option) (*sagemaker.AddTagsOutput, error)
	AddTagsRequest(*sagemaker.AddTagsInput) (*request.Request, *sagemaker.AddTagsOutput)

	AssociateTrialComponent(*sagemaker.AssociateTrialComponentInput) (*sagemaker.AssociateTrialComponentOutput, error)
	AssociateTrialComponentWithContext(aws.Context, *sagemaker.AssociateTrialComponentInput, ...request.Option) (*sagemaker.AssociateTrialComponentOutput, error)
	AssociateTrialComponentRequest(*sagemaker.AssociateTrialComponentInput) (*request.Request, *sagemaker.AssociateTrialComponentOutput)

	BatchDescribeModelPackage(*sagemaker.BatchDescribeModelPackageInput) (*sagemaker.BatchDescribeModelPackageOutput, error)
	BatchDescribeModelPackageWithContext(aws.Context, *sagemaker.BatchDescribeModelPackageInput, ...request.Option) (*sagemaker.BatchDescribeModelPackageOutput, error)
	BatchDescribeModelPackageRequest(*sagemaker.BatchDescribeModelPackageInput) (*request.Request, *sagemaker.BatchDescribeModelPackageOutput)

	CreateAction(*sagemaker.CreateActionInput) (*sagemaker.CreateActionOutput, error)
	CreateActionWithContext(aws.Context, *sagemaker.CreateActionInput, ...request.Option) (*sagemaker.CreateActionOutput, error)
	CreateActionRequest(*sagemaker.CreateActionInput) (*request.Request, *sagemaker.CreateActionOutput)

	CreateAlgorithm(*sagemaker.CreateAlgorithmInput) (*sagemaker.CreateAlgorithmOutput, error)
	CreateAlgorithmWithContext(aws.Context, *sagemaker.CreateAlgorithmInput, ...request.Option) (*sagemaker.CreateAlgorithmOutput, error)
	CreateAlgorithmRequest(*sagemaker.CreateAlgorithmInput) (*request.Request, *sagemaker.CreateAlgorithmOutput)

	CreateApp(*sagemaker.CreateAppInput) (*sagemaker.CreateAppOutput, error)
	CreateAppWithContext(aws.Context, *sagemaker.CreateAppInput, ...request.Option) (*sagemaker.CreateAppOutput, error)
	CreateAppRequest(*sagemaker.CreateAppInput) (*request.Request, *sagemaker.CreateAppOutput)

	CreateAppImageConfig(*sagemaker.CreateAppImageConfigInput) (*sagemaker.CreateAppImageConfigOutput, error)
	CreateAppImageConfigWithContext(aws.Context, *sagemaker.CreateAppImageConfigInput, ...request.Option) (*sagemaker.CreateAppImageConfigOutput, error)
	CreateAppImageConfigRequest(*sagemaker.CreateAppImageConfigInput) (*request.Request, *sagemaker.CreateAppImageConfigOutput)

	CreateArtifact(*sagemaker.CreateArtifactInput) (*sagemaker.CreateArtifactOutput, error)
	CreateArtifactWithContext(aws.Context, *sagemaker.CreateArtifactInput, ...request.Option) (*sagemaker.CreateArtifactOutput, error)
	CreateArtifactRequest(*sagemaker.CreateArtifactInput) (*request.Request, *sagemaker.CreateArtifactOutput)

	CreateAutoMLJob(*sagemaker.CreateAutoMLJobInput) (*sagemaker.CreateAutoMLJobOutput, error)
	CreateAutoMLJobWithContext(aws.Context, *sagemaker.CreateAutoMLJobInput, ...request.Option) (*sagemaker.CreateAutoMLJobOutput, error)
	CreateAutoMLJobRequest(*sagemaker.CreateAutoMLJobInput) (*request.Request, *sagemaker.CreateAutoMLJobOutput)

	CreateAutoMLJobV2(*sagemaker.CreateAutoMLJobV2Input) (*sagemaker.CreateAutoMLJobV2Output, error)
	CreateAutoMLJobV2WithContext(aws.Context, *sagemaker.CreateAutoMLJobV2Input, ...request.Option) (*sagemaker.CreateAutoMLJobV2Output, error)
	CreateAutoMLJobV2Request(*sagemaker.CreateAutoMLJobV2Input) (*request.Request, *sagemaker.CreateAutoMLJobV2Output)

	CreateCodeRepository(*sagemaker.CreateCodeRepositoryInput) (*sagemaker.CreateCodeRepositoryOutput, error)
	CreateCodeRepositoryWithContext(aws.Context, *sagemaker.CreateCodeRepositoryInput, ...request.Option) (*sagemaker.CreateCodeRepositoryOutput, error)
	CreateCodeRepositoryRequest(*sagemaker.CreateCodeRepositoryInput) (*request.Request, *sagemaker.CreateCodeRepositoryOutput)

	CreateCompilationJob(*sagemaker.CreateCompilationJobInput) (*sagemaker.CreateCompilationJobOutput, error)
	CreateCompilationJobWithContext(aws.Context, *sagemaker.CreateCompilationJobInput, ...request.Option) (*sagemaker.CreateCompilationJobOutput, error)
	CreateCompilationJobRequest(*sagemaker.CreateCompilationJobInput) (*request.Request, *sagemaker.CreateCompilationJobOutput)

	CreateContext(*sagemaker.CreateContextInput) (*sagemaker.CreateContextOutput, error)
	CreateContextWithContext(aws.Context, *sagemaker.CreateContextInput, ...request.Option) (*sagemaker.CreateContextOutput, error)
	CreateContextRequest(*sagemaker.CreateContextInput) (*request.Request, *sagemaker.CreateContextOutput)

	CreateDataQualityJobDefinition(*sagemaker.CreateDataQualityJobDefinitionInput) (*sagemaker.CreateDataQualityJobDefinitionOutput, error)
	CreateDataQualityJobDefinitionWithContext(aws.Context, *sagemaker.CreateDataQualityJobDefinitionInput, ...request.Option) (*sagemaker.CreateDataQualityJobDefinitionOutput, error)
	CreateDataQualityJobDefinitionRequest(*sagemaker.CreateDataQualityJobDefinitionInput) (*request.Request, *sagemaker.CreateDataQualityJobDefinitionOutput)

	CreateDeviceFleet(*sagemaker.CreateDeviceFleetInput) (*sagemaker.CreateDeviceFleetOutput, error)
	CreateDeviceFleetWithContext(aws.Context, *sagemaker.CreateDeviceFleetInput, ...request.Option) (*sagemaker.CreateDeviceFleetOutput, error)
	CreateDeviceFleetRequest(*sagemaker.CreateDeviceFleetInput) (*request.Request, *sagemaker.CreateDeviceFleetOutput)

	CreateDomain(*sagemaker.CreateDomainInput) (*sagemaker.CreateDomainOutput, error)
	CreateDomainWithContext(aws.Context, *sagemaker.CreateDomainInput, ...request.Option) (*sagemaker.CreateDomainOutput, error)
	CreateDomainRequest(*sagemaker.CreateDomainInput) (*request.Request, *sagemaker.CreateDomainOutput)

	CreateEdgeDeploymentPlan(*sagemaker.CreateEdgeDeploymentPlanInput) (*sagemaker.CreateEdgeDeploymentPlanOutput, error)
	CreateEdgeDeploymentPlanWithContext(aws.Context, *sagemaker.CreateEdgeDeploymentPlanInput, ...request.Option) (*sagemaker.CreateEdgeDeploymentPlanOutput, error)
	CreateEdgeDeploymentPlanRequest(*sagemaker.CreateEdgeDeploymentPlanInput) (*request.Request, *sagemaker.CreateEdgeDeploymentPlanOutput)

	CreateEdgeDeploymentStage(*sagemaker.CreateEdgeDeploymentStageInput) (*sagemaker.CreateEdgeDeploymentStageOutput, error)
	CreateEdgeDeploymentStageWithContext(aws.Context, *sagemaker.CreateEdgeDeploymentStageInput, ...request.Option) (*sagemaker.CreateEdgeDeploymentStageOutput, error)
	CreateEdgeDeploymentStageRequest(*sagemaker.CreateEdgeDeploymentStageInput) (*request.Request, *sagemaker.CreateEdgeDeploymentStageOutput)

	CreateEdgePackagingJob(*sagemaker.CreateEdgePackagingJobInput) (*sagemaker.CreateEdgePackagingJobOutput, error)
	CreateEdgePackagingJobWithContext(aws.Context, *sagemaker.CreateEdgePackagingJobInput, ...request.Option) (*sagemaker.CreateEdgePackagingJobOutput, error)
	CreateEdgePackagingJobRequest(*sagemaker.CreateEdgePackagingJobInput) (*request.Request, *sagemaker.CreateEdgePackagingJobOutput)

	CreateEndpoint(*sagemaker.CreateEndpointInput) (*sagemaker.CreateEndpointOutput, error)
	CreateEndpointWithContext(aws.Context, *sagemaker.CreateEndpointInput, ...request.Option) (*sagemaker.CreateEndpointOutput, error)
	CreateEndpointRequest(*sagemaker.CreateEndpointInput) (*request.Request, *sagemaker.CreateEndpointOutput)

	CreateEndpointConfig(*sagemaker.CreateEndpointConfigInput) (*sagemaker.CreateEndpointConfigOutput, error)
	CreateEndpointConfigWithContext(aws.Context, *sagemaker.CreateEndpointConfigInput, ...request.Option) (*sagemaker.CreateEndpointConfigOutput, error)
	CreateEndpointConfigRequest(*sagemaker.CreateEndpointConfigInput) (*request.Request, *sagemaker.CreateEndpointConfigOutput)

	CreateExperiment(*sagemaker.CreateExperimentInput) (*sagemaker.CreateExperimentOutput, error)
	CreateExperimentWithContext(aws.Context, *sagemaker.CreateExperimentInput, ...request.Option) (*sagemaker.CreateExperimentOutput, error)
	CreateExperimentRequest(*sagemaker.CreateExperimentInput) (*request.Request, *sagemaker.CreateExperimentOutput)

	CreateFeatureGroup(*sagemaker.CreateFeatureGroupInput) (*sagemaker.CreateFeatureGroupOutput, error)
	CreateFeatureGroupWithContext(aws.Context, *sagemaker.CreateFeatureGroupInput, ...request.Option) (*sagemaker.CreateFeatureGroupOutput, error)
	CreateFeatureGroupRequest(*sagemaker.CreateFeatureGroupInput) (*request.Request, *sagemaker.CreateFeatureGroupOutput)

	CreateFlowDefinition(*sagemaker.CreateFlowDefinitionInput) (*sagemaker.CreateFlowDefinitionOutput, error)
	CreateFlowDefinitionWithContext(aws.Context, *sagemaker.CreateFlowDefinitionInput, ...request.Option) (*sagemaker.CreateFlowDefinitionOutput, error)
	CreateFlowDefinitionRequest(*sagemaker.CreateFlowDefinitionInput) (*request.Request, *sagemaker.CreateFlowDefinitionOutput)

	CreateHub(*sagemaker.CreateHubInput) (*sagemaker.CreateHubOutput, error)
	CreateHubWithContext(aws.Context, *sagemaker.CreateHubInput, ...request.Option) (*sagemaker.CreateHubOutput, error)
	CreateHubRequest(*sagemaker.CreateHubInput) (*request.Request, *sagemaker.CreateHubOutput)

	CreateHumanTaskUi(*sagemaker.CreateHumanTaskUiInput) (*sagemaker.CreateHumanTaskUiOutput, error)
	CreateHumanTaskUiWithContext(aws.Context, *sagemaker.CreateHumanTaskUiInput, ...request.Option) (*sagemaker.CreateHumanTaskUiOutput, error)
	CreateHumanTaskUiRequest(*sagemaker.CreateHumanTaskUiInput) (*request.Request, *sagemaker.CreateHumanTaskUiOutput)

	CreateHyperParameterTuningJob(*sagemaker.CreateHyperParameterTuningJobInput) (*sagemaker.CreateHyperParameterTuningJobOutput, error)
	CreateHyperParameterTuningJobWithContext(aws.Context, *sagemaker.CreateHyperParameterTuningJobInput, ...request.Option) (*sagemaker.CreateHyperParameterTuningJobOutput, error)
	CreateHyperParameterTuningJobRequest(*sagemaker.CreateHyperParameterTuningJobInput) (*request.Request, *sagemaker.CreateHyperParameterTuningJobOutput)

	CreateImage(*sagemaker.CreateImageInput) (*sagemaker.CreateImageOutput, error)
	CreateImageWithContext(aws.Context, *sagemaker.CreateImageInput, ...request.Option) (*sagemaker.CreateImageOutput, error)
	CreateImageRequest(*sagemaker.CreateImageInput) (*request.Request, *sagemaker.CreateImageOutput)

	CreateImageVersion(*sagemaker.CreateImageVersionInput) (*sagemaker.CreateImageVersionOutput, error)
	CreateImageVersionWithContext(aws.Context, *sagemaker.CreateImageVersionInput, ...request.Option) (*sagemaker.CreateImageVersionOutput, error)
	CreateImageVersionRequest(*sagemaker.CreateImageVersionInput) (*request.Request, *sagemaker.CreateImageVersionOutput)

	CreateInferenceExperiment(*sagemaker.CreateInferenceExperimentInput) (*sagemaker.CreateInferenceExperimentOutput, error)
	CreateInferenceExperimentWithContext(aws.Context, *sagemaker.CreateInferenceExperimentInput, ...request.Option) (*sagemaker.CreateInferenceExperimentOutput, error)
	CreateInferenceExperimentRequest(*sagemaker.CreateInferenceExperimentInput) (*request.Request, *sagemaker.CreateInferenceExperimentOutput)

	CreateInferenceRecommendationsJob(*sagemaker.CreateInferenceRecommendationsJobInput) (*sagemaker.CreateInferenceRecommendationsJobOutput, error)
	CreateInferenceRecommendationsJobWithContext(aws.Context, *sagemaker.CreateInferenceRecommendationsJobInput, ...request.Option) (*sagemaker.CreateInferenceRecommendationsJobOutput, error)
	CreateInferenceRecommendationsJobRequest(*sagemaker.CreateInferenceRecommendationsJobInput) (*request.Request, *sagemaker.CreateInferenceRecommendationsJobOutput)

	CreateLabelingJob(*sagemaker.CreateLabelingJobInput) (*sagemaker.CreateLabelingJobOutput, error)
	CreateLabelingJobWithContext(aws.Context, *sagemaker.CreateLabelingJobInput, ...request.Option) (*sagemaker.CreateLabelingJobOutput, error)
	CreateLabelingJobRequest(*sagemaker.CreateLabelingJobInput) (*request.Request, *sagemaker.CreateLabelingJobOutput)

	CreateModel(*sagemaker.CreateModelInput) (*sagemaker.CreateModelOutput, error)
	CreateModelWithContext(aws.Context, *sagemaker.CreateModelInput, ...request.Option) (*sagemaker.CreateModelOutput, error)
	CreateModelRequest(*sagemaker.CreateModelInput) (*request.Request, *sagemaker.CreateModelOutput)

	CreateModelBiasJobDefinition(*sagemaker.CreateModelBiasJobDefinitionInput) (*sagemaker.CreateModelBiasJobDefinitionOutput, error)
	CreateModelBiasJobDefinitionWithContext(aws.Context, *sagemaker.CreateModelBiasJobDefinitionInput, ...request.Option) (*sagemaker.CreateModelBiasJobDefinitionOutput, error)
	CreateModelBiasJobDefinitionRequest(*sagemaker.CreateModelBiasJobDefinitionInput) (*request.Request, *sagemaker.CreateModelBiasJobDefinitionOutput)

	CreateModelCard(*sagemaker.CreateModelCardInput) (*sagemaker.CreateModelCardOutput, error)
	CreateModelCardWithContext(aws.Context, *sagemaker.CreateModelCardInput, ...request.Option) (*sagemaker.CreateModelCardOutput, error)
	CreateModelCardRequest(*sagemaker.CreateModelCardInput) (*request.Request, *sagemaker.CreateModelCardOutput)

	CreateModelCardExportJob(*sagemaker.CreateModelCardExportJobInput) (*sagemaker.CreateModelCardExportJobOutput, error)
	CreateModelCardExportJobWithContext(aws.Context, *sagemaker.CreateModelCardExportJobInput, ...request.Option) (*sagemaker.CreateModelCardExportJobOutput, error)
	CreateModelCardExportJobRequest(*sagemaker.CreateModelCardExportJobInput) (*request.Request, *sagemaker.CreateModelCardExportJobOutput)

	CreateModelExplainabilityJobDefinition(*sagemaker.CreateModelExplainabilityJobDefinitionInput) (*sagemaker.CreateModelExplainabilityJobDefinitionOutput, error)
	CreateModelExplainabilityJobDefinitionWithContext(aws.Context, *sagemaker.CreateModelExplainabilityJobDefinitionInput, ...request.Option) (*sagemaker.CreateModelExplainabilityJobDefinitionOutput, error)
	CreateModelExplainabilityJobDefinitionRequest(*sagemaker.CreateModelExplainabilityJobDefinitionInput) (*request.Request, *sagemaker.CreateModelExplainabilityJobDefinitionOutput)

	CreateModelPackage(*sagemaker.CreateModelPackageInput) (*sagemaker.CreateModelPackageOutput, error)
	CreateModelPackageWithContext(aws.Context, *sagemaker.CreateModelPackageInput, ...request.Option) (*sagemaker.CreateModelPackageOutput, error)
	CreateModelPackageRequest(*sagemaker.CreateModelPackageInput) (*request.Request, *sagemaker.CreateModelPackageOutput)

	CreateModelPackageGroup(*sagemaker.CreateModelPackageGroupInput) (*sagemaker.CreateModelPackageGroupOutput, error)
	CreateModelPackageGroupWithContext(aws.Context, *sagemaker.CreateModelPackageGroupInput, ...request.Option) (*sagemaker.CreateModelPackageGroupOutput, error)
	CreateModelPackageGroupRequest(*sagemaker.CreateModelPackageGroupInput) (*request.Request, *sagemaker.CreateModelPackageGroupOutput)

	CreateModelQualityJobDefinition(*sagemaker.CreateModelQualityJobDefinitionInput) (*sagemaker.CreateModelQualityJobDefinitionOutput, error)
	CreateModelQualityJobDefinitionWithContext(aws.Context, *sagemaker.CreateModelQualityJobDefinitionInput, ...request.Option) (*sagemaker.CreateModelQualityJobDefinitionOutput, error)
	CreateModelQualityJobDefinitionRequest(*sagemaker.CreateModelQualityJobDefinitionInput) (*request.Request, *sagemaker.CreateModelQualityJobDefinitionOutput)

	CreateMonitoringSchedule(*sagemaker.CreateMonitoringScheduleInput) (*sagemaker.CreateMonitoringScheduleOutput, error)
	CreateMonitoringScheduleWithContext(aws.Context, *sagemaker.CreateMonitoringScheduleInput, ...request.Option) (*sagemaker.CreateMonitoringScheduleOutput, error)
	CreateMonitoringScheduleRequest(*sagemaker.CreateMonitoringScheduleInput) (*request.Request, *sagemaker.CreateMonitoringScheduleOutput)

	CreateNotebookInstance(*sagemaker.CreateNotebookInstanceInput) (*sagemaker.CreateNotebookInstanceOutput, error)
	CreateNotebookInstanceWithContext(aws.Context, *sagemaker.CreateNotebookInstanceInput, ...request.Option) (*sagemaker.CreateNotebookInstanceOutput, error)
	CreateNotebookInstanceRequest(*sagemaker.CreateNotebookInstanceInput) (*request.Request, *sagemaker.CreateNotebookInstanceOutput)

	CreateNotebookInstanceLifecycleConfig(*sagemaker.CreateNotebookInstanceLifecycleConfigInput) (*sagemaker.CreateNotebookInstanceLifecycleConfigOutput, error)
	CreateNotebookInstanceLifecycleConfigWithContext(aws.Context, *sagemaker.CreateNotebookInstanceLifecycleConfigInput, ...request.Option) (*sagemaker.CreateNotebookInstanceLifecycleConfigOutput, error)
	CreateNotebookInstanceLifecycleConfigRequest(*sagemaker.CreateNotebookInstanceLifecycleConfigInput) (*request.Request, *sagemaker.CreateNotebookInstanceLifecycleConfigOutput)

	CreatePipeline(*sagemaker.CreatePipelineInput) (*sagemaker.CreatePipelineOutput, error)
	CreatePipelineWithContext(aws.Context, *sagemaker.CreatePipelineInput, ...request.Option) (*sagemaker.CreatePipelineOutput, error)
	CreatePipelineRequest(*sagemaker.CreatePipelineInput) (*request.Request, *sagemaker.CreatePipelineOutput)

	CreatePresignedDomainUrl(*sagemaker.CreatePresignedDomainUrlInput) (*sagemaker.CreatePresignedDomainUrlOutput, error)
	CreatePresignedDomainUrlWithContext(aws.Context, *sagemaker.CreatePresignedDomainUrlInput, ...request.Option) (*sagemaker.CreatePresignedDomainUrlOutput, error)
	CreatePresignedDomainUrlRequest(*sagemaker.CreatePresignedDomainUrlInput) (*request.Request, *sagemaker.CreatePresignedDomainUrlOutput)

	CreatePresignedNotebookInstanceUrl(*sagemaker.CreatePresignedNotebookInstanceUrlInput) (*sagemaker.CreatePresignedNotebookInstanceUrlOutput, error)
	CreatePresignedNotebookInstanceUrlWithContext(aws.Context, *sagemaker.CreatePresignedNotebookInstanceUrlInput, ...request.Option) (*sagemaker.CreatePresignedNotebookInstanceUrlOutput, error)
	CreatePresignedNotebookInstanceUrlRequest(*sagemaker.CreatePresignedNotebookInstanceUrlInput) (*request.Request, *sagemaker.CreatePresignedNotebookInstanceUrlOutput)

	CreateProcessingJob(*sagemaker.CreateProcessingJobInput) (*sagemaker.CreateProcessingJobOutput, error)
	CreateProcessingJobWithContext(aws.Context, *sagemaker.CreateProcessingJobInput, ...request.Option) (*sagemaker.CreateProcessingJobOutput, error)
	CreateProcessingJobRequest(*sagemaker.CreateProcessingJobInput) (*request.Request, *sagemaker.CreateProcessingJobOutput)

	CreateProject(*sagemaker.CreateProjectInput) (*sagemaker.CreateProjectOutput, error)
	CreateProjectWithContext(aws.Context, *sagemaker.CreateProjectInput, ...request.Option) (*sagemaker.CreateProjectOutput, error)
	CreateProjectRequest(*sagemaker.CreateProjectInput) (*request.Request, *sagemaker.CreateProjectOutput)

	CreateSpace(*sagemaker.CreateSpaceInput) (*sagemaker.CreateSpaceOutput, error)
	CreateSpaceWithContext(aws.Context, *sagemaker.CreateSpaceInput, ...request.Option) (*sagemaker.CreateSpaceOutput, error)
	CreateSpaceRequest(*sagemaker.CreateSpaceInput) (*request.Request, *sagemaker.CreateSpaceOutput)

	CreateStudioLifecycleConfig(*sagemaker.CreateStudioLifecycleConfigInput) (*sagemaker.CreateStudioLifecycleConfigOutput, error)
	CreateStudioLifecycleConfigWithContext(aws.Context, *sagemaker.CreateStudioLifecycleConfigInput, ...request.Option) (*sagemaker.CreateStudioLifecycleConfigOutput, error)
	CreateStudioLifecycleConfigRequest(*sagemaker.CreateStudioLifecycleConfigInput) (*request.Request, *sagemaker.CreateStudioLifecycleConfigOutput)

	CreateTrainingJob(*sagemaker.CreateTrainingJobInput) (*sagemaker.CreateTrainingJobOutput, error)
	CreateTrainingJobWithContext(aws.Context, *sagemaker.CreateTrainingJobInput, ...request.Option) (*sagemaker.CreateTrainingJobOutput, error)
	CreateTrainingJobRequest(*sagemaker.CreateTrainingJobInput) (*request.Request, *sagemaker.CreateTrainingJobOutput)

	CreateTransformJob(*sagemaker.CreateTransformJobInput) (*sagemaker.CreateTransformJobOutput, error)
	CreateTransformJobWithContext(aws.Context, *sagemaker.CreateTransformJobInput, ...request.Option) (*sagemaker.CreateTransformJobOutput, error)
	CreateTransformJobRequest(*sagemaker.CreateTransformJobInput) (*request.Request, *sagemaker.CreateTransformJobOutput)

	CreateTrial(*sagemaker.CreateTrialInput) (*sagemaker.CreateTrialOutput, error)
	CreateTrialWithContext(aws.Context, *sagemaker.CreateTrialInput, ...request.Option) (*sagemaker.CreateTrialOutput, error)
	CreateTrialRequest(*sagemaker.CreateTrialInput) (*request.Request, *sagemaker.CreateTrialOutput)

	CreateTrialComponent(*sagemaker.CreateTrialComponentInput) (*sagemaker.CreateTrialComponentOutput, error)
	CreateTrialComponentWithContext(aws.Context, *sagemaker.CreateTrialComponentInput, ...request.Option) (*sagemaker.CreateTrialComponentOutput, error)
	CreateTrialComponentRequest(*sagemaker.CreateTrialComponentInput) (*request.Request, *sagemaker.CreateTrialComponentOutput)

	CreateUserProfile(*sagemaker.CreateUserProfileInput) (*sagemaker.CreateUserProfileOutput, error)
	CreateUserProfileWithContext(aws.Context, *sagemaker.CreateUserProfileInput, ...request.Option) (*sagemaker.CreateUserProfileOutput, error)
	CreateUserProfileRequest(*sagemaker.CreateUserProfileInput) (*request.Request, *sagemaker.CreateUserProfileOutput)

	CreateWorkforce(*sagemaker.CreateWorkforceInput) (*sagemaker.CreateWorkforceOutput, error)
	CreateWorkforceWithContext(aws.Context, *sagemaker.CreateWorkforceInput, ...request.Option) (*sagemaker.CreateWorkforceOutput, error)
	CreateWorkforceRequest(*sagemaker.CreateWorkforceInput) (*request.Request, *sagemaker.CreateWorkforceOutput)

	CreateWorkteam(*sagemaker.CreateWorkteamInput) (*sagemaker.CreateWorkteamOutput, error)
	CreateWorkteamWithContext(aws.Context, *sagemaker.CreateWorkteamInput, ...request.Option) (*sagemaker.CreateWorkteamOutput, error)
	CreateWorkteamRequest(*sagemaker.CreateWorkteamInput) (*request.Request, *sagemaker.CreateWorkteamOutput)

	DeleteAction(*sagemaker.DeleteActionInput) (*sagemaker.DeleteActionOutput, error)
	DeleteActionWithContext(aws.Context, *sagemaker.DeleteActionInput, ...request.Option) (*sagemaker.DeleteActionOutput, error)
	DeleteActionRequest(*sagemaker.DeleteActionInput) (*request.Request, *sagemaker.DeleteActionOutput)

	DeleteAlgorithm(*sagemaker.DeleteAlgorithmInput) (*sagemaker.DeleteAlgorithmOutput, error)
	DeleteAlgorithmWithContext(aws.Context, *sagemaker.DeleteAlgorithmInput, ...request.Option) (*sagemaker.DeleteAlgorithmOutput, error)
	DeleteAlgorithmRequest(*sagemaker.DeleteAlgorithmInput) (*request.Request, *sagemaker.DeleteAlgorithmOutput)

	DeleteApp(*sagemaker.DeleteAppInput) (*sagemaker.DeleteAppOutput, error)
	DeleteAppWithContext(aws.Context, *sagemaker.DeleteAppInput, ...request.Option) (*sagemaker.DeleteAppOutput, error)
	DeleteAppRequest(*sagemaker.DeleteAppInput) (*request.Request, *sagemaker.DeleteAppOutput)

	DeleteAppImageConfig(*sagemaker.DeleteAppImageConfigInput) (*sagemaker.DeleteAppImageConfigOutput, error)
	DeleteAppImageConfigWithContext(aws.Context, *sagemaker.DeleteAppImageConfigInput, ...request.Option) (*sagemaker.DeleteAppImageConfigOutput, error)
	DeleteAppImageConfigRequest(*sagemaker.DeleteAppImageConfigInput) (*request.Request, *sagemaker.DeleteAppImageConfigOutput)

	DeleteArtifact(*sagemaker.DeleteArtifactInput) (*sagemaker.DeleteArtifactOutput, error)
	DeleteArtifactWithContext(aws.Context, *sagemaker.DeleteArtifactInput, ...request.Option) (*sagemaker.DeleteArtifactOutput, error)
	DeleteArtifactRequest(*sagemaker.DeleteArtifactInput) (*request.Request, *sagemaker.DeleteArtifactOutput)

	DeleteAssociation(*sagemaker.DeleteAssociationInput) (*sagemaker.DeleteAssociationOutput, error)
	DeleteAssociationWithContext(aws.Context, *sagemaker.DeleteAssociationInput, ...request.Option) (*sagemaker.DeleteAssociationOutput, error)
	DeleteAssociationRequest(*sagemaker.DeleteAssociationInput) (*request.Request, *sagemaker.DeleteAssociationOutput)

	DeleteCodeRepository(*sagemaker.DeleteCodeRepositoryInput) (*sagemaker.DeleteCodeRepositoryOutput, error)
	DeleteCodeRepositoryWithContext(aws.Context, *sagemaker.DeleteCodeRepositoryInput, ...request.Option) (*sagemaker.DeleteCodeRepositoryOutput, error)
	DeleteCodeRepositoryRequest(*sagemaker.DeleteCodeRepositoryInput) (*request.Request, *sagemaker.DeleteCodeRepositoryOutput)

	DeleteContext(*sagemaker.DeleteContextInput) (*sagemaker.DeleteContextOutput, error)
	DeleteContextWithContext(aws.Context, *sagemaker.DeleteContextInput, ...request.Option) (*sagemaker.DeleteContextOutput, error)
	DeleteContextRequest(*sagemaker.DeleteContextInput) (*request.Request, *sagemaker.DeleteContextOutput)

	DeleteDataQualityJobDefinition(*sagemaker.DeleteDataQualityJobDefinitionInput) (*sagemaker.DeleteDataQualityJobDefinitionOutput, error)
	DeleteDataQualityJobDefinitionWithContext(aws.Context, *sagemaker.DeleteDataQualityJobDefinitionInput, ...request.Option) (*sagemaker.DeleteDataQualityJobDefinitionOutput, error)
	DeleteDataQualityJobDefinitionRequest(*sagemaker.DeleteDataQualityJobDefinitionInput) (*request.Request, *sagemaker.DeleteDataQualityJobDefinitionOutput)

	DeleteDeviceFleet(*sagemaker.DeleteDeviceFleetInput) (*sagemaker.DeleteDeviceFleetOutput, error)
	DeleteDeviceFleetWithContext(aws.Context, *sagemaker.DeleteDeviceFleetInput, ...request.Option) (*sagemaker.DeleteDeviceFleetOutput, error)
	DeleteDeviceFleetRequest(*sagemaker.DeleteDeviceFleetInput) (*request.Request, *sagemaker.DeleteDeviceFleetOutput)

	DeleteDomain(*sagemaker.DeleteDomainInput) (*sagemaker.DeleteDomainOutput, error)
	DeleteDomainWithContext(aws.Context, *sagemaker.DeleteDomainInput, ...request.Option) (*sagemaker.DeleteDomainOutput, error)
	DeleteDomainRequest(*sagemaker.DeleteDomainInput) (*request.Request, *sagemaker.DeleteDomainOutput)

	DeleteEdgeDeploymentPlan(*sagemaker.DeleteEdgeDeploymentPlanInput) (*sagemaker.DeleteEdgeDeploymentPlanOutput, error)
	DeleteEdgeDeploymentPlanWithContext(aws.Context, *sagemaker.DeleteEdgeDeploymentPlanInput, ...request.Option) (*sagemaker.DeleteEdgeDeploymentPlanOutput, error)
	DeleteEdgeDeploymentPlanRequest(*sagemaker.DeleteEdgeDeploymentPlanInput) (*request.Request, *sagemaker.DeleteEdgeDeploymentPlanOutput)

	DeleteEdgeDeploymentStage(*sagemaker.DeleteEdgeDeploymentStageInput) (*sagemaker.DeleteEdgeDeploymentStageOutput, error)
	DeleteEdgeDeploymentStageWithContext(aws.Context, *sagemaker.DeleteEdgeDeploymentStageInput, ...request.Option) (*sagemaker.DeleteEdgeDeploymentStageOutput, error)
	DeleteEdgeDeploymentStageRequest(*sagemaker.DeleteEdgeDeploymentStageInput) (*request.Request, *sagemaker.DeleteEdgeDeploymentStageOutput)

	DeleteEndpoint(*sagemaker.DeleteEndpointInput) (*sagemaker.DeleteEndpointOutput, error)
	DeleteEndpointWithContext(aws.Context, *sagemaker.DeleteEndpointInput, ...request.Option) (*sagemaker.DeleteEndpointOutput, error)
	DeleteEndpointRequest(*sagemaker.DeleteEndpointInput) (*request.Request, *sagemaker.DeleteEndpointOutput)

	DeleteEndpointConfig(*sagemaker.DeleteEndpointConfigInput) (*sagemaker.DeleteEndpointConfigOutput, error)
	DeleteEndpointConfigWithContext(aws.Context, *sagemaker.DeleteEndpointConfigInput, ...request.Option) (*sagemaker.DeleteEndpointConfigOutput, error)
	DeleteEndpointConfigRequest(*sagemaker.DeleteEndpointConfigInput) (*request.Request, *sagemaker.DeleteEndpointConfigOutput)

	DeleteExperiment(*sagemaker.DeleteExperimentInput) (*sagemaker.DeleteExperimentOutput, error)
	DeleteExperimentWithContext(aws.Context, *sagemaker.DeleteExperimentInput, ...request.Option) (*sagemaker.DeleteExperimentOutput, error)
	DeleteExperimentRequest(*sagemaker.DeleteExperimentInput) (*request.Request, *sagemaker.DeleteExperimentOutput)

	DeleteFeatureGroup(*sagemaker.DeleteFeatureGroupInput) (*sagemaker.DeleteFeatureGroupOutput, error)
	DeleteFeatureGroupWithContext(aws.Context, *sagemaker.DeleteFeatureGroupInput, ...request.Option) (*sagemaker.DeleteFeatureGroupOutput, error)
	DeleteFeatureGroupRequest(*sagemaker.DeleteFeatureGroupInput) (*request.Request, *sagemaker.DeleteFeatureGroupOutput)

	DeleteFlowDefinition(*sagemaker.DeleteFlowDefinitionInput) (*sagemaker.DeleteFlowDefinitionOutput, error)
	DeleteFlowDefinitionWithContext(aws.Context, *sagemaker.DeleteFlowDefinitionInput, ...request.Option) (*sagemaker.DeleteFlowDefinitionOutput, error)
	DeleteFlowDefinitionRequest(*sagemaker.DeleteFlowDefinitionInput) (*request.Request, *sagemaker.DeleteFlowDefinitionOutput)

	DeleteHub(*sagemaker.DeleteHubInput) (*sagemaker.DeleteHubOutput, error)
	DeleteHubWithContext(aws.Context, *sagemaker.DeleteHubInput, ...request.Option) (*sagemaker.DeleteHubOutput, error)
	DeleteHubRequest(*sagemaker.DeleteHubInput) (*request.Request, *sagemaker.DeleteHubOutput)

	DeleteHubContent(*sagemaker.DeleteHubContentInput) (*sagemaker.DeleteHubContentOutput, error)
	DeleteHubContentWithContext(aws.Context, *sagemaker.DeleteHubContentInput, ...request.Option) (*sagemaker.DeleteHubContentOutput, error)
	DeleteHubContentRequest(*sagemaker.DeleteHubContentInput) (*request.Request, *sagemaker.DeleteHubContentOutput)

	DeleteHumanTaskUi(*sagemaker.DeleteHumanTaskUiInput) (*sagemaker.DeleteHumanTaskUiOutput, error)
	DeleteHumanTaskUiWithContext(aws.Context, *sagemaker.DeleteHumanTaskUiInput, ...request.Option) (*sagemaker.DeleteHumanTaskUiOutput, error)
	DeleteHumanTaskUiRequest(*sagemaker.DeleteHumanTaskUiInput) (*request.Request, *sagemaker.DeleteHumanTaskUiOutput)

	DeleteImage(*sagemaker.DeleteImageInput) (*sagemaker.DeleteImageOutput, error)
	DeleteImageWithContext(aws.Context, *sagemaker.DeleteImageInput, ...request.Option) (*sagemaker.DeleteImageOutput, error)
	DeleteImageRequest(*sagemaker.DeleteImageInput) (*request.Request, *sagemaker.DeleteImageOutput)

	DeleteImageVersion(*sagemaker.DeleteImageVersionInput) (*sagemaker.DeleteImageVersionOutput, error)
	DeleteImageVersionWithContext(aws.Context, *sagemaker.DeleteImageVersionInput, ...request.Option) (*sagemaker.DeleteImageVersionOutput, error)
	DeleteImageVersionRequest(*sagemaker.DeleteImageVersionInput) (*request.Request, *sagemaker.DeleteImageVersionOutput)

	DeleteInferenceExperiment(*sagemaker.DeleteInferenceExperimentInput) (*sagemaker.DeleteInferenceExperimentOutput, error)
	DeleteInferenceExperimentWithContext(aws.Context, *sagemaker.DeleteInferenceExperimentInput, ...request.Option) (*sagemaker.DeleteInferenceExperimentOutput, error)
	DeleteInferenceExperimentRequest(*sagemaker.DeleteInferenceExperimentInput) (*request.Request, *sagemaker.DeleteInferenceExperimentOutput)

	DeleteModel(*sagemaker.DeleteModelInput) (*sagemaker.DeleteModelOutput, error)
	DeleteModelWithContext(aws.Context, *sagemaker.DeleteModelInput, ...request.Option) (*sagemaker.DeleteModelOutput, error)
	DeleteModelRequest(*sagemaker.DeleteModelInput) (*request.Request, *sagemaker.DeleteModelOutput)

	DeleteModelBiasJobDefinition(*sagemaker.DeleteModelBiasJobDefinitionInput) (*sagemaker.DeleteModelBiasJobDefinitionOutput, error)
	DeleteModelBiasJobDefinitionWithContext(aws.Context, *sagemaker.DeleteModelBiasJobDefinitionInput, ...request.Option) (*sagemaker.DeleteModelBiasJobDefinitionOutput, error)
	DeleteModelBiasJobDefinitionRequest(*sagemaker.DeleteModelBiasJobDefinitionInput) (*request.Request, *sagemaker.DeleteModelBiasJobDefinitionOutput)

	DeleteModelCard(*sagemaker.DeleteModelCardInput) (*sagemaker.DeleteModelCardOutput, error)
	DeleteModelCardWithContext(aws.Context, *sagemaker.DeleteModelCardInput, ...request.Option) (*sagemaker.DeleteModelCardOutput, error)
	DeleteModelCardRequest(*sagemaker.DeleteModelCardInput) (*request.Request, *sagemaker.DeleteModelCardOutput)

	DeleteModelExplainabilityJobDefinition(*sagemaker.DeleteModelExplainabilityJobDefinitionInput) (*sagemaker.DeleteModelExplainabilityJobDefinitionOutput, error)
	DeleteModelExplainabilityJobDefinitionWithContext(aws.Context, *sagemaker.DeleteModelExplainabilityJobDefinitionInput, ...request.Option) (*sagemaker.DeleteModelExplainabilityJobDefinitionOutput, error)
	DeleteModelExplainabilityJobDefinitionRequest(*sagemaker.DeleteModelExplainabilityJobDefinitionInput) (*request.Request, *sagemaker.DeleteModelExplainabilityJobDefinitionOutput)

	DeleteModelPackage(*sagemaker.DeleteModelPackageInput) (*sagemaker.DeleteModelPackageOutput, error)
	DeleteModelPackageWithContext(aws.Context, *sagemaker.DeleteModelPackageInput, ...request.Option) (*sagemaker.DeleteModelPackageOutput, error)
	DeleteModelPackageRequest(*sagemaker.DeleteModelPackageInput) (*request.Request, *sagemaker.DeleteModelPackageOutput)

	DeleteModelPackageGroup(*sagemaker.DeleteModelPackageGroupInput) (*sagemaker.DeleteModelPackageGroupOutput, error)
	DeleteModelPackageGroupWithContext(aws.Context, *sagemaker.DeleteModelPackageGroupInput, ...request.Option) (*sagemaker.DeleteModelPackageGroupOutput, error)
	DeleteModelPackageGroupRequest(*sagemaker.DeleteModelPackageGroupInput) (*request.Request, *sagemaker.DeleteModelPackageGroupOutput)

	DeleteModelPackageGroupPolicy(*sagemaker.DeleteModelPackageGroupPolicyInput) (*sagemaker.DeleteModelPackageGroupPolicyOutput, error)
	DeleteModelPackageGroupPolicyWithContext(aws.Context, *sagemaker.DeleteModelPackageGroupPolicyInput, ...request.Option) (*sagemaker.DeleteModelPackageGroupPolicyOutput, error)
	DeleteModelPackageGroupPolicyRequest(*sagemaker.DeleteModelPackageGroupPolicyInput) (*request.Request, *sagemaker.DeleteModelPackageGroupPolicyOutput)

	DeleteModelQualityJobDefinition(*sagemaker.DeleteModelQualityJobDefinitionInput) (*sagemaker.DeleteModelQualityJobDefinitionOutput, error)
	DeleteModelQualityJobDefinitionWithContext(aws.Context, *sagemaker.DeleteModelQualityJobDefinitionInput, ...request.Option) (*sagemaker.DeleteModelQualityJobDefinitionOutput, error)
	DeleteModelQualityJobDefinitionRequest(*sagemaker.DeleteModelQualityJobDefinitionInput) (*request.Request, *sagemaker.DeleteModelQualityJobDefinitionOutput)

	DeleteMonitoringSchedule(*sagemaker.DeleteMonitoringScheduleInput) (*sagemaker.DeleteMonitoringScheduleOutput, error)
	DeleteMonitoringScheduleWithContext(aws.Context, *sagemaker.DeleteMonitoringScheduleInput, ...request.Option) (*sagemaker.DeleteMonitoringScheduleOutput, error)
	DeleteMonitoringScheduleRequest(*sagemaker.DeleteMonitoringScheduleInput) (*request.Request, *sagemaker.DeleteMonitoringScheduleOutput)

	DeleteNotebookInstance(*sagemaker.DeleteNotebookInstanceInput) (*sagemaker.DeleteNotebookInstanceOutput, error)
	DeleteNotebookInstanceWithContext(aws.Context, *sagemaker.DeleteNotebookInstanceInput, ...request.Option) (*sagemaker.DeleteNotebookInstanceOutput, error)
	DeleteNotebookInstanceRequest(*sagemaker.DeleteNotebookInstanceInput) (*request.Request, *sagemaker.DeleteNotebookInstanceOutput)

	DeleteNotebookInstanceLifecycleConfig(*sagemaker.DeleteNotebookInstanceLifecycleConfigInput) (*sagemaker.DeleteNotebookInstanceLifecycleConfigOutput, error)
	DeleteNotebookInstanceLifecycleConfigWithContext(aws.Context, *sagemaker.DeleteNotebookInstanceLifecycleConfigInput, ...request.Option) (*sagemaker.DeleteNotebookInstanceLifecycleConfigOutput, error)
	DeleteNotebookInstanceLifecycleConfigRequest(*sagemaker.DeleteNotebookInstanceLifecycleConfigInput) (*request.Request, *sagemaker.DeleteNotebookInstanceLifecycleConfigOutput)

	DeletePipeline(*sagemaker.DeletePipelineInput) (*sagemaker.DeletePipelineOutput, error)
	DeletePipelineWithContext(aws.Context, *sagemaker.DeletePipelineInput, ...request.Option) (*sagemaker.DeletePipelineOutput, error)
	DeletePipelineRequest(*sagemaker.DeletePipelineInput) (*request.Request, *sagemaker.DeletePipelineOutput)

	DeleteProject(*sagemaker.DeleteProjectInput) (*sagemaker.DeleteProjectOutput, error)
	DeleteProjectWithContext(aws.Context, *sagemaker.DeleteProjectInput, ...request.Option) (*sagemaker.DeleteProjectOutput, error)
	DeleteProjectRequest(*sagemaker.DeleteProjectInput) (*request.Request, *sagemaker.DeleteProjectOutput)

	DeleteSpace(*sagemaker.DeleteSpaceInput) (*sagemaker.DeleteSpaceOutput, error)
	DeleteSpaceWithContext(aws.Context, *sagemaker.DeleteSpaceInput, ...request.Option) (*sagemaker.DeleteSpaceOutput, error)
	DeleteSpaceRequest(*sagemaker.DeleteSpaceInput) (*request.Request, *sagemaker.DeleteSpaceOutput)

	DeleteStudioLifecycleConfig(*sagemaker.DeleteStudioLifecycleConfigInput) (*sagemaker.DeleteStudioLifecycleConfigOutput, error)
	DeleteStudioLifecycleConfigWithContext(aws.Context, *sagemaker.DeleteStudioLifecycleConfigInput, ...request.Option) (*sagemaker.DeleteStudioLifecycleConfigOutput, error)
	DeleteStudioLifecycleConfigRequest(*sagemaker.DeleteStudioLifecycleConfigInput) (*request.Request, *sagemaker.DeleteStudioLifecycleConfigOutput)

	DeleteTags(*sagemaker.DeleteTagsInput) (*sagemaker.DeleteTagsOutput, error)
	DeleteTagsWithContext(aws.Context, *sagemaker.DeleteTagsInput, ...request.Option) (*sagemaker.DeleteTagsOutput, error)
	DeleteTagsRequest(*sagemaker.DeleteTagsInput) (*request.Request, *sagemaker.DeleteTagsOutput)

	DeleteTrial(*sagemaker.DeleteTrialInput) (*sagemaker.DeleteTrialOutput, error)
	DeleteTrialWithContext(aws.Context, *sagemaker.DeleteTrialInput, ...request.Option) (*sagemaker.DeleteTrialOutput, error)
	DeleteTrialRequest(*sagemaker.DeleteTrialInput) (*request.Request, *sagemaker.DeleteTrialOutput)

	DeleteTrialComponent(*sagemaker.DeleteTrialComponentInput) (*sagemaker.DeleteTrialComponentOutput, error)
	DeleteTrialComponentWithContext(aws.Context, *sagemaker.DeleteTrialComponentInput, ...request.Option) (*sagemaker.DeleteTrialComponentOutput, error)
	DeleteTrialComponentRequest(*sagemaker.DeleteTrialComponentInput) (*request.Request, *sagemaker.DeleteTrialComponentOutput)

	DeleteUserProfile(*sagemaker.DeleteUserProfileInput) (*sagemaker.DeleteUserProfileOutput, error)
	DeleteUserProfileWithContext(aws.Context, *sagemaker.DeleteUserProfileInput, ...request.Option) (*sagemaker.DeleteUserProfileOutput, error)
	DeleteUserProfileRequest(*sagemaker.DeleteUserProfileInput) (*request.Request, *sagemaker.DeleteUserProfileOutput)

	DeleteWorkforce(*sagemaker.DeleteWorkforceInput) (*sagemaker.DeleteWorkforceOutput, error)
	DeleteWorkforceWithContext(aws.Context, *sagemaker.DeleteWorkforceInput, ...request.Option) (*sagemaker.DeleteWorkforceOutput, error)
	DeleteWorkforceRequest(*sagemaker.DeleteWorkforceInput) (*request.Request, *sagemaker.DeleteWorkforceOutput)

	DeleteWorkteam(*sagemaker.DeleteWorkteamInput) (*sagemaker.DeleteWorkteamOutput, error)
	DeleteWorkteamWithContext(aws.Context, *sagemaker.DeleteWorkteamInput, ...request.Option) (*sagemaker.DeleteWorkteamOutput, error)
	DeleteWorkteamRequest(*sagemaker.DeleteWorkteamInput) (*request.Request, *sagemaker.DeleteWorkteamOutput)

	DeregisterDevices(*sagemaker.DeregisterDevicesInput) (*sagemaker.DeregisterDevicesOutput, error)
	DeregisterDevicesWithContext(aws.Context, *sagemaker.DeregisterDevicesInput, ...request.Option) (*sagemaker.DeregisterDevicesOutput, error)
	DeregisterDevicesRequest(*sagemaker.DeregisterDevicesInput) (*request.Request, *sagemaker.DeregisterDevicesOutput)

	DescribeAction(*sagemaker.DescribeActionInput) (*sagemaker.DescribeActionOutput, error)
	DescribeActionWithContext(aws.Context, *sagemaker.DescribeActionInput, ...request.Option) (*sagemaker.DescribeActionOutput, error)
	DescribeActionRequest(*sagemaker.DescribeActionInput) (*request.Request, *sagemaker.DescribeActionOutput)

	DescribeAlgorithm(*sagemaker.DescribeAlgorithmInput) (*sagemaker.DescribeAlgorithmOutput, error)
	DescribeAlgorithmWithContext(aws.Context, *sagemaker.DescribeAlgorithmInput, ...request.Option) (*sagemaker.DescribeAlgorithmOutput, error)
	DescribeAlgorithmRequest(*sagemaker.DescribeAlgorithmInput) (*request.Request, *sagemaker.DescribeAlgorithmOutput)

	DescribeApp(*sagemaker.DescribeAppInput) (*sagemaker.DescribeAppOutput, error)
	DescribeAppWithContext(aws.Context, *sagemaker.DescribeAppInput, ...request.Option) (*sagemaker.DescribeAppOutput, error)
	DescribeAppRequest(*sagemaker.DescribeAppInput) (*request.Request, *sagemaker.DescribeAppOutput)

	DescribeAppImageConfig(*sagemaker.DescribeAppImageConfigInput) (*sagemaker.DescribeAppImageConfigOutput, error)
	DescribeAppImageConfigWithContext(aws.Context, *sagemaker.DescribeAppImageConfigInput, ...request.Option) (*sagemaker.DescribeAppImageConfigOutput, error)
	DescribeAppImageConfigRequest(*sagemaker.DescribeAppImageConfigInput) (*request.Request, *sagemaker.DescribeAppImageConfigOutput)

	DescribeArtifact(*sagemaker.DescribeArtifactInput) (*sagemaker.DescribeArtifactOutput, error)
	DescribeArtifactWithContext(aws.Context, *sagemaker.DescribeArtifactInput, ...request.Option) (*sagemaker.DescribeArtifactOutput, error)
	DescribeArtifactRequest(*sagemaker.DescribeArtifactInput) (*request.Request, *sagemaker.DescribeArtifactOutput)

	DescribeAutoMLJob(*sagemaker.DescribeAutoMLJobInput) (*sagemaker.DescribeAutoMLJobOutput, error)
	DescribeAutoMLJobWithContext(aws.Context, *sagemaker.DescribeAutoMLJobInput, ...request.Option) (*sagemaker.DescribeAutoMLJobOutput, error)
	DescribeAutoMLJobRequest(*sagemaker.DescribeAutoMLJobInput) (*request.Request, *sagemaker.DescribeAutoMLJobOutput)

	DescribeAutoMLJobV2(*sagemaker.DescribeAutoMLJobV2Input) (*sagemaker.DescribeAutoMLJobV2Output, error)
	DescribeAutoMLJobV2WithContext(aws.Context, *sagemaker.DescribeAutoMLJobV2Input, ...request.Option) (*sagemaker.DescribeAutoMLJobV2Output, error)
	DescribeAutoMLJobV2Request(*sagemaker.DescribeAutoMLJobV2Input) (*request.Request, *sagemaker.DescribeAutoMLJobV2Output)

	DescribeCodeRepository(*sagemaker.DescribeCodeRepositoryInput) (*sagemaker.DescribeCodeRepositoryOutput, error)
	DescribeCodeRepositoryWithContext(aws.Context, *sagemaker.DescribeCodeRepositoryInput, ...request.Option) (*sagemaker.DescribeCodeRepositoryOutput, error)
	DescribeCodeRepositoryRequest(*sagemaker.DescribeCodeRepositoryInput) (*request.Request, *sagemaker.DescribeCodeRepositoryOutput)

	DescribeCompilationJob(*sagemaker.DescribeCompilationJobInput) (*sagemaker.DescribeCompilationJobOutput, error)
	DescribeCompilationJobWithContext(aws.Context, *sagemaker.DescribeCompilationJobInput, ...request.Option) (*sagemaker.DescribeCompilationJobOutput, error)
	DescribeCompilationJobRequest(*sagemaker.DescribeCompilationJobInput) (*request.Request, *sagemaker.DescribeCompilationJobOutput)

	DescribeContext(*sagemaker.DescribeContextInput) (*sagemaker.DescribeContextOutput, error)
	DescribeContextWithContext(aws.Context, *sagemaker.DescribeContextInput, ...request.Option) (*sagemaker.DescribeContextOutput, error)
	DescribeContextRequest(*sagemaker.DescribeContextInput) (*request.Request, *sagemaker.DescribeContextOutput)

	DescribeDataQualityJobDefinition(*sagemaker.DescribeDataQualityJobDefinitionInput) (*sagemaker.DescribeDataQualityJobDefinitionOutput, error)
	DescribeDataQualityJobDefinitionWithContext(aws.Context, *sagemaker.DescribeDataQualityJobDefinitionInput, ...request.Option) (*sagemaker.DescribeDataQualityJobDefinitionOutput, error)
	DescribeDataQualityJobDefinitionRequest(*sagemaker.DescribeDataQualityJobDefinitionInput) (*request.Request, *sagemaker.DescribeDataQualityJobDefinitionOutput)

	DescribeDevice(*sagemaker.DescribeDeviceInput) (*sagemaker.DescribeDeviceOutput, error)
	DescribeDeviceWithContext(aws.Context, *sagemaker.DescribeDeviceInput, ...request.Option) (*sagemaker.DescribeDeviceOutput, error)
	DescribeDeviceRequest(*sagemaker.DescribeDeviceInput) (*request.Request, *sagemaker.DescribeDeviceOutput)

	DescribeDeviceFleet(*sagemaker.DescribeDeviceFleetInput) (*sagemaker.DescribeDeviceFleetOutput, error)
	DescribeDeviceFleetWithContext(aws.Context, *sagemaker.DescribeDeviceFleetInput, ...request.Option) (*sagemaker.DescribeDeviceFleetOutput, error)
	DescribeDeviceFleetRequest(*sagemaker.DescribeDeviceFleetInput) (*request.Request, *sagemaker.DescribeDeviceFleetOutput)

	DescribeDomain(*sagemaker.DescribeDomainInput) (*sagemaker.DescribeDomainOutput, error)
	DescribeDomainWithContext(aws.Context, *sagemaker.DescribeDomainInput, ...request.Option) (*sagemaker.DescribeDomainOutput, error)
	DescribeDomainRequest(*sagemaker.DescribeDomainInput) (*request.Request, *sagemaker.DescribeDomainOutput)

	DescribeEdgeDeploymentPlan(*sagemaker.DescribeEdgeDeploymentPlanInput) (*sagemaker.DescribeEdgeDeploymentPlanOutput, error)
	DescribeEdgeDeploymentPlanWithContext(aws.Context, *sagemaker.DescribeEdgeDeploymentPlanInput, ...request.Option) (*sagemaker.DescribeEdgeDeploymentPlanOutput, error)
	DescribeEdgeDeploymentPlanRequest(*sagemaker.DescribeEdgeDeploymentPlanInput) (*request.Request, *sagemaker.DescribeEdgeDeploymentPlanOutput)

	DescribeEdgePackagingJob(*sagemaker.DescribeEdgePackagingJobInput) (*sagemaker.DescribeEdgePackagingJobOutput, error)
	DescribeEdgePackagingJobWithContext(aws.Context, *sagemaker.DescribeEdgePackagingJobInput, ...request.Option) (*sagemaker.DescribeEdgePackagingJobOutput, error)
	DescribeEdgePackagingJobRequest(*sagemaker.DescribeEdgePackagingJobInput) (*request.Request, *sagemaker.DescribeEdgePackagingJobOutput)

	DescribeEndpoint(*sagemaker.DescribeEndpointInput) (*sagemaker.DescribeEndpointOutput, error)
	DescribeEndpointWithContext(aws.Context, *sagemaker.DescribeEndpointInput, ...request.Option) (*sagemaker.DescribeEndpointOutput, error)
	DescribeEndpointRequest(*sagemaker.DescribeEndpointInput) (*request.Request, *sagemaker.DescribeEndpointOutput)

	DescribeEndpointConfig(*sagemaker.DescribeEndpointConfigInput) (*sagemaker.DescribeEndpointConfigOutput, error)
	DescribeEndpointConfigWithContext(aws.Context, *sagemaker.DescribeEndpointConfigInput, ...request.Option) (*sagemaker.DescribeEndpointConfigOutput, error)
	DescribeEndpointConfigRequest(*sagemaker.DescribeEndpointConfigInput) (*request.Request, *sagemaker.DescribeEndpointConfigOutput)

	DescribeExperiment(*sagemaker.DescribeExperimentInput) (*sagemaker.DescribeExperimentOutput, error)
	DescribeExperimentWithContext(aws.Context, *sagemaker.DescribeExperimentInput, ...request.Option) (*sagemaker.DescribeExperimentOutput, error)
	DescribeExperimentRequest(*sagemaker.DescribeExperimentInput) (*request.Request, *sagemaker.DescribeExperimentOutput)

	DescribeFeatureGroup(*sagemaker.DescribeFeatureGroupInput) (*sagemaker.DescribeFeatureGroupOutput, error)
	DescribeFeatureGroupWithContext(aws.Context, *sagemaker.DescribeFeatureGroupInput, ...request.Option) (*sagemaker.DescribeFeatureGroupOutput, error)
	DescribeFeatureGroupRequest(*sagemaker.DescribeFeatureGroupInput) (*request.Request, *sagemaker.DescribeFeatureGroupOutput)

	DescribeFeatureMetadata(*sagemaker.DescribeFeatureMetadataInput) (*sagemaker.DescribeFeatureMetadataOutput, error)
	DescribeFeatureMetadataWithContext(aws.Context, *sagemaker.DescribeFeatureMetadataInput, ...request.Option) (*sagemaker.DescribeFeatureMetadataOutput, error)
	DescribeFeatureMetadataRequest(*sagemaker.DescribeFeatureMetadataInput) (*request.Request, *sagemaker.DescribeFeatureMetadataOutput)

	DescribeFlowDefinition(*sagemaker.DescribeFlowDefinitionInput) (*sagemaker.DescribeFlowDefinitionOutput, error)
	DescribeFlowDefinitionWithContext(aws.Context, *sagemaker.DescribeFlowDefinitionInput, ...request.Option) (*sagemaker.DescribeFlowDefinitionOutput, error)
	DescribeFlowDefinitionRequest(*sagemaker.DescribeFlowDefinitionInput) (*request.Request, *sagemaker.DescribeFlowDefinitionOutput)

	DescribeHub(*sagemaker.DescribeHubInput) (*sagemaker.DescribeHubOutput, error)
	DescribeHubWithContext(aws.Context, *sagemaker.DescribeHubInput, ...request.Option) (*sagemaker.DescribeHubOutput, error)
	DescribeHubRequest(*sagemaker.DescribeHubInput) (*request.Request, *sagemaker.DescribeHubOutput)

	DescribeHubContent(*sagemaker.DescribeHubContentInput) (*sagemaker.DescribeHubContentOutput, error)
	DescribeHubContentWithContext(aws.Context, *sagemaker.DescribeHubContentInput, ...request.Option) (*sagemaker.DescribeHubContentOutput, error)
	DescribeHubContentRequest(*sagemaker.DescribeHubContentInput) (*request.Request, *sagemaker.DescribeHubContentOutput)

	DescribeHumanTaskUi(*sagemaker.DescribeHumanTaskUiInput) (*sagemaker.DescribeHumanTaskUiOutput, error)
	DescribeHumanTaskUiWithContext(aws.Context, *sagemaker.DescribeHumanTaskUiInput, ...request.Option) (*sagemaker.DescribeHumanTaskUiOutput, error)
	DescribeHumanTaskUiRequest(*sagemaker.DescribeHumanTaskUiInput) (*request.Request, *sagemaker.DescribeHumanTaskUiOutput)

	DescribeHyperParameterTuningJob(*sagemaker.DescribeHyperParameterTuningJobInput) (*sagemaker.DescribeHyperParameterTuningJobOutput, error)
	DescribeHyperParameterTuningJobWithContext(aws.Context, *sagemaker.DescribeHyperParameterTuningJobInput, ...request.Option) (*sagemaker.DescribeHyperParameterTuningJobOutput, error)
	DescribeHyperParameterTuningJobRequest(*sagemaker.DescribeHyperParameterTuningJobInput) (*request.Request, *sagemaker.DescribeHyperParameterTuningJobOutput)

	DescribeImage(*sagemaker.DescribeImageInput) (*sagemaker.DescribeImageOutput, error)
	DescribeImageWithContext(aws.Context, *sagemaker.DescribeImageInput, ...request.Option) (*sagemaker.DescribeImageOutput, error)
	DescribeImageRequest(*sagemaker.DescribeImageInput) (*request.Request, *sagemaker.DescribeImageOutput)

	DescribeImageVersion(*sagemaker.DescribeImageVersionInput) (*sagemaker.DescribeImageVersionOutput, error)
	DescribeImageVersionWithContext(aws.Context, *sagemaker.DescribeImageVersionInput, ...request.Option) (*sagemaker.DescribeImageVersionOutput, error)
	DescribeImageVersionRequest(*sagemaker.DescribeImageVersionInput) (*request.Request, *sagemaker.DescribeImageVersionOutput)

	DescribeInferenceExperiment(*sagemaker.DescribeInferenceExperimentInput) (*sagemaker.DescribeInferenceExperimentOutput, error)
	DescribeInferenceExperimentWithContext(aws.Context, *sagemaker.DescribeInferenceExperimentInput, ...request.Option) (*sagemaker.DescribeInferenceExperimentOutput, error)
	DescribeInferenceExperimentRequest(*sagemaker.DescribeInferenceExperimentInput) (*request.Request, *sagemaker.DescribeInferenceExperimentOutput)

	DescribeInferenceRecommendationsJob(*sagemaker.DescribeInferenceRecommendationsJobInput) (*sagemaker.DescribeInferenceRecommendationsJobOutput, error)
	DescribeInferenceRecommendationsJobWithContext(aws.Context, *sagemaker.DescribeInferenceRecommendationsJobInput, ...request.Option) (*sagemaker.DescribeInferenceRecommendationsJobOutput, error)
	DescribeInferenceRecommendationsJobRequest(*sagemaker.DescribeInferenceRecommendationsJobInput) (*request.Request, *sagemaker.DescribeInferenceRecommendationsJobOutput)

	DescribeLabelingJob(*sagemaker.DescribeLabelingJobInput) (*sagemaker.DescribeLabelingJobOutput, error)
	DescribeLabelingJobWithContext(aws.Context, *sagemaker.DescribeLabelingJobInput, ...request.Option) (*sagemaker.DescribeLabelingJobOutput, error)
	DescribeLabelingJobRequest(*sagemaker.DescribeLabelingJobInput) (*request.Request, *sagemaker.DescribeLabelingJobOutput)

	DescribeLineageGroup(*sagemaker.DescribeLineageGroupInput) (*sagemaker.DescribeLineageGroupOutput, error)
	DescribeLineageGroupWithContext(aws.Context, *sagemaker.DescribeLineageGroupInput, ...request.Option) (*sagemaker.DescribeLineageGroupOutput, error)
	DescribeLineageGroupRequest(*sagemaker.DescribeLineageGroupInput) (*request.Request, *sagemaker.DescribeLineageGroupOutput)

	DescribeModel(*sagemaker.DescribeModelInput) (*sagemaker.DescribeModelOutput, error)
	DescribeModelWithContext(aws.Context, *sagemaker.DescribeModelInput, ...request.Option) (*sagemaker.DescribeModelOutput, error)
	DescribeModelRequest(*sagemaker.DescribeModelInput) (*request.Request, *sagemaker.DescribeModelOutput)

	DescribeModelBiasJobDefinition(*sagemaker.DescribeModelBiasJobDefinitionInput) (*sagemaker.DescribeModelBiasJobDefinitionOutput, error)
	DescribeModelBiasJobDefinitionWithContext(aws.Context, *sagemaker.DescribeModelBiasJobDefinitionInput, ...request.Option) (*sagemaker.DescribeModelBiasJobDefinitionOutput, error)
	DescribeModelBiasJobDefinitionRequest(*sagemaker.DescribeModelBiasJobDefinitionInput) (*request.Request, *sagemaker.DescribeModelBiasJobDefinitionOutput)

	DescribeModelCard(*sagemaker.DescribeModelCardInput) (*sagemaker.DescribeModelCardOutput, error)
	DescribeModelCardWithContext(aws.Context, *sagemaker.DescribeModelCardInput, ...request.Option) (*sagemaker.DescribeModelCardOutput, error)
	DescribeModelCardRequest(*sagemaker.DescribeModelCardInput) (*request.Request, *sagemaker.DescribeModelCardOutput)

	DescribeModelCardExportJob(*sagemaker.DescribeModelCardExportJobInput) (*sagemaker.DescribeModelCardExportJobOutput, error)
	DescribeModelCardExportJobWithContext(aws.Context, *sagemaker.DescribeModelCardExportJobInput, ...request.Option) (*sagemaker.DescribeModelCardExportJobOutput, error)
	DescribeModelCardExportJobRequest(*sagemaker.DescribeModelCardExportJobInput) (*request.Request, *sagemaker.DescribeModelCardExportJobOutput)

	DescribeModelExplainabilityJobDefinition(*sagemaker.DescribeModelExplainabilityJobDefinitionInput) (*sagemaker.DescribeModelExplainabilityJobDefinitionOutput, error)
	DescribeModelExplainabilityJobDefinitionWithContext(aws.Context, *sagemaker.DescribeModelExplainabilityJobDefinitionInput, ...request.Option) (*sagemaker.DescribeModelExplainabilityJobDefinitionOutput, error)
	DescribeModelExplainabilityJobDefinitionRequest(*sagemaker.DescribeModelExplainabilityJobDefinitionInput) (*request.Request, *sagemaker.DescribeModelExplainabilityJobDefinitionOutput)

	DescribeModelPackage(*sagemaker.DescribeModelPackageInput) (*sagemaker.DescribeModelPackageOutput, error)
	DescribeModelPackageWithContext(aws.Context, *sagemaker.DescribeModelPackageInput, ...request.Option) (*sagemaker.DescribeModelPackageOutput, error)
	DescribeModelPackageRequest(*sagemaker.DescribeModelPackageInput) (*request.Request, *sagemaker.DescribeModelPackageOutput)

	DescribeModelPackageGroup(*sagemaker.DescribeModelPackageGroupInput) (*sagemaker.DescribeModelPackageGroupOutput, error)
	DescribeModelPackageGroupWithContext(aws.Context, *sagemaker.DescribeModelPackageGroupInput, ...request.Option) (*sagemaker.DescribeModelPackageGroupOutput, error)
	DescribeModelPackageGroupRequest(*sagemaker.DescribeModelPackageGroupInput) (*request.Request, *sagemaker.DescribeModelPackageGroupOutput)

	DescribeModelQualityJobDefinition(*sagemaker.DescribeModelQualityJobDefinitionInput) (*sagemaker.DescribeModelQualityJobDefinitionOutput, error)
	DescribeModelQualityJobDefinitionWithContext(aws.Context, *sagemaker.DescribeModelQualityJobDefinitionInput, ...request.Option) (*sagemaker.DescribeModelQualityJobDefinitionOutput, error)
	DescribeModelQualityJobDefinitionRequest(*sagemaker.DescribeModelQualityJobDefinitionInput) (*request.Request, *sagemaker.DescribeModelQualityJobDefinitionOutput)

	DescribeMonitoringSchedule(*sagemaker.DescribeMonitoringScheduleInput) (*sagemaker.DescribeMonitoringScheduleOutput, error)
	DescribeMonitoringScheduleWithContext(aws.Context, *sagemaker.DescribeMonitoringScheduleInput, ...request.Option) (*sagemaker.DescribeMonitoringScheduleOutput, error)
	DescribeMonitoringScheduleRequest(*sagemaker.DescribeMonitoringScheduleInput) (*request.Request, *sagemaker.DescribeMonitoringScheduleOutput)

	DescribeNotebookInstance(*sagemaker.DescribeNotebookInstanceInput) (*sagemaker.DescribeNotebookInstanceOutput, error)
	DescribeNotebookInstanceWithContext(aws.Context, *sagemaker.DescribeNotebookInstanceInput, ...request.Option) (*sagemaker.DescribeNotebookInstanceOutput, error)
	DescribeNotebookInstanceRequest(*sagemaker.DescribeNotebookInstanceInput) (*request.Request, *sagemaker.DescribeNotebookInstanceOutput)

	DescribeNotebookInstanceLifecycleConfig(*sagemaker.DescribeNotebookInstanceLifecycleConfigInput) (*sagemaker.DescribeNotebookInstanceLifecycleConfigOutput, error)
	DescribeNotebookInstanceLifecycleConfigWithContext(aws.Context, *sagemaker.DescribeNotebookInstanceLifecycleConfigInput, ...request.Option) (*sagemaker.DescribeNotebookInstanceLifecycleConfigOutput, error)
	DescribeNotebookInstanceLifecycleConfigRequest(*sagemaker.DescribeNotebookInstanceLifecycleConfigInput) (*request.Request, *sagemaker.DescribeNotebookInstanceLifecycleConfigOutput)

	DescribePipeline(*sagemaker.DescribePipelineInput) (*sagemaker.DescribePipelineOutput, error)
	DescribePipelineWithContext(aws.Context, *sagemaker.DescribePipelineInput, ...request.Option) (*sagemaker.DescribePipelineOutput, error)
	DescribePipelineRequest(*sagemaker.DescribePipelineInput) (*request.Request, *sagemaker.DescribePipelineOutput)

	DescribePipelineDefinitionForExecution(*sagemaker.DescribePipelineDefinitionForExecutionInput) (*sagemaker.DescribePipelineDefinitionForExecutionOutput, error)
	DescribePipelineDefinitionForExecutionWithContext(aws.Context, *sagemaker.DescribePipelineDefinitionForExecutionInput, ...request.Option) (*sagemaker.DescribePipelineDefinitionForExecutionOutput, error)
	DescribePipelineDefinitionForExecutionRequest(*sagemaker.DescribePipelineDefinitionForExecutionInput) (*request.Request, *sagemaker.DescribePipelineDefinitionForExecutionOutput)

	DescribePipelineExecution(*sagemaker.DescribePipelineExecutionInput) (*sagemaker.DescribePipelineExecutionOutput, error)
	DescribePipelineExecutionWithContext(aws.Context, *sagemaker.DescribePipelineExecutionInput, ...request.Option) (*sagemaker.DescribePipelineExecutionOutput, error)
	DescribePipelineExecutionRequest(*sagemaker.DescribePipelineExecutionInput) (*request.Request, *sagemaker.DescribePipelineExecutionOutput)

	DescribeProcessingJob(*sagemaker.DescribeProcessingJobInput) (*sagemaker.DescribeProcessingJobOutput, error)
	DescribeProcessingJobWithContext(aws.Context, *sagemaker.DescribeProcessingJobInput, ...request.Option) (*sagemaker.DescribeProcessingJobOutput, error)
	DescribeProcessingJobRequest(*sagemaker.DescribeProcessingJobInput) (*request.Request, *sagemaker.DescribeProcessingJobOutput)

	DescribeProject(*sagemaker.DescribeProjectInput) (*sagemaker.DescribeProjectOutput, error)
	DescribeProjectWithContext(aws.Context, *sagemaker.DescribeProjectInput, ...request.Option) (*sagemaker.DescribeProjectOutput, error)
	DescribeProjectRequest(*sagemaker.DescribeProjectInput) (*request.Request, *sagemaker.DescribeProjectOutput)

	DescribeSpace(*sagemaker.DescribeSpaceInput) (*sagemaker.DescribeSpaceOutput, error)
	DescribeSpaceWithContext(aws.Context, *sagemaker.DescribeSpaceInput, ...request.Option) (*sagemaker.DescribeSpaceOutput, error)
	DescribeSpaceRequest(*sagemaker.DescribeSpaceInput) (*request.Request, *sagemaker.DescribeSpaceOutput)

	DescribeStudioLifecycleConfig(*sagemaker.DescribeStudioLifecycleConfigInput) (*sagemaker.DescribeStudioLifecycleConfigOutput, error)
	DescribeStudioLifecycleConfigWithContext(aws.Context, *sagemaker.DescribeStudioLifecycleConfigInput, ...request.Option) (*sagemaker.DescribeStudioLifecycleConfigOutput, error)
	DescribeStudioLifecycleConfigRequest(*sagemaker.DescribeStudioLifecycleConfigInput) (*request.Request, *sagemaker.DescribeStudioLifecycleConfigOutput)

	DescribeSubscribedWorkteam(*sagemaker.DescribeSubscribedWorkteamInput) (*sagemaker.DescribeSubscribedWorkteamOutput, error)
	DescribeSubscribedWorkteamWithContext(aws.Context, *sagemaker.DescribeSubscribedWorkteamInput, ...request.Option) (*sagemaker.DescribeSubscribedWorkteamOutput, error)
	DescribeSubscribedWorkteamRequest(*sagemaker.DescribeSubscribedWorkteamInput) (*request.Request, *sagemaker.DescribeSubscribedWorkteamOutput)

	DescribeTrainingJob(*sagemaker.DescribeTrainingJobInput) (*sagemaker.DescribeTrainingJobOutput, error)
	DescribeTrainingJobWithContext(aws.Context, *sagemaker.DescribeTrainingJobInput, ...request.Option) (*sagemaker.DescribeTrainingJobOutput, error)
	DescribeTrainingJobRequest(*sagemaker.DescribeTrainingJobInput) (*request.Request, *sagemaker.DescribeTrainingJobOutput)

	DescribeTransformJob(*sagemaker.DescribeTransformJobInput) (*sagemaker.DescribeTransformJobOutput, error)
	DescribeTransformJobWithContext(aws.Context, *sagemaker.DescribeTransformJobInput, ...request.Option) (*sagemaker.DescribeTransformJobOutput, error)
	DescribeTransformJobRequest(*sagemaker.DescribeTransformJobInput) (*request.Request, *sagemaker.DescribeTransformJobOutput)

	DescribeTrial(*sagemaker.DescribeTrialInput) (*sagemaker.DescribeTrialOutput, error)
	DescribeTrialWithContext(aws.Context, *sagemaker.DescribeTrialInput, ...request.Option) (*sagemaker.DescribeTrialOutput, error)
	DescribeTrialRequest(*sagemaker.DescribeTrialInput) (*request.Request, *sagemaker.DescribeTrialOutput)

	DescribeTrialComponent(*sagemaker.DescribeTrialComponentInput) (*sagemaker.DescribeTrialComponentOutput, error)
	DescribeTrialComponentWithContext(aws.Context, *sagemaker.DescribeTrialComponentInput, ...request.Option) (*sagemaker.DescribeTrialComponentOutput, error)
	DescribeTrialComponentRequest(*sagemaker.DescribeTrialComponentInput) (*request.Request, *sagemaker.DescribeTrialComponentOutput)

	DescribeUserProfile(*sagemaker.DescribeUserProfileInput) (*sagemaker.DescribeUserProfileOutput, error)
	DescribeUserProfileWithContext(aws.Context, *sagemaker.DescribeUserProfileInput, ...request.Option) (*sagemaker.DescribeUserProfileOutput, error)
	DescribeUserProfileRequest(*sagemaker.DescribeUserProfileInput) (*request.Request, *sagemaker.DescribeUserProfileOutput)

	DescribeWorkforce(*sagemaker.DescribeWorkforceInput) (*sagemaker.DescribeWorkforceOutput, error)
	DescribeWorkforceWithContext(aws.Context, *sagemaker.DescribeWorkforceInput, ...request.Option) (*sagemaker.DescribeWorkforceOutput, error)
	DescribeWorkforceRequest(*sagemaker.DescribeWorkforceInput) (*request.Request, *sagemaker.DescribeWorkforceOutput)

	DescribeWorkteam(*sagemaker.DescribeWorkteamInput) (*sagemaker.DescribeWorkteamOutput, error)
	DescribeWorkteamWithContext(aws.Context, *sagemaker.DescribeWorkteamInput, ...request.Option) (*sagemaker.DescribeWorkteamOutput, error)
	DescribeWorkteamRequest(*sagemaker.DescribeWorkteamInput) (*request.Request, *sagemaker.DescribeWorkteamOutput)

	DisableSagemakerServicecatalogPortfolio(*sagemaker.DisableSagemakerServicecatalogPortfolioInput) (*sagemaker.DisableSagemakerServicecatalogPortfolioOutput, error)
	DisableSagemakerServicecatalogPortfolioWithContext(aws.Context, *sagemaker.DisableSagemakerServicecatalogPortfolioInput, ...request.Option) (*sagemaker.DisableSagemakerServicecatalogPortfolioOutput, error)
	DisableSagemakerServicecatalogPortfolioRequest(*sagemaker.DisableSagemakerServicecatalogPortfolioInput) (*request.Request, *sagemaker.DisableSagemakerServicecatalogPortfolioOutput)

	DisassociateTrialComponent(*sagemaker.DisassociateTrialComponentInput) (*sagemaker.DisassociateTrialComponentOutput, error)
	DisassociateTrialComponentWithContext(aws.Context, *sagemaker.DisassociateTrialComponentInput, ...request.Option) (*sagemaker.DisassociateTrialComponentOutput, error)
	DisassociateTrialComponentRequest(*sagemaker.DisassociateTrialComponentInput) (*request.Request, *sagemaker.DisassociateTrialComponentOutput)

	EnableSagemakerServicecatalogPortfolio(*sagemaker.EnableSagemakerServicecatalogPortfolioInput) (*sagemaker.EnableSagemakerServicecatalogPortfolioOutput, error)
	EnableSagemakerServicecatalogPortfolioWithContext(aws.Context, *sagemaker.EnableSagemakerServicecatalogPortfolioInput, ...request.Option) (*sagemaker.EnableSagemakerServicecatalogPortfolioOutput, error)
	EnableSagemakerServicecatalogPortfolioRequest(*sagemaker.EnableSagemakerServicecatalogPortfolioInput) (*request.Request, *sagemaker.EnableSagemakerServicecatalogPortfolioOutput)

	GetDeviceFleetReport(*sagemaker.GetDeviceFleetReportInput) (*sagemaker.GetDeviceFleetReportOutput, error)
	GetDeviceFleetReportWithContext(aws.Context, *sagemaker.GetDeviceFleetReportInput, ...request.Option) (*sagemaker.GetDeviceFleetReportOutput, error)
	GetDeviceFleetReportRequest(*sagemaker.GetDeviceFleetReportInput) (*request.Request, *sagemaker.GetDeviceFleetReportOutput)

	GetLineageGroupPolicy(*sagemaker.GetLineageGroupPolicyInput) (*sagemaker.GetLineageGroupPolicyOutput, error)
	GetLineageGroupPolicyWithContext(aws.Context, *sagemaker.GetLineageGroupPolicyInput, ...request.Option) (*sagemaker.GetLineageGroupPolicyOutput, error)
	GetLineageGroupPolicyRequest(*sagemaker.GetLineageGroupPolicyInput) (*request.Request, *sagemaker.GetLineageGroupPolicyOutput)

	GetModelPackageGroupPolicy(*sagemaker.GetModelPackageGroupPolicyInput) (*sagemaker.GetModelPackageGroupPolicyOutput, error)
	GetModelPackageGroupPolicyWithContext(aws.Context, *sagemaker.GetModelPackageGroupPolicyInput, ...request.Option) (*sagemaker.GetModelPackageGroupPolicyOutput, error)
	GetModelPackageGroupPolicyRequest(*sagemaker.GetModelPackageGroupPolicyInput) (*request.Request, *sagemaker.GetModelPackageGroupPolicyOutput)

	GetSagemakerServicecatalogPortfolioStatus(*sagemaker.GetSagemakerServicecatalogPortfolioStatusInput) (*sagemaker.GetSagemakerServicecatalogPortfolioStatusOutput, error)
	GetSagemakerServicecatalogPortfolioStatusWithContext(aws.Context, *sagemaker.GetSagemakerServicecatalogPortfolioStatusInput, ...request.Option) (*sagemaker.GetSagemakerServicecatalogPortfolioStatusOutput, error)
	GetSagemakerServicecatalogPortfolioStatusRequest(*sagemaker.GetSagemakerServicecatalogPortfolioStatusInput) (*request.Request, *sagemaker.GetSagemakerServicecatalogPortfolioStatusOutput)

	GetScalingConfigurationRecommendation(*sagemaker.GetScalingConfigurationRecommendationInput) (*sagemaker.GetScalingConfigurationRecommendationOutput, error)
	GetScalingConfigurationRecommendationWithContext(aws.Context, *sagemaker.GetScalingConfigurationRecommendationInput, ...request.Option) (*sagemaker.GetScalingConfigurationRecommendationOutput, error)
	GetScalingConfigurationRecommendationRequest(*sagemaker.GetScalingConfigurationRecommendationInput) (*request.Request, *sagemaker.GetScalingConfigurationRecommendationOutput)

	GetSearchSuggestions(*sagemaker.GetSearchSuggestionsInput) (*sagemaker.GetSearchSuggestionsOutput, error)
	GetSearchSuggestionsWithContext(aws.Context, *sagemaker.GetSearchSuggestionsInput, ...request.Option) (*sagemaker.GetSearchSuggestionsOutput, error)
	GetSearchSuggestionsRequest(*sagemaker.GetSearchSuggestionsInput) (*request.Request, *sagemaker.GetSearchSuggestionsOutput)

	ImportHubContent(*sagemaker.ImportHubContentInput) (*sagemaker.ImportHubContentOutput, error)
	ImportHubContentWithContext(aws.Context, *sagemaker.ImportHubContentInput, ...request.Option) (*sagemaker.ImportHubContentOutput, error)
	ImportHubContentRequest(*sagemaker.ImportHubContentInput) (*request.Request, *sagemaker.ImportHubContentOutput)

	ListActions(*sagemaker.ListActionsInput) (*sagemaker.ListActionsOutput, error)
	ListActionsWithContext(aws.Context, *sagemaker.ListActionsInput, ...request.Option) (*sagemaker.ListActionsOutput, error)
	ListActionsRequest(*sagemaker.ListActionsInput) (*request.Request, *sagemaker.ListActionsOutput)

	ListActionsPages(*sagemaker.ListActionsInput, func(*sagemaker.ListActionsOutput, bool) bool) error
	ListActionsPagesWithContext(aws.Context, *sagemaker.ListActionsInput, func(*sagemaker.ListActionsOutput, bool) bool, ...request.Option) error

	ListAlgorithms(*sagemaker.ListAlgorithmsInput) (*sagemaker.ListAlgorithmsOutput, error)
	ListAlgorithmsWithContext(aws.Context, *sagemaker.ListAlgorithmsInput, ...request.Option) (*sagemaker.ListAlgorithmsOutput, error)
	ListAlgorithmsRequest(*sagemaker.ListAlgorithmsInput) (*request.Request, *sagemaker.ListAlgorithmsOutput)

	ListAlgorithmsPages(*sagemaker.ListAlgorithmsInput, func(*sagemaker.ListAlgorithmsOutput, bool) bool) error
	ListAlgorithmsPagesWithContext(aws.Context, *sagemaker.ListAlgorithmsInput, func(*sagemaker.ListAlgorithmsOutput, bool) bool, ...request.Option) error

	ListAliases(*sagemaker.ListAliasesInput) (*sagemaker.ListAliasesOutput, error)
	ListAliasesWithContext(aws.Context, *sagemaker.ListAliasesInput, ...request.Option) (*sagemaker.ListAliasesOutput, error)
	ListAliasesRequest(*sagemaker.ListAliasesInput) (*request.Request, *sagemaker.ListAliasesOutput)

	ListAliasesPages(*sagemaker.ListAliasesInput, func(*sagemaker.ListAliasesOutput, bool) bool) error
	ListAliasesPagesWithContext(aws.Context, *sagemaker.ListAliasesInput, func(*sagemaker.ListAliasesOutput, bool) bool, ...request.Option) error

	ListAppImageConfigs(*sagemaker.ListAppImageConfigsInput) (*sagemaker.ListAppImageConfigsOutput, error)
	ListAppImageConfigsWithContext(aws.Context, *sagemaker.ListAppImageConfigsInput, ...request.Option) (*sagemaker.ListAppImageConfigsOutput, error)
	ListAppImageConfigsRequest(*sagemaker.ListAppImageConfigsInput) (*request.Request, *sagemaker.ListAppImageConfigsOutput)

	ListAppImageConfigsPages(*sagemaker.ListAppImageConfigsInput, func(*sagemaker.ListAppImageConfigsOutput, bool) bool) error
	ListAppImageConfigsPagesWithContext(aws.Context, *sagemaker.ListAppImageConfigsInput, func(*sagemaker.ListAppImageConfigsOutput, bool) bool, ...request.Option) error

	ListApps(*sagemaker.ListAppsInput) (*sagemaker.ListAppsOutput, error)
	ListAppsWithContext(aws.Context, *sagemaker.ListAppsInput, ...request.Option) (*sagemaker.ListAppsOutput, error)
	ListAppsRequest(*sagemaker.ListAppsInput) (*request.Request, *sagemaker.ListAppsOutput)

	ListAppsPages(*sagemaker.ListAppsInput, func(*sagemaker.ListAppsOutput, bool) bool) error
	ListAppsPagesWithContext(aws.Context, *sagemaker.ListAppsInput, func(*sagemaker.ListAppsOutput, bool) bool, ...request.Option) error

	ListArtifacts(*sagemaker.ListArtifactsInput) (*sagemaker.ListArtifactsOutput, error)
	ListArtifactsWithContext(aws.Context, *sagemaker.ListArtifactsInput, ...request.Option) (*sagemaker.ListArtifactsOutput, error)
	ListArtifactsRequest(*sagemaker.ListArtifactsInput) (*request.Request, *sagemaker.ListArtifactsOutput)

	ListArtifactsPages(*sagemaker.ListArtifactsInput, func(*sagemaker.ListArtifactsOutput, bool) bool) error
	ListArtifactsPagesWithContext(aws.Context, *sagemaker.ListArtifactsInput, func(*sagemaker.ListArtifactsOutput, bool) bool, ...request.Option) error

	ListAssociations(*sagemaker.ListAssociationsInput) (*sagemaker.ListAssociationsOutput, error)
	ListAssociationsWithContext(aws.Context, *sagemaker.ListAssociationsInput, ...request.Option) (*sagemaker.ListAssociationsOutput, error)
	ListAssociationsRequest(*sagemaker.ListAssociationsInput) (*request.Request, *sagemaker.ListAssociationsOutput)

	ListAssociationsPages(*sagemaker.ListAssociationsInput, func(*sagemaker.ListAssociationsOutput, bool) bool) error
	ListAssociationsPagesWithContext(aws.Context, *sagemaker.ListAssociationsInput, func(*sagemaker.ListAssociationsOutput, bool) bool, ...request.Option) error

	ListAutoMLJobs(*sagemaker.ListAutoMLJobsInput) (*sagemaker.ListAutoMLJobsOutput, error)
	ListAutoMLJobsWithContext(aws.Context, *sagemaker.ListAutoMLJobsInput, ...request.Option) (*sagemaker.ListAutoMLJobsOutput, error)
	ListAutoMLJobsRequest(*sagemaker.ListAutoMLJobsInput) (*request.Request, *sagemaker.ListAutoMLJobsOutput)

	ListAutoMLJobsPages(*sagemaker.ListAutoMLJobsInput, func(*sagemaker.ListAutoMLJobsOutput, bool) bool) error
	ListAutoMLJobsPagesWithContext(aws.Context, *sagemaker.ListAutoMLJobsInput, func(*sagemaker.ListAutoMLJobsOutput, bool) bool, ...request.Option) error

	ListCandidatesForAutoMLJob(*sagemaker.ListCandidatesForAutoMLJobInput) (*sagemaker.ListCandidatesForAutoMLJobOutput, error)
	ListCandidatesForAutoMLJobWithContext(aws.Context, *sagemaker.ListCandidatesForAutoMLJobInput, ...request.Option) (*sagemaker.ListCandidatesForAutoMLJobOutput, error)
	ListCandidatesForAutoMLJobRequest(*sagemaker.ListCandidatesForAutoMLJobInput) (*request.Request, *sagemaker.ListCandidatesForAutoMLJobOutput)

	ListCandidatesForAutoMLJobPages(*sagemaker.ListCandidatesForAutoMLJobInput, func(*sagemaker.ListCandidatesForAutoMLJobOutput, bool) bool) error
	ListCandidatesForAutoMLJobPagesWithContext(aws.Context, *sagemaker.ListCandidatesForAutoMLJobInput, func(*sagemaker.ListCandidatesForAutoMLJobOutput, bool) bool, ...request.Option) error

	ListCodeRepositories(*sagemaker.ListCodeRepositoriesInput) (*sagemaker.ListCodeRepositoriesOutput, error)
	ListCodeRepositoriesWithContext(aws.Context, *sagemaker.ListCodeRepositoriesInput, ...request.Option) (*sagemaker.ListCodeRepositoriesOutput, error)
	ListCodeRepositoriesRequest(*sagemaker.ListCodeRepositoriesInput) (*request.Request, *sagemaker.ListCodeRepositoriesOutput)

	ListCodeRepositoriesPages(*sagemaker.ListCodeRepositoriesInput, func(*sagemaker.ListCodeRepositoriesOutput, bool) bool) error
	ListCodeRepositoriesPagesWithContext(aws.Context, *sagemaker.ListCodeRepositoriesInput, func(*sagemaker.ListCodeRepositoriesOutput, bool) bool, ...request.Option) error

	ListCompilationJobs(*sagemaker.ListCompilationJobsInput) (*sagemaker.ListCompilationJobsOutput, error)
	ListCompilationJobsWithContext(aws.Context, *sagemaker.ListCompilationJobsInput, ...request.Option) (*sagemaker.ListCompilationJobsOutput, error)
	ListCompilationJobsRequest(*sagemaker.ListCompilationJobsInput) (*request.Request, *sagemaker.ListCompilationJobsOutput)

	ListCompilationJobsPages(*sagemaker.ListCompilationJobsInput, func(*sagemaker.ListCompilationJobsOutput, bool) bool) error
	ListCompilationJobsPagesWithContext(aws.Context, *sagemaker.ListCompilationJobsInput, func(*sagemaker.ListCompilationJobsOutput, bool) bool, ...request.Option) error

	ListContexts(*sagemaker.ListContextsInput) (*sagemaker.ListContextsOutput, error)
	ListContextsWithContext(aws.Context, *sagemaker.ListContextsInput, ...request.Option) (*sagemaker.ListContextsOutput, error)
	ListContextsRequest(*sagemaker.ListContextsInput) (*request.Request, *sagemaker.ListContextsOutput)

	ListContextsPages(*sagemaker.ListContextsInput, func(*sagemaker.ListContextsOutput, bool) bool) error
	ListContextsPagesWithContext(aws.Context, *sagemaker.ListContextsInput, func(*sagemaker.ListContextsOutput, bool) bool, ...request.Option) error

	ListDataQualityJobDefinitions(*sagemaker.ListDataQualityJobDefinitionsInput) (*sagemaker.ListDataQualityJobDefinitionsOutput, error)
	ListDataQualityJobDefinitionsWithContext(aws.Context, *sagemaker.ListDataQualityJobDefinitionsInput, ...request.Option) (*sagemaker.ListDataQualityJobDefinitionsOutput, error)
	ListDataQualityJobDefinitionsRequest(*sagemaker.ListDataQualityJobDefinitionsInput) (*request.Request, *sagemaker.ListDataQualityJobDefinitionsOutput)

	ListDataQualityJobDefinitionsPages(*sagemaker.ListDataQualityJobDefinitionsInput, func(*sagemaker.ListDataQualityJobDefinitionsOutput, bool) bool) error
	ListDataQualityJobDefinitionsPagesWithContext(aws.Context, *sagemaker.ListDataQualityJobDefinitionsInput, func(*sagemaker.ListDataQualityJobDefinitionsOutput, bool) bool, ...request.Option) error

	ListDeviceFleets(*sagemaker.ListDeviceFleetsInput) (*sagemaker.ListDeviceFleetsOutput, error)
	ListDeviceFleetsWithContext(aws.Context, *sagemaker.ListDeviceFleetsInput, ...request.Option) (*sagemaker.ListDeviceFleetsOutput, error)
	ListDeviceFleetsRequest(*sagemaker.ListDeviceFleetsInput) (*request.Request, *sagemaker.ListDeviceFleetsOutput)

	ListDeviceFleetsPages(*sagemaker.ListDeviceFleetsInput, func(*sagemaker.ListDeviceFleetsOutput, bool) bool) error
	ListDeviceFleetsPagesWithContext(aws.Context, *sagemaker.ListDeviceFleetsInput, func(*sagemaker.ListDeviceFleetsOutput, bool) bool, ...request.Option) error

	ListDevices(*sagemaker.ListDevicesInput) (*sagemaker.ListDevicesOutput, error)
	ListDevicesWithContext(aws.Context, *sagemaker.ListDevicesInput, ...request.Option) (*sagemaker.ListDevicesOutput, error)
	ListDevicesRequest(*sagemaker.ListDevicesInput) (*request.Request, *sagemaker.ListDevicesOutput)

	ListDevicesPages(*sagemaker.ListDevicesInput, func(*sagemaker.ListDevicesOutput, bool) bool) error
	ListDevicesPagesWithContext(aws.Context, *sagemaker.ListDevicesInput, func(*sagemaker.ListDevicesOutput, bool) bool, ...request.Option) error

	ListDomains(*sagemaker.ListDomainsInput) (*sagemaker.ListDomainsOutput, error)
	ListDomainsWithContext(aws.Context, *sagemaker.ListDomainsInput, ...request.Option) (*sagemaker.ListDomainsOutput, error)
	ListDomainsRequest(*sagemaker.ListDomainsInput) (*request.Request, *sagemaker.ListDomainsOutput)

	ListDomainsPages(*sagemaker.ListDomainsInput, func(*sagemaker.ListDomainsOutput, bool) bool) error
	ListDomainsPagesWithContext(aws.Context, *sagemaker.ListDomainsInput, func(*sagemaker.ListDomainsOutput, bool) bool, ...request.Option) error

	ListEdgeDeploymentPlans(*sagemaker.ListEdgeDeploymentPlansInput) (*sagemaker.ListEdgeDeploymentPlansOutput, error)
	ListEdgeDeploymentPlansWithContext(aws.Context, *sagemaker.ListEdgeDeploymentPlansInput, ...request.Option) (*sagemaker.ListEdgeDeploymentPlansOutput, error)
	ListEdgeDeploymentPlansRequest(*sagemaker.ListEdgeDeploymentPlansInput) (*request.Request, *sagemaker.ListEdgeDeploymentPlansOutput)

	ListEdgeDeploymentPlansPages(*sagemaker.ListEdgeDeploymentPlansInput, func(*sagemaker.ListEdgeDeploymentPlansOutput, bool) bool) error
	ListEdgeDeploymentPlansPagesWithContext(aws.Context, *sagemaker.ListEdgeDeploymentPlansInput, func(*sagemaker.ListEdgeDeploymentPlansOutput, bool) bool, ...request.Option) error

	ListEdgePackagingJobs(*sagemaker.ListEdgePackagingJobsInput) (*sagemaker.ListEdgePackagingJobsOutput, error)
	ListEdgePackagingJobsWithContext(aws.Context, *sagemaker.ListEdgePackagingJobsInput, ...request.Option) (*sagemaker.ListEdgePackagingJobsOutput, error)
	ListEdgePackagingJobsRequest(*sagemaker.ListEdgePackagingJobsInput) (*request.Request, *sagemaker.ListEdgePackagingJobsOutput)

	ListEdgePackagingJobsPages(*sagemaker.ListEdgePackagingJobsInput, func(*sagemaker.ListEdgePackagingJobsOutput, bool) bool) error
	ListEdgePackagingJobsPagesWithContext(aws.Context, *sagemaker.ListEdgePackagingJobsInput, func(*sagemaker.ListEdgePackagingJobsOutput, bool) bool, ...request.Option) error

	ListEndpointConfigs(*sagemaker.ListEndpointConfigsInput) (*sagemaker.ListEndpointConfigsOutput, error)
	ListEndpointConfigsWithContext(aws.Context, *sagemaker.ListEndpointConfigsInput, ...request.Option) (*sagemaker.ListEndpointConfigsOutput, error)
	ListEndpointConfigsRequest(*sagemaker.ListEndpointConfigsInput) (*request.Request, *sagemaker.ListEndpointConfigsOutput)

	ListEndpointConfigsPages(*sagemaker.ListEndpointConfigsInput, func(*sagemaker.ListEndpointConfigsOutput, bool) bool) error
	ListEndpointConfigsPagesWithContext(aws.Context, *sagemaker.ListEndpointConfigsInput, func(*sagemaker.ListEndpointConfigsOutput, bool) bool, ...request.Option) error

	ListEndpoints(*sagemaker.ListEndpointsInput) (*sagemaker.ListEndpointsOutput, error)
	ListEndpointsWithContext(aws.Context, *sagemaker.ListEndpointsInput, ...request.Option) (*sagemaker.ListEndpointsOutput, error)
	ListEndpointsRequest(*sagemaker.ListEndpointsInput) (*request.Request, *sagemaker.ListEndpointsOutput)

	ListEndpointsPages(*sagemaker.ListEndpointsInput, func(*sagemaker.ListEndpointsOutput, bool) bool) error
	ListEndpointsPagesWithContext(aws.Context, *sagemaker.ListEndpointsInput, func(*sagemaker.ListEndpointsOutput, bool) bool, ...request.Option) error

	ListExperiments(*sagemaker.ListExperimentsInput) (*sagemaker.ListExperimentsOutput, error)
	ListExperimentsWithContext(aws.Context, *sagemaker.ListExperimentsInput, ...request.Option) (*sagemaker.ListExperimentsOutput, error)
	ListExperimentsRequest(*sagemaker.ListExperimentsInput) (*request.Request, *sagemaker.ListExperimentsOutput)

	ListExperimentsPages(*sagemaker.ListExperimentsInput, func(*sagemaker.ListExperimentsOutput, bool) bool) error
	ListExperimentsPagesWithContext(aws.Context, *sagemaker.ListExperimentsInput, func(*sagemaker.ListExperimentsOutput, bool) bool, ...request.Option) error

	ListFeatureGroups(*sagemaker.ListFeatureGroupsInput) (*sagemaker.ListFeatureGroupsOutput, error)
	ListFeatureGroupsWithContext(aws.Context, *sagemaker.ListFeatureGroupsInput, ...request.Option) (*sagemaker.ListFeatureGroupsOutput, error)
	ListFeatureGroupsRequest(*sagemaker.ListFeatureGroupsInput) (*request.Request, *sagemaker.ListFeatureGroupsOutput)

	ListFeatureGroupsPages(*sagemaker.ListFeatureGroupsInput, func(*sagemaker.ListFeatureGroupsOutput, bool) bool) error
	ListFeatureGroupsPagesWithContext(aws.Context, *sagemaker.ListFeatureGroupsInput, func(*sagemaker.ListFeatureGroupsOutput, bool) bool, ...request.Option) error

	ListFlowDefinitions(*sagemaker.ListFlowDefinitionsInput) (*sagemaker.ListFlowDefinitionsOutput, error)
	ListFlowDefinitionsWithContext(aws.Context, *sagemaker.ListFlowDefinitionsInput, ...request.Option) (*sagemaker.ListFlowDefinitionsOutput, error)
	ListFlowDefinitionsRequest(*sagemaker.ListFlowDefinitionsInput) (*request.Request, *sagemaker.ListFlowDefinitionsOutput)

	ListFlowDefinitionsPages(*sagemaker.ListFlowDefinitionsInput, func(*sagemaker.ListFlowDefinitionsOutput, bool) bool) error
	ListFlowDefinitionsPagesWithContext(aws.Context, *sagemaker.ListFlowDefinitionsInput, func(*sagemaker.ListFlowDefinitionsOutput, bool) bool, ...request.Option) error

	ListHubContentVersions(*sagemaker.ListHubContentVersionsInput) (*sagemaker.ListHubContentVersionsOutput, error)
	ListHubContentVersionsWithContext(aws.Context, *sagemaker.ListHubContentVersionsInput, ...request.Option) (*sagemaker.ListHubContentVersionsOutput, error)
	ListHubContentVersionsRequest(*sagemaker.ListHubContentVersionsInput) (*request.Request, *sagemaker.ListHubContentVersionsOutput)

	ListHubContents(*sagemaker.ListHubContentsInput) (*sagemaker.ListHubContentsOutput, error)
	ListHubContentsWithContext(aws.Context, *sagemaker.ListHubContentsInput, ...request.Option) (*sagemaker.ListHubContentsOutput, error)
	ListHubContentsRequest(*sagemaker.ListHubContentsInput) (*request.Request, *sagemaker.ListHubContentsOutput)

	ListHubs(*sagemaker.ListHubsInput) (*sagemaker.ListHubsOutput, error)
	ListHubsWithContext(aws.Context, *sagemaker.ListHubsInput, ...request.Option) (*sagemaker.ListHubsOutput, error)
	ListHubsRequest(*sagemaker.ListHubsInput) (*request.Request, *sagemaker.ListHubsOutput)

	ListHumanTaskUis(*sagemaker.ListHumanTaskUisInput) (*sagemaker.ListHumanTaskUisOutput, error)
	ListHumanTaskUisWithContext(aws.Context, *sagemaker.ListHumanTaskUisInput, ...request.Option) (*sagemaker.ListHumanTaskUisOutput, error)
	ListHumanTaskUisRequest(*sagemaker.ListHumanTaskUisInput) (*request.Request, *sagemaker.ListHumanTaskUisOutput)

	ListHumanTaskUisPages(*sagemaker.ListHumanTaskUisInput, func(*sagemaker.ListHumanTaskUisOutput, bool) bool) error
	ListHumanTaskUisPagesWithContext(aws.Context, *sagemaker.ListHumanTaskUisInput, func(*sagemaker.ListHumanTaskUisOutput, bool) bool, ...request.Option) error

	ListHyperParameterTuningJobs(*sagemaker.ListHyperParameterTuningJobsInput) (*sagemaker.ListHyperParameterTuningJobsOutput, error)
	ListHyperParameterTuningJobsWithContext(aws.Context, *sagemaker.ListHyperParameterTuningJobsInput, ...request.Option) (*sagemaker.ListHyperParameterTuningJobsOutput, error)
	ListHyperParameterTuningJobsRequest(*sagemaker.ListHyperParameterTuningJobsInput) (*request.Request, *sagemaker.ListHyperParameterTuningJobsOutput)

	ListHyperParameterTuningJobsPages(*sagemaker.ListHyperParameterTuningJobsInput, func(*sagemaker.ListHyperParameterTuningJobsOutput, bool) bool) error
	ListHyperParameterTuningJobsPagesWithContext(aws.Context, *sagemaker.ListHyperParameterTuningJobsInput, func(*sagemaker.ListHyperParameterTuningJobsOutput, bool) bool, ...request.Option) error

	ListImageVersions(*sagemaker.ListImageVersionsInput) (*sagemaker.ListImageVersionsOutput, error)
	ListImageVersionsWithContext(aws.Context, *sagemaker.ListImageVersionsInput, ...request.Option) (*sagemaker.ListImageVersionsOutput, error)
	ListImageVersionsRequest(*sagemaker.ListImageVersionsInput) (*request.Request, *sagemaker.ListImageVersionsOutput)

	ListImageVersionsPages(*sagemaker.ListImageVersionsInput, func(*sagemaker.ListImageVersionsOutput, bool) bool) error
	ListImageVersionsPagesWithContext(aws.Context, *sagemaker.ListImageVersionsInput, func(*sagemaker.ListImageVersionsOutput, bool) bool, ...request.Option) error

	ListImages(*sagemaker.ListImagesInput) (*sagemaker.ListImagesOutput, error)
	ListImagesWithContext(aws.Context, *sagemaker.ListImagesInput, ...request.Option) (*sagemaker.ListImagesOutput, error)
	ListImagesRequest(*sagemaker.ListImagesInput) (*request.Request, *sagemaker.ListImagesOutput)

	ListImagesPages(*sagemaker.ListImagesInput, func(*sagemaker.ListImagesOutput, bool) bool) error
	ListImagesPagesWithContext(aws.Context, *sagemaker.ListImagesInput, func(*sagemaker.ListImagesOutput, bool) bool, ...request.Option) error

	ListInferenceExperiments(*sagemaker.ListInferenceExperimentsInput) (*sagemaker.ListInferenceExperimentsOutput, error)
	ListInferenceExperimentsWithContext(aws.Context, *sagemaker.ListInferenceExperimentsInput, ...request.Option) (*sagemaker.ListInferenceExperimentsOutput, error)
	ListInferenceExperimentsRequest(*sagemaker.ListInferenceExperimentsInput) (*request.Request, *sagemaker.ListInferenceExperimentsOutput)

	ListInferenceExperimentsPages(*sagemaker.ListInferenceExperimentsInput, func(*sagemaker.ListInferenceExperimentsOutput, bool) bool) error
	ListInferenceExperimentsPagesWithContext(aws.Context, *sagemaker.ListInferenceExperimentsInput, func(*sagemaker.ListInferenceExperimentsOutput, bool) bool, ...request.Option) error

	ListInferenceRecommendationsJobSteps(*sagemaker.ListInferenceRecommendationsJobStepsInput) (*sagemaker.ListInferenceRecommendationsJobStepsOutput, error)
	ListInferenceRecommendationsJobStepsWithContext(aws.Context, *sagemaker.ListInferenceRecommendationsJobStepsInput, ...request.Option) (*sagemaker.ListInferenceRecommendationsJobStepsOutput, error)
	ListInferenceRecommendationsJobStepsRequest(*sagemaker.ListInferenceRecommendationsJobStepsInput) (*request.Request, *sagemaker.ListInferenceRecommendationsJobStepsOutput)

	ListInferenceRecommendationsJobStepsPages(*sagemaker.ListInferenceRecommendationsJobStepsInput, func(*sagemaker.ListInferenceRecommendationsJobStepsOutput, bool) bool) error
	ListInferenceRecommendationsJobStepsPagesWithContext(aws.Context, *sagemaker.ListInferenceRecommendationsJobStepsInput, func(*sagemaker.ListInferenceRecommendationsJobStepsOutput, bool) bool, ...request.Option) error

	ListInferenceRecommendationsJobs(*sagemaker.ListInferenceRecommendationsJobsInput) (*sagemaker.ListInferenceRecommendationsJobsOutput, error)
	ListInferenceRecommendationsJobsWithContext(aws.Context, *sagemaker.ListInferenceRecommendationsJobsInput, ...request.Option) (*sagemaker.ListInferenceRecommendationsJobsOutput, error)
	ListInferenceRecommendationsJobsRequest(*sagemaker.ListInferenceRecommendationsJobsInput) (*request.Request, *sagemaker.ListInferenceRecommendationsJobsOutput)

	ListInferenceRecommendationsJobsPages(*sagemaker.ListInferenceRecommendationsJobsInput, func(*sagemaker.ListInferenceRecommendationsJobsOutput, bool) bool) error
	ListInferenceRecommendationsJobsPagesWithContext(aws.Context, *sagemaker.ListInferenceRecommendationsJobsInput, func(*sagemaker.ListInferenceRecommendationsJobsOutput, bool) bool, ...request.Option) error

	ListLabelingJobs(*sagemaker.ListLabelingJobsInput) (*sagemaker.ListLabelingJobsOutput, error)
	ListLabelingJobsWithContext(aws.Context, *sagemaker.ListLabelingJobsInput, ...request.Option) (*sagemaker.ListLabelingJobsOutput, error)
	ListLabelingJobsRequest(*sagemaker.ListLabelingJobsInput) (*request.Request, *sagemaker.ListLabelingJobsOutput)

	ListLabelingJobsPages(*sagemaker.ListLabelingJobsInput, func(*sagemaker.ListLabelingJobsOutput, bool) bool) error
	ListLabelingJobsPagesWithContext(aws.Context, *sagemaker.ListLabelingJobsInput, func(*sagemaker.ListLabelingJobsOutput, bool) bool, ...request.Option) error

	ListLabelingJobsForWorkteam(*sagemaker.ListLabelingJobsForWorkteamInput) (*sagemaker.ListLabelingJobsForWorkteamOutput, error)
	ListLabelingJobsForWorkteamWithContext(aws.Context, *sagemaker.ListLabelingJobsForWorkteamInput, ...request.Option) (*sagemaker.ListLabelingJobsForWorkteamOutput, error)
	ListLabelingJobsForWorkteamRequest(*sagemaker.ListLabelingJobsForWorkteamInput) (*request.Request, *sagemaker.ListLabelingJobsForWorkteamOutput)

	ListLabelingJobsForWorkteamPages(*sagemaker.ListLabelingJobsForWorkteamInput, func(*sagemaker.ListLabelingJobsForWorkteamOutput, bool) bool) error
	ListLabelingJobsForWorkteamPagesWithContext(aws.Context, *sagemaker.ListLabelingJobsForWorkteamInput, func(*sagemaker.ListLabelingJobsForWorkteamOutput, bool) bool, ...request.Option) error

	ListLineageGroups(*sagemaker.ListLineageGroupsInput) (*sagemaker.ListLineageGroupsOutput, error)
	ListLineageGroupsWithContext(aws.Context, *sagemaker.ListLineageGroupsInput, ...request.Option) (*sagemaker.ListLineageGroupsOutput, error)
	ListLineageGroupsRequest(*sagemaker.ListLineageGroupsInput) (*request.Request, *sagemaker.ListLineageGroupsOutput)

	ListLineageGroupsPages(*sagemaker.ListLineageGroupsInput, func(*sagemaker.ListLineageGroupsOutput, bool) bool) error
	ListLineageGroupsPagesWithContext(aws.Context, *sagemaker.ListLineageGroupsInput, func(*sagemaker.ListLineageGroupsOutput, bool) bool, ...request.Option) error

	ListModelBiasJobDefinitions(*sagemaker.ListModelBiasJobDefinitionsInput) (*sagemaker.ListModelBiasJobDefinitionsOutput, error)
	ListModelBiasJobDefinitionsWithContext(aws.Context, *sagemaker.ListModelBiasJobDefinitionsInput, ...request.Option) (*sagemaker.ListModelBiasJobDefinitionsOutput, error)
	ListModelBiasJobDefinitionsRequest(*sagemaker.ListModelBiasJobDefinitionsInput) (*request.Request, *sagemaker.ListModelBiasJobDefinitionsOutput)

	ListModelBiasJobDefinitionsPages(*sagemaker.ListModelBiasJobDefinitionsInput, func(*sagemaker.ListModelBiasJobDefinitionsOutput, bool) bool) error
	ListModelBiasJobDefinitionsPagesWithContext(aws.Context, *sagemaker.ListModelBiasJobDefinitionsInput, func(*sagemaker.ListModelBiasJobDefinitionsOutput, bool) bool, ...request.Option) error

	ListModelCardExportJobs(*sagemaker.ListModelCardExportJobsInput) (*sagemaker.ListModelCardExportJobsOutput, error)
	ListModelCardExportJobsWithContext(aws.Context, *sagemaker.ListModelCardExportJobsInput, ...request.Option) (*sagemaker.ListModelCardExportJobsOutput, error)
	ListModelCardExportJobsRequest(*sagemaker.ListModelCardExportJobsInput) (*request.Request, *sagemaker.ListModelCardExportJobsOutput)

	ListModelCardExportJobsPages(*sagemaker.ListModelCardExportJobsInput, func(*sagemaker.ListModelCardExportJobsOutput, bool) bool) error
	ListModelCardExportJobsPagesWithContext(aws.Context, *sagemaker.ListModelCardExportJobsInput, func(*sagemaker.ListModelCardExportJobsOutput, bool) bool, ...request.Option) error

	ListModelCardVersions(*sagemaker.ListModelCardVersionsInput) (*sagemaker.ListModelCardVersionsOutput, error)
	ListModelCardVersionsWithContext(aws.Context, *sagemaker.ListModelCardVersionsInput, ...request.Option) (*sagemaker.ListModelCardVersionsOutput, error)
	ListModelCardVersionsRequest(*sagemaker.ListModelCardVersionsInput) (*request.Request, *sagemaker.ListModelCardVersionsOutput)

	ListModelCardVersionsPages(*sagemaker.ListModelCardVersionsInput, func(*sagemaker.ListModelCardVersionsOutput, bool) bool) error
	ListModelCardVersionsPagesWithContext(aws.Context, *sagemaker.ListModelCardVersionsInput, func(*sagemaker.ListModelCardVersionsOutput, bool) bool, ...request.Option) error

	ListModelCards(*sagemaker.ListModelCardsInput) (*sagemaker.ListModelCardsOutput, error)
	ListModelCardsWithContext(aws.Context, *sagemaker.ListModelCardsInput, ...request.Option) (*sagemaker.ListModelCardsOutput, error)
	ListModelCardsRequest(*sagemaker.ListModelCardsInput) (*request.Request, *sagemaker.ListModelCardsOutput)

	ListModelCardsPages(*sagemaker.ListModelCardsInput, func(*sagemaker.ListModelCardsOutput, bool) bool) error
	ListModelCardsPagesWithContext(aws.Context, *sagemaker.ListModelCardsInput, func(*sagemaker.ListModelCardsOutput, bool) bool, ...request.Option) error

	ListModelExplainabilityJobDefinitions(*sagemaker.ListModelExplainabilityJobDefinitionsInput) (*sagemaker.ListModelExplainabilityJobDefinitionsOutput, error)
	ListModelExplainabilityJobDefinitionsWithContext(aws.Context, *sagemaker.ListModelExplainabilityJobDefinitionsInput, ...request.Option) (*sagemaker.ListModelExplainabilityJobDefinitionsOutput, error)
	ListModelExplainabilityJobDefinitionsRequest(*sagemaker.ListModelExplainabilityJobDefinitionsInput) (*request.Request, *sagemaker.ListModelExplainabilityJobDefinitionsOutput)

	ListModelExplainabilityJobDefinitionsPages(*sagemaker.ListModelExplainabilityJobDefinitionsInput, func(*sagemaker.ListModelExplainabilityJobDefinitionsOutput, bool) bool) error
	ListModelExplainabilityJobDefinitionsPagesWithContext(aws.Context, *sagemaker.ListModelExplainabilityJobDefinitionsInput, func(*sagemaker.ListModelExplainabilityJobDefinitionsOutput, bool) bool, ...request.Option) error

	ListModelMetadata(*sagemaker.ListModelMetadataInput) (*sagemaker.ListModelMetadataOutput, error)
	ListModelMetadataWithContext(aws.Context, *sagemaker.ListModelMetadataInput, ...request.Option) (*sagemaker.ListModelMetadataOutput, error)
	ListModelMetadataRequest(*sagemaker.ListModelMetadataInput) (*request.Request, *sagemaker.ListModelMetadataOutput)

	ListModelMetadataPages(*sagemaker.ListModelMetadataInput, func(*sagemaker.ListModelMetadataOutput, bool) bool) error
	ListModelMetadataPagesWithContext(aws.Context, *sagemaker.ListModelMetadataInput, func(*sagemaker.ListModelMetadataOutput, bool) bool, ...request.Option) error

	ListModelPackageGroups(*sagemaker.ListModelPackageGroupsInput) (*sagemaker.ListModelPackageGroupsOutput, error)
	ListModelPackageGroupsWithContext(aws.Context, *sagemaker.ListModelPackageGroupsInput, ...request.Option) (*sagemaker.ListModelPackageGroupsOutput, error)
	ListModelPackageGroupsRequest(*sagemaker.ListModelPackageGroupsInput) (*request.Request, *sagemaker.ListModelPackageGroupsOutput)

	ListModelPackageGroupsPages(*sagemaker.ListModelPackageGroupsInput, func(*sagemaker.ListModelPackageGroupsOutput, bool) bool) error
	ListModelPackageGroupsPagesWithContext(aws.Context, *sagemaker.ListModelPackageGroupsInput, func(*sagemaker.ListModelPackageGroupsOutput, bool) bool, ...request.Option) error

	ListModelPackages(*sagemaker.ListModelPackagesInput) (*sagemaker.ListModelPackagesOutput, error)
	ListModelPackagesWithContext(aws.Context, *sagemaker.ListModelPackagesInput, ...request.Option) (*sagemaker.ListModelPackagesOutput, error)
	ListModelPackagesRequest(*sagemaker.ListModelPackagesInput) (*request.Request, *sagemaker.ListModelPackagesOutput)

	ListModelPackagesPages(*sagemaker.ListModelPackagesInput, func(*sagemaker.ListModelPackagesOutput, bool) bool) error
	ListModelPackagesPagesWithContext(aws.Context, *sagemaker.ListModelPackagesInput, func(*sagemaker.ListModelPackagesOutput, bool) bool, ...request.Option) error

	ListModelQualityJobDefinitions(*sagemaker.ListModelQualityJobDefinitionsInput) (*sagemaker.ListModelQualityJobDefinitionsOutput, error)
	ListModelQualityJobDefinitionsWithContext(aws.Context, *sagemaker.ListModelQualityJobDefinitionsInput, ...request.Option) (*sagemaker.ListModelQualityJobDefinitionsOutput, error)
	ListModelQualityJobDefinitionsRequest(*sagemaker.ListModelQualityJobDefinitionsInput) (*request.Request, *sagemaker.ListModelQualityJobDefinitionsOutput)

	ListModelQualityJobDefinitionsPages(*sagemaker.ListModelQualityJobDefinitionsInput, func(*sagemaker.ListModelQualityJobDefinitionsOutput, bool) bool) error
	ListModelQualityJobDefinitionsPagesWithContext(aws.Context, *sagemaker.ListModelQualityJobDefinitionsInput, func(*sagemaker.ListModelQualityJobDefinitionsOutput, bool) bool, ...request.Option) error

	ListModels(*sagemaker.ListModelsInput) (*sagemaker.ListModelsOutput, error)
	ListModelsWithContext(aws.Context, *sagemaker.ListModelsInput, ...request.Option) (*sagemaker.ListModelsOutput, error)
	ListModelsRequest(*sagemaker.ListModelsInput) (*request.Request, *sagemaker.ListModelsOutput)

	ListModelsPages(*sagemaker.ListModelsInput, func(*sagemaker.ListModelsOutput, bool) bool) error
	ListModelsPagesWithContext(aws.Context, *sagemaker.ListModelsInput, func(*sagemaker.ListModelsOutput, bool) bool, ...request.Option) error

	ListMonitoringAlertHistory(*sagemaker.ListMonitoringAlertHistoryInput) (*sagemaker.ListMonitoringAlertHistoryOutput, error)
	ListMonitoringAlertHistoryWithContext(aws.Context, *sagemaker.ListMonitoringAlertHistoryInput, ...request.Option) (*sagemaker.ListMonitoringAlertHistoryOutput, error)
	ListMonitoringAlertHistoryRequest(*sagemaker.ListMonitoringAlertHistoryInput) (*request.Request, *sagemaker.ListMonitoringAlertHistoryOutput)

	ListMonitoringAlertHistoryPages(*sagemaker.ListMonitoringAlertHistoryInput, func(*sagemaker.ListMonitoringAlertHistoryOutput, bool) bool) error
	ListMonitoringAlertHistoryPagesWithContext(aws.Context, *sagemaker.ListMonitoringAlertHistoryInput, func(*sagemaker.ListMonitoringAlertHistoryOutput, bool) bool, ...request.Option) error

	ListMonitoringAlerts(*sagemaker.ListMonitoringAlertsInput) (*sagemaker.ListMonitoringAlertsOutput, error)
	ListMonitoringAlertsWithContext(aws.Context, *sagemaker.ListMonitoringAlertsInput, ...request.Option) (*sagemaker.ListMonitoringAlertsOutput, error)
	ListMonitoringAlertsRequest(*sagemaker.ListMonitoringAlertsInput) (*request.Request, *sagemaker.ListMonitoringAlertsOutput)

	ListMonitoringAlertsPages(*sagemaker.ListMonitoringAlertsInput, func(*sagemaker.ListMonitoringAlertsOutput, bool) bool) error
	ListMonitoringAlertsPagesWithContext(aws.Context, *sagemaker.ListMonitoringAlertsInput, func(*sagemaker.ListMonitoringAlertsOutput, bool) bool, ...request.Option) error

	ListMonitoringExecutions(*sagemaker.ListMonitoringExecutionsInput) (*sagemaker.ListMonitoringExecutionsOutput, error)
	ListMonitoringExecutionsWithContext(aws.Context, *sagemaker.ListMonitoringExecutionsInput, ...request.Option) (*sagemaker.ListMonitoringExecutionsOutput, error)
	ListMonitoringExecutionsRequest(*sagemaker.ListMonitoringExecutionsInput) (*request.Request, *sagemaker.ListMonitoringExecutionsOutput)

	ListMonitoringExecutionsPages(*sagemaker.ListMonitoringExecutionsInput, func(*sagemaker.ListMonitoringExecutionsOutput, bool) bool) error
	ListMonitoringExecutionsPagesWithContext(aws.Context, *sagemaker.ListMonitoringExecutionsInput, func(*sagemaker.ListMonitoringExecutionsOutput, bool) bool, ...request.Option) error

	ListMonitoringSchedules(*sagemaker.ListMonitoringSchedulesInput) (*sagemaker.ListMonitoringSchedulesOutput, error)
	ListMonitoringSchedulesWithContext(aws.Context, *sagemaker.ListMonitoringSchedulesInput, ...request.Option) (*sagemaker.ListMonitoringSchedulesOutput, error)
	ListMonitoringSchedulesRequest(*sagemaker.ListMonitoringSchedulesInput) (*request.Request, *sagemaker.ListMonitoringSchedulesOutput)

	ListMonitoringSchedulesPages(*sagemaker.ListMonitoringSchedulesInput, func(*sagemaker.ListMonitoringSchedulesOutput, bool) bool) error
	ListMonitoringSchedulesPagesWithContext(aws.Context, *sagemaker.ListMonitoringSchedulesInput, func(*sagemaker.ListMonitoringSchedulesOutput, bool) bool, ...request.Option) error

	ListNotebookInstanceLifecycleConfigs(*sagemaker.ListNotebookInstanceLifecycleConfigsInput) (*sagemaker.ListNotebookInstanceLifecycleConfigsOutput, error)
	ListNotebookInstanceLifecycleConfigsWithContext(aws.Context, *sagemaker.ListNotebookInstanceLifecycleConfigsInput, ...request.Option) (*sagemaker.ListNotebookInstanceLifecycleConfigsOutput, error)
	ListNotebookInstanceLifecycleConfigsRequest(*sagemaker.ListNotebookInstanceLifecycleConfigsInput) (*request.Request, *sagemaker.ListNotebookInstanceLifecycleConfigsOutput)

	ListNotebookInstanceLifecycleConfigsPages(*sagemaker.ListNotebookInstanceLifecycleConfigsInput, func(*sagemaker.ListNotebookInstanceLifecycleConfigsOutput, bool) bool) error
	ListNotebookInstanceLifecycleConfigsPagesWithContext(aws.Context, *sagemaker.ListNotebookInstanceLifecycleConfigsInput, func(*sagemaker.ListNotebookInstanceLifecycleConfigsOutput, bool) bool, ...request.Option) error

	ListNotebookInstances(*sagemaker.ListNotebookInstancesInput) (*sagemaker.ListNotebookInstancesOutput, error)
	ListNotebookInstancesWithContext(aws.Context, *sagemaker.ListNotebookInstancesInput, ...request.Option) (*sagemaker.ListNotebookInstancesOutput, error)
	ListNotebookInstancesRequest(*sagemaker.ListNotebookInstancesInput) (*request.Request, *sagemaker.ListNotebookInstancesOutput)

	ListNotebookInstancesPages(*sagemaker.ListNotebookInstancesInput, func(*sagemaker.ListNotebookInstancesOutput, bool) bool) error
	ListNotebookInstancesPagesWithContext(aws.Context, *sagemaker.ListNotebookInstancesInput, func(*sagemaker.ListNotebookInstancesOutput, bool) bool, ...request.Option) error

	ListPipelineExecutionSteps(*sagemaker.ListPipelineExecutionStepsInput) (*sagemaker.ListPipelineExecutionStepsOutput, error)
	ListPipelineExecutionStepsWithContext(aws.Context, *sagemaker.ListPipelineExecutionStepsInput, ...request.Option) (*sagemaker.ListPipelineExecutionStepsOutput, error)
	ListPipelineExecutionStepsRequest(*sagemaker.ListPipelineExecutionStepsInput) (*request.Request, *sagemaker.ListPipelineExecutionStepsOutput)

	ListPipelineExecutionStepsPages(*sagemaker.ListPipelineExecutionStepsInput, func(*sagemaker.ListPipelineExecutionStepsOutput, bool) bool) error
	ListPipelineExecutionStepsPagesWithContext(aws.Context, *sagemaker.ListPipelineExecutionStepsInput, func(*sagemaker.ListPipelineExecutionStepsOutput, bool) bool, ...request.Option) error

	ListPipelineExecutions(*sagemaker.ListPipelineExecutionsInput) (*sagemaker.ListPipelineExecutionsOutput, error)
	ListPipelineExecutionsWithContext(aws.Context, *sagemaker.ListPipelineExecutionsInput, ...request.Option) (*sagemaker.ListPipelineExecutionsOutput, error)
	ListPipelineExecutionsRequest(*sagemaker.ListPipelineExecutionsInput) (*request.Request, *sagemaker.ListPipelineExecutionsOutput)

	ListPipelineExecutionsPages(*sagemaker.ListPipelineExecutionsInput, func(*sagemaker.ListPipelineExecutionsOutput, bool) bool) error
	ListPipelineExecutionsPagesWithContext(aws.Context, *sagemaker.ListPipelineExecutionsInput, func(*sagemaker.ListPipelineExecutionsOutput, bool) bool, ...request.Option) error

	ListPipelineParametersForExecution(*sagemaker.ListPipelineParametersForExecutionInput) (*sagemaker.ListPipelineParametersForExecutionOutput, error)
	ListPipelineParametersForExecutionWithContext(aws.Context, *sagemaker.ListPipelineParametersForExecutionInput, ...request.Option) (*sagemaker.ListPipelineParametersForExecutionOutput, error)
	ListPipelineParametersForExecutionRequest(*sagemaker.ListPipelineParametersForExecutionInput) (*request.Request, *sagemaker.ListPipelineParametersForExecutionOutput)

	ListPipelineParametersForExecutionPages(*sagemaker.ListPipelineParametersForExecutionInput, func(*sagemaker.ListPipelineParametersForExecutionOutput, bool) bool) error
	ListPipelineParametersForExecutionPagesWithContext(aws.Context, *sagemaker.ListPipelineParametersForExecutionInput, func(*sagemaker.ListPipelineParametersForExecutionOutput, bool) bool, ...request.Option) error

	ListPipelines(*sagemaker.ListPipelinesInput) (*sagemaker.ListPipelinesOutput, error)
	ListPipelinesWithContext(aws.Context, *sagemaker.ListPipelinesInput, ...request.Option) (*sagemaker.ListPipelinesOutput, error)
	ListPipelinesRequest(*sagemaker.ListPipelinesInput) (*request.Request, *sagemaker.ListPipelinesOutput)

	ListPipelinesPages(*sagemaker.ListPipelinesInput, func(*sagemaker.ListPipelinesOutput, bool) bool) error
	ListPipelinesPagesWithContext(aws.Context, *sagemaker.ListPipelinesInput, func(*sagemaker.ListPipelinesOutput, bool) bool, ...request.Option) error

	ListProcessingJobs(*sagemaker.ListProcessingJobsInput) (*sagemaker.ListProcessingJobsOutput, error)
	ListProcessingJobsWithContext(aws.Context, *sagemaker.ListProcessingJobsInput, ...request.Option) (*sagemaker.ListProcessingJobsOutput, error)
	ListProcessingJobsRequest(*sagemaker.ListProcessingJobsInput) (*request.Request, *sagemaker.ListProcessingJobsOutput)

	ListProcessingJobsPages(*sagemaker.ListProcessingJobsInput, func(*sagemaker.ListProcessingJobsOutput, bool) bool) error
	ListProcessingJobsPagesWithContext(aws.Context, *sagemaker.ListProcessingJobsInput, func(*sagemaker.ListProcessingJobsOutput, bool) bool, ...request.Option) error

	ListProjects(*sagemaker.ListProjectsInput) (*sagemaker.ListProjectsOutput, error)
	ListProjectsWithContext(aws.Context, *sagemaker.ListProjectsInput, ...request.Option) (*sagemaker.ListProjectsOutput, error)
	ListProjectsRequest(*sagemaker.ListProjectsInput) (*request.Request, *sagemaker.ListProjectsOutput)

	ListProjectsPages(*sagemaker.ListProjectsInput, func(*sagemaker.ListProjectsOutput, bool) bool) error
	ListProjectsPagesWithContext(aws.Context, *sagemaker.ListProjectsInput, func(*sagemaker.ListProjectsOutput, bool) bool, ...request.Option) error

	ListResourceCatalogs(*sagemaker.ListResourceCatalogsInput) (*sagemaker.ListResourceCatalogsOutput, error)
	ListResourceCatalogsWithContext(aws.Context, *sagemaker.ListResourceCatalogsInput, ...request.Option) (*sagemaker.ListResourceCatalogsOutput, error)
	ListResourceCatalogsRequest(*sagemaker.ListResourceCatalogsInput) (*request.Request, *sagemaker.ListResourceCatalogsOutput)

	ListResourceCatalogsPages(*sagemaker.ListResourceCatalogsInput, func(*sagemaker.ListResourceCatalogsOutput, bool) bool) error
	ListResourceCatalogsPagesWithContext(aws.Context, *sagemaker.ListResourceCatalogsInput, func(*sagemaker.ListResourceCatalogsOutput, bool) bool, ...request.Option) error

	ListSpaces(*sagemaker.ListSpacesInput) (*sagemaker.ListSpacesOutput, error)
	ListSpacesWithContext(aws.Context, *sagemaker.ListSpacesInput, ...request.Option) (*sagemaker.ListSpacesOutput, error)
	ListSpacesRequest(*sagemaker.ListSpacesInput) (*request.Request, *sagemaker.ListSpacesOutput)

	ListSpacesPages(*sagemaker.ListSpacesInput, func(*sagemaker.ListSpacesOutput, bool) bool) error
	ListSpacesPagesWithContext(aws.Context, *sagemaker.ListSpacesInput, func(*sagemaker.ListSpacesOutput, bool) bool, ...request.Option) error

	ListStageDevices(*sagemaker.ListStageDevicesInput) (*sagemaker.ListStageDevicesOutput, error)
	ListStageDevicesWithContext(aws.Context, *sagemaker.ListStageDevicesInput, ...request.Option) (*sagemaker.ListStageDevicesOutput, error)
	ListStageDevicesRequest(*sagemaker.ListStageDevicesInput) (*request.Request, *sagemaker.ListStageDevicesOutput)

	ListStageDevicesPages(*sagemaker.ListStageDevicesInput, func(*sagemaker.ListStageDevicesOutput, bool) bool) error
	ListStageDevicesPagesWithContext(aws.Context, *sagemaker.ListStageDevicesInput, func(*sagemaker.ListStageDevicesOutput, bool) bool, ...request.Option) error

	ListStudioLifecycleConfigs(*sagemaker.ListStudioLifecycleConfigsInput) (*sagemaker.ListStudioLifecycleConfigsOutput, error)
	ListStudioLifecycleConfigsWithContext(aws.Context, *sagemaker.ListStudioLifecycleConfigsInput, ...request.Option) (*sagemaker.ListStudioLifecycleConfigsOutput, error)
	ListStudioLifecycleConfigsRequest(*sagemaker.ListStudioLifecycleConfigsInput) (*request.Request, *sagemaker.ListStudioLifecycleConfigsOutput)

	ListStudioLifecycleConfigsPages(*sagemaker.ListStudioLifecycleConfigsInput, func(*sagemaker.ListStudioLifecycleConfigsOutput, bool) bool) error
	ListStudioLifecycleConfigsPagesWithContext(aws.Context, *sagemaker.ListStudioLifecycleConfigsInput, func(*sagemaker.ListStudioLifecycleConfigsOutput, bool) bool, ...request.Option) error

	ListSubscribedWorkteams(*sagemaker.ListSubscribedWorkteamsInput) (*sagemaker.ListSubscribedWorkteamsOutput, error)
	ListSubscribedWorkteamsWithContext(aws.Context, *sagemaker.ListSubscribedWorkteamsInput, ...request.Option) (*sagemaker.ListSubscribedWorkteamsOutput, error)
	ListSubscribedWorkteamsRequest(*sagemaker.ListSubscribedWorkteamsInput) (*request.Request, *sagemaker.ListSubscribedWorkteamsOutput)

	ListSubscribedWorkteamsPages(*sagemaker.ListSubscribedWorkteamsInput, func(*sagemaker.ListSubscribedWorkteamsOutput, bool) bool) error
	ListSubscribedWorkteamsPagesWithContext(aws.Context, *sagemaker.ListSubscribedWorkteamsInput, func(*sagemaker.ListSubscribedWorkteamsOutput, bool) bool, ...request.Option) error

	ListTags(*sagemaker.ListTagsInput) (*sagemaker.ListTagsOutput, error)
	ListTagsWithContext(aws.Context, *sagemaker.ListTagsInput, ...request.Option) (*sagemaker.ListTagsOutput, error)
	ListTagsRequest(*sagemaker.ListTagsInput) (*request.Request, *sagemaker.ListTagsOutput)

	ListTagsPages(*sagemaker.ListTagsInput, func(*sagemaker.ListTagsOutput, bool) bool) error
	ListTagsPagesWithContext(aws.Context, *sagemaker.ListTagsInput, func(*sagemaker.ListTagsOutput, bool) bool, ...request.Option) error

	ListTrainingJobs(*sagemaker.ListTrainingJobsInput) (*sagemaker.ListTrainingJobsOutput, error)
	ListTrainingJobsWithContext(aws.Context, *sagemaker.ListTrainingJobsInput, ...request.Option) (*sagemaker.ListTrainingJobsOutput, error)
	ListTrainingJobsRequest(*sagemaker.ListTrainingJobsInput) (*request.Request, *sagemaker.ListTrainingJobsOutput)

	ListTrainingJobsPages(*sagemaker.ListTrainingJobsInput, func(*sagemaker.ListTrainingJobsOutput, bool) bool) error
	ListTrainingJobsPagesWithContext(aws.Context, *sagemaker.ListTrainingJobsInput, func(*sagemaker.ListTrainingJobsOutput, bool) bool, ...request.Option) error

	ListTrainingJobsForHyperParameterTuningJob(*sagemaker.ListTrainingJobsForHyperParameterTuningJobInput) (*sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput, error)
	ListTrainingJobsForHyperParameterTuningJobWithContext(aws.Context, *sagemaker.ListTrainingJobsForHyperParameterTuningJobInput, ...request.Option) (*sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput, error)
	ListTrainingJobsForHyperParameterTuningJobRequest(*sagemaker.ListTrainingJobsForHyperParameterTuningJobInput) (*request.Request, *sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput)

	ListTrainingJobsForHyperParameterTuningJobPages(*sagemaker.ListTrainingJobsForHyperParameterTuningJobInput, func(*sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput, bool) bool) error
	ListTrainingJobsForHyperParameterTuningJobPagesWithContext(aws.Context, *sagemaker.ListTrainingJobsForHyperParameterTuningJobInput, func(*sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput, bool) bool, ...request.Option) error

	ListTransformJobs(*sagemaker.ListTransformJobsInput) (*sagemaker.ListTransformJobsOutput, error)
	ListTransformJobsWithContext(aws.Context, *sagemaker.ListTransformJobsInput, ...request.Option) (*sagemaker.ListTransformJobsOutput, error)
	ListTransformJobsRequest(*sagemaker.ListTransformJobsInput) (*request.Request, *sagemaker.ListTransformJobsOutput)

	ListTransformJobsPages(*sagemaker.ListTransformJobsInput, func(*sagemaker.ListTransformJobsOutput, bool) bool) error
	ListTransformJobsPagesWithContext(aws.Context, *sagemaker.ListTransformJobsInput, func(*sagemaker.ListTransformJobsOutput, bool) bool, ...request.Option) error

	ListTrialComponents(*sagemaker.ListTrialComponentsInput) (*sagemaker.ListTrialComponentsOutput, error)
	ListTrialComponentsWithContext(aws.Context, *sagemaker.ListTrialComponentsInput, ...request.Option) (*sagemaker.ListTrialComponentsOutput, error)
	ListTrialComponentsRequest(*sagemaker.ListTrialComponentsInput) (*request.Request, *sagemaker.ListTrialComponentsOutput)

	ListTrialComponentsPages(*sagemaker.ListTrialComponentsInput, func(*sagemaker.ListTrialComponentsOutput, bool) bool) error
	ListTrialComponentsPagesWithContext(aws.Context, *sagemaker.ListTrialComponentsInput, func(*sagemaker.ListTrialComponentsOutput, bool) bool, ...request.Option) error

	ListTrials(*sagemaker.ListTrialsInput) (*sagemaker.ListTrialsOutput, error)
	ListTrialsWithContext(aws.Context, *sagemaker.ListTrialsInput, ...request.Option) (*sagemaker.ListTrialsOutput, error)
	ListTrialsRequest(*sagemaker.ListTrialsInput) (*request.Request, *sagemaker.ListTrialsOutput)

	ListTrialsPages(*sagemaker.ListTrialsInput, func(*sagemaker.ListTrialsOutput, bool) bool) error
	ListTrialsPagesWithContext(aws.Context, *sagemaker.ListTrialsInput, func(*sagemaker.ListTrialsOutput, bool) bool, ...request.Option) error

	ListUserProfiles(*sagemaker.ListUserProfilesInput) (*sagemaker.ListUserProfilesOutput, error)
	ListUserProfilesWithContext(aws.Context, *sagemaker.ListUserProfilesInput, ...request.Option) (*sagemaker.ListUserProfilesOutput, error)
	ListUserProfilesRequest(*sagemaker.ListUserProfilesInput) (*request.Request, *sagemaker.ListUserProfilesOutput)

	ListUserProfilesPages(*sagemaker.ListUserProfilesInput, func(*sagemaker.ListUserProfilesOutput, bool) bool) error
	ListUserProfilesPagesWithContext(aws.Context, *sagemaker.ListUserProfilesInput, func(*sagemaker.ListUserProfilesOutput, bool) bool, ...request.Option) error

	ListWorkforces(*sagemaker.ListWorkforcesInput) (*sagemaker.ListWorkforcesOutput, error)
	ListWorkforcesWithContext(aws.Context, *sagemaker.ListWorkforcesInput, ...request.Option) (*sagemaker.ListWorkforcesOutput, error)
	ListWorkforcesRequest(*sagemaker.ListWorkforcesInput) (*request.Request, *sagemaker.ListWorkforcesOutput)

	ListWorkforcesPages(*sagemaker.ListWorkforcesInput, func(*sagemaker.ListWorkforcesOutput, bool) bool) error
	ListWorkforcesPagesWithContext(aws.Context, *sagemaker.ListWorkforcesInput, func(*sagemaker.ListWorkforcesOutput, bool) bool, ...request.Option) error

	ListWorkteams(*sagemaker.ListWorkteamsInput) (*sagemaker.ListWorkteamsOutput, error)
	ListWorkteamsWithContext(aws.Context, *sagemaker.ListWorkteamsInput, ...request.Option) (*sagemaker.ListWorkteamsOutput, error)
	ListWorkteamsRequest(*sagemaker.ListWorkteamsInput) (*request.Request, *sagemaker.ListWorkteamsOutput)

	ListWorkteamsPages(*sagemaker.ListWorkteamsInput, func(*sagemaker.ListWorkteamsOutput, bool) bool) error
	ListWorkteamsPagesWithContext(aws.Context, *sagemaker.ListWorkteamsInput, func(*sagemaker.ListWorkteamsOutput, bool) bool, ...request.Option) error

	PutModelPackageGroupPolicy(*sagemaker.PutModelPackageGroupPolicyInput) (*sagemaker.PutModelPackageGroupPolicyOutput, error)
	PutModelPackageGroupPolicyWithContext(aws.Context, *sagemaker.PutModelPackageGroupPolicyInput, ...request.Option) (*sagemaker.PutModelPackageGroupPolicyOutput, error)
	PutModelPackageGroupPolicyRequest(*sagemaker.PutModelPackageGroupPolicyInput) (*request.Request, *sagemaker.PutModelPackageGroupPolicyOutput)

	QueryLineage(*sagemaker.QueryLineageInput) (*sagemaker.QueryLineageOutput, error)
	QueryLineageWithContext(aws.Context, *sagemaker.QueryLineageInput, ...request.Option) (*sagemaker.QueryLineageOutput, error)
	QueryLineageRequest(*sagemaker.QueryLineageInput) (*request.Request, *sagemaker.QueryLineageOutput)

	QueryLineagePages(*sagemaker.QueryLineageInput, func(*sagemaker.QueryLineageOutput, bool) bool) error
	QueryLineagePagesWithContext(aws.Context, *sagemaker.QueryLineageInput, func(*sagemaker.QueryLineageOutput, bool) bool, ...request.Option) error

	RegisterDevices(*sagemaker.RegisterDevicesInput) (*sagemaker.RegisterDevicesOutput, error)
	RegisterDevicesWithContext(aws.Context, *sagemaker.RegisterDevicesInput, ...request.Option) (*sagemaker.RegisterDevicesOutput, error)
	RegisterDevicesRequest(*sagemaker.RegisterDevicesInput) (*request.Request, *sagemaker.RegisterDevicesOutput)

	RenderUiTemplate(*sagemaker.RenderUiTemplateInput) (*sagemaker.RenderUiTemplateOutput, error)
	RenderUiTemplateWithContext(aws.Context, *sagemaker.RenderUiTemplateInput, ...request.Option) (*sagemaker.RenderUiTemplateOutput, error)
	RenderUiTemplateRequest(*sagemaker.RenderUiTemplateInput) (*request.Request, *sagemaker.RenderUiTemplateOutput)

	RetryPipelineExecution(*sagemaker.RetryPipelineExecutionInput) (*sagemaker.RetryPipelineExecutionOutput, error)
	RetryPipelineExecutionWithContext(aws.Context, *sagemaker.RetryPipelineExecutionInput, ...request.Option) (*sagemaker.RetryPipelineExecutionOutput, error)
	RetryPipelineExecutionRequest(*sagemaker.RetryPipelineExecutionInput) (*request.Request, *sagemaker.RetryPipelineExecutionOutput)

	Search(*sagemaker.SearchInput) (*sagemaker.SearchOutput, error)
	SearchWithContext(aws.Context, *sagemaker.SearchInput, ...request.Option) (*sagemaker.SearchOutput, error)
	SearchRequest(*sagemaker.SearchInput) (*request.Request, *sagemaker.SearchOutput)

	SearchPages(*sagemaker.SearchInput, func(*sagemaker.SearchOutput, bool) bool) error
	SearchPagesWithContext(aws.Context, *sagemaker.SearchInput, func(*sagemaker.SearchOutput, bool) bool, ...request.Option) error

	SendPipelineExecutionStepFailure(*sagemaker.SendPipelineExecutionStepFailureInput) (*sagemaker.SendPipelineExecutionStepFailureOutput, error)
	SendPipelineExecutionStepFailureWithContext(aws.Context, *sagemaker.SendPipelineExecutionStepFailureInput, ...request.Option) (*sagemaker.SendPipelineExecutionStepFailureOutput, error)
	SendPipelineExecutionStepFailureRequest(*sagemaker.SendPipelineExecutionStepFailureInput) (*request.Request, *sagemaker.SendPipelineExecutionStepFailureOutput)

	SendPipelineExecutionStepSuccess(*sagemaker.SendPipelineExecutionStepSuccessInput) (*sagemaker.SendPipelineExecutionStepSuccessOutput, error)
	SendPipelineExecutionStepSuccessWithContext(aws.Context, *sagemaker.SendPipelineExecutionStepSuccessInput, ...request.Option) (*sagemaker.SendPipelineExecutionStepSuccessOutput, error)
	SendPipelineExecutionStepSuccessRequest(*sagemaker.SendPipelineExecutionStepSuccessInput) (*request.Request, *sagemaker.SendPipelineExecutionStepSuccessOutput)

	StartEdgeDeploymentStage(*sagemaker.StartEdgeDeploymentStageInput) (*sagemaker.StartEdgeDeploymentStageOutput, error)
	StartEdgeDeploymentStageWithContext(aws.Context, *sagemaker.StartEdgeDeploymentStageInput, ...request.Option) (*sagemaker.StartEdgeDeploymentStageOutput, error)
	StartEdgeDeploymentStageRequest(*sagemaker.StartEdgeDeploymentStageInput) (*request.Request, *sagemaker.StartEdgeDeploymentStageOutput)

	StartInferenceExperiment(*sagemaker.StartInferenceExperimentInput) (*sagemaker.StartInferenceExperimentOutput, error)
	StartInferenceExperimentWithContext(aws.Context, *sagemaker.StartInferenceExperimentInput, ...request.Option) (*sagemaker.StartInferenceExperimentOutput, error)
	StartInferenceExperimentRequest(*sagemaker.StartInferenceExperimentInput) (*request.Request, *sagemaker.StartInferenceExperimentOutput)

	StartMonitoringSchedule(*sagemaker.StartMonitoringScheduleInput) (*sagemaker.StartMonitoringScheduleOutput, error)
	StartMonitoringScheduleWithContext(aws.Context, *sagemaker.StartMonitoringScheduleInput, ...request.Option) (*sagemaker.StartMonitoringScheduleOutput, error)
	StartMonitoringScheduleRequest(*sagemaker.StartMonitoringScheduleInput) (*request.Request, *sagemaker.StartMonitoringScheduleOutput)

	StartNotebookInstance(*sagemaker.StartNotebookInstanceInput) (*sagemaker.StartNotebookInstanceOutput, error)
	StartNotebookInstanceWithContext(aws.Context, *sagemaker.StartNotebookInstanceInput, ...request.Option) (*sagemaker.StartNotebookInstanceOutput, error)
	StartNotebookInstanceRequest(*sagemaker.StartNotebookInstanceInput) (*request.Request, *sagemaker.StartNotebookInstanceOutput)

	StartPipelineExecution(*sagemaker.StartPipelineExecutionInput) (*sagemaker.StartPipelineExecutionOutput, error)
	StartPipelineExecutionWithContext(aws.Context, *sagemaker.StartPipelineExecutionInput, ...request.Option) (*sagemaker.StartPipelineExecutionOutput, error)
	StartPipelineExecutionRequest(*sagemaker.StartPipelineExecutionInput) (*request.Request, *sagemaker.StartPipelineExecutionOutput)

	StopAutoMLJob(*sagemaker.StopAutoMLJobInput) (*sagemaker.StopAutoMLJobOutput, error)
	StopAutoMLJobWithContext(aws.Context, *sagemaker.StopAutoMLJobInput, ...request.Option) (*sagemaker.StopAutoMLJobOutput, error)
	StopAutoMLJobRequest(*sagemaker.StopAutoMLJobInput) (*request.Request, *sagemaker.StopAutoMLJobOutput)

	StopCompilationJob(*sagemaker.StopCompilationJobInput) (*sagemaker.StopCompilationJobOutput, error)
	StopCompilationJobWithContext(aws.Context, *sagemaker.StopCompilationJobInput, ...request.Option) (*sagemaker.StopCompilationJobOutput, error)
	StopCompilationJobRequest(*sagemaker.StopCompilationJobInput) (*request.Request, *sagemaker.StopCompilationJobOutput)

	StopEdgeDeploymentStage(*sagemaker.StopEdgeDeploymentStageInput) (*sagemaker.StopEdgeDeploymentStageOutput, error)
	StopEdgeDeploymentStageWithContext(aws.Context, *sagemaker.StopEdgeDeploymentStageInput, ...request.Option) (*sagemaker.StopEdgeDeploymentStageOutput, error)
	StopEdgeDeploymentStageRequest(*sagemaker.StopEdgeDeploymentStageInput) (*request.Request, *sagemaker.StopEdgeDeploymentStageOutput)

	StopEdgePackagingJob(*sagemaker.StopEdgePackagingJobInput) (*sagemaker.StopEdgePackagingJobOutput, error)
	StopEdgePackagingJobWithContext(aws.Context, *sagemaker.StopEdgePackagingJobInput, ...request.Option) (*sagemaker.StopEdgePackagingJobOutput, error)
	StopEdgePackagingJobRequest(*sagemaker.StopEdgePackagingJobInput) (*request.Request, *sagemaker.StopEdgePackagingJobOutput)

	StopHyperParameterTuningJob(*sagemaker.StopHyperParameterTuningJobInput) (*sagemaker.StopHyperParameterTuningJobOutput, error)
	StopHyperParameterTuningJobWithContext(aws.Context, *sagemaker.StopHyperParameterTuningJobInput, ...request.Option) (*sagemaker.StopHyperParameterTuningJobOutput, error)
	StopHyperParameterTuningJobRequest(*sagemaker.StopHyperParameterTuningJobInput) (*request.Request, *sagemaker.StopHyperParameterTuningJobOutput)

	StopInferenceExperiment(*sagemaker.StopInferenceExperimentInput) (*sagemaker.StopInferenceExperimentOutput, error)
	StopInferenceExperimentWithContext(aws.Context, *sagemaker.StopInferenceExperimentInput, ...request.Option) (*sagemaker.StopInferenceExperimentOutput, error)
	StopInferenceExperimentRequest(*sagemaker.StopInferenceExperimentInput) (*request.Request, *sagemaker.StopInferenceExperimentOutput)

	StopInferenceRecommendationsJob(*sagemaker.StopInferenceRecommendationsJobInput) (*sagemaker.StopInferenceRecommendationsJobOutput, error)
	StopInferenceRecommendationsJobWithContext(aws.Context, *sagemaker.StopInferenceRecommendationsJobInput, ...request.Option) (*sagemaker.StopInferenceRecommendationsJobOutput, error)
	StopInferenceRecommendationsJobRequest(*sagemaker.StopInferenceRecommendationsJobInput) (*request.Request, *sagemaker.StopInferenceRecommendationsJobOutput)

	StopLabelingJob(*sagemaker.StopLabelingJobInput) (*sagemaker.StopLabelingJobOutput, error)
	StopLabelingJobWithContext(aws.Context, *sagemaker.StopLabelingJobInput, ...request.Option) (*sagemaker.StopLabelingJobOutput, error)
	StopLabelingJobRequest(*sagemaker.StopLabelingJobInput) (*request.Request, *sagemaker.StopLabelingJobOutput)

	StopMonitoringSchedule(*sagemaker.StopMonitoringScheduleInput) (*sagemaker.StopMonitoringScheduleOutput, error)
	StopMonitoringScheduleWithContext(aws.Context, *sagemaker.StopMonitoringScheduleInput, ...request.Option) (*sagemaker.StopMonitoringScheduleOutput, error)
	StopMonitoringScheduleRequest(*sagemaker.StopMonitoringScheduleInput) (*request.Request, *sagemaker.StopMonitoringScheduleOutput)

	StopNotebookInstance(*sagemaker.StopNotebookInstanceInput) (*sagemaker.StopNotebookInstanceOutput, error)
	StopNotebookInstanceWithContext(aws.Context, *sagemaker.StopNotebookInstanceInput, ...request.Option) (*sagemaker.StopNotebookInstanceOutput, error)
	StopNotebookInstanceRequest(*sagemaker.StopNotebookInstanceInput) (*request.Request, *sagemaker.StopNotebookInstanceOutput)

	StopPipelineExecution(*sagemaker.StopPipelineExecutionInput) (*sagemaker.StopPipelineExecutionOutput, error)
	StopPipelineExecutionWithContext(aws.Context, *sagemaker.StopPipelineExecutionInput, ...request.Option) (*sagemaker.StopPipelineExecutionOutput, error)
	StopPipelineExecutionRequest(*sagemaker.StopPipelineExecutionInput) (*request.Request, *sagemaker.StopPipelineExecutionOutput)

	StopProcessingJob(*sagemaker.StopProcessingJobInput) (*sagemaker.StopProcessingJobOutput, error)
	StopProcessingJobWithContext(aws.Context, *sagemaker.StopProcessingJobInput, ...request.Option) (*sagemaker.StopProcessingJobOutput, error)
	StopProcessingJobRequest(*sagemaker.StopProcessingJobInput) (*request.Request, *sagemaker.StopProcessingJobOutput)

	StopTrainingJob(*sagemaker.StopTrainingJobInput) (*sagemaker.StopTrainingJobOutput, error)
	StopTrainingJobWithContext(aws.Context, *sagemaker.StopTrainingJobInput, ...request.Option) (*sagemaker.StopTrainingJobOutput, error)
	StopTrainingJobRequest(*sagemaker.StopTrainingJobInput) (*request.Request, *sagemaker.StopTrainingJobOutput)

	StopTransformJob(*sagemaker.StopTransformJobInput) (*sagemaker.StopTransformJobOutput, error)
	StopTransformJobWithContext(aws.Context, *sagemaker.StopTransformJobInput, ...request.Option) (*sagemaker.StopTransformJobOutput, error)
	StopTransformJobRequest(*sagemaker.StopTransformJobInput) (*request.Request, *sagemaker.StopTransformJobOutput)

	UpdateAction(*sagemaker.UpdateActionInput) (*sagemaker.UpdateActionOutput, error)
	UpdateActionWithContext(aws.Context, *sagemaker.UpdateActionInput, ...request.Option) (*sagemaker.UpdateActionOutput, error)
	UpdateActionRequest(*sagemaker.UpdateActionInput) (*request.Request, *sagemaker.UpdateActionOutput)

	UpdateAppImageConfig(*sagemaker.UpdateAppImageConfigInput) (*sagemaker.UpdateAppImageConfigOutput, error)
	UpdateAppImageConfigWithContext(aws.Context, *sagemaker.UpdateAppImageConfigInput, ...request.Option) (*sagemaker.UpdateAppImageConfigOutput, error)
	UpdateAppImageConfigRequest(*sagemaker.UpdateAppImageConfigInput) (*request.Request, *sagemaker.UpdateAppImageConfigOutput)

	UpdateArtifact(*sagemaker.UpdateArtifactInput) (*sagemaker.UpdateArtifactOutput, error)
	UpdateArtifactWithContext(aws.Context, *sagemaker.UpdateArtifactInput, ...request.Option) (*sagemaker.UpdateArtifactOutput, error)
	UpdateArtifactRequest(*sagemaker.UpdateArtifactInput) (*request.Request, *sagemaker.UpdateArtifactOutput)

	UpdateCodeRepository(*sagemaker.UpdateCodeRepositoryInput) (*sagemaker.UpdateCodeRepositoryOutput, error)
	UpdateCodeRepositoryWithContext(aws.Context, *sagemaker.UpdateCodeRepositoryInput, ...request.Option) (*sagemaker.UpdateCodeRepositoryOutput, error)
	UpdateCodeRepositoryRequest(*sagemaker.UpdateCodeRepositoryInput) (*request.Request, *sagemaker.UpdateCodeRepositoryOutput)

	UpdateContext(*sagemaker.UpdateContextInput) (*sagemaker.UpdateContextOutput, error)
	UpdateContextWithContext(aws.Context, *sagemaker.UpdateContextInput, ...request.Option) (*sagemaker.UpdateContextOutput, error)
	UpdateContextRequest(*sagemaker.UpdateContextInput) (*request.Request, *sagemaker.UpdateContextOutput)

	UpdateDeviceFleet(*sagemaker.UpdateDeviceFleetInput) (*sagemaker.UpdateDeviceFleetOutput, error)
	UpdateDeviceFleetWithContext(aws.Context, *sagemaker.UpdateDeviceFleetInput, ...request.Option) (*sagemaker.UpdateDeviceFleetOutput, error)
	UpdateDeviceFleetRequest(*sagemaker.UpdateDeviceFleetInput) (*request.Request, *sagemaker.UpdateDeviceFleetOutput)

	UpdateDevices(*sagemaker.UpdateDevicesInput) (*sagemaker.UpdateDevicesOutput, error)
	UpdateDevicesWithContext(aws.Context, *sagemaker.UpdateDevicesInput, ...request.Option) (*sagemaker.UpdateDevicesOutput, error)
	UpdateDevicesRequest(*sagemaker.UpdateDevicesInput) (*request.Request, *sagemaker.UpdateDevicesOutput)

	UpdateDomain(*sagemaker.UpdateDomainInput) (*sagemaker.UpdateDomainOutput, error)
	UpdateDomainWithContext(aws.Context, *sagemaker.UpdateDomainInput, ...request.Option) (*sagemaker.UpdateDomainOutput, error)
	UpdateDomainRequest(*sagemaker.UpdateDomainInput) (*request.Request, *sagemaker.UpdateDomainOutput)

	UpdateEndpoint(*sagemaker.UpdateEndpointInput) (*sagemaker.UpdateEndpointOutput, error)
	UpdateEndpointWithContext(aws.Context, *sagemaker.UpdateEndpointInput, ...request.Option) (*sagemaker.UpdateEndpointOutput, error)
	UpdateEndpointRequest(*sagemaker.UpdateEndpointInput) (*request.Request, *sagemaker.UpdateEndpointOutput)

	UpdateEndpointWeightsAndCapacities(*sagemaker.UpdateEndpointWeightsAndCapacitiesInput) (*sagemaker.UpdateEndpointWeightsAndCapacitiesOutput, error)
	UpdateEndpointWeightsAndCapacitiesWithContext(aws.Context, *sagemaker.UpdateEndpointWeightsAndCapacitiesInput, ...request.Option) (*sagemaker.UpdateEndpointWeightsAndCapacitiesOutput, error)
	UpdateEndpointWeightsAndCapacitiesRequest(*sagemaker.UpdateEndpointWeightsAndCapacitiesInput) (*request.Request, *sagemaker.UpdateEndpointWeightsAndCapacitiesOutput)

	UpdateExperiment(*sagemaker.UpdateExperimentInput) (*sagemaker.UpdateExperimentOutput, error)
	UpdateExperimentWithContext(aws.Context, *sagemaker.UpdateExperimentInput, ...request.Option) (*sagemaker.UpdateExperimentOutput, error)
	UpdateExperimentRequest(*sagemaker.UpdateExperimentInput) (*request.Request, *sagemaker.UpdateExperimentOutput)

	UpdateFeatureGroup(*sagemaker.UpdateFeatureGroupInput) (*sagemaker.UpdateFeatureGroupOutput, error)
	UpdateFeatureGroupWithContext(aws.Context, *sagemaker.UpdateFeatureGroupInput, ...request.Option) (*sagemaker.UpdateFeatureGroupOutput, error)
	UpdateFeatureGroupRequest(*sagemaker.UpdateFeatureGroupInput) (*request.Request, *sagemaker.UpdateFeatureGroupOutput)

	UpdateFeatureMetadata(*sagemaker.UpdateFeatureMetadataInput) (*sagemaker.UpdateFeatureMetadataOutput, error)
	UpdateFeatureMetadataWithContext(aws.Context, *sagemaker.UpdateFeatureMetadataInput, ...request.Option) (*sagemaker.UpdateFeatureMetadataOutput, error)
	UpdateFeatureMetadataRequest(*sagemaker.UpdateFeatureMetadataInput) (*request.Request, *sagemaker.UpdateFeatureMetadataOutput)

	UpdateHub(*sagemaker.UpdateHubInput) (*sagemaker.UpdateHubOutput, error)
	UpdateHubWithContext(aws.Context, *sagemaker.UpdateHubInput, ...request.Option) (*sagemaker.UpdateHubOutput, error)
	UpdateHubRequest(*sagemaker.UpdateHubInput) (*request.Request, *sagemaker.UpdateHubOutput)

	UpdateImage(*sagemaker.UpdateImageInput) (*sagemaker.UpdateImageOutput, error)
	UpdateImageWithContext(aws.Context, *sagemaker.UpdateImageInput, ...request.Option) (*sagemaker.UpdateImageOutput, error)
	UpdateImageRequest(*sagemaker.UpdateImageInput) (*request.Request, *sagemaker.UpdateImageOutput)

	UpdateImageVersion(*sagemaker.UpdateImageVersionInput) (*sagemaker.UpdateImageVersionOutput, error)
	UpdateImageVersionWithContext(aws.Context, *sagemaker.UpdateImageVersionInput, ...request.Option) (*sagemaker.UpdateImageVersionOutput, error)
	UpdateImageVersionRequest(*sagemaker.UpdateImageVersionInput) (*request.Request, *sagemaker.UpdateImageVersionOutput)

	UpdateInferenceExperiment(*sagemaker.UpdateInferenceExperimentInput) (*sagemaker.UpdateInferenceExperimentOutput, error)
	UpdateInferenceExperimentWithContext(aws.Context, *sagemaker.UpdateInferenceExperimentInput, ...request.Option) (*sagemaker.UpdateInferenceExperimentOutput, error)
	UpdateInferenceExperimentRequest(*sagemaker.UpdateInferenceExperimentInput) (*request.Request, *sagemaker.UpdateInferenceExperimentOutput)

	UpdateModelCard(*sagemaker.UpdateModelCardInput) (*sagemaker.UpdateModelCardOutput, error)
	UpdateModelCardWithContext(aws.Context, *sagemaker.UpdateModelCardInput, ...request.Option) (*sagemaker.UpdateModelCardOutput, error)
	UpdateModelCardRequest(*sagemaker.UpdateModelCardInput) (*request.Request, *sagemaker.UpdateModelCardOutput)

	UpdateModelPackage(*sagemaker.UpdateModelPackageInput) (*sagemaker.UpdateModelPackageOutput, error)
	UpdateModelPackageWithContext(aws.Context, *sagemaker.UpdateModelPackageInput, ...request.Option) (*sagemaker.UpdateModelPackageOutput, error)
	UpdateModelPackageRequest(*sagemaker.UpdateModelPackageInput) (*request.Request, *sagemaker.UpdateModelPackageOutput)

	UpdateMonitoringAlert(*sagemaker.UpdateMonitoringAlertInput) (*sagemaker.UpdateMonitoringAlertOutput, error)
	UpdateMonitoringAlertWithContext(aws.Context, *sagemaker.UpdateMonitoringAlertInput, ...request.Option) (*sagemaker.UpdateMonitoringAlertOutput, error)
	UpdateMonitoringAlertRequest(*sagemaker.UpdateMonitoringAlertInput) (*request.Request, *sagemaker.UpdateMonitoringAlertOutput)

	UpdateMonitoringSchedule(*sagemaker.UpdateMonitoringScheduleInput) (*sagemaker.UpdateMonitoringScheduleOutput, error)
	UpdateMonitoringScheduleWithContext(aws.Context, *sagemaker.UpdateMonitoringScheduleInput, ...request.Option) (*sagemaker.UpdateMonitoringScheduleOutput, error)
	UpdateMonitoringScheduleRequest(*sagemaker.UpdateMonitoringScheduleInput) (*request.Request, *sagemaker.UpdateMonitoringScheduleOutput)

	UpdateNotebookInstance(*sagemaker.UpdateNotebookInstanceInput) (*sagemaker.UpdateNotebookInstanceOutput, error)
	UpdateNotebookInstanceWithContext(aws.Context, *sagemaker.UpdateNotebookInstanceInput, ...request.Option) (*sagemaker.UpdateNotebookInstanceOutput, error)
	UpdateNotebookInstanceRequest(*sagemaker.UpdateNotebookInstanceInput) (*request.Request, *sagemaker.UpdateNotebookInstanceOutput)

	UpdateNotebookInstanceLifecycleConfig(*sagemaker.UpdateNotebookInstanceLifecycleConfigInput) (*sagemaker.UpdateNotebookInstanceLifecycleConfigOutput, error)
	UpdateNotebookInstanceLifecycleConfigWithContext(aws.Context, *sagemaker.UpdateNotebookInstanceLifecycleConfigInput, ...request.Option) (*sagemaker.UpdateNotebookInstanceLifecycleConfigOutput, error)
	UpdateNotebookInstanceLifecycleConfigRequest(*sagemaker.UpdateNotebookInstanceLifecycleConfigInput) (*request.Request, *sagemaker.UpdateNotebookInstanceLifecycleConfigOutput)

	UpdatePipeline(*sagemaker.UpdatePipelineInput) (*sagemaker.UpdatePipelineOutput, error)
	UpdatePipelineWithContext(aws.Context, *sagemaker.UpdatePipelineInput, ...request.Option) (*sagemaker.UpdatePipelineOutput, error)
	UpdatePipelineRequest(*sagemaker.UpdatePipelineInput) (*request.Request, *sagemaker.UpdatePipelineOutput)

	UpdatePipelineExecution(*sagemaker.UpdatePipelineExecutionInput) (*sagemaker.UpdatePipelineExecutionOutput, error)
	UpdatePipelineExecutionWithContext(aws.Context, *sagemaker.UpdatePipelineExecutionInput, ...request.Option) (*sagemaker.UpdatePipelineExecutionOutput, error)
	UpdatePipelineExecutionRequest(*sagemaker.UpdatePipelineExecutionInput) (*request.Request, *sagemaker.UpdatePipelineExecutionOutput)

	UpdateProject(*sagemaker.UpdateProjectInput) (*sagemaker.UpdateProjectOutput, error)
	UpdateProjectWithContext(aws.Context, *sagemaker.UpdateProjectInput, ...request.Option) (*sagemaker.UpdateProjectOutput, error)
	UpdateProjectRequest(*sagemaker.UpdateProjectInput) (*request.Request, *sagemaker.UpdateProjectOutput)

	UpdateSpace(*sagemaker.UpdateSpaceInput) (*sagemaker.UpdateSpaceOutput, error)
	UpdateSpaceWithContext(aws.Context, *sagemaker.UpdateSpaceInput, ...request.Option) (*sagemaker.UpdateSpaceOutput, error)
	UpdateSpaceRequest(*sagemaker.UpdateSpaceInput) (*request.Request, *sagemaker.UpdateSpaceOutput)

	UpdateTrainingJob(*sagemaker.UpdateTrainingJobInput) (*sagemaker.UpdateTrainingJobOutput, error)
	UpdateTrainingJobWithContext(aws.Context, *sagemaker.UpdateTrainingJobInput, ...request.Option) (*sagemaker.UpdateTrainingJobOutput, error)
	UpdateTrainingJobRequest(*sagemaker.UpdateTrainingJobInput) (*request.Request, *sagemaker.UpdateTrainingJobOutput)

	UpdateTrial(*sagemaker.UpdateTrialInput) (*sagemaker.UpdateTrialOutput, error)
	UpdateTrialWithContext(aws.Context, *sagemaker.UpdateTrialInput, ...request.Option) (*sagemaker.UpdateTrialOutput, error)
	UpdateTrialRequest(*sagemaker.UpdateTrialInput) (*request.Request, *sagemaker.UpdateTrialOutput)

	UpdateTrialComponent(*sagemaker.UpdateTrialComponentInput) (*sagemaker.UpdateTrialComponentOutput, error)
	UpdateTrialComponentWithContext(aws.Context, *sagemaker.UpdateTrialComponentInput, ...request.Option) (*sagemaker.UpdateTrialComponentOutput, error)
	UpdateTrialComponentRequest(*sagemaker.UpdateTrialComponentInput) (*request.Request, *sagemaker.UpdateTrialComponentOutput)

	UpdateUserProfile(*sagemaker.UpdateUserProfileInput) (*sagemaker.UpdateUserProfileOutput, error)
	UpdateUserProfileWithContext(aws.Context, *sagemaker.UpdateUserProfileInput, ...request.Option) (*sagemaker.UpdateUserProfileOutput, error)
	UpdateUserProfileRequest(*sagemaker.UpdateUserProfileInput) (*request.Request, *sagemaker.UpdateUserProfileOutput)

	UpdateWorkforce(*sagemaker.UpdateWorkforceInput) (*sagemaker.UpdateWorkforceOutput, error)
	UpdateWorkforceWithContext(aws.Context, *sagemaker.UpdateWorkforceInput, ...request.Option) (*sagemaker.UpdateWorkforceOutput, error)
	UpdateWorkforceRequest(*sagemaker.UpdateWorkforceInput) (*request.Request, *sagemaker.UpdateWorkforceOutput)

	UpdateWorkteam(*sagemaker.UpdateWorkteamInput) (*sagemaker.UpdateWorkteamOutput, error)
	UpdateWorkteamWithContext(aws.Context, *sagemaker.UpdateWorkteamInput, ...request.Option) (*sagemaker.UpdateWorkteamOutput, error)
	UpdateWorkteamRequest(*sagemaker.UpdateWorkteamInput) (*request.Request, *sagemaker.UpdateWorkteamOutput)

	WaitUntilEndpointDeleted(*sagemaker.DescribeEndpointInput) error
	WaitUntilEndpointDeletedWithContext(aws.Context, *sagemaker.DescribeEndpointInput, ...request.WaiterOption) error

	WaitUntilEndpointInService(*sagemaker.DescribeEndpointInput) error
	WaitUntilEndpointInServiceWithContext(aws.Context, *sagemaker.DescribeEndpointInput, ...request.WaiterOption) error

	WaitUntilImageCreated(*sagemaker.DescribeImageInput) error
	WaitUntilImageCreatedWithContext(aws.Context, *sagemaker.DescribeImageInput, ...request.WaiterOption) error

	WaitUntilImageDeleted(*sagemaker.DescribeImageInput) error
	WaitUntilImageDeletedWithContext(aws.Context, *sagemaker.DescribeImageInput, ...request.WaiterOption) error

	WaitUntilImageUpdated(*sagemaker.DescribeImageInput) error
	WaitUntilImageUpdatedWithContext(aws.Context, *sagemaker.DescribeImageInput, ...request.WaiterOption) error

	WaitUntilImageVersionCreated(*sagemaker.DescribeImageVersionInput) error
	WaitUntilImageVersionCreatedWithContext(aws.Context, *sagemaker.DescribeImageVersionInput, ...request.WaiterOption) error

	WaitUntilImageVersionDeleted(*sagemaker.DescribeImageVersionInput) error
	WaitUntilImageVersionDeletedWithContext(aws.Context, *sagemaker.DescribeImageVersionInput, ...request.WaiterOption) error

	WaitUntilNotebookInstanceDeleted(*sagemaker.DescribeNotebookInstanceInput) error
	WaitUntilNotebookInstanceDeletedWithContext(aws.Context, *sagemaker.DescribeNotebookInstanceInput, ...request.WaiterOption) error

	WaitUntilNotebookInstanceInService(*sagemaker.DescribeNotebookInstanceInput) error
	WaitUntilNotebookInstanceInServiceWithContext(aws.Context, *sagemaker.DescribeNotebookInstanceInput, ...request.WaiterOption) error

	WaitUntilNotebookInstanceStopped(*sagemaker.DescribeNotebookInstanceInput) error
	WaitUntilNotebookInstanceStoppedWithContext(aws.Context, *sagemaker.DescribeNotebookInstanceInput, ...request.WaiterOption) error

	WaitUntilProcessingJobCompletedOrStopped(*sagemaker.DescribeProcessingJobInput) error
	WaitUntilProcessingJobCompletedOrStoppedWithContext(aws.Context, *sagemaker.DescribeProcessingJobInput, ...request.WaiterOption) error

	WaitUntilTrainingJobCompletedOrStopped(*sagemaker.DescribeTrainingJobInput) error
	WaitUntilTrainingJobCompletedOrStoppedWithContext(aws.Context, *sagemaker.DescribeTrainingJobInput, ...request.WaiterOption) error

	WaitUntilTransformJobCompletedOrStopped(*sagemaker.DescribeTransformJobInput) error
	WaitUntilTransformJobCompletedOrStoppedWithContext(aws.Context, *sagemaker.DescribeTransformJobInput, ...request.WaiterOption) error
}

var _ SageMakerAPI = (*sagemaker.SageMaker)(nil)
