// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/dataflow/v1beta3/templates.proto

package dataflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TemplatesService_CreateJobFromTemplate_FullMethodName = "/google.dataflow.v1beta3.TemplatesService/CreateJobFromTemplate"
	TemplatesService_LaunchTemplate_FullMethodName        = "/google.dataflow.v1beta3.TemplatesService/LaunchTemplate"
	TemplatesService_GetTemplate_FullMethodName           = "/google.dataflow.v1beta3.TemplatesService/GetTemplate"
)

// TemplatesServiceClient is the client API for TemplatesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TemplatesServiceClient interface {
	// Creates a Cloud Dataflow job from a template. Do not enter confidential
	// information when you supply string values using the API.
	//
	// To create a job, we recommend using `projects.locations.templates.create`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.templates.create` is not recommended, because your job will
	// always start in `us-central1`.
	CreateJobFromTemplate(ctx context.Context, in *CreateJobFromTemplateRequest, opts ...grpc.CallOption) (*Job, error)
	// Launches a template.
	//
	// To launch a template, we recommend using
	// `projects.locations.templates.launch` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.templates.launch` is not recommended, because jobs launched
	// from the template will always start in `us-central1`.
	LaunchTemplate(ctx context.Context, in *LaunchTemplateRequest, opts ...grpc.CallOption) (*LaunchTemplateResponse, error)
	// Get the template associated with a template.
	//
	// To get the template, we recommend using `projects.locations.templates.get`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.templates.get` is not recommended, because only
	// templates that are running in `us-central1` are retrieved.
	GetTemplate(ctx context.Context, in *GetTemplateRequest, opts ...grpc.CallOption) (*GetTemplateResponse, error)
}

type templatesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTemplatesServiceClient(cc grpc.ClientConnInterface) TemplatesServiceClient {
	return &templatesServiceClient{cc}
}

func (c *templatesServiceClient) CreateJobFromTemplate(ctx context.Context, in *CreateJobFromTemplateRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, TemplatesService_CreateJobFromTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *templatesServiceClient) LaunchTemplate(ctx context.Context, in *LaunchTemplateRequest, opts ...grpc.CallOption) (*LaunchTemplateResponse, error) {
	out := new(LaunchTemplateResponse)
	err := c.cc.Invoke(ctx, TemplatesService_LaunchTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *templatesServiceClient) GetTemplate(ctx context.Context, in *GetTemplateRequest, opts ...grpc.CallOption) (*GetTemplateResponse, error) {
	out := new(GetTemplateResponse)
	err := c.cc.Invoke(ctx, TemplatesService_GetTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TemplatesServiceServer is the server API for TemplatesService service.
// All implementations should embed UnimplementedTemplatesServiceServer
// for forward compatibility
type TemplatesServiceServer interface {
	// Creates a Cloud Dataflow job from a template. Do not enter confidential
	// information when you supply string values using the API.
	//
	// To create a job, we recommend using `projects.locations.templates.create`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.templates.create` is not recommended, because your job will
	// always start in `us-central1`.
	CreateJobFromTemplate(context.Context, *CreateJobFromTemplateRequest) (*Job, error)
	// Launches a template.
	//
	// To launch a template, we recommend using
	// `projects.locations.templates.launch` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.templates.launch` is not recommended, because jobs launched
	// from the template will always start in `us-central1`.
	LaunchTemplate(context.Context, *LaunchTemplateRequest) (*LaunchTemplateResponse, error)
	// Get the template associated with a template.
	//
	// To get the template, we recommend using `projects.locations.templates.get`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.templates.get` is not recommended, because only
	// templates that are running in `us-central1` are retrieved.
	GetTemplate(context.Context, *GetTemplateRequest) (*GetTemplateResponse, error)
}

// UnimplementedTemplatesServiceServer should be embedded to have forward compatible implementations.
type UnimplementedTemplatesServiceServer struct {
}

func (UnimplementedTemplatesServiceServer) CreateJobFromTemplate(context.Context, *CreateJobFromTemplateRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJobFromTemplate not implemented")
}
func (UnimplementedTemplatesServiceServer) LaunchTemplate(context.Context, *LaunchTemplateRequest) (*LaunchTemplateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LaunchTemplate not implemented")
}
func (UnimplementedTemplatesServiceServer) GetTemplate(context.Context, *GetTemplateRequest) (*GetTemplateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTemplate not implemented")
}

// UnsafeTemplatesServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TemplatesServiceServer will
// result in compilation errors.
type UnsafeTemplatesServiceServer interface {
	mustEmbedUnimplementedTemplatesServiceServer()
}

func RegisterTemplatesServiceServer(s grpc.ServiceRegistrar, srv TemplatesServiceServer) {
	s.RegisterService(&TemplatesService_ServiceDesc, srv)
}

func _TemplatesService_CreateJobFromTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobFromTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TemplatesServiceServer).CreateJobFromTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TemplatesService_CreateJobFromTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TemplatesServiceServer).CreateJobFromTemplate(ctx, req.(*CreateJobFromTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TemplatesService_LaunchTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LaunchTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TemplatesServiceServer).LaunchTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TemplatesService_LaunchTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TemplatesServiceServer).LaunchTemplate(ctx, req.(*LaunchTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TemplatesService_GetTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TemplatesServiceServer).GetTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TemplatesService_GetTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TemplatesServiceServer).GetTemplate(ctx, req.(*GetTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TemplatesService_ServiceDesc is the grpc.ServiceDesc for TemplatesService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TemplatesService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.TemplatesService",
	HandlerType: (*TemplatesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJobFromTemplate",
			Handler:    _TemplatesService_CreateJobFromTemplate_Handler,
		},
		{
			MethodName: "LaunchTemplate",
			Handler:    _TemplatesService_LaunchTemplate_Handler,
		},
		{
			MethodName: "GetTemplate",
			Handler:    _TemplatesService_GetTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/templates.proto",
}

const (
	FlexTemplatesService_LaunchFlexTemplate_FullMethodName = "/google.dataflow.v1beta3.FlexTemplatesService/LaunchFlexTemplate"
)

// FlexTemplatesServiceClient is the client API for FlexTemplatesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FlexTemplatesServiceClient interface {
	// Launch a job with a FlexTemplate.
	LaunchFlexTemplate(ctx context.Context, in *LaunchFlexTemplateRequest, opts ...grpc.CallOption) (*LaunchFlexTemplateResponse, error)
}

type flexTemplatesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFlexTemplatesServiceClient(cc grpc.ClientConnInterface) FlexTemplatesServiceClient {
	return &flexTemplatesServiceClient{cc}
}

func (c *flexTemplatesServiceClient) LaunchFlexTemplate(ctx context.Context, in *LaunchFlexTemplateRequest, opts ...grpc.CallOption) (*LaunchFlexTemplateResponse, error) {
	out := new(LaunchFlexTemplateResponse)
	err := c.cc.Invoke(ctx, FlexTemplatesService_LaunchFlexTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FlexTemplatesServiceServer is the server API for FlexTemplatesService service.
// All implementations should embed UnimplementedFlexTemplatesServiceServer
// for forward compatibility
type FlexTemplatesServiceServer interface {
	// Launch a job with a FlexTemplate.
	LaunchFlexTemplate(context.Context, *LaunchFlexTemplateRequest) (*LaunchFlexTemplateResponse, error)
}

// UnimplementedFlexTemplatesServiceServer should be embedded to have forward compatible implementations.
type UnimplementedFlexTemplatesServiceServer struct {
}

func (UnimplementedFlexTemplatesServiceServer) LaunchFlexTemplate(context.Context, *LaunchFlexTemplateRequest) (*LaunchFlexTemplateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LaunchFlexTemplate not implemented")
}

// UnsafeFlexTemplatesServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FlexTemplatesServiceServer will
// result in compilation errors.
type UnsafeFlexTemplatesServiceServer interface {
	mustEmbedUnimplementedFlexTemplatesServiceServer()
}

func RegisterFlexTemplatesServiceServer(s grpc.ServiceRegistrar, srv FlexTemplatesServiceServer) {
	s.RegisterService(&FlexTemplatesService_ServiceDesc, srv)
}

func _FlexTemplatesService_LaunchFlexTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LaunchFlexTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlexTemplatesServiceServer).LaunchFlexTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FlexTemplatesService_LaunchFlexTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlexTemplatesServiceServer).LaunchFlexTemplate(ctx, req.(*LaunchFlexTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FlexTemplatesService_ServiceDesc is the grpc.ServiceDesc for FlexTemplatesService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FlexTemplatesService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.FlexTemplatesService",
	HandlerType: (*FlexTemplatesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "LaunchFlexTemplate",
			Handler:    _FlexTemplatesService_LaunchFlexTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/templates.proto",
}
