// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package honeycode

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchCreateTableRows = "BatchCreateTableRows"

// BatchCreateTableRowsRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateTableRows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateTableRows for more information on using the BatchCreateTableRows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateTableRowsRequest method.
//    req, resp := client.BatchCreateTableRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchCreateTableRows
func (c *Honeycode) BatchCreateTableRowsRequest(input *BatchCreateTableRowsInput) (req *request.Request, output *BatchCreateTableRowsOutput) {
	op := &request.Operation{
		Name:       opBatchCreateTableRows,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/rows/batchcreate",
	}

	if input == nil {
		input = &BatchCreateTableRowsInput{}
	}

	output = &BatchCreateTableRowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateTableRows API operation for Amazon Honeycode.
//
// The BatchCreateTableRows API allows you to create one or more rows at the
// end of a table in a workbook. The API allows you to specify the values to
// set in some or all of the columns in the new rows.
//
// If a column is not explicitly set in a specific row, then the column level
// formula specified in the table will be applied to the new row. If there is
// no column level formula but the last row of the table has a formula, then
// that formula will be copied down to the new row. If there is no column level
// formula and no formula in the last row of the table, then that column will
// be left blank for the new rows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation BatchCreateTableRows for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceQuotaExceededException
//   The request caused service quota to be breached.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchCreateTableRows
func (c *Honeycode) BatchCreateTableRows(input *BatchCreateTableRowsInput) (*BatchCreateTableRowsOutput, error) {
	req, out := c.BatchCreateTableRowsRequest(input)
	return out, req.Send()
}

// BatchCreateTableRowsWithContext is the same as BatchCreateTableRows with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateTableRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) BatchCreateTableRowsWithContext(ctx aws.Context, input *BatchCreateTableRowsInput, opts ...request.Option) (*BatchCreateTableRowsOutput, error) {
	req, out := c.BatchCreateTableRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteTableRows = "BatchDeleteTableRows"

// BatchDeleteTableRowsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteTableRows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteTableRows for more information on using the BatchDeleteTableRows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteTableRowsRequest method.
//    req, resp := client.BatchDeleteTableRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchDeleteTableRows
func (c *Honeycode) BatchDeleteTableRowsRequest(input *BatchDeleteTableRowsInput) (req *request.Request, output *BatchDeleteTableRowsOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteTableRows,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/rows/batchdelete",
	}

	if input == nil {
		input = &BatchDeleteTableRowsInput{}
	}

	output = &BatchDeleteTableRowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteTableRows API operation for Amazon Honeycode.
//
// The BatchDeleteTableRows API allows you to delete one or more rows from a
// table in a workbook. You need to specify the ids of the rows that you want
// to delete from the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation BatchDeleteTableRows for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchDeleteTableRows
func (c *Honeycode) BatchDeleteTableRows(input *BatchDeleteTableRowsInput) (*BatchDeleteTableRowsOutput, error) {
	req, out := c.BatchDeleteTableRowsRequest(input)
	return out, req.Send()
}

// BatchDeleteTableRowsWithContext is the same as BatchDeleteTableRows with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteTableRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) BatchDeleteTableRowsWithContext(ctx aws.Context, input *BatchDeleteTableRowsInput, opts ...request.Option) (*BatchDeleteTableRowsOutput, error) {
	req, out := c.BatchDeleteTableRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateTableRows = "BatchUpdateTableRows"

// BatchUpdateTableRowsRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateTableRows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateTableRows for more information on using the BatchUpdateTableRows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateTableRowsRequest method.
//    req, resp := client.BatchUpdateTableRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpdateTableRows
func (c *Honeycode) BatchUpdateTableRowsRequest(input *BatchUpdateTableRowsInput) (req *request.Request, output *BatchUpdateTableRowsOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateTableRows,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/rows/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateTableRowsInput{}
	}

	output = &BatchUpdateTableRowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateTableRows API operation for Amazon Honeycode.
//
// The BatchUpdateTableRows API allows you to update one or more rows in a table
// in a workbook.
//
// You can specify the values to set in some or all of the columns in the table
// for the specified rows. If a column is not explicitly specified in a particular
// row, then that column will not be updated for that row. To clear out the
// data in a specific cell, you need to set the value as an empty string ("").
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation BatchUpdateTableRows for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpdateTableRows
func (c *Honeycode) BatchUpdateTableRows(input *BatchUpdateTableRowsInput) (*BatchUpdateTableRowsOutput, error) {
	req, out := c.BatchUpdateTableRowsRequest(input)
	return out, req.Send()
}

// BatchUpdateTableRowsWithContext is the same as BatchUpdateTableRows with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateTableRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) BatchUpdateTableRowsWithContext(ctx aws.Context, input *BatchUpdateTableRowsInput, opts ...request.Option) (*BatchUpdateTableRowsOutput, error) {
	req, out := c.BatchUpdateTableRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpsertTableRows = "BatchUpsertTableRows"

// BatchUpsertTableRowsRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpsertTableRows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpsertTableRows for more information on using the BatchUpsertTableRows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpsertTableRowsRequest method.
//    req, resp := client.BatchUpsertTableRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpsertTableRows
func (c *Honeycode) BatchUpsertTableRowsRequest(input *BatchUpsertTableRowsInput) (req *request.Request, output *BatchUpsertTableRowsOutput) {
	op := &request.Operation{
		Name:       opBatchUpsertTableRows,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/rows/batchupsert",
	}

	if input == nil {
		input = &BatchUpsertTableRowsInput{}
	}

	output = &BatchUpsertTableRowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpsertTableRows API operation for Amazon Honeycode.
//
// The BatchUpsertTableRows API allows you to upsert one or more rows in a table.
// The upsert operation takes a filter expression as input and evaluates it
// to find matching rows on the destination table. If matching rows are found,
// it will update the cells in the matching rows to new values specified in
// the request. If no matching rows are found, a new row is added at the end
// of the table and the cells in that row are set to the new values specified
// in the request.
//
// You can specify the values to set in some or all of the columns in the table
// for the matching or newly appended rows. If a column is not explicitly specified
// for a particular row, then that column will not be updated for that row.
// To clear out the data in a specific cell, you need to set the value as an
// empty string ("").
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation BatchUpsertTableRows for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceQuotaExceededException
//   The request caused service quota to be breached.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpsertTableRows
func (c *Honeycode) BatchUpsertTableRows(input *BatchUpsertTableRowsInput) (*BatchUpsertTableRowsOutput, error) {
	req, out := c.BatchUpsertTableRowsRequest(input)
	return out, req.Send()
}

// BatchUpsertTableRowsWithContext is the same as BatchUpsertTableRows with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpsertTableRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) BatchUpsertTableRowsWithContext(ctx aws.Context, input *BatchUpsertTableRowsInput, opts ...request.Option) (*BatchUpsertTableRowsOutput, error) {
	req, out := c.BatchUpsertTableRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTableDataImportJob = "DescribeTableDataImportJob"

// DescribeTableDataImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableDataImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTableDataImportJob for more information on using the DescribeTableDataImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableDataImportJobRequest method.
//    req, resp := client.DescribeTableDataImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/DescribeTableDataImportJob
func (c *Honeycode) DescribeTableDataImportJobRequest(input *DescribeTableDataImportJobInput) (req *request.Request, output *DescribeTableDataImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTableDataImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/import/{jobId}",
	}

	if input == nil {
		input = &DescribeTableDataImportJobInput{}
	}

	output = &DescribeTableDataImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableDataImportJob API operation for Amazon Honeycode.
//
// The DescribeTableDataImportJob API allows you to retrieve the status and
// details of a table data import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation DescribeTableDataImportJob for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/DescribeTableDataImportJob
func (c *Honeycode) DescribeTableDataImportJob(input *DescribeTableDataImportJobInput) (*DescribeTableDataImportJobOutput, error) {
	req, out := c.DescribeTableDataImportJobRequest(input)
	return out, req.Send()
}

// DescribeTableDataImportJobWithContext is the same as DescribeTableDataImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTableDataImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) DescribeTableDataImportJobWithContext(ctx aws.Context, input *DescribeTableDataImportJobInput, opts ...request.Option) (*DescribeTableDataImportJobOutput, error) {
	req, out := c.DescribeTableDataImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetScreenData = "GetScreenData"

// GetScreenDataRequest generates a "aws/request.Request" representing the
// client's request for the GetScreenData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScreenData for more information on using the GetScreenData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetScreenDataRequest method.
//    req, resp := client.GetScreenDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData
func (c *Honeycode) GetScreenDataRequest(input *GetScreenDataInput) (req *request.Request, output *GetScreenDataOutput) {
	op := &request.Operation{
		Name:       opGetScreenData,
		HTTPMethod: "POST",
		HTTPPath:   "/screendata",
	}

	if input == nil {
		input = &GetScreenDataInput{}
	}

	output = &GetScreenDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetScreenData API operation for Amazon Honeycode.
//
// The GetScreenData API allows retrieval of data from a screen in a Honeycode
// app. The API allows setting local variables in the screen to filter, sort
// or otherwise affect what will be displayed on the screen.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation GetScreenData for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData
func (c *Honeycode) GetScreenData(input *GetScreenDataInput) (*GetScreenDataOutput, error) {
	req, out := c.GetScreenDataRequest(input)
	return out, req.Send()
}

// GetScreenDataWithContext is the same as GetScreenData with the addition of
// the ability to pass a context and additional request options.
//
// See GetScreenData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) GetScreenDataWithContext(ctx aws.Context, input *GetScreenDataInput, opts ...request.Option) (*GetScreenDataOutput, error) {
	req, out := c.GetScreenDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvokeScreenAutomation = "InvokeScreenAutomation"

// InvokeScreenAutomationRequest generates a "aws/request.Request" representing the
// client's request for the InvokeScreenAutomation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeScreenAutomation for more information on using the InvokeScreenAutomation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeScreenAutomationRequest method.
//    req, resp := client.InvokeScreenAutomationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation
func (c *Honeycode) InvokeScreenAutomationRequest(input *InvokeScreenAutomationInput) (req *request.Request, output *InvokeScreenAutomationOutput) {
	op := &request.Operation{
		Name:       opInvokeScreenAutomation,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/apps/{appId}/screens/{screenId}/automations/{automationId}",
	}

	if input == nil {
		input = &InvokeScreenAutomationInput{}
	}

	output = &InvokeScreenAutomationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeScreenAutomation API operation for Amazon Honeycode.
//
// The InvokeScreenAutomation API allows invoking an action defined in a screen
// in a Honeycode app. The API allows setting local variables, which can then
// be used in the automation being invoked. This allows automating the Honeycode
// app interactions to write, update or delete data in the workbook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation InvokeScreenAutomation for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * AutomationExecutionException
//   The automation execution did not end successfully.
//
//   * AutomationExecutionTimeoutException
//   The automation execution timed out.
//
//   * RequestTimeoutException
//   The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation
func (c *Honeycode) InvokeScreenAutomation(input *InvokeScreenAutomationInput) (*InvokeScreenAutomationOutput, error) {
	req, out := c.InvokeScreenAutomationRequest(input)
	return out, req.Send()
}

// InvokeScreenAutomationWithContext is the same as InvokeScreenAutomation with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeScreenAutomation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) InvokeScreenAutomationWithContext(ctx aws.Context, input *InvokeScreenAutomationInput, opts ...request.Option) (*InvokeScreenAutomationOutput, error) {
	req, out := c.InvokeScreenAutomationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTableColumns = "ListTableColumns"

// ListTableColumnsRequest generates a "aws/request.Request" representing the
// client's request for the ListTableColumns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTableColumns for more information on using the ListTableColumns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTableColumnsRequest method.
//    req, resp := client.ListTableColumnsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns
func (c *Honeycode) ListTableColumnsRequest(input *ListTableColumnsInput) (req *request.Request, output *ListTableColumnsOutput) {
	op := &request.Operation{
		Name:       opListTableColumns,
		HTTPMethod: "GET",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/columns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTableColumnsInput{}
	}

	output = &ListTableColumnsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTableColumns API operation for Amazon Honeycode.
//
// The ListTableColumns API allows you to retrieve a list of all the columns
// in a table in a workbook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation ListTableColumns for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns
func (c *Honeycode) ListTableColumns(input *ListTableColumnsInput) (*ListTableColumnsOutput, error) {
	req, out := c.ListTableColumnsRequest(input)
	return out, req.Send()
}

// ListTableColumnsWithContext is the same as ListTableColumns with the addition of
// the ability to pass a context and additional request options.
//
// See ListTableColumns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) ListTableColumnsWithContext(ctx aws.Context, input *ListTableColumnsInput, opts ...request.Option) (*ListTableColumnsOutput, error) {
	req, out := c.ListTableColumnsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTableColumnsPages iterates over the pages of a ListTableColumns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTableColumns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTableColumns operation.
//    pageNum := 0
//    err := client.ListTableColumnsPages(params,
//        func(page *honeycode.ListTableColumnsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Honeycode) ListTableColumnsPages(input *ListTableColumnsInput, fn func(*ListTableColumnsOutput, bool) bool) error {
	return c.ListTableColumnsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTableColumnsPagesWithContext same as ListTableColumnsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) ListTableColumnsPagesWithContext(ctx aws.Context, input *ListTableColumnsInput, fn func(*ListTableColumnsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTableColumnsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTableColumnsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTableColumnsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTableRows = "ListTableRows"

// ListTableRowsRequest generates a "aws/request.Request" representing the
// client's request for the ListTableRows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTableRows for more information on using the ListTableRows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTableRowsRequest method.
//    req, resp := client.ListTableRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows
func (c *Honeycode) ListTableRowsRequest(input *ListTableRowsInput) (req *request.Request, output *ListTableRowsOutput) {
	op := &request.Operation{
		Name:       opListTableRows,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/rows/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTableRowsInput{}
	}

	output = &ListTableRowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTableRows API operation for Amazon Honeycode.
//
// The ListTableRows API allows you to retrieve a list of all the rows in a
// table in a workbook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation ListTableRows for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows
func (c *Honeycode) ListTableRows(input *ListTableRowsInput) (*ListTableRowsOutput, error) {
	req, out := c.ListTableRowsRequest(input)
	return out, req.Send()
}

// ListTableRowsWithContext is the same as ListTableRows with the addition of
// the ability to pass a context and additional request options.
//
// See ListTableRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) ListTableRowsWithContext(ctx aws.Context, input *ListTableRowsInput, opts ...request.Option) (*ListTableRowsOutput, error) {
	req, out := c.ListTableRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTableRowsPages iterates over the pages of a ListTableRows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTableRows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTableRows operation.
//    pageNum := 0
//    err := client.ListTableRowsPages(params,
//        func(page *honeycode.ListTableRowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Honeycode) ListTableRowsPages(input *ListTableRowsInput, fn func(*ListTableRowsOutput, bool) bool) error {
	return c.ListTableRowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTableRowsPagesWithContext same as ListTableRowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) ListTableRowsPagesWithContext(ctx aws.Context, input *ListTableRowsInput, fn func(*ListTableRowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTableRowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTableRowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTableRowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTablesRequest method.
//    req, resp := client.ListTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables
func (c *Honeycode) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "GET",
		HTTPPath:   "/workbooks/{workbookId}/tables",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTables API operation for Amazon Honeycode.
//
// The ListTables API allows you to retrieve a list of all the tables in a workbook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation ListTables for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables
func (c *Honeycode) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTables operation.
//    pageNum := 0
//    err := client.ListTablesPages(params,
//        func(page *honeycode.ListTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Honeycode) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opQueryTableRows = "QueryTableRows"

// QueryTableRowsRequest generates a "aws/request.Request" representing the
// client's request for the QueryTableRows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See QueryTableRows for more information on using the QueryTableRows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryTableRowsRequest method.
//    req, resp := client.QueryTableRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows
func (c *Honeycode) QueryTableRowsRequest(input *QueryTableRowsInput) (req *request.Request, output *QueryTableRowsOutput) {
	op := &request.Operation{
		Name:       opQueryTableRows,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/rows/query",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &QueryTableRowsInput{}
	}

	output = &QueryTableRowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// QueryTableRows API operation for Amazon Honeycode.
//
// The QueryTableRows API allows you to use a filter formula to query for specific
// rows in a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation QueryTableRows for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows
func (c *Honeycode) QueryTableRows(input *QueryTableRowsInput) (*QueryTableRowsOutput, error) {
	req, out := c.QueryTableRowsRequest(input)
	return out, req.Send()
}

// QueryTableRowsWithContext is the same as QueryTableRows with the addition of
// the ability to pass a context and additional request options.
//
// See QueryTableRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) QueryTableRowsWithContext(ctx aws.Context, input *QueryTableRowsInput, opts ...request.Option) (*QueryTableRowsOutput, error) {
	req, out := c.QueryTableRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// QueryTableRowsPages iterates over the pages of a QueryTableRows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See QueryTableRows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a QueryTableRows operation.
//    pageNum := 0
//    err := client.QueryTableRowsPages(params,
//        func(page *honeycode.QueryTableRowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Honeycode) QueryTableRowsPages(input *QueryTableRowsInput, fn func(*QueryTableRowsOutput, bool) bool) error {
	return c.QueryTableRowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// QueryTableRowsPagesWithContext same as QueryTableRowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) QueryTableRowsPagesWithContext(ctx aws.Context, input *QueryTableRowsInput, fn func(*QueryTableRowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *QueryTableRowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.QueryTableRowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*QueryTableRowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartTableDataImportJob = "StartTableDataImportJob"

// StartTableDataImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTableDataImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTableDataImportJob for more information on using the StartTableDataImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTableDataImportJobRequest method.
//    req, resp := client.StartTableDataImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/StartTableDataImportJob
func (c *Honeycode) StartTableDataImportJobRequest(input *StartTableDataImportJobInput) (req *request.Request, output *StartTableDataImportJobOutput) {
	op := &request.Operation{
		Name:       opStartTableDataImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/tables/{tableId}/import",
	}

	if input == nil {
		input = &StartTableDataImportJobInput{}
	}

	output = &StartTableDataImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTableDataImportJob API operation for Amazon Honeycode.
//
// The StartTableDataImportJob API allows you to start an import job on a table.
// This API will only return the id of the job that was started. To find out
// the status of the import request, you need to call the DescribeTableDataImportJob
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation StartTableDataImportJob for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the resource
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, Table, App, Screen or Screen Automation was not found with the
//   given ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/StartTableDataImportJob
func (c *Honeycode) StartTableDataImportJob(input *StartTableDataImportJobInput) (*StartTableDataImportJobOutput, error) {
	req, out := c.StartTableDataImportJobRequest(input)
	return out, req.Send()
}

// StartTableDataImportJobWithContext is the same as StartTableDataImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTableDataImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) StartTableDataImportJobWithContext(ctx aws.Context, input *StartTableDataImportJobInput, opts ...request.Option) (*StartTableDataImportJobOutput, error) {
	req, out := c.StartTableDataImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action. Check that the
// workbook is owned by you and your IAM policy allows access to the resource
// in the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The automation execution did not end successfully.
type AutomationExecutionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionException) GoString() string {
	return s.String()
}

func newErrorAutomationExecutionException(v protocol.ResponseMetadata) error {
	return &AutomationExecutionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationExecutionException) Code() string {
	return "AutomationExecutionException"
}

// Message returns the exception's message.
func (s *AutomationExecutionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationExecutionException) OrigErr() error {
	return nil
}

func (s *AutomationExecutionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationExecutionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationExecutionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The automation execution timed out.
type AutomationExecutionTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionTimeoutException) GoString() string {
	return s.String()
}

func newErrorAutomationExecutionTimeoutException(v protocol.ResponseMetadata) error {
	return &AutomationExecutionTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationExecutionTimeoutException) Code() string {
	return "AutomationExecutionTimeoutException"
}

// Message returns the exception's message.
func (s *AutomationExecutionTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationExecutionTimeoutException) OrigErr() error {
	return nil
}

func (s *AutomationExecutionTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationExecutionTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationExecutionTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchCreateTableRowsInput struct {
	_ struct{} `type:"structure"`

	// The request token for performing the batch create operation. Request tokens
	// help to identify duplicate requests. If a call times out or fails due to
	// a transient error like a failed network connection, you can retry the call
	// with the same request token. The service ensures that if the first call using
	// that request token is successfully performed, the second call will not perform
	// the operation again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The list of rows to create at the end of the table. Each item in this list
	// needs to have a batch item id to uniquely identify the element in the request
	// and the cells to create for that row. You need to specify at least one item
	// in this list.
	//
	// Note that if one of the column ids in any of the rows in the request does
	// not exist in the table, then the request fails and no updates are made to
	// the table.
	//
	// RowsToCreate is a required field
	RowsToCreate []*CreateRowData `locationName:"rowsToCreate" min:"1" type:"list" required:"true"`

	// The ID of the table where the new rows are being added.
	//
	// If a table with the specified ID could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook where the new rows are being added.
	//
	// If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateTableRowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateTableRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateTableRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateTableRowsInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.RowsToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("RowsToCreate"))
	}
	if s.RowsToCreate != nil && len(s.RowsToCreate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RowsToCreate", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.RowsToCreate != nil {
		for i, v := range s.RowsToCreate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RowsToCreate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *BatchCreateTableRowsInput) SetClientRequestToken(v string) *BatchCreateTableRowsInput {
	s.ClientRequestToken = &v
	return s
}

// SetRowsToCreate sets the RowsToCreate field's value.
func (s *BatchCreateTableRowsInput) SetRowsToCreate(v []*CreateRowData) *BatchCreateTableRowsInput {
	s.RowsToCreate = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *BatchCreateTableRowsInput) SetTableId(v string) *BatchCreateTableRowsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *BatchCreateTableRowsInput) SetWorkbookId(v string) *BatchCreateTableRowsInput {
	s.WorkbookId = &v
	return s
}

type BatchCreateTableRowsOutput struct {
	_ struct{} `type:"structure"`

	// The map of batch item id to the row id that was created for that item.
	//
	// CreatedRows is a required field
	CreatedRows map[string]*string `locationName:"createdRows" type:"map" required:"true"`

	// The list of batch items in the request that could not be added to the table.
	// Each element in this list contains one item from the request that could not
	// be added to the table along with the reason why that item could not be added.
	FailedBatchItems []*FailedBatchItem `locationName:"failedBatchItems" type:"list"`

	// The updated workbook cursor after adding the new rows at the end of the table.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateTableRowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateTableRowsOutput) GoString() string {
	return s.String()
}

// SetCreatedRows sets the CreatedRows field's value.
func (s *BatchCreateTableRowsOutput) SetCreatedRows(v map[string]*string) *BatchCreateTableRowsOutput {
	s.CreatedRows = v
	return s
}

// SetFailedBatchItems sets the FailedBatchItems field's value.
func (s *BatchCreateTableRowsOutput) SetFailedBatchItems(v []*FailedBatchItem) *BatchCreateTableRowsOutput {
	s.FailedBatchItems = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *BatchCreateTableRowsOutput) SetWorkbookCursor(v int64) *BatchCreateTableRowsOutput {
	s.WorkbookCursor = &v
	return s
}

type BatchDeleteTableRowsInput struct {
	_ struct{} `type:"structure"`

	// The request token for performing the delete action. Request tokens help to
	// identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will not perform the action
	// again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The list of row ids to delete from the table. You need to specify at least
	// one row id in this list.
	//
	// Note that if one of the row ids provided in the request does not exist in
	// the table, then the request fails and no rows are deleted from the table.
	//
	// RowIds is a required field
	RowIds []*string `locationName:"rowIds" min:"1" type:"list" required:"true"`

	// The ID of the table where the rows are being deleted.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook where the rows are being deleted.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableRowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTableRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteTableRowsInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.RowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("RowIds"))
	}
	if s.RowIds != nil && len(s.RowIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RowIds", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *BatchDeleteTableRowsInput) SetClientRequestToken(v string) *BatchDeleteTableRowsInput {
	s.ClientRequestToken = &v
	return s
}

// SetRowIds sets the RowIds field's value.
func (s *BatchDeleteTableRowsInput) SetRowIds(v []*string) *BatchDeleteTableRowsInput {
	s.RowIds = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *BatchDeleteTableRowsInput) SetTableId(v string) *BatchDeleteTableRowsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *BatchDeleteTableRowsInput) SetWorkbookId(v string) *BatchDeleteTableRowsInput {
	s.WorkbookId = &v
	return s
}

type BatchDeleteTableRowsOutput struct {
	_ struct{} `type:"structure"`

	// The list of row ids in the request that could not be deleted from the table.
	// Each element in this list contains one row id from the request that could
	// not be deleted along with the reason why that item could not be deleted.
	FailedBatchItems []*FailedBatchItem `locationName:"failedBatchItems" type:"list"`

	// The updated workbook cursor after deleting the rows from the table.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableRowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableRowsOutput) GoString() string {
	return s.String()
}

// SetFailedBatchItems sets the FailedBatchItems field's value.
func (s *BatchDeleteTableRowsOutput) SetFailedBatchItems(v []*FailedBatchItem) *BatchDeleteTableRowsOutput {
	s.FailedBatchItems = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *BatchDeleteTableRowsOutput) SetWorkbookCursor(v int64) *BatchDeleteTableRowsOutput {
	s.WorkbookCursor = &v
	return s
}

type BatchUpdateTableRowsInput struct {
	_ struct{} `type:"structure"`

	// The request token for performing the update action. Request tokens help to
	// identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will not perform the action
	// again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The list of rows to update in the table. Each item in this list needs to
	// contain the row id to update along with the map of column id to cell values
	// for each column in that row that needs to be updated. You need to specify
	// at least one row in this list, and for each row, you need to specify at least
	// one column to update.
	//
	// Note that if one of the row or column ids in the request does not exist in
	// the table, then the request fails and no updates are made to the table.
	//
	// RowsToUpdate is a required field
	RowsToUpdate []*UpdateRowData `locationName:"rowsToUpdate" min:"1" type:"list" required:"true"`

	// The ID of the table where the rows are being updated.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook where the rows are being updated.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateTableRowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateTableRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateTableRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateTableRowsInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.RowsToUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("RowsToUpdate"))
	}
	if s.RowsToUpdate != nil && len(s.RowsToUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RowsToUpdate", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.RowsToUpdate != nil {
		for i, v := range s.RowsToUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RowsToUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *BatchUpdateTableRowsInput) SetClientRequestToken(v string) *BatchUpdateTableRowsInput {
	s.ClientRequestToken = &v
	return s
}

// SetRowsToUpdate sets the RowsToUpdate field's value.
func (s *BatchUpdateTableRowsInput) SetRowsToUpdate(v []*UpdateRowData) *BatchUpdateTableRowsInput {
	s.RowsToUpdate = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *BatchUpdateTableRowsInput) SetTableId(v string) *BatchUpdateTableRowsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *BatchUpdateTableRowsInput) SetWorkbookId(v string) *BatchUpdateTableRowsInput {
	s.WorkbookId = &v
	return s
}

type BatchUpdateTableRowsOutput struct {
	_ struct{} `type:"structure"`

	// The list of batch items in the request that could not be updated in the table.
	// Each element in this list contains one item from the request that could not
	// be updated in the table along with the reason why that item could not be
	// updated.
	FailedBatchItems []*FailedBatchItem `locationName:"failedBatchItems" type:"list"`

	// The updated workbook cursor after adding the new rows at the end of the table.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateTableRowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateTableRowsOutput) GoString() string {
	return s.String()
}

// SetFailedBatchItems sets the FailedBatchItems field's value.
func (s *BatchUpdateTableRowsOutput) SetFailedBatchItems(v []*FailedBatchItem) *BatchUpdateTableRowsOutput {
	s.FailedBatchItems = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *BatchUpdateTableRowsOutput) SetWorkbookCursor(v int64) *BatchUpdateTableRowsOutput {
	s.WorkbookCursor = &v
	return s
}

type BatchUpsertTableRowsInput struct {
	_ struct{} `type:"structure"`

	// The request token for performing the update action. Request tokens help to
	// identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will not perform the action
	// again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The list of rows to upsert in the table. Each item in this list needs to
	// have a batch item id to uniquely identify the element in the request, a filter
	// expression to find the rows to update for that element and the cell values
	// to set for each column in the upserted rows. You need to specify at least
	// one item in this list.
	//
	// Note that if one of the filter formulas in the request fails to evaluate
	// because of an error or one of the column ids in any of the rows does not
	// exist in the table, then the request fails and no updates are made to the
	// table.
	//
	// RowsToUpsert is a required field
	RowsToUpsert []*UpsertRowData `locationName:"rowsToUpsert" type:"list" required:"true"`

	// The ID of the table where the rows are being upserted.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook where the rows are being upserted.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpsertTableRowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpsertTableRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpsertTableRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpsertTableRowsInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.RowsToUpsert == nil {
		invalidParams.Add(request.NewErrParamRequired("RowsToUpsert"))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.RowsToUpsert != nil {
		for i, v := range s.RowsToUpsert {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RowsToUpsert", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *BatchUpsertTableRowsInput) SetClientRequestToken(v string) *BatchUpsertTableRowsInput {
	s.ClientRequestToken = &v
	return s
}

// SetRowsToUpsert sets the RowsToUpsert field's value.
func (s *BatchUpsertTableRowsInput) SetRowsToUpsert(v []*UpsertRowData) *BatchUpsertTableRowsInput {
	s.RowsToUpsert = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *BatchUpsertTableRowsInput) SetTableId(v string) *BatchUpsertTableRowsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *BatchUpsertTableRowsInput) SetWorkbookId(v string) *BatchUpsertTableRowsInput {
	s.WorkbookId = &v
	return s
}

type BatchUpsertTableRowsOutput struct {
	_ struct{} `type:"structure"`

	// The list of batch items in the request that could not be updated or appended
	// in the table. Each element in this list contains one item from the request
	// that could not be updated in the table along with the reason why that item
	// could not be updated or appended.
	FailedBatchItems []*FailedBatchItem `locationName:"failedBatchItems" type:"list"`

	// A map with the batch item id as the key and the result of the upsert operation
	// as the value. The result of the upsert operation specifies whether existing
	// rows were updated or a new row was appended, along with the list of row ids
	// that were affected.
	//
	// Rows is a required field
	Rows map[string]*UpsertRowsResult `locationName:"rows" type:"map" required:"true"`

	// The updated workbook cursor after updating or appending rows in the table.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpsertTableRowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpsertTableRowsOutput) GoString() string {
	return s.String()
}

// SetFailedBatchItems sets the FailedBatchItems field's value.
func (s *BatchUpsertTableRowsOutput) SetFailedBatchItems(v []*FailedBatchItem) *BatchUpsertTableRowsOutput {
	s.FailedBatchItems = v
	return s
}

// SetRows sets the Rows field's value.
func (s *BatchUpsertTableRowsOutput) SetRows(v map[string]*UpsertRowsResult) *BatchUpsertTableRowsOutput {
	s.Rows = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *BatchUpsertTableRowsOutput) SetWorkbookCursor(v int64) *BatchUpsertTableRowsOutput {
	s.WorkbookCursor = &v
	return s
}

// An object that represents a single cell in a table.
type Cell struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The format of the cell. If this field is empty, then the format is either
	// not specified in the workbook or the format is set to AUTO.
	Format *string `locationName:"format" type:"string" enum:"Format"`

	// The formatted value of the cell. This is the value that you see displayed
	// in the cell in the UI.
	//
	// Note that the formatted value of a cell is always represented as a string
	// irrespective of the data that is stored in the cell. For example, if a cell
	// contains a date, the formatted value of the cell is the string representation
	// of the formatted date being shown in the cell in the UI. See details in the
	// rawValue field below for how cells of different formats will have different
	// raw and formatted values.
	FormattedValue *string `locationName:"formattedValue" type:"string"`

	// The formula contained in the cell. This field is empty if a cell does not
	// have a formula.
	//
	// Formula is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Cell's
	// String and GoString methods.
	Formula *string `locationName:"formula" type:"string" sensitive:"true"`

	// The raw value of the data contained in the cell. The raw value depends on
	// the format of the data in the cell. However the attribute in the API return
	// value is always a string containing the raw value.
	//
	// Cells with format DATE, DATE_TIME or TIME have the raw value as a floating
	// point number where the whole number represents the number of days since 1/1/1900
	// and the fractional part represents the fraction of the day since midnight.
	// For example, a cell with date 11/3/2020 has the raw value "44138". A cell
	// with the time 9:00 AM has the raw value "0.375" and a cell with date/time
	// value of 11/3/2020 9:00 AM has the raw value "44138.375". Notice that even
	// though the raw value is a number in all three cases, it is still represented
	// as a string.
	//
	// Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the raw
	// value of the data as the number representing the data being displayed. For
	// example, the number 1.325 with two decimal places in the format will have
	// it's raw value as "1.325" and formatted value as "1.33". A currency value
	// for $10 will have the raw value as "10" and formatted value as "$10.00".
	// A value representing 20% with two decimal places in the format will have
	// its raw value as "0.2" and the formatted value as "20.00%". An accounting
	// value of -$25 will have "-25" as the raw value and "$ (25.00)" as the formatted
	// value.
	//
	// Cells with format TEXT will have the raw text as the raw value. For example,
	// a cell with text "John Smith" will have "John Smith" as both the raw value
	// and the formatted value.
	//
	// Cells with format CONTACT will have the name of the contact as a formatted
	// value and the email address of the contact as the raw value. For example,
	// a contact for John Smith will have "John Smith" as the formatted value and
	// "john.smith@example.com" as the raw value.
	//
	// Cells with format ROWLINK (aka picklist) will have the first column of the
	// linked row as the formatted value and the row id of the linked row as the
	// raw value. For example, a cell containing a picklist to a table that displays
	// task status might have "Completed" as the formatted value and "row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03"
	// as the raw value.
	//
	// Cells with format AUTO or cells without any format that are auto-detected
	// as one of the formats above will contain the raw and formatted values as
	// mentioned above, based on the auto-detected formats. If there is no auto-detected
	// format, the raw and formatted values will be the same as the data in the
	// cell.
	RawValue *string `locationName:"rawValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cell) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cell) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *Cell) SetFormat(v string) *Cell {
	s.Format = &v
	return s
}

// SetFormattedValue sets the FormattedValue field's value.
func (s *Cell) SetFormattedValue(v string) *Cell {
	s.FormattedValue = &v
	return s
}

// SetFormula sets the Formula field's value.
func (s *Cell) SetFormula(v string) *Cell {
	s.Formula = &v
	return s
}

// SetRawValue sets the RawValue field's value.
func (s *Cell) SetRawValue(v string) *Cell {
	s.RawValue = &v
	return s
}

// CellInput object contains the data needed to create or update cells in a
// table.
type CellInput struct {
	_ struct{} `type:"structure"`

	// Fact represents the data that is entered into a cell. This data can be free
	// text or a formula. Formulas need to start with the equals (=) sign.
	//
	// Fact is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CellInput's
	// String and GoString methods.
	Fact *string `locationName:"fact" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CellInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CellInput) GoString() string {
	return s.String()
}

// SetFact sets the Fact field's value.
func (s *CellInput) SetFact(v string) *CellInput {
	s.Fact = &v
	return s
}

// Metadata for column in the table.
type ColumnMetadata struct {
	_ struct{} `type:"structure"`

	// The format of the column.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// The name of the column.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ColumnMetadata's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnMetadata) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *ColumnMetadata) SetFormat(v string) *ColumnMetadata {
	s.Format = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnMetadata) SetName(v string) *ColumnMetadata {
	s.Name = &v
	return s
}

// Data needed to create a single row in a table as part of the BatchCreateTableRows
// request.
type CreateRowData struct {
	_ struct{} `type:"structure"`

	// An external identifier that represents the single row that is being created
	// as part of the BatchCreateTableRows request. This can be any string that
	// you can use to identify the row in the request. The BatchCreateTableRows
	// API puts the batch item id in the results to allow you to link data in the
	// request to data in the results.
	//
	// BatchItemId is a required field
	BatchItemId *string `locationName:"batchItemId" min:"1" type:"string" required:"true"`

	// A map representing the cells to create in the new row. The key is the column
	// id of the cell and the value is the CellInput object that represents the
	// data to set in that cell.
	//
	// CellsToCreate is a required field
	CellsToCreate map[string]*CellInput `locationName:"cellsToCreate" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRowData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRowData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRowData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRowData"}
	if s.BatchItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchItemId"))
	}
	if s.BatchItemId != nil && len(*s.BatchItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchItemId", 1))
	}
	if s.CellsToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("CellsToCreate"))
	}
	if s.CellsToCreate != nil && len(s.CellsToCreate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellsToCreate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchItemId sets the BatchItemId field's value.
func (s *CreateRowData) SetBatchItemId(v string) *CreateRowData {
	s.BatchItemId = &v
	return s
}

// SetCellsToCreate sets the CellsToCreate field's value.
func (s *CreateRowData) SetCellsToCreate(v map[string]*CellInput) *CreateRowData {
	s.CellsToCreate = v
	return s
}

// The data in a particular data cell defined on the screen.
type DataItem struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The formatted value of the data. e.g. John Smith.
	FormattedValue *string `locationName:"formattedValue" type:"string"`

	// The overrideFormat is optional and is specified only if a particular row
	// of data has a different format for the data than the default format defined
	// on the screen or the table.
	OverrideFormat *string `locationName:"overrideFormat" type:"string" enum:"Format"`

	// The raw value of the data. e.g. jsmith@example.com
	RawValue *string `locationName:"rawValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataItem) GoString() string {
	return s.String()
}

// SetFormattedValue sets the FormattedValue field's value.
func (s *DataItem) SetFormattedValue(v string) *DataItem {
	s.FormattedValue = &v
	return s
}

// SetOverrideFormat sets the OverrideFormat field's value.
func (s *DataItem) SetOverrideFormat(v string) *DataItem {
	s.OverrideFormat = &v
	return s
}

// SetRawValue sets the RawValue field's value.
func (s *DataItem) SetRawValue(v string) *DataItem {
	s.RawValue = &v
	return s
}

// An object that contains the options relating to parsing delimited text as
// part of an import request.
type DelimitedTextImportOptions struct {
	_ struct{} `type:"structure"`

	// The encoding of the data in the input file.
	DataCharacterEncoding *string `locationName:"dataCharacterEncoding" type:"string" enum:"ImportDataCharacterEncoding"`

	// The delimiter to use for separating columns in a single row of the input.
	//
	// Delimiter is a required field
	Delimiter *string `locationName:"delimiter" min:"1" type:"string" required:"true"`

	// Indicates whether the input file has a header row at the top containing the
	// column names.
	HasHeaderRow *bool `locationName:"hasHeaderRow" type:"boolean"`

	// A parameter to indicate whether empty rows should be ignored or be included
	// in the import.
	IgnoreEmptyRows *bool `locationName:"ignoreEmptyRows" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DelimitedTextImportOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DelimitedTextImportOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DelimitedTextImportOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DelimitedTextImportOptions"}
	if s.Delimiter == nil {
		invalidParams.Add(request.NewErrParamRequired("Delimiter"))
	}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Delimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataCharacterEncoding sets the DataCharacterEncoding field's value.
func (s *DelimitedTextImportOptions) SetDataCharacterEncoding(v string) *DelimitedTextImportOptions {
	s.DataCharacterEncoding = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *DelimitedTextImportOptions) SetDelimiter(v string) *DelimitedTextImportOptions {
	s.Delimiter = &v
	return s
}

// SetHasHeaderRow sets the HasHeaderRow field's value.
func (s *DelimitedTextImportOptions) SetHasHeaderRow(v bool) *DelimitedTextImportOptions {
	s.HasHeaderRow = &v
	return s
}

// SetIgnoreEmptyRows sets the IgnoreEmptyRows field's value.
func (s *DelimitedTextImportOptions) SetIgnoreEmptyRows(v bool) *DelimitedTextImportOptions {
	s.IgnoreEmptyRows = &v
	return s
}

type DescribeTableDataImportJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the job that was returned by the StartTableDataImportJob request.
	//
	// If a job with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// The ID of the table into which data was imported.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook into which data was imported.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableDataImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableDataImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableDataImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableDataImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTableDataImportJobInput) SetJobId(v string) *DescribeTableDataImportJobInput {
	s.JobId = &v
	return s
}

// SetTableId sets the TableId field's value.
func (s *DescribeTableDataImportJobInput) SetTableId(v string) *DescribeTableDataImportJobInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *DescribeTableDataImportJobInput) SetWorkbookId(v string) *DescribeTableDataImportJobInput {
	s.WorkbookId = &v
	return s
}

type DescribeTableDataImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The metadata about the job that was submitted for import.
	//
	// JobMetadata is a required field
	JobMetadata *TableDataImportJobMetadata `locationName:"jobMetadata" type:"structure" required:"true"`

	// The current status of the import job.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"TableDataImportJobStatus"`

	// A message providing more details about the current status of the import job.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableDataImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableDataImportJobOutput) GoString() string {
	return s.String()
}

// SetJobMetadata sets the JobMetadata field's value.
func (s *DescribeTableDataImportJobOutput) SetJobMetadata(v *TableDataImportJobMetadata) *DescribeTableDataImportJobOutput {
	s.JobMetadata = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DescribeTableDataImportJobOutput) SetJobStatus(v string) *DescribeTableDataImportJobOutput {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribeTableDataImportJobOutput) SetMessage(v string) *DescribeTableDataImportJobOutput {
	s.Message = &v
	return s
}

// An object that contains the options relating to the destination of the import
// request.
type DestinationOptions struct {
	_ struct{} `type:"structure"`

	// A map of the column id to the import properties for each column.
	ColumnMap map[string]*SourceDataColumnProperties `locationName:"columnMap" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationOptions"}
	if s.ColumnMap != nil {
		for i, v := range s.ColumnMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnMap", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnMap sets the ColumnMap field's value.
func (s *DestinationOptions) SetColumnMap(v map[string]*SourceDataColumnProperties) *DestinationOptions {
	s.ColumnMap = v
	return s
}

// A single item in a batch that failed to perform the intended action because
// of an error preventing it from succeeding.
type FailedBatchItem struct {
	_ struct{} `type:"structure"`

	// The error message that indicates why the batch item failed.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`

	// The id of the batch item that failed. This is the batch item id for the BatchCreateTableRows
	// and BatchUpsertTableRows operations and the row id for the BatchUpdateTableRows
	// and BatchDeleteTableRows operations.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedBatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedBatchItem) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedBatchItem) SetErrorMessage(v string) *FailedBatchItem {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *FailedBatchItem) SetId(v string) *FailedBatchItem {
	s.Id = &v
	return s
}

// An object that represents a filter formula along with the id of the context
// row under which the filter function needs to evaluate.
type Filter struct {
	_ struct{} `type:"structure"`

	// The optional contextRowId attribute can be used to specify the row id of
	// the context row if the filter formula contains unqualified references to
	// table columns and needs a context row to evaluate them successfully.
	ContextRowId *string `locationName:"contextRowId" min:"77" type:"string"`

	// A formula representing a filter function that returns zero or more matching
	// rows from a table. Valid formulas in this field return a list of rows from
	// a table. The most common ways of writing a formula to return a list of rows
	// are to use the FindRow() or Filter() functions. Any other formula that returns
	// zero or more rows is also acceptable. For example, you can use a formula
	// that points to a cell that contains a filter function.
	//
	// Formula is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Filter's
	// String and GoString methods.
	//
	// Formula is a required field
	Formula *string `locationName:"formula" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.ContextRowId != nil && len(*s.ContextRowId) < 77 {
		invalidParams.Add(request.NewErrParamMinLen("ContextRowId", 77))
	}
	if s.Formula == nil {
		invalidParams.Add(request.NewErrParamRequired("Formula"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContextRowId sets the ContextRowId field's value.
func (s *Filter) SetContextRowId(v string) *Filter {
	s.ContextRowId = &v
	return s
}

// SetFormula sets the Formula field's value.
func (s *Filter) SetFormula(v string) *Filter {
	s.Formula = &v
	return s
}

type GetScreenDataInput struct {
	_ struct{} `type:"structure"`

	// The ID of the app that contains the screem.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" min:"36" type:"string" required:"true"`

	// The number of results to be returned on a single page. Specify a number between
	// 1 and 100. The maximum value is 100.
	//
	// This parameter is optional. If you don't specify this parameter, the default
	// page size is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the screen.
	//
	// ScreenId is a required field
	ScreenId *string `locationName:"screenId" min:"36" type:"string" required:"true"`

	// Variables are optional and are needed only if the screen requires them to
	// render correctly. Variables are specified as a map where the key is the name
	// of the variable as defined on the screen. The value is an object which currently
	// has only one property, rawValue, which holds the value of the variable to
	// be passed to the screen.
	//
	// Variables is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetScreenDataInput's
	// String and GoString methods.
	Variables map[string]*VariableValue `locationName:"variables" type:"map" sensitive:"true"`

	// The ID of the workbook that contains the screen.
	//
	// WorkbookId is a required field
	WorkbookId *string `locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScreenDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScreenDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScreenDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScreenDataInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ScreenId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScreenId"))
	}
	if s.ScreenId != nil && len(*s.ScreenId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ScreenId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetScreenDataInput) SetAppId(v string) *GetScreenDataInput {
	s.AppId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetScreenDataInput) SetMaxResults(v int64) *GetScreenDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetScreenDataInput) SetNextToken(v string) *GetScreenDataInput {
	s.NextToken = &v
	return s
}

// SetScreenId sets the ScreenId field's value.
func (s *GetScreenDataInput) SetScreenId(v string) *GetScreenDataInput {
	s.ScreenId = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *GetScreenDataInput) SetVariables(v map[string]*VariableValue) *GetScreenDataInput {
	s.Variables = v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *GetScreenDataInput) SetWorkbookId(v string) *GetScreenDataInput {
	s.WorkbookId = &v
	return s
}

type GetScreenDataOutput struct {
	_ struct{} `type:"structure"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the query has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A map of all the rows on the screen keyed by block name.
	//
	// Results is a required field
	Results map[string]*ResultSet `locationName:"results" type:"map" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this workbook
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScreenDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScreenDataOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetScreenDataOutput) SetNextToken(v string) *GetScreenDataOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *GetScreenDataOutput) SetResults(v map[string]*ResultSet) *GetScreenDataOutput {
	s.Results = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *GetScreenDataOutput) SetWorkbookCursor(v int64) *GetScreenDataOutput {
	s.WorkbookCursor = &v
	return s
}

// An object that has details about the source of the data that was submitted
// for import.
type ImportDataSource struct {
	_ struct{} `type:"structure"`

	// The configuration parameters for the data source of the import
	//
	// DataSourceConfig is a required field
	DataSourceConfig *ImportDataSourceConfig `locationName:"dataSourceConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDataSource"}
	if s.DataSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfig"))
	}
	if s.DataSourceConfig != nil {
		if err := s.DataSourceConfig.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceConfig sets the DataSourceConfig field's value.
func (s *ImportDataSource) SetDataSourceConfig(v *ImportDataSourceConfig) *ImportDataSource {
	s.DataSourceConfig = v
	return s
}

// An object that contains the configuration parameters for the data source
// of an import request.
type ImportDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The URL from which source data will be downloaded for the import request.
	DataSourceUrl *string `locationName:"dataSourceUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDataSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDataSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDataSourceConfig"}
	if s.DataSourceUrl != nil && len(*s.DataSourceUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceUrl sets the DataSourceUrl field's value.
func (s *ImportDataSourceConfig) SetDataSourceUrl(v string) *ImportDataSourceConfig {
	s.DataSourceUrl = &v
	return s
}

// An object that contains the attributes of the submitter of the import job.
type ImportJobSubmitter struct {
	_ struct{} `type:"structure"`

	// The email id of the submitter of the import job, if available.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ImportJobSubmitter's
	// String and GoString methods.
	Email *string `locationName:"email" min:"3" type:"string" sensitive:"true"`

	// The AWS user ARN of the submitter of the import job, if available.
	UserArn *string `locationName:"userArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportJobSubmitter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportJobSubmitter) GoString() string {
	return s.String()
}

// SetEmail sets the Email field's value.
func (s *ImportJobSubmitter) SetEmail(v string) *ImportJobSubmitter {
	s.Email = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *ImportJobSubmitter) SetUserArn(v string) *ImportJobSubmitter {
	s.UserArn = &v
	return s
}

// An object that contains the options specified by the sumitter of the import
// request.
type ImportOptions struct {
	_ struct{} `type:"structure"`

	// Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.
	DelimitedTextOptions *DelimitedTextImportOptions `locationName:"delimitedTextOptions" type:"structure"`

	// Options relating to the destination of the import request.
	DestinationOptions *DestinationOptions `locationName:"destinationOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportOptions"}
	if s.DelimitedTextOptions != nil {
		if err := s.DelimitedTextOptions.Validate(); err != nil {
			invalidParams.AddNested("DelimitedTextOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DestinationOptions != nil {
		if err := s.DestinationOptions.Validate(); err != nil {
			invalidParams.AddNested("DestinationOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelimitedTextOptions sets the DelimitedTextOptions field's value.
func (s *ImportOptions) SetDelimitedTextOptions(v *DelimitedTextImportOptions) *ImportOptions {
	s.DelimitedTextOptions = v
	return s
}

// SetDestinationOptions sets the DestinationOptions field's value.
func (s *ImportOptions) SetDestinationOptions(v *DestinationOptions) *ImportOptions {
	s.DestinationOptions = v
	return s
}

// There were unexpected errors from the server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvokeScreenAutomationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the app that contains the screen automation.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"36" type:"string" required:"true"`

	// The request token for performing the automation action. Request tokens help
	// to identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will return the response
	// of the previous call rather than performing the action again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The row ID for the automation if the automation is defined inside a block
	// with source or list.
	RowId *string `locationName:"rowId" min:"77" type:"string"`

	// The ID of the automation action to be performed.
	//
	// ScreenAutomationId is a required field
	ScreenAutomationId *string `location:"uri" locationName:"automationId" min:"36" type:"string" required:"true"`

	// The ID of the screen that contains the screen automation.
	//
	// ScreenId is a required field
	ScreenId *string `location:"uri" locationName:"screenId" min:"36" type:"string" required:"true"`

	// Variables are specified as a map where the key is the name of the variable
	// as defined on the screen. The value is an object which currently has only
	// one property, rawValue, which holds the value of the variable to be passed
	// to the screen. Any variables defined in a screen are required to be passed
	// in the call.
	//
	// Variables is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InvokeScreenAutomationInput's
	// String and GoString methods.
	Variables map[string]*VariableValue `locationName:"variables" type:"map" sensitive:"true"`

	// The ID of the workbook that contains the screen automation.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeScreenAutomationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeScreenAutomationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeScreenAutomationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeScreenAutomationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 36))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.RowId != nil && len(*s.RowId) < 77 {
		invalidParams.Add(request.NewErrParamMinLen("RowId", 77))
	}
	if s.ScreenAutomationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScreenAutomationId"))
	}
	if s.ScreenAutomationId != nil && len(*s.ScreenAutomationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ScreenAutomationId", 36))
	}
	if s.ScreenId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScreenId"))
	}
	if s.ScreenId != nil && len(*s.ScreenId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ScreenId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *InvokeScreenAutomationInput) SetAppId(v string) *InvokeScreenAutomationInput {
	s.AppId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *InvokeScreenAutomationInput) SetClientRequestToken(v string) *InvokeScreenAutomationInput {
	s.ClientRequestToken = &v
	return s
}

// SetRowId sets the RowId field's value.
func (s *InvokeScreenAutomationInput) SetRowId(v string) *InvokeScreenAutomationInput {
	s.RowId = &v
	return s
}

// SetScreenAutomationId sets the ScreenAutomationId field's value.
func (s *InvokeScreenAutomationInput) SetScreenAutomationId(v string) *InvokeScreenAutomationInput {
	s.ScreenAutomationId = &v
	return s
}

// SetScreenId sets the ScreenId field's value.
func (s *InvokeScreenAutomationInput) SetScreenId(v string) *InvokeScreenAutomationInput {
	s.ScreenId = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *InvokeScreenAutomationInput) SetVariables(v map[string]*VariableValue) *InvokeScreenAutomationInput {
	s.Variables = v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *InvokeScreenAutomationInput) SetWorkbookId(v string) *InvokeScreenAutomationInput {
	s.WorkbookId = &v
	return s
}

type InvokeScreenAutomationOutput struct {
	_ struct{} `type:"structure"`

	// The updated workbook cursor after performing the automation action.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeScreenAutomationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeScreenAutomationOutput) GoString() string {
	return s.String()
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *InvokeScreenAutomationOutput) SetWorkbookCursor(v int64) *InvokeScreenAutomationOutput {
	s.WorkbookCursor = &v
	return s
}

type ListTableColumnsInput struct {
	_ struct{} `type:"structure"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the table whose columns are being retrieved.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook that contains the table whose columns are being retrieved.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableColumnsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableColumnsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTableColumnsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTableColumnsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableColumnsInput) SetNextToken(v string) *ListTableColumnsInput {
	s.NextToken = &v
	return s
}

// SetTableId sets the TableId field's value.
func (s *ListTableColumnsInput) SetTableId(v string) *ListTableColumnsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *ListTableColumnsInput) SetWorkbookId(v string) *ListTableColumnsInput {
	s.WorkbookId = &v
	return s
}

type ListTableColumnsOutput struct {
	_ struct{} `type:"structure"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the request has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of columns in the table.
	//
	// TableColumns is a required field
	TableColumns []*TableColumn `locationName:"tableColumns" type:"list" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this request
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableColumnsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableColumnsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableColumnsOutput) SetNextToken(v string) *ListTableColumnsOutput {
	s.NextToken = &v
	return s
}

// SetTableColumns sets the TableColumns field's value.
func (s *ListTableColumnsOutput) SetTableColumns(v []*TableColumn) *ListTableColumnsOutput {
	s.TableColumns = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *ListTableColumnsOutput) SetWorkbookCursor(v int64) *ListTableColumnsOutput {
	s.WorkbookCursor = &v
	return s
}

type ListTableRowsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of rows to return in each page of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// This parameter is optional. If one or more row ids are specified in this
	// list, then only the specified row ids are returned in the result. If no row
	// ids are specified here, then all the rows in the table are returned.
	RowIds []*string `locationName:"rowIds" min:"1" type:"list"`

	// The ID of the table whose rows are being retrieved.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook that contains the table whose rows are being retrieved.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTableRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTableRowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RowIds != nil && len(s.RowIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RowIds", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTableRowsInput) SetMaxResults(v int64) *ListTableRowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableRowsInput) SetNextToken(v string) *ListTableRowsInput {
	s.NextToken = &v
	return s
}

// SetRowIds sets the RowIds field's value.
func (s *ListTableRowsInput) SetRowIds(v []*string) *ListTableRowsInput {
	s.RowIds = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *ListTableRowsInput) SetTableId(v string) *ListTableRowsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *ListTableRowsInput) SetWorkbookId(v string) *ListTableRowsInput {
	s.WorkbookId = &v
	return s
}

type ListTableRowsOutput struct {
	_ struct{} `type:"structure"`

	// The list of columns in the table whose row data is returned in the result.
	//
	// ColumnIds is a required field
	ColumnIds []*string `locationName:"columnIds" min:"1" type:"list" required:"true"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the request has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of row ids included in the request that were not found in the table.
	RowIdsNotFound []*string `locationName:"rowIdsNotFound" min:"1" type:"list"`

	// The list of rows in the table. Note that this result is paginated, so this
	// list contains a maximum of 100 rows.
	//
	// Rows is a required field
	Rows []*TableRow `locationName:"rows" type:"list" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this request
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRowsOutput) GoString() string {
	return s.String()
}

// SetColumnIds sets the ColumnIds field's value.
func (s *ListTableRowsOutput) SetColumnIds(v []*string) *ListTableRowsOutput {
	s.ColumnIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableRowsOutput) SetNextToken(v string) *ListTableRowsOutput {
	s.NextToken = &v
	return s
}

// SetRowIdsNotFound sets the RowIdsNotFound field's value.
func (s *ListTableRowsOutput) SetRowIdsNotFound(v []*string) *ListTableRowsOutput {
	s.RowIdsNotFound = v
	return s
}

// SetRows sets the Rows field's value.
func (s *ListTableRowsOutput) SetRows(v []*TableRow) *ListTableRowsOutput {
	s.Rows = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *ListTableRowsOutput) SetWorkbookCursor(v int64) *ListTableRowsOutput {
	s.WorkbookCursor = &v
	return s
}

type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tables to return in each page of the results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the workbook whose tables are being retrieved.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTablesInput) SetMaxResults(v int64) *ListTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesInput) SetNextToken(v string) *ListTablesInput {
	s.NextToken = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *ListTablesInput) SetWorkbookId(v string) *ListTablesInput {
	s.WorkbookId = &v
	return s
}

type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the request has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of tables in the workbook.
	//
	// Tables is a required field
	Tables []*Table `locationName:"tables" type:"list" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this request
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesOutput) SetNextToken(v string) *ListTablesOutput {
	s.NextToken = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *ListTablesOutput) SetTables(v []*Table) *ListTablesOutput {
	s.Tables = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *ListTablesOutput) SetWorkbookCursor(v int64) *ListTablesOutput {
	s.WorkbookCursor = &v
	return s
}

type QueryTableRowsInput struct {
	_ struct{} `type:"structure"`

	// An object that represents a filter formula along with the id of the context
	// row under which the filter function needs to evaluate.
	//
	// FilterFormula is a required field
	FilterFormula *Filter `locationName:"filterFormula" type:"structure" required:"true"`

	// The maximum number of rows to return in each page of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the table whose rows are being queried.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// TableId is a required field
	TableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The ID of the workbook whose table rows are being queried.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTableRowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTableRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryTableRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryTableRowsInput"}
	if s.FilterFormula == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterFormula"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TableId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableId"))
	}
	if s.TableId != nil && len(*s.TableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TableId", 36))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.FilterFormula != nil {
		if err := s.FilterFormula.Validate(); err != nil {
			invalidParams.AddNested("FilterFormula", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterFormula sets the FilterFormula field's value.
func (s *QueryTableRowsInput) SetFilterFormula(v *Filter) *QueryTableRowsInput {
	s.FilterFormula = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *QueryTableRowsInput) SetMaxResults(v int64) *QueryTableRowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryTableRowsInput) SetNextToken(v string) *QueryTableRowsInput {
	s.NextToken = &v
	return s
}

// SetTableId sets the TableId field's value.
func (s *QueryTableRowsInput) SetTableId(v string) *QueryTableRowsInput {
	s.TableId = &v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *QueryTableRowsInput) SetWorkbookId(v string) *QueryTableRowsInput {
	s.WorkbookId = &v
	return s
}

type QueryTableRowsOutput struct {
	_ struct{} `type:"structure"`

	// The list of columns in the table whose row data is returned in the result.
	//
	// ColumnIds is a required field
	ColumnIds []*string `locationName:"columnIds" min:"1" type:"list" required:"true"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the request has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of rows in the table that match the query filter.
	//
	// Rows is a required field
	Rows []*TableRow `locationName:"rows" type:"list" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this request
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTableRowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTableRowsOutput) GoString() string {
	return s.String()
}

// SetColumnIds sets the ColumnIds field's value.
func (s *QueryTableRowsOutput) SetColumnIds(v []*string) *QueryTableRowsOutput {
	s.ColumnIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryTableRowsOutput) SetNextToken(v string) *QueryTableRowsOutput {
	s.NextToken = &v
	return s
}

// SetRows sets the Rows field's value.
func (s *QueryTableRowsOutput) SetRows(v []*TableRow) *QueryTableRowsOutput {
	s.Rows = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *QueryTableRowsOutput) SetWorkbookCursor(v int64) *QueryTableRowsOutput {
	s.WorkbookCursor = &v
	return s
}

// The request timed out.
type RequestTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestTimeoutException) GoString() string {
	return s.String()
}

func newErrorRequestTimeoutException(v protocol.ResponseMetadata) error {
	return &RequestTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTimeoutException) Code() string {
	return "RequestTimeoutException"
}

// Message returns the exception's message.
func (s *RequestTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTimeoutException) OrigErr() error {
	return nil
}

func (s *RequestTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A Workbook, Table, App, Screen or Screen Automation was not found with the
// given ID.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A single row in the ResultSet.
type ResultRow struct {
	_ struct{} `type:"structure"`

	// List of all the data cells in a row.
	//
	// DataItems is a required field
	DataItems []*DataItem `locationName:"dataItems" type:"list" required:"true"`

	// The ID for a particular row.
	RowId *string `locationName:"rowId" min:"77" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultRow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultRow) GoString() string {
	return s.String()
}

// SetDataItems sets the DataItems field's value.
func (s *ResultRow) SetDataItems(v []*DataItem) *ResultRow {
	s.DataItems = v
	return s
}

// SetRowId sets the RowId field's value.
func (s *ResultRow) SetRowId(v string) *ResultRow {
	s.RowId = &v
	return s
}

// ResultSet contains the results of the request for a single block or list
// defined on the screen.
type ResultSet struct {
	_ struct{} `type:"structure"`

	// List of headers for all the data cells in the block. The header identifies
	// the name and default format of the data cell. Data cells appear in the same
	// order in all rows as defined in the header. The names and formats are not
	// repeated in the rows. If a particular row does not have a value for a data
	// cell, a blank value is used.
	//
	// For example, a task list that displays the task name, due date and assigned
	// person might have headers [ { "name": "Task Name"}, {"name": "Due Date",
	// "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row
	// in the result will have the task name as the first item, due date as the
	// second item and assigned person as the third item. If a particular task does
	// not have a due date, that row will still have a blank value in the second
	// element and the assigned person will still be in the third element.
	//
	// Headers is a required field
	Headers []*ColumnMetadata `locationName:"headers" type:"list" required:"true"`

	// List of rows returned by the request. Each row has a row Id and a list of
	// data cells in that row. The data cells will be present in the same order
	// as they are defined in the header.
	//
	// Rows is a required field
	Rows []*ResultRow `locationName:"rows" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultSet) GoString() string {
	return s.String()
}

// SetHeaders sets the Headers field's value.
func (s *ResultSet) SetHeaders(v []*ColumnMetadata) *ResultSet {
	s.Headers = v
	return s
}

// SetRows sets the Rows field's value.
func (s *ResultSet) SetRows(v []*ResultRow) *ResultSet {
	s.Rows = v
	return s
}

// The request caused service quota to be breached.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Remote service is unreachable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains the properties for importing data to a specific column
// in a table.
type SourceDataColumnProperties struct {
	_ struct{} `type:"structure"`

	// The index of the column in the input file.
	ColumnIndex *int64 `locationName:"columnIndex" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceDataColumnProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceDataColumnProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceDataColumnProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceDataColumnProperties"}
	if s.ColumnIndex != nil && *s.ColumnIndex < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ColumnIndex", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnIndex sets the ColumnIndex field's value.
func (s *SourceDataColumnProperties) SetColumnIndex(v int64) *SourceDataColumnProperties {
	s.ColumnIndex = &v
	return s
}

type StartTableDataImportJobInput struct {
	_ struct{} `type:"structure"`

	// The request token for performing the update action. Request tokens help to
	// identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will not perform the action
	// again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	//
	// ClientRequestToken is a required field
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string" required:"true"`

	// The format of the data that is being imported. Currently the only option
	// supported is "DELIMITED_TEXT".
	//
	// DataFormat is a required field
	DataFormat *string `locationName:"dataFormat" type:"string" required:"true" enum:"ImportSourceDataFormat"`

	// The source of the data that is being imported. The size of source must be
	// no larger than 100 MB. Source must have no more than 100,000 cells and no
	// more than 1,000 rows.
	//
	// DataSource is a required field
	DataSource *ImportDataSource `locationName:"dataSource" type:"structure" required:"true"`

	// The ID of the table where the rows are being imported.
	//
	// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// DestinationTableId is a required field
	DestinationTableId *string `location:"uri" locationName:"tableId" min:"36" type:"string" required:"true"`

	// The options for customizing this import request.
	//
	// ImportOptions is a required field
	ImportOptions *ImportOptions `locationName:"importOptions" type:"structure" required:"true"`

	// The ID of the workbook where the rows are being imported.
	//
	// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTableDataImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTableDataImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTableDataImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTableDataImportJobInput"}
	if s.ClientRequestToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientRequestToken"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.DataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DataFormat"))
	}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DestinationTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationTableId"))
	}
	if s.DestinationTableId != nil && len(*s.DestinationTableId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationTableId", 36))
	}
	if s.ImportOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportOptions"))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 36))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ImportOptions != nil {
		if err := s.ImportOptions.Validate(); err != nil {
			invalidParams.AddNested("ImportOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTableDataImportJobInput) SetClientRequestToken(v string) *StartTableDataImportJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *StartTableDataImportJobInput) SetDataFormat(v string) *StartTableDataImportJobInput {
	s.DataFormat = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *StartTableDataImportJobInput) SetDataSource(v *ImportDataSource) *StartTableDataImportJobInput {
	s.DataSource = v
	return s
}

// SetDestinationTableId sets the DestinationTableId field's value.
func (s *StartTableDataImportJobInput) SetDestinationTableId(v string) *StartTableDataImportJobInput {
	s.DestinationTableId = &v
	return s
}

// SetImportOptions sets the ImportOptions field's value.
func (s *StartTableDataImportJobInput) SetImportOptions(v *ImportOptions) *StartTableDataImportJobInput {
	s.ImportOptions = v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *StartTableDataImportJobInput) SetWorkbookId(v string) *StartTableDataImportJobInput {
	s.WorkbookId = &v
	return s
}

type StartTableDataImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The id that is assigned to this import job. Future requests to find out the
	// status of this import job need to send this id in the appropriate parameter
	// in the request.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// The status of the import job immediately after submitting the request.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"TableDataImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTableDataImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTableDataImportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTableDataImportJobOutput) SetJobId(v string) *StartTableDataImportJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTableDataImportJobOutput) SetJobStatus(v string) *StartTableDataImportJobOutput {
	s.JobStatus = &v
	return s
}

// An object representing the properties of a table in a workbook.
type Table struct {
	_ struct{} `type:"structure"`

	// The id of the table.
	TableId *string `locationName:"tableId" min:"36" type:"string"`

	// The name of the table.
	TableName *string `locationName:"tableName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) GoString() string {
	return s.String()
}

// SetTableId sets the TableId field's value.
func (s *Table) SetTableId(v string) *Table {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Table) SetTableName(v string) *Table {
	s.TableName = &v
	return s
}

// An object that contains attributes about a single column in a table
type TableColumn struct {
	_ struct{} `type:"structure"`

	// The column level format that is applied in the table. An empty value in this
	// field means that the column format is the default value 'AUTO'.
	Format *string `locationName:"format" type:"string" enum:"Format"`

	// The id of the column in the table.
	TableColumnId *string `locationName:"tableColumnId" min:"36" type:"string"`

	// The name of the column in the table.
	TableColumnName *string `locationName:"tableColumnName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableColumn) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *TableColumn) SetFormat(v string) *TableColumn {
	s.Format = &v
	return s
}

// SetTableColumnId sets the TableColumnId field's value.
func (s *TableColumn) SetTableColumnId(v string) *TableColumn {
	s.TableColumnId = &v
	return s
}

// SetTableColumnName sets the TableColumnName field's value.
func (s *TableColumn) SetTableColumnName(v string) *TableColumn {
	s.TableColumnName = &v
	return s
}

// The metadata associated with the table data import job that was submitted.
type TableDataImportJobMetadata struct {
	_ struct{} `type:"structure"`

	// The source of the data that was submitted for import.
	//
	// DataSource is a required field
	DataSource *ImportDataSource `locationName:"dataSource" type:"structure" required:"true"`

	// The options that was specified at the time of submitting the import request.
	//
	// ImportOptions is a required field
	ImportOptions *ImportOptions `locationName:"importOptions" type:"structure" required:"true"`

	// The timestamp when the job was submitted for import.
	//
	// SubmitTime is a required field
	SubmitTime *time.Time `locationName:"submitTime" type:"timestamp" required:"true"`

	// Details about the submitter of the import request.
	//
	// Submitter is a required field
	Submitter *ImportJobSubmitter `locationName:"submitter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableDataImportJobMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableDataImportJobMetadata) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *TableDataImportJobMetadata) SetDataSource(v *ImportDataSource) *TableDataImportJobMetadata {
	s.DataSource = v
	return s
}

// SetImportOptions sets the ImportOptions field's value.
func (s *TableDataImportJobMetadata) SetImportOptions(v *ImportOptions) *TableDataImportJobMetadata {
	s.ImportOptions = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *TableDataImportJobMetadata) SetSubmitTime(v time.Time) *TableDataImportJobMetadata {
	s.SubmitTime = &v
	return s
}

// SetSubmitter sets the Submitter field's value.
func (s *TableDataImportJobMetadata) SetSubmitter(v *ImportJobSubmitter) *TableDataImportJobMetadata {
	s.Submitter = v
	return s
}

// An object that contains attributes about a single row in a table
type TableRow struct {
	_ struct{} `type:"structure"`

	// A list of cells in the table row. The cells appear in the same order as the
	// columns of the table.
	//
	// Cells is a required field
	Cells []*Cell `locationName:"cells" type:"list" required:"true"`

	// The id of the row in the table.
	//
	// RowId is a required field
	RowId *string `locationName:"rowId" min:"77" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableRow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableRow) GoString() string {
	return s.String()
}

// SetCells sets the Cells field's value.
func (s *TableRow) SetCells(v []*Cell) *TableRow {
	s.Cells = v
	return s
}

// SetRowId sets the RowId field's value.
func (s *TableRow) SetRowId(v string) *TableRow {
	s.RowId = &v
	return s
}

// Tps(transactions per second) rate reached.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Data needed to create a single row in a table as part of the BatchCreateTableRows
// request.
type UpdateRowData struct {
	_ struct{} `type:"structure"`

	// A map representing the cells to update in the given row. The key is the column
	// id of the cell and the value is the CellInput object that represents the
	// data to set in that cell.
	//
	// CellsToUpdate is a required field
	CellsToUpdate map[string]*CellInput `locationName:"cellsToUpdate" min:"1" type:"map" required:"true"`

	// The id of the row that needs to be updated.
	//
	// RowId is a required field
	RowId *string `locationName:"rowId" min:"77" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRowData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRowData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRowData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRowData"}
	if s.CellsToUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("CellsToUpdate"))
	}
	if s.CellsToUpdate != nil && len(s.CellsToUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellsToUpdate", 1))
	}
	if s.RowId == nil {
		invalidParams.Add(request.NewErrParamRequired("RowId"))
	}
	if s.RowId != nil && len(*s.RowId) < 77 {
		invalidParams.Add(request.NewErrParamMinLen("RowId", 77))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCellsToUpdate sets the CellsToUpdate field's value.
func (s *UpdateRowData) SetCellsToUpdate(v map[string]*CellInput) *UpdateRowData {
	s.CellsToUpdate = v
	return s
}

// SetRowId sets the RowId field's value.
func (s *UpdateRowData) SetRowId(v string) *UpdateRowData {
	s.RowId = &v
	return s
}

// Data needed to upsert rows in a table as part of a single item in the BatchUpsertTableRows
// request.
type UpsertRowData struct {
	_ struct{} `type:"structure"`

	// An external identifier that represents a single item in the request that
	// is being upserted as part of the BatchUpsertTableRows request. This can be
	// any string that you can use to identify the item in the request. The BatchUpsertTableRows
	// API puts the batch item id in the results to allow you to link data in the
	// request to data in the results.
	//
	// BatchItemId is a required field
	BatchItemId *string `locationName:"batchItemId" min:"1" type:"string" required:"true"`

	// A map representing the cells to update for the matching rows or an appended
	// row. The key is the column id of the cell and the value is the CellInput
	// object that represents the data to set in that cell.
	//
	// CellsToUpdate is a required field
	CellsToUpdate map[string]*CellInput `locationName:"cellsToUpdate" min:"1" type:"map" required:"true"`

	// The filter formula to use to find existing matching rows to update. The formula
	// needs to return zero or more rows. If the formula returns 0 rows, then a
	// new row will be appended in the target table. If the formula returns one
	// or more rows, then the returned rows will be updated.
	//
	// Note that the filter formula needs to return rows from the target table for
	// the upsert operation to succeed. If the filter formula has a syntax error
	// or it doesn't evaluate to zero or more rows in the target table for any one
	// item in the input list, then the entire BatchUpsertTableRows request fails
	// and no updates are made to the table.
	//
	// Filter is a required field
	Filter *Filter `locationName:"filter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpsertRowData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpsertRowData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpsertRowData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpsertRowData"}
	if s.BatchItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchItemId"))
	}
	if s.BatchItemId != nil && len(*s.BatchItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchItemId", 1))
	}
	if s.CellsToUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("CellsToUpdate"))
	}
	if s.CellsToUpdate != nil && len(s.CellsToUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellsToUpdate", 1))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchItemId sets the BatchItemId field's value.
func (s *UpsertRowData) SetBatchItemId(v string) *UpsertRowData {
	s.BatchItemId = &v
	return s
}

// SetCellsToUpdate sets the CellsToUpdate field's value.
func (s *UpsertRowData) SetCellsToUpdate(v map[string]*CellInput) *UpsertRowData {
	s.CellsToUpdate = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *UpsertRowData) SetFilter(v *Filter) *UpsertRowData {
	s.Filter = v
	return s
}

// An object that represents the result of a single upsert row request.
type UpsertRowsResult struct {
	_ struct{} `type:"structure"`

	// The list of row ids that were changed as part of an upsert row operation.
	// If the upsert resulted in an update, this list could potentially contain
	// multiple rows that matched the filter and hence got updated. If the upsert
	// resulted in an append, this list would only have the single row that was
	// appended.
	//
	// RowIds is a required field
	RowIds []*string `locationName:"rowIds" min:"1" type:"list" required:"true"`

	// The result of the upsert action.
	//
	// UpsertAction is a required field
	UpsertAction *string `locationName:"upsertAction" type:"string" required:"true" enum:"UpsertAction"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpsertRowsResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpsertRowsResult) GoString() string {
	return s.String()
}

// SetRowIds sets the RowIds field's value.
func (s *UpsertRowsResult) SetRowIds(v []*string) *UpsertRowsResult {
	s.RowIds = v
	return s
}

// SetUpsertAction sets the UpsertAction field's value.
func (s *UpsertRowsResult) SetUpsertAction(v string) *UpsertRowsResult {
	s.UpsertAction = &v
	return s
}

// Request is invalid. The message in the response contains details on why the
// request is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input variables to the app to be used by the InvokeScreenAutomation action
// request.
type VariableValue struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Raw value of the variable.
	//
	// RawValue is a required field
	RawValue *string `locationName:"rawValue" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableValue"}
	if s.RawValue == nil {
		invalidParams.Add(request.NewErrParamRequired("RawValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRawValue sets the RawValue field's value.
func (s *VariableValue) SetRawValue(v string) *VariableValue {
	s.RawValue = &v
	return s
}

const (
	// FormatAuto is a Format enum value
	FormatAuto = "AUTO"

	// FormatNumber is a Format enum value
	FormatNumber = "NUMBER"

	// FormatCurrency is a Format enum value
	FormatCurrency = "CURRENCY"

	// FormatDate is a Format enum value
	FormatDate = "DATE"

	// FormatTime is a Format enum value
	FormatTime = "TIME"

	// FormatDateTime is a Format enum value
	FormatDateTime = "DATE_TIME"

	// FormatPercentage is a Format enum value
	FormatPercentage = "PERCENTAGE"

	// FormatText is a Format enum value
	FormatText = "TEXT"

	// FormatAccounting is a Format enum value
	FormatAccounting = "ACCOUNTING"

	// FormatContact is a Format enum value
	FormatContact = "CONTACT"

	// FormatRowlink is a Format enum value
	FormatRowlink = "ROWLINK"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatAuto,
		FormatNumber,
		FormatCurrency,
		FormatDate,
		FormatTime,
		FormatDateTime,
		FormatPercentage,
		FormatText,
		FormatAccounting,
		FormatContact,
		FormatRowlink,
	}
}

const (
	// ImportDataCharacterEncodingUtf8 is a ImportDataCharacterEncoding enum value
	ImportDataCharacterEncodingUtf8 = "UTF-8"

	// ImportDataCharacterEncodingUsAscii is a ImportDataCharacterEncoding enum value
	ImportDataCharacterEncodingUsAscii = "US-ASCII"

	// ImportDataCharacterEncodingIso88591 is a ImportDataCharacterEncoding enum value
	ImportDataCharacterEncodingIso88591 = "ISO-8859-1"

	// ImportDataCharacterEncodingUtf16be is a ImportDataCharacterEncoding enum value
	ImportDataCharacterEncodingUtf16be = "UTF-16BE"

	// ImportDataCharacterEncodingUtf16le is a ImportDataCharacterEncoding enum value
	ImportDataCharacterEncodingUtf16le = "UTF-16LE"

	// ImportDataCharacterEncodingUtf16 is a ImportDataCharacterEncoding enum value
	ImportDataCharacterEncodingUtf16 = "UTF-16"
)

// ImportDataCharacterEncoding_Values returns all elements of the ImportDataCharacterEncoding enum
func ImportDataCharacterEncoding_Values() []string {
	return []string{
		ImportDataCharacterEncodingUtf8,
		ImportDataCharacterEncodingUsAscii,
		ImportDataCharacterEncodingIso88591,
		ImportDataCharacterEncodingUtf16be,
		ImportDataCharacterEncodingUtf16le,
		ImportDataCharacterEncodingUtf16,
	}
}

const (
	// ImportSourceDataFormatDelimitedText is a ImportSourceDataFormat enum value
	ImportSourceDataFormatDelimitedText = "DELIMITED_TEXT"
)

// ImportSourceDataFormat_Values returns all elements of the ImportSourceDataFormat enum
func ImportSourceDataFormat_Values() []string {
	return []string{
		ImportSourceDataFormatDelimitedText,
	}
}

const (
	// TableDataImportJobStatusSubmitted is a TableDataImportJobStatus enum value
	TableDataImportJobStatusSubmitted = "SUBMITTED"

	// TableDataImportJobStatusInProgress is a TableDataImportJobStatus enum value
	TableDataImportJobStatusInProgress = "IN_PROGRESS"

	// TableDataImportJobStatusCompleted is a TableDataImportJobStatus enum value
	TableDataImportJobStatusCompleted = "COMPLETED"

	// TableDataImportJobStatusFailed is a TableDataImportJobStatus enum value
	TableDataImportJobStatusFailed = "FAILED"
)

// TableDataImportJobStatus_Values returns all elements of the TableDataImportJobStatus enum
func TableDataImportJobStatus_Values() []string {
	return []string{
		TableDataImportJobStatusSubmitted,
		TableDataImportJobStatusInProgress,
		TableDataImportJobStatusCompleted,
		TableDataImportJobStatusFailed,
	}
}

const (
	// UpsertActionUpdated is a UpsertAction enum value
	UpsertActionUpdated = "UPDATED"

	// UpsertActionAppended is a UpsertAction enum value
	UpsertActionAppended = "APPENDED"
)

// UpsertAction_Values returns all elements of the UpsertAction enum
func UpsertAction_Values() []string {
	return []string{
		UpsertActionUpdated,
		UpsertActionAppended,
	}
}
