// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3outposts

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/CreateEndpoint
func (c *S3Outposts) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/S3Outposts/CreateEndpoint",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon S3 on Outposts.
//
// Amazon S3 on Outposts Access Points simplify managing data access at scale
// for shared datasets in S3 on Outposts. S3 on Outposts uses endpoints to connect
// to Outposts buckets so that you can perform actions within your virtual private
// cloud (VPC). For more information, see Accessing S3 on Outposts using VPC
// only access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/AccessingS3Outposts.html).
//
// This action creates an endpoint and associates it with the specified Outposts.
//
// It can take up to 5 minutes for this action to complete.
//
// Related actions include:
//
//    * DeleteEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_DeleteEndpoint.html)
//
//    * ListEndpoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_ListEndpoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   There was an exception with the internal server.
//
//   * ValidationException
//   There was an exception validating this data.
//
//   * AccessDeniedException
//   Access was denied for this action.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ConflictException
//   There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/CreateEndpoint
func (c *S3Outposts) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/DeleteEndpoint
func (c *S3Outposts) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/S3Outposts/DeleteEndpoint",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon S3 on Outposts.
//
// Amazon S3 on Outposts Access Points simplify managing data access at scale
// for shared datasets in S3 on Outposts. S3 on Outposts uses endpoints to connect
// to Outposts buckets so that you can perform actions within your virtual private
// cloud (VPC). For more information, see Accessing S3 on Outposts using VPC
// only access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/AccessingS3Outposts.html).
//
// This action deletes an endpoint.
//
// It can take up to 5 minutes for this action to complete.
//
// Related actions include:
//
//    * CreateEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_CreateEndpoint.html)
//
//    * ListEndpoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_ListEndpoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   There was an exception with the internal server.
//
//   * AccessDeniedException
//   Access was denied for this action.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ValidationException
//   There was an exception validating this data.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/DeleteEndpoint
func (c *S3Outposts) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointsRequest method.
//    req, resp := client.ListEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListEndpoints
func (c *S3Outposts) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/S3Outposts/ListEndpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon S3 on Outposts.
//
// Amazon S3 on Outposts Access Points simplify managing data access at scale
// for shared datasets in S3 on Outposts. S3 on Outposts uses endpoints to connect
// to Outposts buckets so that you can perform actions within your virtual private
// cloud (VPC). For more information, see Accessing S3 on Outposts using VPC
// only access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/AccessingS3Outposts.html).
//
// This action lists endpoints associated with the Outposts.
//
// Related actions include:
//
//    * CreateEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_CreateEndpoint.html)
//
//    * DeleteEndpoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_DeleteEndpoint.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon S3 on Outposts's
// API operation ListEndpoints for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   There was an exception with the internal server.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * AccessDeniedException
//   Access was denied for this action.
//
//   * ValidationException
//   There was an exception validating this data.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3outposts-2017-07-25/ListEndpoints
func (c *S3Outposts) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointsPages iterates over the pages of a ListEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpoints operation.
//    pageNum := 0
//    err := client.ListEndpointsPages(params,
//        func(page *s3outposts.ListEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3Outposts) ListEndpointsPages(input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool) error {
	return c.ListEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointsPagesWithContext same as ListEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Outposts) ListEndpointsPagesWithContext(ctx aws.Context, input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// Access was denied for this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a conflict with this action, and it could not be completed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The type of access for the on-premise network connectivity for the Outpost
	// endpoint. To access the endpoint from an on-premises network, you must specify
	// the access type and provide the customer owned IPv4 pool.
	AccessType *string `type:"string" enum:"EndpointAccessType"`

	// The ID of the customer-owned IPv4 pool for the endpoint. IP addresses will
	// be allocated from this pool for the endpoint.
	CustomerOwnedIpv4Pool *string `type:"string"`

	// The ID of the AWS Outposts.
	//
	// OutpostId is a required field
	OutpostId *string `type:"string" required:"true"`

	// The ID of the security group to use with the endpoint.
	//
	// SecurityGroupId is a required field
	SecurityGroupId *string `type:"string" required:"true"`

	// The ID of the subnet in the selected VPC. The endpoint subnet must belong
	// to the Outpost that has the Amazon S3 on Outposts provisioned.
	//
	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.SecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupId"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessType sets the AccessType field's value.
func (s *CreateEndpointInput) SetAccessType(v string) *CreateEndpointInput {
	s.AccessType = &v
	return s
}

// SetCustomerOwnedIpv4Pool sets the CustomerOwnedIpv4Pool field's value.
func (s *CreateEndpointInput) SetCustomerOwnedIpv4Pool(v string) *CreateEndpointInput {
	s.CustomerOwnedIpv4Pool = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *CreateEndpointInput) SetOutpostId(v string) *CreateEndpointInput {
	s.OutpostId = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *CreateEndpointInput) SetSecurityGroupId(v string) *CreateEndpointInput {
	s.SecurityGroupId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateEndpointInput) SetSubnetId(v string) *CreateEndpointInput {
	s.SubnetId = &v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	EndpointArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreateEndpointOutput) SetEndpointArn(v string) *CreateEndpointOutput {
	s.EndpointArn = &v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the endpoint.
	//
	// EndpointId is a required field
	EndpointId *string `location:"querystring" locationName:"endpointId" type:"string" required:"true"`

	// The ID of the AWS Outposts.
	//
	// OutpostId is a required field
	OutpostId *string `location:"querystring" locationName:"outpostId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointId sets the EndpointId field's value.
func (s *DeleteEndpointInput) SetEndpointId(v string) *DeleteEndpointInput {
	s.EndpointId = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *DeleteEndpointInput) SetOutpostId(v string) *DeleteEndpointInput {
	s.OutpostId = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// Amazon S3 on Outposts Access Points simplify managing data access at scale
// for shared datasets in S3 on Outposts. S3 on Outposts uses endpoints to connect
// to Outposts buckets so that you can perform actions within your virtual private
// cloud (VPC). For more information, see Accessing S3 on Outposts using VPC
// only access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/AccessingS3Outposts.html).
type Endpoint struct {
	_ struct{} `type:"structure"`

	AccessType *string `type:"string" enum:"EndpointAccessType"`

	// The VPC CIDR committed by this endpoint.
	CidrBlock *string `type:"string"`

	// The time the endpoint was created.
	CreationTime *time.Time `type:"timestamp"`

	// The ID of the customer-owned IPv4 pool used for the endpoint.
	CustomerOwnedIpv4Pool *string `type:"string"`

	// The Amazon Resource Name (ARN) of the endpoint.
	EndpointArn *string `type:"string"`

	// The network interface of the endpoint.
	NetworkInterfaces []*NetworkInterface `type:"list"`

	// The ID of the AWS Outposts.
	OutpostsId *string `type:"string"`

	// The ID of the security group used for the endpoint.
	SecurityGroupId *string `type:"string"`

	// The status of the endpoint.
	Status *string `type:"string" enum:"EndpointStatus"`

	// The ID of the subnet used for the endpoint.
	SubnetId *string `type:"string"`

	// The ID of the VPC used for the endpoint.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAccessType sets the AccessType field's value.
func (s *Endpoint) SetAccessType(v string) *Endpoint {
	s.AccessType = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *Endpoint) SetCidrBlock(v string) *Endpoint {
	s.CidrBlock = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Endpoint) SetCreationTime(v time.Time) *Endpoint {
	s.CreationTime = &v
	return s
}

// SetCustomerOwnedIpv4Pool sets the CustomerOwnedIpv4Pool field's value.
func (s *Endpoint) SetCustomerOwnedIpv4Pool(v string) *Endpoint {
	s.CustomerOwnedIpv4Pool = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Endpoint) SetEndpointArn(v string) *Endpoint {
	s.EndpointArn = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *Endpoint) SetNetworkInterfaces(v []*NetworkInterface) *Endpoint {
	s.NetworkInterfaces = v
	return s
}

// SetOutpostsId sets the OutpostsId field's value.
func (s *Endpoint) SetOutpostsId(v string) *Endpoint {
	s.OutpostsId = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *Endpoint) SetSecurityGroupId(v string) *Endpoint {
	s.SecurityGroupId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Endpoint) SetStatus(v string) *Endpoint {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Endpoint) SetSubnetId(v string) *Endpoint {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Endpoint) SetVpcId(v string) *Endpoint {
	s.VpcId = &v
	return s
}

// There was an exception with the internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The max number of endpoints that can be returned on the request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The next endpoint requested in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointsInput) SetMaxResults(v int64) *ListEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsInput) SetNextToken(v string) *ListEndpointsInput {
	s.NextToken = &v
	return s
}

type ListEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Returns an array of endpoints associated with AWS Outposts.
	Endpoints []*Endpoint `type:"list"`

	// The next endpoint returned in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListEndpointsOutput) SetEndpoints(v []*Endpoint) *ListEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsOutput) SetNextToken(v string) *ListEndpointsOutput {
	s.NextToken = &v
	return s
}

// The container for the network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID for the network interface.
	NetworkInterfaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *NetworkInterface) SetNetworkInterfaceId(v string) *NetworkInterface {
	s.NetworkInterfaceId = &v
	return s
}

// The requested resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was an exception validating this data.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// EndpointAccessTypePrivate is a EndpointAccessType enum value
	EndpointAccessTypePrivate = "Private"

	// EndpointAccessTypeCustomerOwnedIp is a EndpointAccessType enum value
	EndpointAccessTypeCustomerOwnedIp = "CustomerOwnedIp"
)

// EndpointAccessType_Values returns all elements of the EndpointAccessType enum
func EndpointAccessType_Values() []string {
	return []string{
		EndpointAccessTypePrivate,
		EndpointAccessTypeCustomerOwnedIp,
	}
}

const (
	// EndpointStatusPending is a EndpointStatus enum value
	EndpointStatusPending = "Pending"

	// EndpointStatusAvailable is a EndpointStatus enum value
	EndpointStatusAvailable = "Available"

	// EndpointStatusDeleting is a EndpointStatus enum value
	EndpointStatusDeleting = "Deleting"
)

// EndpointStatus_Values returns all elements of the EndpointStatus enum
func EndpointStatus_Values() []string {
	return []string{
		EndpointStatusPending,
		EndpointStatusAvailable,
		EndpointStatusDeleting,
	}
}
