// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateDiscoverer = "CreateDiscoverer"

// CreateDiscovererRequest generates a "aws/request.Request" representing the
// client's request for the CreateDiscoverer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDiscoverer for more information on using the CreateDiscoverer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiscovererRequest method.
//    req, resp := client.CreateDiscovererRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer
func (c *Schemas) CreateDiscovererRequest(input *CreateDiscovererInput) (req *request.Request, output *CreateDiscovererOutput) {
	op := &request.Operation{
		Name:       opCreateDiscoverer,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/discoverers",
	}

	if input == nil {
		input = &CreateDiscovererInput{}
	}

	output = &CreateDiscovererOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDiscoverer API operation for Schemas.
//
// Creates a discoverer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation CreateDiscoverer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * UnauthorizedException
//
//   * ForbiddenException
//
//   * ServiceUnavailableException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer
func (c *Schemas) CreateDiscoverer(input *CreateDiscovererInput) (*CreateDiscovererOutput, error) {
	req, out := c.CreateDiscovererRequest(input)
	return out, req.Send()
}

// CreateDiscovererWithContext is the same as CreateDiscoverer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDiscoverer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) CreateDiscovererWithContext(ctx aws.Context, input *CreateDiscovererInput, opts ...request.Option) (*CreateDiscovererOutput, error) {
	req, out := c.CreateDiscovererRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegistry = "CreateRegistry"

// CreateRegistryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegistry for more information on using the CreateRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegistryRequest method.
//    req, resp := client.CreateRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateRegistry
func (c *Schemas) CreateRegistryRequest(input *CreateRegistryInput) (req *request.Request, output *CreateRegistryOutput) {
	op := &request.Operation{
		Name:       opCreateRegistry,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/registries/name/{registryName}",
	}

	if input == nil {
		input = &CreateRegistryInput{}
	}

	output = &CreateRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegistry API operation for Schemas.
//
// Creates a registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation CreateRegistry for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * UnauthorizedException
//
//   * ForbiddenException
//
//   * ServiceUnavailableException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateRegistry
func (c *Schemas) CreateRegistry(input *CreateRegistryInput) (*CreateRegistryOutput, error) {
	req, out := c.CreateRegistryRequest(input)
	return out, req.Send()
}

// CreateRegistryWithContext is the same as CreateRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) CreateRegistryWithContext(ctx aws.Context, input *CreateRegistryInput, opts ...request.Option) (*CreateRegistryOutput, error) {
	req, out := c.CreateRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchema = "CreateSchema"

// CreateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchema for more information on using the CreateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSchemaRequest method.
//    req, resp := client.CreateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateSchema
func (c *Schemas) CreateSchemaRequest(input *CreateSchemaInput) (req *request.Request, output *CreateSchemaOutput) {
	op := &request.Operation{
		Name:       opCreateSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
	}

	if input == nil {
		input = &CreateSchemaInput{}
	}

	output = &CreateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchema API operation for Schemas.
//
// Creates a schema definition.
//
// Inactive schemas will be deleted after two years.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation CreateSchema for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateSchema
func (c *Schemas) CreateSchema(input *CreateSchemaInput) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	return out, req.Send()
}

// CreateSchemaWithContext is the same as CreateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) CreateSchemaWithContext(ctx aws.Context, input *CreateSchemaInput, opts ...request.Option) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDiscoverer = "DeleteDiscoverer"

// DeleteDiscovererRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDiscoverer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDiscoverer for more information on using the DeleteDiscoverer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDiscovererRequest method.
//    req, resp := client.DeleteDiscovererRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteDiscoverer
func (c *Schemas) DeleteDiscovererRequest(input *DeleteDiscovererInput) (req *request.Request, output *DeleteDiscovererOutput) {
	op := &request.Operation{
		Name:       opDeleteDiscoverer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/discoverers/id/{discovererId}",
	}

	if input == nil {
		input = &DeleteDiscovererInput{}
	}

	output = &DeleteDiscovererOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDiscoverer API operation for Schemas.
//
// Deletes a discoverer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DeleteDiscoverer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteDiscoverer
func (c *Schemas) DeleteDiscoverer(input *DeleteDiscovererInput) (*DeleteDiscovererOutput, error) {
	req, out := c.DeleteDiscovererRequest(input)
	return out, req.Send()
}

// DeleteDiscovererWithContext is the same as DeleteDiscoverer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDiscoverer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DeleteDiscovererWithContext(ctx aws.Context, input *DeleteDiscovererInput, opts ...request.Option) (*DeleteDiscovererOutput, error) {
	req, out := c.DeleteDiscovererRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegistry = "DeleteRegistry"

// DeleteRegistryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegistry for more information on using the DeleteRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegistryRequest method.
//    req, resp := client.DeleteRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteRegistry
func (c *Schemas) DeleteRegistryRequest(input *DeleteRegistryInput) (req *request.Request, output *DeleteRegistryOutput) {
	op := &request.Operation{
		Name:       opDeleteRegistry,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/registries/name/{registryName}",
	}

	if input == nil {
		input = &DeleteRegistryInput{}
	}

	output = &DeleteRegistryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRegistry API operation for Schemas.
//
// Deletes a Registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DeleteRegistry for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteRegistry
func (c *Schemas) DeleteRegistry(input *DeleteRegistryInput) (*DeleteRegistryOutput, error) {
	req, out := c.DeleteRegistryRequest(input)
	return out, req.Send()
}

// DeleteRegistryWithContext is the same as DeleteRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DeleteRegistryWithContext(ctx aws.Context, input *DeleteRegistryInput, opts ...request.Option) (*DeleteRegistryOutput, error) {
	req, out := c.DeleteRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourcePolicyRequest method.
//    req, resp := client.DeleteResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteResourcePolicy
func (c *Schemas) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/policy",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for Schemas.
//
// Delete the resource-based policy attached to the specified registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteResourcePolicy
func (c *Schemas) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchema = "DeleteSchema"

// DeleteSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchema for more information on using the DeleteSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSchemaRequest method.
//    req, resp := client.DeleteSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema
func (c *Schemas) DeleteSchemaRequest(input *DeleteSchemaInput) (req *request.Request, output *DeleteSchemaOutput) {
	op := &request.Operation{
		Name:       opDeleteSchema,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
	}

	if input == nil {
		input = &DeleteSchemaInput{}
	}

	output = &DeleteSchemaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchema API operation for Schemas.
//
// Delete a schema definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DeleteSchema for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema
func (c *Schemas) DeleteSchema(input *DeleteSchemaInput) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	return out, req.Send()
}

// DeleteSchemaWithContext is the same as DeleteSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DeleteSchemaWithContext(ctx aws.Context, input *DeleteSchemaInput, opts ...request.Option) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchemaVersion = "DeleteSchemaVersion"

// DeleteSchemaVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchemaVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchemaVersion for more information on using the DeleteSchemaVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSchemaVersionRequest method.
//    req, resp := client.DeleteSchemaVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchemaVersion
func (c *Schemas) DeleteSchemaVersionRequest(input *DeleteSchemaVersionInput) (req *request.Request, output *DeleteSchemaVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteSchemaVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}/version/{schemaVersion}",
	}

	if input == nil {
		input = &DeleteSchemaVersionInput{}
	}

	output = &DeleteSchemaVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchemaVersion API operation for Schemas.
//
// Delete the schema version definition
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DeleteSchemaVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchemaVersion
func (c *Schemas) DeleteSchemaVersion(input *DeleteSchemaVersionInput) (*DeleteSchemaVersionOutput, error) {
	req, out := c.DeleteSchemaVersionRequest(input)
	return out, req.Send()
}

// DeleteSchemaVersionWithContext is the same as DeleteSchemaVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchemaVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DeleteSchemaVersionWithContext(ctx aws.Context, input *DeleteSchemaVersionInput, opts ...request.Option) (*DeleteSchemaVersionOutput, error) {
	req, out := c.DeleteSchemaVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCodeBinding = "DescribeCodeBinding"

// DescribeCodeBindingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCodeBinding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCodeBinding for more information on using the DescribeCodeBinding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCodeBindingRequest method.
//    req, resp := client.DescribeCodeBindingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeCodeBinding
func (c *Schemas) DescribeCodeBindingRequest(input *DescribeCodeBindingInput) (req *request.Request, output *DescribeCodeBindingOutput) {
	op := &request.Operation{
		Name:       opDescribeCodeBinding,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}/language/{language}",
	}

	if input == nil {
		input = &DescribeCodeBindingInput{}
	}

	output = &DescribeCodeBindingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCodeBinding API operation for Schemas.
//
// Describe the code binding URI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DescribeCodeBinding for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeCodeBinding
func (c *Schemas) DescribeCodeBinding(input *DescribeCodeBindingInput) (*DescribeCodeBindingOutput, error) {
	req, out := c.DescribeCodeBindingRequest(input)
	return out, req.Send()
}

// DescribeCodeBindingWithContext is the same as DescribeCodeBinding with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCodeBinding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DescribeCodeBindingWithContext(ctx aws.Context, input *DescribeCodeBindingInput, opts ...request.Option) (*DescribeCodeBindingOutput, error) {
	req, out := c.DescribeCodeBindingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDiscoverer = "DescribeDiscoverer"

// DescribeDiscovererRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDiscoverer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDiscoverer for more information on using the DescribeDiscoverer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDiscovererRequest method.
//    req, resp := client.DescribeDiscovererRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeDiscoverer
func (c *Schemas) DescribeDiscovererRequest(input *DescribeDiscovererInput) (req *request.Request, output *DescribeDiscovererOutput) {
	op := &request.Operation{
		Name:       opDescribeDiscoverer,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/discoverers/id/{discovererId}",
	}

	if input == nil {
		input = &DescribeDiscovererInput{}
	}

	output = &DescribeDiscovererOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDiscoverer API operation for Schemas.
//
// Describes the discoverer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DescribeDiscoverer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeDiscoverer
func (c *Schemas) DescribeDiscoverer(input *DescribeDiscovererInput) (*DescribeDiscovererOutput, error) {
	req, out := c.DescribeDiscovererRequest(input)
	return out, req.Send()
}

// DescribeDiscovererWithContext is the same as DescribeDiscoverer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDiscoverer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DescribeDiscovererWithContext(ctx aws.Context, input *DescribeDiscovererInput, opts ...request.Option) (*DescribeDiscovererOutput, error) {
	req, out := c.DescribeDiscovererRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRegistry = "DescribeRegistry"

// DescribeRegistryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRegistry for more information on using the DescribeRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRegistryRequest method.
//    req, resp := client.DescribeRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry
func (c *Schemas) DescribeRegistryRequest(input *DescribeRegistryInput) (req *request.Request, output *DescribeRegistryOutput) {
	op := &request.Operation{
		Name:       opDescribeRegistry,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}",
	}

	if input == nil {
		input = &DescribeRegistryInput{}
	}

	output = &DescribeRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRegistry API operation for Schemas.
//
// Describes the registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DescribeRegistry for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry
func (c *Schemas) DescribeRegistry(input *DescribeRegistryInput) (*DescribeRegistryOutput, error) {
	req, out := c.DescribeRegistryRequest(input)
	return out, req.Send()
}

// DescribeRegistryWithContext is the same as DescribeRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DescribeRegistryWithContext(ctx aws.Context, input *DescribeRegistryInput, opts ...request.Option) (*DescribeRegistryOutput, error) {
	req, out := c.DescribeRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchema = "DescribeSchema"

// DescribeSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchema for more information on using the DescribeSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSchemaRequest method.
//    req, resp := client.DescribeSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeSchema
func (c *Schemas) DescribeSchemaRequest(input *DescribeSchemaInput) (req *request.Request, output *DescribeSchemaOutput) {
	op := &request.Operation{
		Name:       opDescribeSchema,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
	}

	if input == nil {
		input = &DescribeSchemaInput{}
	}

	output = &DescribeSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchema API operation for Schemas.
//
// Retrieve the schema definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation DescribeSchema for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeSchema
func (c *Schemas) DescribeSchema(input *DescribeSchemaInput) (*DescribeSchemaOutput, error) {
	req, out := c.DescribeSchemaRequest(input)
	return out, req.Send()
}

// DescribeSchemaWithContext is the same as DescribeSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) DescribeSchemaWithContext(ctx aws.Context, input *DescribeSchemaInput, opts ...request.Option) (*DescribeSchemaOutput, error) {
	req, out := c.DescribeSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportSchema = "ExportSchema"

// ExportSchemaRequest generates a "aws/request.Request" representing the
// client's request for the ExportSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportSchema for more information on using the ExportSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportSchemaRequest method.
//    req, resp := client.ExportSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ExportSchema
func (c *Schemas) ExportSchemaRequest(input *ExportSchemaInput) (req *request.Request, output *ExportSchemaOutput) {
	op := &request.Operation{
		Name:       opExportSchema,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}/export",
	}

	if input == nil {
		input = &ExportSchemaInput{}
	}

	output = &ExportSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportSchema API operation for Schemas.
//
// Exports a schema to a different specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation ExportSchema for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ExportSchema
func (c *Schemas) ExportSchema(input *ExportSchemaInput) (*ExportSchemaOutput, error) {
	req, out := c.ExportSchemaRequest(input)
	return out, req.Send()
}

// ExportSchemaWithContext is the same as ExportSchema with the addition of
// the ability to pass a context and additional request options.
//
// See ExportSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ExportSchemaWithContext(ctx aws.Context, input *ExportSchemaInput, opts ...request.Option) (*ExportSchemaOutput, error) {
	req, out := c.ExportSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCodeBindingSource = "GetCodeBindingSource"

// GetCodeBindingSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetCodeBindingSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCodeBindingSource for more information on using the GetCodeBindingSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCodeBindingSourceRequest method.
//    req, resp := client.GetCodeBindingSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetCodeBindingSource
func (c *Schemas) GetCodeBindingSourceRequest(input *GetCodeBindingSourceInput) (req *request.Request, output *GetCodeBindingSourceOutput) {
	op := &request.Operation{
		Name:       opGetCodeBindingSource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}/language/{language}/source",
	}

	if input == nil {
		input = &GetCodeBindingSourceInput{}
	}

	output = &GetCodeBindingSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCodeBindingSource API operation for Schemas.
//
// Get the code binding source URI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation GetCodeBindingSource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetCodeBindingSource
func (c *Schemas) GetCodeBindingSource(input *GetCodeBindingSourceInput) (*GetCodeBindingSourceOutput, error) {
	req, out := c.GetCodeBindingSourceRequest(input)
	return out, req.Send()
}

// GetCodeBindingSourceWithContext is the same as GetCodeBindingSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetCodeBindingSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) GetCodeBindingSourceWithContext(ctx aws.Context, input *GetCodeBindingSourceInput, opts ...request.Option) (*GetCodeBindingSourceOutput, error) {
	req, out := c.GetCodeBindingSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiscoveredSchema = "GetDiscoveredSchema"

// GetDiscoveredSchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetDiscoveredSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiscoveredSchema for more information on using the GetDiscoveredSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiscoveredSchemaRequest method.
//    req, resp := client.GetDiscoveredSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema
func (c *Schemas) GetDiscoveredSchemaRequest(input *GetDiscoveredSchemaInput) (req *request.Request, output *GetDiscoveredSchemaOutput) {
	op := &request.Operation{
		Name:       opGetDiscoveredSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/discover",
	}

	if input == nil {
		input = &GetDiscoveredSchemaInput{}
	}

	output = &GetDiscoveredSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiscoveredSchema API operation for Schemas.
//
// Get the discovered schema that was generated based on sampled events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation GetDiscoveredSchema for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema
func (c *Schemas) GetDiscoveredSchema(input *GetDiscoveredSchemaInput) (*GetDiscoveredSchemaOutput, error) {
	req, out := c.GetDiscoveredSchemaRequest(input)
	return out, req.Send()
}

// GetDiscoveredSchemaWithContext is the same as GetDiscoveredSchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiscoveredSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) GetDiscoveredSchemaWithContext(ctx aws.Context, input *GetDiscoveredSchemaInput, opts ...request.Option) (*GetDiscoveredSchemaOutput, error) {
	req, out := c.GetDiscoveredSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcePolicyRequest method.
//    req, resp := client.GetResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetResourcePolicy
func (c *Schemas) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/policy",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for Schemas.
//
// Retrieves the resource-based policy attached to a given registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetResourcePolicy
func (c *Schemas) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDiscoverers = "ListDiscoverers"

// ListDiscoverersRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoverers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoverers for more information on using the ListDiscoverers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDiscoverersRequest method.
//    req, resp := client.ListDiscoverersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers
func (c *Schemas) ListDiscoverersRequest(input *ListDiscoverersInput) (req *request.Request, output *ListDiscoverersOutput) {
	op := &request.Operation{
		Name:       opListDiscoverers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/discoverers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDiscoverersInput{}
	}

	output = &ListDiscoverersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDiscoverers API operation for Schemas.
//
// List the discoverers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation ListDiscoverers for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers
func (c *Schemas) ListDiscoverers(input *ListDiscoverersInput) (*ListDiscoverersOutput, error) {
	req, out := c.ListDiscoverersRequest(input)
	return out, req.Send()
}

// ListDiscoverersWithContext is the same as ListDiscoverers with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoverers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListDiscoverersWithContext(ctx aws.Context, input *ListDiscoverersInput, opts ...request.Option) (*ListDiscoverersOutput, error) {
	req, out := c.ListDiscoverersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDiscoverersPages iterates over the pages of a ListDiscoverers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDiscoverers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDiscoverers operation.
//    pageNum := 0
//    err := client.ListDiscoverersPages(params,
//        func(page *schemas.ListDiscoverersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Schemas) ListDiscoverersPages(input *ListDiscoverersInput, fn func(*ListDiscoverersOutput, bool) bool) error {
	return c.ListDiscoverersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDiscoverersPagesWithContext same as ListDiscoverersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListDiscoverersPagesWithContext(ctx aws.Context, input *ListDiscoverersInput, fn func(*ListDiscoverersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDiscoverersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDiscoverersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDiscoverersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRegistries = "ListRegistries"

// ListRegistriesRequest generates a "aws/request.Request" representing the
// client's request for the ListRegistries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegistries for more information on using the ListRegistries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegistriesRequest method.
//    req, resp := client.ListRegistriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries
func (c *Schemas) ListRegistriesRequest(input *ListRegistriesInput) (req *request.Request, output *ListRegistriesOutput) {
	op := &request.Operation{
		Name:       opListRegistries,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRegistriesInput{}
	}

	output = &ListRegistriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegistries API operation for Schemas.
//
// List the registries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation ListRegistries for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries
func (c *Schemas) ListRegistries(input *ListRegistriesInput) (*ListRegistriesOutput, error) {
	req, out := c.ListRegistriesRequest(input)
	return out, req.Send()
}

// ListRegistriesWithContext is the same as ListRegistries with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegistries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListRegistriesWithContext(ctx aws.Context, input *ListRegistriesInput, opts ...request.Option) (*ListRegistriesOutput, error) {
	req, out := c.ListRegistriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRegistriesPages iterates over the pages of a ListRegistries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRegistries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRegistries operation.
//    pageNum := 0
//    err := client.ListRegistriesPages(params,
//        func(page *schemas.ListRegistriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Schemas) ListRegistriesPages(input *ListRegistriesInput, fn func(*ListRegistriesOutput, bool) bool) error {
	return c.ListRegistriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRegistriesPagesWithContext same as ListRegistriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListRegistriesPagesWithContext(ctx aws.Context, input *ListRegistriesInput, fn func(*ListRegistriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRegistriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRegistriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRegistriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemaVersions = "ListSchemaVersions"

// ListSchemaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemaVersions for more information on using the ListSchemaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchemaVersionsRequest method.
//    req, resp := client.ListSchemaVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions
func (c *Schemas) ListSchemaVersionsRequest(input *ListSchemaVersionsInput) (req *request.Request, output *ListSchemaVersionsOutput) {
	op := &request.Operation{
		Name:       opListSchemaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemaVersionsInput{}
	}

	output = &ListSchemaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemaVersions API operation for Schemas.
//
// Provides a list of the schema versions and related information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation ListSchemaVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions
func (c *Schemas) ListSchemaVersions(input *ListSchemaVersionsInput) (*ListSchemaVersionsOutput, error) {
	req, out := c.ListSchemaVersionsRequest(input)
	return out, req.Send()
}

// ListSchemaVersionsWithContext is the same as ListSchemaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListSchemaVersionsWithContext(ctx aws.Context, input *ListSchemaVersionsInput, opts ...request.Option) (*ListSchemaVersionsOutput, error) {
	req, out := c.ListSchemaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemaVersionsPages iterates over the pages of a ListSchemaVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemaVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSchemaVersions operation.
//    pageNum := 0
//    err := client.ListSchemaVersionsPages(params,
//        func(page *schemas.ListSchemaVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Schemas) ListSchemaVersionsPages(input *ListSchemaVersionsInput, fn func(*ListSchemaVersionsOutput, bool) bool) error {
	return c.ListSchemaVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemaVersionsPagesWithContext same as ListSchemaVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListSchemaVersionsPagesWithContext(ctx aws.Context, input *ListSchemaVersionsInput, fn func(*ListSchemaVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemaVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemaVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemaVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemas = "ListSchemas"

// ListSchemasRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemas for more information on using the ListSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchemasRequest method.
//    req, resp := client.ListSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas
func (c *Schemas) ListSchemasRequest(input *ListSchemasInput) (req *request.Request, output *ListSchemasOutput) {
	op := &request.Operation{
		Name:       opListSchemas,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemasInput{}
	}

	output = &ListSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemas API operation for Schemas.
//
// List the schemas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation ListSchemas for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas
func (c *Schemas) ListSchemas(input *ListSchemasInput) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	return out, req.Send()
}

// ListSchemasWithContext is the same as ListSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListSchemasWithContext(ctx aws.Context, input *ListSchemasInput, opts ...request.Option) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemasPages iterates over the pages of a ListSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSchemas operation.
//    pageNum := 0
//    err := client.ListSchemasPages(params,
//        func(page *schemas.ListSchemasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Schemas) ListSchemasPages(input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool) error {
	return c.ListSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemasPagesWithContext same as ListSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListSchemasPagesWithContext(ctx aws.Context, input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListTagsForResource
func (c *Schemas) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Schemas.
//
// Get tags for resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListTagsForResource
func (c *Schemas) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutCodeBinding = "PutCodeBinding"

// PutCodeBindingRequest generates a "aws/request.Request" representing the
// client's request for the PutCodeBinding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutCodeBinding for more information on using the PutCodeBinding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutCodeBindingRequest method.
//    req, resp := client.PutCodeBindingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutCodeBinding
func (c *Schemas) PutCodeBindingRequest(input *PutCodeBindingInput) (req *request.Request, output *PutCodeBindingOutput) {
	op := &request.Operation{
		Name:       opPutCodeBinding,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}/language/{language}",
	}

	if input == nil {
		input = &PutCodeBindingInput{}
	}

	output = &PutCodeBindingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutCodeBinding API operation for Schemas.
//
// Put code binding URI
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation PutCodeBinding for usage and error information.
//
// Returned Error Types:
//   * GoneException
//
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutCodeBinding
func (c *Schemas) PutCodeBinding(input *PutCodeBindingInput) (*PutCodeBindingOutput, error) {
	req, out := c.PutCodeBindingRequest(input)
	return out, req.Send()
}

// PutCodeBindingWithContext is the same as PutCodeBinding with the addition of
// the ability to pass a context and additional request options.
//
// See PutCodeBinding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) PutCodeBindingWithContext(ctx aws.Context, input *PutCodeBindingInput, opts ...request.Option) (*PutCodeBindingOutput, error) {
	req, out := c.PutCodeBindingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourcePolicyRequest method.
//    req, resp := client.PutResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutResourcePolicy
func (c *Schemas) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/policy",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for Schemas.
//
// The name of the policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * PreconditionFailedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutResourcePolicy
func (c *Schemas) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchSchemas = "SearchSchemas"

// SearchSchemasRequest generates a "aws/request.Request" representing the
// client's request for the SearchSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSchemas for more information on using the SearchSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchSchemasRequest method.
//    req, resp := client.SearchSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas
func (c *Schemas) SearchSchemasRequest(input *SearchSchemasInput) (req *request.Request, output *SearchSchemasOutput) {
	op := &request.Operation{
		Name:       opSearchSchemas,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSchemasInput{}
	}

	output = &SearchSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSchemas API operation for Schemas.
//
// Search the schemas
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation SearchSchemas for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas
func (c *Schemas) SearchSchemas(input *SearchSchemasInput) (*SearchSchemasOutput, error) {
	req, out := c.SearchSchemasRequest(input)
	return out, req.Send()
}

// SearchSchemasWithContext is the same as SearchSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) SearchSchemasWithContext(ctx aws.Context, input *SearchSchemasInput, opts ...request.Option) (*SearchSchemasOutput, error) {
	req, out := c.SearchSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSchemasPages iterates over the pages of a SearchSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchSchemas operation.
//    pageNum := 0
//    err := client.SearchSchemasPages(params,
//        func(page *schemas.SearchSchemasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Schemas) SearchSchemasPages(input *SearchSchemasInput, fn func(*SearchSchemasOutput, bool) bool) error {
	return c.SearchSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSchemasPagesWithContext same as SearchSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) SearchSchemasPagesWithContext(ctx aws.Context, input *SearchSchemasInput, fn func(*SearchSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartDiscoverer = "StartDiscoverer"

// StartDiscovererRequest generates a "aws/request.Request" representing the
// client's request for the StartDiscoverer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDiscoverer for more information on using the StartDiscoverer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDiscovererRequest method.
//    req, resp := client.StartDiscovererRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StartDiscoverer
func (c *Schemas) StartDiscovererRequest(input *StartDiscovererInput) (req *request.Request, output *StartDiscovererOutput) {
	op := &request.Operation{
		Name:       opStartDiscoverer,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/discoverers/id/{discovererId}/start",
	}

	if input == nil {
		input = &StartDiscovererInput{}
	}

	output = &StartDiscovererOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDiscoverer API operation for Schemas.
//
// Starts the discoverer
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation StartDiscoverer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StartDiscoverer
func (c *Schemas) StartDiscoverer(input *StartDiscovererInput) (*StartDiscovererOutput, error) {
	req, out := c.StartDiscovererRequest(input)
	return out, req.Send()
}

// StartDiscovererWithContext is the same as StartDiscoverer with the addition of
// the ability to pass a context and additional request options.
//
// See StartDiscoverer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) StartDiscovererWithContext(ctx aws.Context, input *StartDiscovererInput, opts ...request.Option) (*StartDiscovererOutput, error) {
	req, out := c.StartDiscovererRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDiscoverer = "StopDiscoverer"

// StopDiscovererRequest generates a "aws/request.Request" representing the
// client's request for the StopDiscoverer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDiscoverer for more information on using the StopDiscoverer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDiscovererRequest method.
//    req, resp := client.StopDiscovererRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer
func (c *Schemas) StopDiscovererRequest(input *StopDiscovererInput) (req *request.Request, output *StopDiscovererOutput) {
	op := &request.Operation{
		Name:       opStopDiscoverer,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/discoverers/id/{discovererId}/stop",
	}

	if input == nil {
		input = &StopDiscovererInput{}
	}

	output = &StopDiscovererOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDiscoverer API operation for Schemas.
//
// Stops the discoverer
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation StopDiscoverer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer
func (c *Schemas) StopDiscoverer(input *StopDiscovererInput) (*StopDiscovererOutput, error) {
	req, out := c.StopDiscovererRequest(input)
	return out, req.Send()
}

// StopDiscovererWithContext is the same as StopDiscoverer with the addition of
// the ability to pass a context and additional request options.
//
// See StopDiscoverer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) StopDiscovererWithContext(ctx aws.Context, input *StopDiscovererInput, opts ...request.Option) (*StopDiscovererOutput, error) {
	req, out := c.StopDiscovererRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/TagResource
func (c *Schemas) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Schemas.
//
// Add tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/TagResource
func (c *Schemas) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UntagResource
func (c *Schemas) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Schemas.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UntagResource
func (c *Schemas) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDiscoverer = "UpdateDiscoverer"

// UpdateDiscovererRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDiscoverer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDiscoverer for more information on using the UpdateDiscoverer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDiscovererRequest method.
//    req, resp := client.UpdateDiscovererRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateDiscoverer
func (c *Schemas) UpdateDiscovererRequest(input *UpdateDiscovererInput) (req *request.Request, output *UpdateDiscovererOutput) {
	op := &request.Operation{
		Name:       opUpdateDiscoverer,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/discoverers/id/{discovererId}",
	}

	if input == nil {
		input = &UpdateDiscovererInput{}
	}

	output = &UpdateDiscovererOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDiscoverer API operation for Schemas.
//
// Updates the discoverer
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation UpdateDiscoverer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateDiscoverer
func (c *Schemas) UpdateDiscoverer(input *UpdateDiscovererInput) (*UpdateDiscovererOutput, error) {
	req, out := c.UpdateDiscovererRequest(input)
	return out, req.Send()
}

// UpdateDiscovererWithContext is the same as UpdateDiscoverer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDiscoverer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) UpdateDiscovererWithContext(ctx aws.Context, input *UpdateDiscovererInput, opts ...request.Option) (*UpdateDiscovererOutput, error) {
	req, out := c.UpdateDiscovererRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegistry = "UpdateRegistry"

// UpdateRegistryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegistry for more information on using the UpdateRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegistryRequest method.
//    req, resp := client.UpdateRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry
func (c *Schemas) UpdateRegistryRequest(input *UpdateRegistryInput) (req *request.Request, output *UpdateRegistryOutput) {
	op := &request.Operation{
		Name:       opUpdateRegistry,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/registries/name/{registryName}",
	}

	if input == nil {
		input = &UpdateRegistryInput{}
	}

	output = &UpdateRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegistry API operation for Schemas.
//
// Updates a registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation UpdateRegistry for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnauthorizedException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry
func (c *Schemas) UpdateRegistry(input *UpdateRegistryInput) (*UpdateRegistryOutput, error) {
	req, out := c.UpdateRegistryRequest(input)
	return out, req.Send()
}

// UpdateRegistryWithContext is the same as UpdateRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) UpdateRegistryWithContext(ctx aws.Context, input *UpdateRegistryInput, opts ...request.Option) (*UpdateRegistryOutput, error) {
	req, out := c.UpdateRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchema = "UpdateSchema"

// UpdateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchema for more information on using the UpdateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSchemaRequest method.
//    req, resp := client.UpdateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema
func (c *Schemas) UpdateSchemaRequest(input *UpdateSchemaInput) (req *request.Request, output *UpdateSchemaOutput) {
	op := &request.Operation{
		Name:       opUpdateSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
	}

	if input == nil {
		input = &UpdateSchemaInput{}
	}

	output = &UpdateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSchema API operation for Schemas.
//
// Updates the schema definition
//
// Inactive schemas will be deleted after two years.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Schemas's
// API operation UpdateSchema for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema
func (c *Schemas) UpdateSchema(input *UpdateSchemaInput) (*UpdateSchemaOutput, error) {
	req, out := c.UpdateSchemaRequest(input)
	return out, req.Send()
}

// UpdateSchemaWithContext is the same as UpdateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Schemas) UpdateSchemaWithContext(ctx aws.Context, input *UpdateSchemaInput, opts ...request.Option) (*UpdateSchemaOutput, error) {
	req, out := c.UpdateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDiscovererInput struct {
	_ struct{} `type:"structure"`

	CrossAccount *bool `type:"boolean"`

	Description *string `type:"string"`

	// SourceArn is a required field
	SourceArn *string `min:"20" type:"string" required:"true"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDiscovererInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiscovererInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiscovererInput"}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossAccount sets the CrossAccount field's value.
func (s *CreateDiscovererInput) SetCrossAccount(v bool) *CreateDiscovererInput {
	s.CrossAccount = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDiscovererInput) SetDescription(v string) *CreateDiscovererInput {
	s.Description = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateDiscovererInput) SetSourceArn(v string) *CreateDiscovererInput {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDiscovererInput) SetTags(v map[string]*string) *CreateDiscovererInput {
	s.Tags = v
	return s
}

type CreateDiscovererOutput struct {
	_ struct{} `type:"structure"`

	CrossAccount *bool `type:"boolean"`

	Description *string `type:"string"`

	DiscovererArn *string `type:"string"`

	DiscovererId *string `type:"string"`

	SourceArn *string `type:"string"`

	State *string `type:"string" enum:"DiscovererState"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDiscovererOutput) GoString() string {
	return s.String()
}

// SetCrossAccount sets the CrossAccount field's value.
func (s *CreateDiscovererOutput) SetCrossAccount(v bool) *CreateDiscovererOutput {
	s.CrossAccount = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDiscovererOutput) SetDescription(v string) *CreateDiscovererOutput {
	s.Description = &v
	return s
}

// SetDiscovererArn sets the DiscovererArn field's value.
func (s *CreateDiscovererOutput) SetDiscovererArn(v string) *CreateDiscovererOutput {
	s.DiscovererArn = &v
	return s
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *CreateDiscovererOutput) SetDiscovererId(v string) *CreateDiscovererOutput {
	s.DiscovererId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateDiscovererOutput) SetSourceArn(v string) *CreateDiscovererOutput {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateDiscovererOutput) SetState(v string) *CreateDiscovererOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDiscovererOutput) SetTags(v map[string]*string) *CreateDiscovererOutput {
	s.Tags = v
	return s
}

type CreateRegistryInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRegistryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRegistryInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRegistryInput) SetDescription(v string) *CreateRegistryInput {
	s.Description = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *CreateRegistryInput) SetRegistryName(v string) *CreateRegistryInput {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRegistryInput) SetTags(v map[string]*string) *CreateRegistryInput {
	s.Tags = v
	return s
}

type CreateRegistryOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	RegistryArn *string `type:"string"`

	RegistryName *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateRegistryOutput) SetDescription(v string) *CreateRegistryOutput {
	s.Description = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *CreateRegistryOutput) SetRegistryArn(v string) *CreateRegistryOutput {
	s.RegistryArn = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *CreateRegistryOutput) SetRegistryName(v string) *CreateRegistryOutput {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRegistryOutput) SetTags(v map[string]*string) *CreateRegistryOutput {
	s.Tags = v
	return s
}

type CreateSchemaInput struct {
	_ struct{} `type:"structure"`

	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	Description *string `type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreateSchemaInput) SetContent(v string) *CreateSchemaInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaInput) SetDescription(v string) *CreateSchemaInput {
	s.Description = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *CreateSchemaInput) SetRegistryName(v string) *CreateSchemaInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaInput) SetSchemaName(v string) *CreateSchemaInput {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchemaInput) SetTags(v map[string]*string) *CreateSchemaInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateSchemaInput) SetType(v string) *CreateSchemaInput {
	s.Type = &v
	return s
}

type CreateSchemaOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	SchemaArn *string `type:"string"`

	SchemaName *string `type:"string"`

	SchemaVersion *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	Type *string `type:"string"`

	VersionCreatedDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaOutput) SetDescription(v string) *CreateSchemaOutput {
	s.Description = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CreateSchemaOutput) SetLastModified(v time.Time) *CreateSchemaOutput {
	s.LastModified = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaOutput) SetSchemaArn(v string) *CreateSchemaOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaOutput) SetSchemaName(v string) *CreateSchemaOutput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *CreateSchemaOutput) SetSchemaVersion(v string) *CreateSchemaOutput {
	s.SchemaVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchemaOutput) SetTags(v map[string]*string) *CreateSchemaOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateSchemaOutput) SetType(v string) *CreateSchemaOutput {
	s.Type = &v
	return s
}

// SetVersionCreatedDate sets the VersionCreatedDate field's value.
func (s *CreateSchemaOutput) SetVersionCreatedDate(v time.Time) *CreateSchemaOutput {
	s.VersionCreatedDate = &v
	return s
}

type DeleteDiscovererInput struct {
	_ struct{} `type:"structure"`

	// DiscovererId is a required field
	DiscovererId *string `location:"uri" locationName:"discovererId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDiscovererInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDiscovererInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDiscovererInput"}
	if s.DiscovererId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscovererId"))
	}
	if s.DiscovererId != nil && len(*s.DiscovererId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiscovererId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *DeleteDiscovererInput) SetDiscovererId(v string) *DeleteDiscovererInput {
	s.DiscovererId = &v
	return s
}

type DeleteDiscovererOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDiscovererOutput) GoString() string {
	return s.String()
}

type DeleteRegistryInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRegistryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRegistryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRegistryInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryName sets the RegistryName field's value.
func (s *DeleteRegistryInput) SetRegistryName(v string) *DeleteRegistryInput {
	s.RegistryName = &v
	return s
}

type DeleteRegistryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRegistryOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	RegistryName *string `location:"querystring" locationName:"registryName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// SetRegistryName sets the RegistryName field's value.
func (s *DeleteResourcePolicyInput) SetRegistryName(v string) *DeleteResourcePolicyInput {
	s.RegistryName = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteSchemaInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryName sets the RegistryName field's value.
func (s *DeleteSchemaInput) SetRegistryName(v string) *DeleteSchemaInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *DeleteSchemaInput) SetSchemaName(v string) *DeleteSchemaInput {
	s.SchemaName = &v
	return s
}

type DeleteSchemaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaOutput) GoString() string {
	return s.String()
}

type DeleteSchemaVersionInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	// SchemaVersion is a required field
	SchemaVersion *string `location:"uri" locationName:"schemaVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaVersionInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}
	if s.SchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaVersion"))
	}
	if s.SchemaVersion != nil && len(*s.SchemaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryName sets the RegistryName field's value.
func (s *DeleteSchemaVersionInput) SetRegistryName(v string) *DeleteSchemaVersionInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *DeleteSchemaVersionInput) SetSchemaName(v string) *DeleteSchemaVersionInput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DeleteSchemaVersionInput) SetSchemaVersion(v string) *DeleteSchemaVersionInput {
	s.SchemaVersion = &v
	return s
}

type DeleteSchemaVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaVersionOutput) GoString() string {
	return s.String()
}

type DescribeCodeBindingInput struct {
	_ struct{} `type:"structure"`

	// Language is a required field
	Language *string `location:"uri" locationName:"language" type:"string" required:"true"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	SchemaVersion *string `location:"querystring" locationName:"schemaVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCodeBindingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCodeBindingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCodeBindingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCodeBindingInput"}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Language != nil && len(*s.Language) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 1))
	}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguage sets the Language field's value.
func (s *DescribeCodeBindingInput) SetLanguage(v string) *DescribeCodeBindingInput {
	s.Language = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *DescribeCodeBindingInput) SetRegistryName(v string) *DescribeCodeBindingInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *DescribeCodeBindingInput) SetSchemaName(v string) *DescribeCodeBindingInput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DescribeCodeBindingInput) SetSchemaVersion(v string) *DescribeCodeBindingInput {
	s.SchemaVersion = &v
	return s
}

type DescribeCodeBindingOutput struct {
	_ struct{} `type:"structure"`

	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	SchemaVersion *string `type:"string"`

	Status *string `type:"string" enum:"CodeGenerationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCodeBindingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCodeBindingOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeCodeBindingOutput) SetCreationDate(v time.Time) *DescribeCodeBindingOutput {
	s.CreationDate = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DescribeCodeBindingOutput) SetLastModified(v time.Time) *DescribeCodeBindingOutput {
	s.LastModified = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DescribeCodeBindingOutput) SetSchemaVersion(v string) *DescribeCodeBindingOutput {
	s.SchemaVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeCodeBindingOutput) SetStatus(v string) *DescribeCodeBindingOutput {
	s.Status = &v
	return s
}

type DescribeDiscovererInput struct {
	_ struct{} `type:"structure"`

	// DiscovererId is a required field
	DiscovererId *string `location:"uri" locationName:"discovererId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscovererInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDiscovererInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDiscovererInput"}
	if s.DiscovererId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscovererId"))
	}
	if s.DiscovererId != nil && len(*s.DiscovererId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiscovererId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *DescribeDiscovererInput) SetDiscovererId(v string) *DescribeDiscovererInput {
	s.DiscovererId = &v
	return s
}

type DescribeDiscovererOutput struct {
	_ struct{} `type:"structure"`

	CrossAccount *bool `type:"boolean"`

	Description *string `type:"string"`

	DiscovererArn *string `type:"string"`

	DiscovererId *string `type:"string"`

	SourceArn *string `type:"string"`

	State *string `type:"string" enum:"DiscovererState"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDiscovererOutput) GoString() string {
	return s.String()
}

// SetCrossAccount sets the CrossAccount field's value.
func (s *DescribeDiscovererOutput) SetCrossAccount(v bool) *DescribeDiscovererOutput {
	s.CrossAccount = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeDiscovererOutput) SetDescription(v string) *DescribeDiscovererOutput {
	s.Description = &v
	return s
}

// SetDiscovererArn sets the DiscovererArn field's value.
func (s *DescribeDiscovererOutput) SetDiscovererArn(v string) *DescribeDiscovererOutput {
	s.DiscovererArn = &v
	return s
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *DescribeDiscovererOutput) SetDiscovererId(v string) *DescribeDiscovererOutput {
	s.DiscovererId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *DescribeDiscovererOutput) SetSourceArn(v string) *DescribeDiscovererOutput {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeDiscovererOutput) SetState(v string) *DescribeDiscovererOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDiscovererOutput) SetTags(v map[string]*string) *DescribeDiscovererOutput {
	s.Tags = v
	return s
}

type DescribeRegistryInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRegistryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRegistryInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryName sets the RegistryName field's value.
func (s *DescribeRegistryInput) SetRegistryName(v string) *DescribeRegistryInput {
	s.RegistryName = &v
	return s
}

type DescribeRegistryOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	RegistryArn *string `type:"string"`

	RegistryName *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistryOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeRegistryOutput) SetDescription(v string) *DescribeRegistryOutput {
	s.Description = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *DescribeRegistryOutput) SetRegistryArn(v string) *DescribeRegistryOutput {
	s.RegistryArn = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *DescribeRegistryOutput) SetRegistryName(v string) *DescribeRegistryOutput {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRegistryOutput) SetTags(v map[string]*string) *DescribeRegistryOutput {
	s.Tags = v
	return s
}

type DescribeSchemaInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	SchemaVersion *string `location:"querystring" locationName:"schemaVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemaInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryName sets the RegistryName field's value.
func (s *DescribeSchemaInput) SetRegistryName(v string) *DescribeSchemaInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *DescribeSchemaInput) SetSchemaName(v string) *DescribeSchemaInput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DescribeSchemaInput) SetSchemaVersion(v string) *DescribeSchemaInput {
	s.SchemaVersion = &v
	return s
}

type DescribeSchemaOutput struct {
	_ struct{} `type:"structure"`

	Content *string `type:"string"`

	Description *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	SchemaArn *string `type:"string"`

	SchemaName *string `type:"string"`

	SchemaVersion *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	Type *string `type:"string"`

	VersionCreatedDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *DescribeSchemaOutput) SetContent(v string) *DescribeSchemaOutput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSchemaOutput) SetDescription(v string) *DescribeSchemaOutput {
	s.Description = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DescribeSchemaOutput) SetLastModified(v time.Time) *DescribeSchemaOutput {
	s.LastModified = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DescribeSchemaOutput) SetSchemaArn(v string) *DescribeSchemaOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *DescribeSchemaOutput) SetSchemaName(v string) *DescribeSchemaOutput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DescribeSchemaOutput) SetSchemaVersion(v string) *DescribeSchemaOutput {
	s.SchemaVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSchemaOutput) SetTags(v map[string]*string) *DescribeSchemaOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeSchemaOutput) SetType(v string) *DescribeSchemaOutput {
	s.Type = &v
	return s
}

// SetVersionCreatedDate sets the VersionCreatedDate field's value.
func (s *DescribeSchemaOutput) SetVersionCreatedDate(v time.Time) *DescribeSchemaOutput {
	s.VersionCreatedDate = &v
	return s
}

type DiscovererSummary struct {
	_ struct{} `type:"structure"`

	// The Status if the discoverer will discover schemas from events sent from
	// another account.
	CrossAccount *bool `type:"boolean"`

	// The ARN of the discoverer.
	DiscovererArn *string `type:"string"`

	// The ID of the discoverer.
	DiscovererId *string `type:"string"`

	// The ARN of the event bus.
	SourceArn *string `type:"string"`

	// The state of the discoverer.
	State *string `type:"string" enum:"DiscovererState"`

	// Tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscovererSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscovererSummary) GoString() string {
	return s.String()
}

// SetCrossAccount sets the CrossAccount field's value.
func (s *DiscovererSummary) SetCrossAccount(v bool) *DiscovererSummary {
	s.CrossAccount = &v
	return s
}

// SetDiscovererArn sets the DiscovererArn field's value.
func (s *DiscovererSummary) SetDiscovererArn(v string) *DiscovererSummary {
	s.DiscovererArn = &v
	return s
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *DiscovererSummary) SetDiscovererId(v string) *DiscovererSummary {
	s.DiscovererId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *DiscovererSummary) SetSourceArn(v string) *DiscovererSummary {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DiscovererSummary) SetState(v string) *DiscovererSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DiscovererSummary) SetTags(v map[string]*string) *DiscovererSummary {
	s.Tags = v
	return s
}

type ExportSchemaInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	SchemaVersion *string `location:"querystring" locationName:"schemaVersion" type:"string"`

	// Type is a required field
	Type *string `location:"querystring" locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportSchemaInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryName sets the RegistryName field's value.
func (s *ExportSchemaInput) SetRegistryName(v string) *ExportSchemaInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ExportSchemaInput) SetSchemaName(v string) *ExportSchemaInput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *ExportSchemaInput) SetSchemaVersion(v string) *ExportSchemaInput {
	s.SchemaVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportSchemaInput) SetType(v string) *ExportSchemaInput {
	s.Type = &v
	return s
}

type ExportSchemaOutput struct {
	_ struct{} `type:"structure"`

	Content *string `type:"string"`

	SchemaArn *string `type:"string"`

	SchemaName *string `type:"string"`

	SchemaVersion *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSchemaOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *ExportSchemaOutput) SetContent(v string) *ExportSchemaOutput {
	s.Content = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *ExportSchemaOutput) SetSchemaArn(v string) *ExportSchemaOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ExportSchemaOutput) SetSchemaName(v string) *ExportSchemaOutput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *ExportSchemaOutput) SetSchemaVersion(v string) *ExportSchemaOutput {
	s.SchemaVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportSchemaOutput) SetType(v string) *ExportSchemaOutput {
	s.Type = &v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetCodeBindingSourceInput struct {
	_ struct{} `type:"structure"`

	// Language is a required field
	Language *string `location:"uri" locationName:"language" type:"string" required:"true"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	SchemaVersion *string `location:"querystring" locationName:"schemaVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCodeBindingSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCodeBindingSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCodeBindingSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCodeBindingSourceInput"}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Language != nil && len(*s.Language) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 1))
	}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguage sets the Language field's value.
func (s *GetCodeBindingSourceInput) SetLanguage(v string) *GetCodeBindingSourceInput {
	s.Language = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *GetCodeBindingSourceInput) SetRegistryName(v string) *GetCodeBindingSourceInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *GetCodeBindingSourceInput) SetSchemaName(v string) *GetCodeBindingSourceInput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *GetCodeBindingSourceInput) SetSchemaVersion(v string) *GetCodeBindingSourceInput {
	s.SchemaVersion = &v
	return s
}

type GetCodeBindingSourceOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCodeBindingSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCodeBindingSourceOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetCodeBindingSourceOutput) SetBody(v []byte) *GetCodeBindingSourceOutput {
	s.Body = v
	return s
}

type GetDiscoveredSchemaInput struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `min:"1" type:"list" required:"true"`

	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDiscoveredSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDiscoveredSchemaInput"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.Events != nil && len(s.Events) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Events", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *GetDiscoveredSchemaInput) SetEvents(v []*string) *GetDiscoveredSchemaInput {
	s.Events = v
	return s
}

// SetType sets the Type field's value.
func (s *GetDiscoveredSchemaInput) SetType(v string) *GetDiscoveredSchemaInput {
	s.Type = &v
	return s
}

type GetDiscoveredSchemaOutput struct {
	_ struct{} `type:"structure"`

	Content *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredSchemaOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *GetDiscoveredSchemaOutput) SetContent(v string) *GetDiscoveredSchemaOutput {
	s.Content = &v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	RegistryName *string `location:"querystring" locationName:"registryName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// SetRegistryName sets the RegistryName field's value.
func (s *GetResourcePolicyInput) SetRegistryName(v string) *GetResourcePolicyInput {
	s.RegistryName = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	Policy aws.JSONValue `type:"jsonvalue"`

	RevisionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePolicyOutput) SetPolicy(v aws.JSONValue) *GetResourcePolicyOutput {
	s.Policy = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetResourcePolicyOutput) SetRevisionId(v string) *GetResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type GoneException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GoneException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GoneException) GoString() string {
	return s.String()
}

func newErrorGoneException(v protocol.ResponseMetadata) error {
	return &GoneException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GoneException) Code() string {
	return "GoneException"
}

// Message returns the exception's message.
func (s *GoneException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GoneException) OrigErr() error {
	return nil
}

func (s *GoneException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GoneException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GoneException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDiscoverersInput struct {
	_ struct{} `type:"structure"`

	DiscovererIdPrefix *string `location:"querystring" locationName:"discovererIdPrefix" type:"string"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	SourceArnPrefix *string `location:"querystring" locationName:"sourceArnPrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoverersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoverersInput) GoString() string {
	return s.String()
}

// SetDiscovererIdPrefix sets the DiscovererIdPrefix field's value.
func (s *ListDiscoverersInput) SetDiscovererIdPrefix(v string) *ListDiscoverersInput {
	s.DiscovererIdPrefix = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDiscoverersInput) SetLimit(v int64) *ListDiscoverersInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoverersInput) SetNextToken(v string) *ListDiscoverersInput {
	s.NextToken = &v
	return s
}

// SetSourceArnPrefix sets the SourceArnPrefix field's value.
func (s *ListDiscoverersInput) SetSourceArnPrefix(v string) *ListDiscoverersInput {
	s.SourceArnPrefix = &v
	return s
}

type ListDiscoverersOutput struct {
	_ struct{} `type:"structure"`

	Discoverers []*DiscovererSummary `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoverersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoverersOutput) GoString() string {
	return s.String()
}

// SetDiscoverers sets the Discoverers field's value.
func (s *ListDiscoverersOutput) SetDiscoverers(v []*DiscovererSummary) *ListDiscoverersOutput {
	s.Discoverers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoverersOutput) SetNextToken(v string) *ListDiscoverersOutput {
	s.NextToken = &v
	return s
}

type ListRegistriesInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	RegistryNamePrefix *string `location:"querystring" locationName:"registryNamePrefix" type:"string"`

	Scope *string `location:"querystring" locationName:"scope" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegistriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegistriesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *ListRegistriesInput) SetLimit(v int64) *ListRegistriesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRegistriesInput) SetNextToken(v string) *ListRegistriesInput {
	s.NextToken = &v
	return s
}

// SetRegistryNamePrefix sets the RegistryNamePrefix field's value.
func (s *ListRegistriesInput) SetRegistryNamePrefix(v string) *ListRegistriesInput {
	s.RegistryNamePrefix = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListRegistriesInput) SetScope(v string) *ListRegistriesInput {
	s.Scope = &v
	return s
}

type ListRegistriesOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Registries []*RegistrySummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegistriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegistriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRegistriesOutput) SetNextToken(v string) *ListRegistriesOutput {
	s.NextToken = &v
	return s
}

// SetRegistries sets the Registries field's value.
func (s *ListRegistriesOutput) SetRegistries(v []*RegistrySummary) *ListRegistriesOutput {
	s.Registries = v
	return s
}

type ListSchemaVersionsInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemaVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemaVersionsInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListSchemaVersionsInput) SetLimit(v int64) *ListSchemaVersionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaVersionsInput) SetNextToken(v string) *ListSchemaVersionsInput {
	s.NextToken = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *ListSchemaVersionsInput) SetRegistryName(v string) *ListSchemaVersionsInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ListSchemaVersionsInput) SetSchemaName(v string) *ListSchemaVersionsInput {
	s.SchemaName = &v
	return s
}

type ListSchemaVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	SchemaVersions []*SchemaVersionSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaVersionsOutput) SetNextToken(v string) *ListSchemaVersionsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaVersions sets the SchemaVersions field's value.
func (s *ListSchemaVersionsOutput) SetSchemaVersions(v []*SchemaVersionSummary) *ListSchemaVersionsOutput {
	s.SchemaVersions = v
	return s
}

type ListSchemasInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	SchemaNamePrefix *string `location:"querystring" locationName:"schemaNamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemasInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListSchemasInput) SetLimit(v int64) *ListSchemasInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasInput) SetNextToken(v string) *ListSchemasInput {
	s.NextToken = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *ListSchemasInput) SetRegistryName(v string) *ListSchemasInput {
	s.RegistryName = &v
	return s
}

// SetSchemaNamePrefix sets the SchemaNamePrefix field's value.
func (s *ListSchemasInput) SetSchemaNamePrefix(v string) *ListSchemasInput {
	s.SchemaNamePrefix = &v
	return s
}

type ListSchemasOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Schemas []*SchemaSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasOutput) SetNextToken(v string) *ListSchemasOutput {
	s.NextToken = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *ListSchemasOutput) SetSchemas(v []*SchemaSummary) *ListSchemasOutput {
	s.Schemas = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PreconditionFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionFailedException) GoString() string {
	return s.String()
}

func newErrorPreconditionFailedException(v protocol.ResponseMetadata) error {
	return &PreconditionFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionFailedException) Code() string {
	return "PreconditionFailedException"
}

// Message returns the exception's message.
func (s *PreconditionFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionFailedException) OrigErr() error {
	return nil
}

func (s *PreconditionFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutCodeBindingInput struct {
	_ struct{} `type:"structure"`

	// Language is a required field
	Language *string `location:"uri" locationName:"language" type:"string" required:"true"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	SchemaVersion *string `location:"querystring" locationName:"schemaVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCodeBindingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCodeBindingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutCodeBindingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutCodeBindingInput"}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Language != nil && len(*s.Language) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 1))
	}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguage sets the Language field's value.
func (s *PutCodeBindingInput) SetLanguage(v string) *PutCodeBindingInput {
	s.Language = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *PutCodeBindingInput) SetRegistryName(v string) *PutCodeBindingInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *PutCodeBindingInput) SetSchemaName(v string) *PutCodeBindingInput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *PutCodeBindingInput) SetSchemaVersion(v string) *PutCodeBindingInput {
	s.SchemaVersion = &v
	return s
}

type PutCodeBindingOutput struct {
	_ struct{} `type:"structure"`

	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	SchemaVersion *string `type:"string"`

	Status *string `type:"string" enum:"CodeGenerationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCodeBindingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCodeBindingOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *PutCodeBindingOutput) SetCreationDate(v time.Time) *PutCodeBindingOutput {
	s.CreationDate = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *PutCodeBindingOutput) SetLastModified(v time.Time) *PutCodeBindingOutput {
	s.LastModified = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *PutCodeBindingOutput) SetSchemaVersion(v string) *PutCodeBindingOutput {
	s.SchemaVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PutCodeBindingOutput) SetStatus(v string) *PutCodeBindingOutput {
	s.Status = &v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Policy is a required field
	Policy aws.JSONValue `type:"jsonvalue" required:"true"`

	RegistryName *string `location:"querystring" locationName:"registryName" type:"string"`

	RevisionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v aws.JSONValue) *PutResourcePolicyInput {
	s.Policy = v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *PutResourcePolicyInput) SetRegistryName(v string) *PutResourcePolicyInput {
	s.RegistryName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *PutResourcePolicyInput) SetRevisionId(v string) *PutResourcePolicyInput {
	s.RevisionId = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	Policy aws.JSONValue `type:"jsonvalue"`

	RevisionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyOutput) SetPolicy(v aws.JSONValue) *PutResourcePolicyOutput {
	s.Policy = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *PutResourcePolicyOutput) SetRevisionId(v string) *PutResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type RegistrySummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the registry.
	RegistryArn *string `type:"string"`

	// The name of the registry.
	RegistryName *string `type:"string"`

	// Tags associated with the registry.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistrySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistrySummary) GoString() string {
	return s.String()
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *RegistrySummary) SetRegistryArn(v string) *RegistrySummary {
	s.RegistryArn = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *RegistrySummary) SetRegistryName(v string) *RegistrySummary {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegistrySummary) SetTags(v map[string]*string) *RegistrySummary {
	s.Tags = v
	return s
}

// A summary of schema details.
type SchemaSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that schema was modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the schema.
	SchemaArn *string `type:"string"`

	// The name of the schema.
	SchemaName *string `type:"string"`

	// Tags associated with the schema.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The number of versions available for the schema.
	VersionCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaSummary) GoString() string {
	return s.String()
}

// SetLastModified sets the LastModified field's value.
func (s *SchemaSummary) SetLastModified(v time.Time) *SchemaSummary {
	s.LastModified = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *SchemaSummary) SetSchemaArn(v string) *SchemaSummary {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *SchemaSummary) SetSchemaName(v string) *SchemaSummary {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SchemaSummary) SetTags(v map[string]*string) *SchemaSummary {
	s.Tags = v
	return s
}

// SetVersionCount sets the VersionCount field's value.
func (s *SchemaSummary) SetVersionCount(v int64) *SchemaSummary {
	s.VersionCount = &v
	return s
}

type SchemaVersionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the schema version.
	SchemaArn *string `type:"string"`

	// The name of the schema.
	SchemaName *string `type:"string"`

	// The version number of the schema.
	SchemaVersion *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaVersionSummary) GoString() string {
	return s.String()
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *SchemaVersionSummary) SetSchemaArn(v string) *SchemaVersionSummary {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *SchemaVersionSummary) SetSchemaName(v string) *SchemaVersionSummary {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *SchemaVersionSummary) SetSchemaVersion(v string) *SchemaVersionSummary {
	s.SchemaVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *SchemaVersionSummary) SetType(v string) *SchemaVersionSummary {
	s.Type = &v
	return s
}

type SearchSchemaSummary struct {
	_ struct{} `type:"structure"`

	// The name of the registry.
	RegistryName *string `type:"string"`

	// The ARN of the schema.
	SchemaArn *string `type:"string"`

	// The name of the schema.
	SchemaName *string `type:"string"`

	// An array of schema version summaries.
	SchemaVersions []*SearchSchemaVersionSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemaSummary) GoString() string {
	return s.String()
}

// SetRegistryName sets the RegistryName field's value.
func (s *SearchSchemaSummary) SetRegistryName(v string) *SearchSchemaSummary {
	s.RegistryName = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *SearchSchemaSummary) SetSchemaArn(v string) *SearchSchemaSummary {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *SearchSchemaSummary) SetSchemaName(v string) *SearchSchemaSummary {
	s.SchemaName = &v
	return s
}

// SetSchemaVersions sets the SchemaVersions field's value.
func (s *SearchSchemaSummary) SetSchemaVersions(v []*SearchSchemaVersionSummary) *SearchSchemaSummary {
	s.SchemaVersions = v
	return s
}

type SearchSchemaVersionSummary struct {
	_ struct{} `type:"structure"`

	// The date the schema version was created.
	CreatedDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The version number of the schema
	SchemaVersion *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemaVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemaVersionSummary) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SearchSchemaVersionSummary) SetCreatedDate(v time.Time) *SearchSchemaVersionSummary {
	s.CreatedDate = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *SearchSchemaVersionSummary) SetSchemaVersion(v string) *SearchSchemaVersionSummary {
	s.SchemaVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *SearchSchemaVersionSummary) SetType(v string) *SearchSchemaVersionSummary {
	s.Type = &v
	return s
}

type SearchSchemasInput struct {
	_ struct{} `type:"structure"`

	// Keywords is a required field
	Keywords *string `location:"querystring" locationName:"keywords" type:"string" required:"true"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchSchemasInput"}
	if s.Keywords == nil {
		invalidParams.Add(request.NewErrParamRequired("Keywords"))
	}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeywords sets the Keywords field's value.
func (s *SearchSchemasInput) SetKeywords(v string) *SearchSchemasInput {
	s.Keywords = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *SearchSchemasInput) SetLimit(v int64) *SearchSchemasInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSchemasInput) SetNextToken(v string) *SearchSchemasInput {
	s.NextToken = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *SearchSchemasInput) SetRegistryName(v string) *SearchSchemasInput {
	s.RegistryName = &v
	return s
}

type SearchSchemasOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Schemas []*SearchSchemaSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSchemasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSchemasOutput) SetNextToken(v string) *SearchSchemasOutput {
	s.NextToken = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *SearchSchemasOutput) SetSchemas(v []*SearchSchemaSummary) *SearchSchemasOutput {
	s.Schemas = v
	return s
}

type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartDiscovererInput struct {
	_ struct{} `type:"structure"`

	// DiscovererId is a required field
	DiscovererId *string `location:"uri" locationName:"discovererId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscovererInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDiscovererInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDiscovererInput"}
	if s.DiscovererId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscovererId"))
	}
	if s.DiscovererId != nil && len(*s.DiscovererId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiscovererId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *StartDiscovererInput) SetDiscovererId(v string) *StartDiscovererInput {
	s.DiscovererId = &v
	return s
}

type StartDiscovererOutput struct {
	_ struct{} `type:"structure"`

	DiscovererId *string `type:"string"`

	State *string `type:"string" enum:"DiscovererState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscovererOutput) GoString() string {
	return s.String()
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *StartDiscovererOutput) SetDiscovererId(v string) *StartDiscovererOutput {
	s.DiscovererId = &v
	return s
}

// SetState sets the State field's value.
func (s *StartDiscovererOutput) SetState(v string) *StartDiscovererOutput {
	s.State = &v
	return s
}

type StopDiscovererInput struct {
	_ struct{} `type:"structure"`

	// DiscovererId is a required field
	DiscovererId *string `location:"uri" locationName:"discovererId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscovererInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDiscovererInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDiscovererInput"}
	if s.DiscovererId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscovererId"))
	}
	if s.DiscovererId != nil && len(*s.DiscovererId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiscovererId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *StopDiscovererInput) SetDiscovererId(v string) *StopDiscovererInput {
	s.DiscovererId = &v
	return s
}

type StopDiscovererOutput struct {
	_ struct{} `type:"structure"`

	DiscovererId *string `type:"string"`

	State *string `type:"string" enum:"DiscovererState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDiscovererOutput) GoString() string {
	return s.String()
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *StopDiscovererOutput) SetDiscovererId(v string) *StopDiscovererOutput {
	s.DiscovererId = &v
	return s
}

// SetState sets the State field's value.
func (s *StopDiscovererOutput) SetState(v string) *StopDiscovererOutput {
	s.State = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Key-value pairs associated with a resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDiscovererInput struct {
	_ struct{} `type:"structure"`

	CrossAccount *bool `type:"boolean"`

	Description *string `type:"string"`

	// DiscovererId is a required field
	DiscovererId *string `location:"uri" locationName:"discovererId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscovererInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDiscovererInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDiscovererInput"}
	if s.DiscovererId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscovererId"))
	}
	if s.DiscovererId != nil && len(*s.DiscovererId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiscovererId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossAccount sets the CrossAccount field's value.
func (s *UpdateDiscovererInput) SetCrossAccount(v bool) *UpdateDiscovererInput {
	s.CrossAccount = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDiscovererInput) SetDescription(v string) *UpdateDiscovererInput {
	s.Description = &v
	return s
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *UpdateDiscovererInput) SetDiscovererId(v string) *UpdateDiscovererInput {
	s.DiscovererId = &v
	return s
}

type UpdateDiscovererOutput struct {
	_ struct{} `type:"structure"`

	CrossAccount *bool `type:"boolean"`

	Description *string `type:"string"`

	DiscovererArn *string `type:"string"`

	DiscovererId *string `type:"string"`

	SourceArn *string `type:"string"`

	State *string `type:"string" enum:"DiscovererState"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDiscovererOutput) GoString() string {
	return s.String()
}

// SetCrossAccount sets the CrossAccount field's value.
func (s *UpdateDiscovererOutput) SetCrossAccount(v bool) *UpdateDiscovererOutput {
	s.CrossAccount = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDiscovererOutput) SetDescription(v string) *UpdateDiscovererOutput {
	s.Description = &v
	return s
}

// SetDiscovererArn sets the DiscovererArn field's value.
func (s *UpdateDiscovererOutput) SetDiscovererArn(v string) *UpdateDiscovererOutput {
	s.DiscovererArn = &v
	return s
}

// SetDiscovererId sets the DiscovererId field's value.
func (s *UpdateDiscovererOutput) SetDiscovererId(v string) *UpdateDiscovererOutput {
	s.DiscovererId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *UpdateDiscovererOutput) SetSourceArn(v string) *UpdateDiscovererOutput {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateDiscovererOutput) SetState(v string) *UpdateDiscovererOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateDiscovererOutput) SetTags(v map[string]*string) *UpdateDiscovererOutput {
	s.Tags = v
	return s
}

type UpdateRegistryInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRegistryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRegistryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRegistryInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRegistryInput) SetDescription(v string) *UpdateRegistryInput {
	s.Description = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *UpdateRegistryInput) SetRegistryName(v string) *UpdateRegistryInput {
	s.RegistryName = &v
	return s
}

type UpdateRegistryOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	RegistryArn *string `type:"string"`

	RegistryName *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRegistryOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateRegistryOutput) SetDescription(v string) *UpdateRegistryOutput {
	s.Description = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *UpdateRegistryOutput) SetRegistryArn(v string) *UpdateRegistryOutput {
	s.RegistryArn = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *UpdateRegistryOutput) SetRegistryName(v string) *UpdateRegistryOutput {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRegistryOutput) SetTags(v map[string]*string) *UpdateRegistryOutput {
	s.Tags = v
	return s
}

type UpdateSchemaInput struct {
	_ struct{} `type:"structure"`

	ClientTokenId *string `type:"string" idempotencyToken:"true"`

	Content *string `min:"1" type:"string"`

	Description *string `type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSchemaInput"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientTokenId sets the ClientTokenId field's value.
func (s *UpdateSchemaInput) SetClientTokenId(v string) *UpdateSchemaInput {
	s.ClientTokenId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *UpdateSchemaInput) SetContent(v string) *UpdateSchemaInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSchemaInput) SetDescription(v string) *UpdateSchemaInput {
	s.Description = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *UpdateSchemaInput) SetRegistryName(v string) *UpdateSchemaInput {
	s.RegistryName = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *UpdateSchemaInput) SetSchemaName(v string) *UpdateSchemaInput {
	s.SchemaName = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateSchemaInput) SetType(v string) *UpdateSchemaInput {
	s.Type = &v
	return s
}

type UpdateSchemaOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	SchemaArn *string `type:"string"`

	SchemaName *string `type:"string"`

	SchemaVersion *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	Type *string `type:"string"`

	VersionCreatedDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateSchemaOutput) SetDescription(v string) *UpdateSchemaOutput {
	s.Description = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *UpdateSchemaOutput) SetLastModified(v time.Time) *UpdateSchemaOutput {
	s.LastModified = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateSchemaOutput) SetSchemaArn(v string) *UpdateSchemaOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *UpdateSchemaOutput) SetSchemaName(v string) *UpdateSchemaOutput {
	s.SchemaName = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *UpdateSchemaOutput) SetSchemaVersion(v string) *UpdateSchemaOutput {
	s.SchemaVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateSchemaOutput) SetTags(v map[string]*string) *UpdateSchemaOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateSchemaOutput) SetType(v string) *UpdateSchemaOutput {
	s.Type = &v
	return s
}

// SetVersionCreatedDate sets the VersionCreatedDate field's value.
func (s *UpdateSchemaOutput) SetVersionCreatedDate(v time.Time) *UpdateSchemaOutput {
	s.VersionCreatedDate = &v
	return s
}

const (
	// CodeGenerationStatusCreateInProgress is a CodeGenerationStatus enum value
	CodeGenerationStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// CodeGenerationStatusCreateComplete is a CodeGenerationStatus enum value
	CodeGenerationStatusCreateComplete = "CREATE_COMPLETE"

	// CodeGenerationStatusCreateFailed is a CodeGenerationStatus enum value
	CodeGenerationStatusCreateFailed = "CREATE_FAILED"
)

// CodeGenerationStatus_Values returns all elements of the CodeGenerationStatus enum
func CodeGenerationStatus_Values() []string {
	return []string{
		CodeGenerationStatusCreateInProgress,
		CodeGenerationStatusCreateComplete,
		CodeGenerationStatusCreateFailed,
	}
}

const (
	// DiscovererStateStarted is a DiscovererState enum value
	DiscovererStateStarted = "STARTED"

	// DiscovererStateStopped is a DiscovererState enum value
	DiscovererStateStopped = "STOPPED"
)

// DiscovererState_Values returns all elements of the DiscovererState enum
func DiscovererState_Values() []string {
	return []string{
		DiscovererStateStarted,
		DiscovererStateStopped,
	}
}

const (
	// TypeOpenApi3 is a Type enum value
	TypeOpenApi3 = "OpenApi3"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeOpenApi3,
	}
}
