// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/persistent_resource_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PersistentResourceService_CreatePersistentResource_FullMethodName = "/google.cloud.aiplatform.v1beta1.PersistentResourceService/CreatePersistentResource"
	PersistentResourceService_GetPersistentResource_FullMethodName    = "/google.cloud.aiplatform.v1beta1.PersistentResourceService/GetPersistentResource"
	PersistentResourceService_ListPersistentResources_FullMethodName  = "/google.cloud.aiplatform.v1beta1.PersistentResourceService/ListPersistentResources"
	PersistentResourceService_DeletePersistentResource_FullMethodName = "/google.cloud.aiplatform.v1beta1.PersistentResourceService/DeletePersistentResource"
	PersistentResourceService_UpdatePersistentResource_FullMethodName = "/google.cloud.aiplatform.v1beta1.PersistentResourceService/UpdatePersistentResource"
	PersistentResourceService_RebootPersistentResource_FullMethodName = "/google.cloud.aiplatform.v1beta1.PersistentResourceService/RebootPersistentResource"
)

// PersistentResourceServiceClient is the client API for PersistentResourceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PersistentResourceServiceClient interface {
	// Creates a PersistentResource.
	CreatePersistentResource(ctx context.Context, in *CreatePersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a PersistentResource.
	GetPersistentResource(ctx context.Context, in *GetPersistentResourceRequest, opts ...grpc.CallOption) (*PersistentResource, error)
	// Lists PersistentResources in a Location.
	ListPersistentResources(ctx context.Context, in *ListPersistentResourcesRequest, opts ...grpc.CallOption) (*ListPersistentResourcesResponse, error)
	// Deletes a PersistentResource.
	DeletePersistentResource(ctx context.Context, in *DeletePersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a PersistentResource.
	UpdatePersistentResource(ctx context.Context, in *UpdatePersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reboots a PersistentResource.
	RebootPersistentResource(ctx context.Context, in *RebootPersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type persistentResourceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPersistentResourceServiceClient(cc grpc.ClientConnInterface) PersistentResourceServiceClient {
	return &persistentResourceServiceClient{cc}
}

func (c *persistentResourceServiceClient) CreatePersistentResource(ctx context.Context, in *CreatePersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PersistentResourceService_CreatePersistentResource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *persistentResourceServiceClient) GetPersistentResource(ctx context.Context, in *GetPersistentResourceRequest, opts ...grpc.CallOption) (*PersistentResource, error) {
	out := new(PersistentResource)
	err := c.cc.Invoke(ctx, PersistentResourceService_GetPersistentResource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *persistentResourceServiceClient) ListPersistentResources(ctx context.Context, in *ListPersistentResourcesRequest, opts ...grpc.CallOption) (*ListPersistentResourcesResponse, error) {
	out := new(ListPersistentResourcesResponse)
	err := c.cc.Invoke(ctx, PersistentResourceService_ListPersistentResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *persistentResourceServiceClient) DeletePersistentResource(ctx context.Context, in *DeletePersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PersistentResourceService_DeletePersistentResource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *persistentResourceServiceClient) UpdatePersistentResource(ctx context.Context, in *UpdatePersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PersistentResourceService_UpdatePersistentResource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *persistentResourceServiceClient) RebootPersistentResource(ctx context.Context, in *RebootPersistentResourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PersistentResourceService_RebootPersistentResource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PersistentResourceServiceServer is the server API for PersistentResourceService service.
// All implementations should embed UnimplementedPersistentResourceServiceServer
// for forward compatibility
type PersistentResourceServiceServer interface {
	// Creates a PersistentResource.
	CreatePersistentResource(context.Context, *CreatePersistentResourceRequest) (*longrunningpb.Operation, error)
	// Gets a PersistentResource.
	GetPersistentResource(context.Context, *GetPersistentResourceRequest) (*PersistentResource, error)
	// Lists PersistentResources in a Location.
	ListPersistentResources(context.Context, *ListPersistentResourcesRequest) (*ListPersistentResourcesResponse, error)
	// Deletes a PersistentResource.
	DeletePersistentResource(context.Context, *DeletePersistentResourceRequest) (*longrunningpb.Operation, error)
	// Updates a PersistentResource.
	UpdatePersistentResource(context.Context, *UpdatePersistentResourceRequest) (*longrunningpb.Operation, error)
	// Reboots a PersistentResource.
	RebootPersistentResource(context.Context, *RebootPersistentResourceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPersistentResourceServiceServer should be embedded to have forward compatible implementations.
type UnimplementedPersistentResourceServiceServer struct {
}

func (UnimplementedPersistentResourceServiceServer) CreatePersistentResource(context.Context, *CreatePersistentResourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePersistentResource not implemented")
}
func (UnimplementedPersistentResourceServiceServer) GetPersistentResource(context.Context, *GetPersistentResourceRequest) (*PersistentResource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPersistentResource not implemented")
}
func (UnimplementedPersistentResourceServiceServer) ListPersistentResources(context.Context, *ListPersistentResourcesRequest) (*ListPersistentResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPersistentResources not implemented")
}
func (UnimplementedPersistentResourceServiceServer) DeletePersistentResource(context.Context, *DeletePersistentResourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePersistentResource not implemented")
}
func (UnimplementedPersistentResourceServiceServer) UpdatePersistentResource(context.Context, *UpdatePersistentResourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePersistentResource not implemented")
}
func (UnimplementedPersistentResourceServiceServer) RebootPersistentResource(context.Context, *RebootPersistentResourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RebootPersistentResource not implemented")
}

// UnsafePersistentResourceServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PersistentResourceServiceServer will
// result in compilation errors.
type UnsafePersistentResourceServiceServer interface {
	mustEmbedUnimplementedPersistentResourceServiceServer()
}

func RegisterPersistentResourceServiceServer(s grpc.ServiceRegistrar, srv PersistentResourceServiceServer) {
	s.RegisterService(&PersistentResourceService_ServiceDesc, srv)
}

func _PersistentResourceService_CreatePersistentResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePersistentResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PersistentResourceServiceServer).CreatePersistentResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PersistentResourceService_CreatePersistentResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PersistentResourceServiceServer).CreatePersistentResource(ctx, req.(*CreatePersistentResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PersistentResourceService_GetPersistentResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPersistentResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PersistentResourceServiceServer).GetPersistentResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PersistentResourceService_GetPersistentResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PersistentResourceServiceServer).GetPersistentResource(ctx, req.(*GetPersistentResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PersistentResourceService_ListPersistentResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPersistentResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PersistentResourceServiceServer).ListPersistentResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PersistentResourceService_ListPersistentResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PersistentResourceServiceServer).ListPersistentResources(ctx, req.(*ListPersistentResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PersistentResourceService_DeletePersistentResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePersistentResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PersistentResourceServiceServer).DeletePersistentResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PersistentResourceService_DeletePersistentResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PersistentResourceServiceServer).DeletePersistentResource(ctx, req.(*DeletePersistentResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PersistentResourceService_UpdatePersistentResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePersistentResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PersistentResourceServiceServer).UpdatePersistentResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PersistentResourceService_UpdatePersistentResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PersistentResourceServiceServer).UpdatePersistentResource(ctx, req.(*UpdatePersistentResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PersistentResourceService_RebootPersistentResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RebootPersistentResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PersistentResourceServiceServer).RebootPersistentResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PersistentResourceService_RebootPersistentResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PersistentResourceServiceServer).RebootPersistentResource(ctx, req.(*RebootPersistentResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PersistentResourceService_ServiceDesc is the grpc.ServiceDesc for PersistentResourceService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PersistentResourceService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.PersistentResourceService",
	HandlerType: (*PersistentResourceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePersistentResource",
			Handler:    _PersistentResourceService_CreatePersistentResource_Handler,
		},
		{
			MethodName: "GetPersistentResource",
			Handler:    _PersistentResourceService_GetPersistentResource_Handler,
		},
		{
			MethodName: "ListPersistentResources",
			Handler:    _PersistentResourceService_ListPersistentResources_Handler,
		},
		{
			MethodName: "DeletePersistentResource",
			Handler:    _PersistentResourceService_DeletePersistentResource_Handler,
		},
		{
			MethodName: "UpdatePersistentResource",
			Handler:    _PersistentResourceService_UpdatePersistentResource_Handler,
		},
		{
			MethodName: "RebootPersistentResource",
			Handler:    _PersistentResourceService_RebootPersistentResource_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/persistent_resource_service.proto",
}
